/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.protocol.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import de.fxlae.typeid.TypeId;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tbdex.sdk.protocol.Parser;
import tbdex.sdk.protocol.SignatureVerifier;
import tbdex.sdk.protocol.Validator;
import tbdex.sdk.protocol.models.CreateRfqData;
import tbdex.sdk.protocol.models.Message;
import tbdex.sdk.protocol.models.MessageKind;
import tbdex.sdk.protocol.models.MessageMetadata;
import tbdex.sdk.protocol.models.Offering;
import tbdex.sdk.protocol.models.PaymentMethod;
import tbdex.sdk.protocol.models.PrivatePaymentDetails;
import tbdex.sdk.protocol.models.RfqData;
import tbdex.sdk.protocol.models.RfqPrivateData;
import tbdex.sdk.protocol.models.SelectedPayinMethod;
import tbdex.sdk.protocol.models.SelectedPayoutMethod;
import tbdex.sdk.protocol.serialization.Json;
import web5.sdk.common.Convert;
import web5.sdk.credentials.PresentationExchange;
import web5.sdk.credentials.model.PresentationDefinitionV2;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ>\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0006\u0010$\u001a\u00020\u001bJ\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u001bH\u0002J\b\u0010-\u001a\u00020\u001bH\u0002J\u0006\u0010.\u001a\u00020\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Ltbdex/sdk/protocol/models/Rfq;", "Ltbdex/sdk/protocol/models/Message;", "metadata", "Ltbdex/sdk/protocol/models/MessageMetadata;", "data", "Ltbdex/sdk/protocol/models/RfqData;", "privateData", "Ltbdex/sdk/protocol/models/RfqPrivateData;", "signature", "", "(Ltbdex/sdk/protocol/models/MessageMetadata;Ltbdex/sdk/protocol/models/RfqData;Ltbdex/sdk/protocol/models/RfqPrivateData;Ljava/lang/String;)V", "getData", "()Ltbdex/sdk/protocol/models/RfqData;", "getMetadata", "()Ltbdex/sdk/protocol/models/MessageMetadata;", "getPrivateData", "()Ltbdex/sdk/protocol/models/RfqPrivateData;", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "validNext", "", "Ltbdex/sdk/protocol/models/MessageKind;", "getValidNext", "()Ljava/util/Set;", "validatePaymentMethod", "", "selectedMethodKind", "selectedMethodDetailsHash", "selectedMethodDetails", "", "", "offeredMethods", "", "Ltbdex/sdk/protocol/models/PaymentMethod;", "verifyAllPrivateData", "verifyClaims", "requiredClaims", "Lweb5/sdk/credentials/model/PresentationDefinitionV2;", "verifyClaimsHash", "verifyOfferingRequirements", "offering", "Ltbdex/sdk/protocol/models/Offering;", "verifyPayinDetailsHash", "verifyPayoutDetailsHash", "verifyPresentPrivateData", "Companion", "tbdex-protocol"})
@SourceDebugExtension(value={"SMAP\nRfq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rfq.kt\ntbdex/sdk/protocol/models/Rfq\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n223#3,2:314\n*S KotlinDebug\n*F\n+ 1 Rfq.kt\ntbdex/sdk/protocol/models/Rfq\n*L\n80#1:314,2\n*E\n"})
public final class Rfq
extends Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageMetadata metadata;
    @NotNull
    private final RfqData data;
    @Nullable
    private final RfqPrivateData privateData;
    @Nullable
    private String signature;
    @NotNull
    private final Set<MessageKind> validNext;

    private Rfq(MessageMetadata metadata, RfqData data, RfqPrivateData privateData, String signature) {
        super(null);
        this.metadata = metadata;
        this.data = data;
        this.privateData = privateData;
        this.signature = signature;
        MessageKind[] messageKindArray = new MessageKind[]{MessageKind.quote, MessageKind.close};
        this.validNext = SetsKt.setOf((Object[])messageKindArray);
    }

    /* synthetic */ Rfq(MessageMetadata messageMetadata, RfqData rfqData, RfqPrivateData rfqPrivateData, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            rfqPrivateData = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(messageMetadata, rfqData, rfqPrivateData, string);
    }

    @Override
    @NotNull
    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public RfqData getData() {
        return this.data;
    }

    @Nullable
    public final RfqPrivateData getPrivateData() {
        return this.privateData;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(@Nullable String string) {
        this.signature = string;
    }

    @Override
    @NotNull
    public Set<MessageKind> getValidNext() {
        return this.validNext;
    }

    public final void verifyOfferingRequirements(@NotNull Offering offering) {
        block5: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)offering, (String)"offering");
            if (!Intrinsics.areEqual((Object)this.getData().getOfferingId(), (Object)offering.getMetadata().getId())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (offering.getData().getPayin().getMin() != null) {
                if (!(Double.parseDouble(offering.getData().getPayin().getMin()) <= Double.parseDouble(this.getData().getPayin().getAmount()))) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
            }
            if (offering.getData().getPayin().getMax() != null) {
                if (!(Double.parseDouble(offering.getData().getPayin().getMax()) >= Double.parseDouble(this.getData().getPayin().getAmount()))) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
            }
            this.validatePaymentMethod(this.getData().getPayin().getKind(), this.getData().getPayin().getPaymentDetailsHash(), (object2 = this.privateData) != null && (object2 = ((RfqPrivateData)object2).getPayin()) != null ? ((PrivatePaymentDetails)object2).getPaymentDetails() : null, offering.getData().getPayin().getMethods());
            this.validatePaymentMethod(this.getData().getPayout().getKind(), this.getData().getPayout().getPaymentDetailsHash(), (object = this.privateData) != null && (object = ((RfqPrivateData)object).getPayout()) != null ? ((PrivatePaymentDetails)object).getPaymentDetails() : null, offering.getData().getPayout().getMethods());
            PresentationDefinitionV2 presentationDefinitionV2 = offering.getData().getRequiredClaims();
            if (presentationDefinitionV2 == null) break block5;
            PresentationDefinitionV2 it = presentationDefinitionV2;
            boolean bl = false;
            this.verifyClaims(it);
        }
    }

    private final void validatePaymentMethod(String selectedMethodKind, String selectedMethodDetailsHash, Map<String, ? extends Object> selectedMethodDetails, List<? extends PaymentMethod> offeredMethods) {
        block4: {
            Object element$iv2;
            block3: {
                Iterable $this$first$iv = offeredMethods;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    PaymentMethod it = (PaymentMethod)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKind(), (Object)selectedMethodKind)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            PaymentMethod matchedOfferingMethod = (PaymentMethod)element$iv2;
            JsonNode jsonNode = matchedOfferingMethod.getRequiredPaymentDetails();
            if (jsonNode == null) break block4;
            JsonNode it = jsonNode;
            boolean bl = false;
            JsonSchema schema = matchedOfferingMethod.getRequiredPaymentDetailsSchema();
            if (schema == null && selectedMethodDetailsHash == null) {
                return;
            }
            JsonNode jsonNodePaymentDetails = Json.INSTANCE.getJsonMapper().valueToTree(selectedMethodDetails);
            JsonSchema jsonSchema = schema;
            if (jsonSchema != null) {
                jsonSchema.validate(jsonNodePaymentDetails);
            }
        }
    }

    private final void verifyClaims(PresentationDefinitionV2 requiredClaims) {
        try {
            Object object = this.privateData;
            PresentationExchange.INSTANCE.satisfiesPresentationDefinition(object != null && (object = ((RfqPrivateData)object).getClaims()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList(), requiredClaims);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No matching claim for Offering requirements: " + requiredClaims.getId());
        }
    }

    public final void verifyAllPrivateData() {
        block2: {
            String it;
            String string = this.getData().getPayin().getPaymentDetailsHash();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.verifyPayinDetailsHash();
            }
            String string2 = this.getData().getPayout().getPaymentDetailsHash();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.verifyPayoutDetailsHash();
            }
            String string3 = this.getData().getClaimsHash();
            if (string3 == null) break block2;
            it = string3;
            boolean bl = false;
            this.verifyClaimsHash();
        }
    }

    public final void verifyPresentPrivateData() {
        Object object;
        Object object2;
        Object object3;
        if (this.getData().getPayin().getPaymentDetailsHash() != null && ((object3 = this.privateData) != null && (object3 = ((RfqPrivateData)object3).getPayin()) != null ? ((PrivatePaymentDetails)object3).getPaymentDetails() : null) != null) {
            this.verifyPayinDetailsHash();
        }
        if (this.getData().getPayout().getPaymentDetailsHash() != null && ((object2 = this.privateData) != null && (object2 = ((RfqPrivateData)object2).getPayout()) != null ? ((PrivatePaymentDetails)object2).getPaymentDetails() : null) != null) {
            this.verifyPayoutDetailsHash();
        }
        if (!((object = (CharSequence)this.getData().getClaimsHash()) == null || object.length() == 0)) {
            RfqPrivateData rfqPrivateData = this.privateData;
            object = rfqPrivateData != null ? rfqPrivateData.getClaims() : null;
            if (!(object == null || object.isEmpty())) {
                this.verifyClaimsHash();
            }
        }
    }

    private final void verifyPayinDetailsHash() {
        String digest;
        String string;
        if (!(this.privateData != null)) {
            boolean bl = false;
            String string2 = "privateData property is missing";
            throw new IllegalArgumentException(string2.toString());
        }
        Object object = this.privateData.getPayin();
        if (object != null && (object = ((PrivatePaymentDetails)object).getPaymentDetails()) != null) {
            Object it = object;
            boolean bl = false;
            string = Rfq.Companion.digestPrivateData(this.privateData.getSalt(), it);
        } else {
            string = digest = null;
        }
        if (!Intrinsics.areEqual(digest, (Object)this.getData().getPayin().getPaymentDetailsHash())) {
            boolean bl = false;
            String string3 = "Private data integrity check failed: data.payin.paymentDetailsHash does not match digest of privateData.payin.paymentDetails";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    private final void verifyPayoutDetailsHash() {
        String digest;
        String string;
        if (!(this.privateData != null)) {
            boolean bl = false;
            String string2 = "privateData property is missing";
            throw new IllegalArgumentException(string2.toString());
        }
        Object object = this.privateData.getPayout();
        if (object != null && (object = ((PrivatePaymentDetails)object).getPaymentDetails()) != null) {
            Object it = object;
            boolean bl = false;
            string = Rfq.Companion.digestPrivateData(this.privateData.getSalt(), it);
        } else {
            string = digest = null;
        }
        if (!Intrinsics.areEqual(digest, (Object)this.getData().getPayout().getPaymentDetailsHash())) {
            boolean bl = false;
            String string3 = "Private data integrity check failed: data.payout.paymentDetailsHash does not match digest of privateData.payout.paymentDetails";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    private final void verifyClaimsHash() {
        if (!(this.privateData != null)) {
            boolean $i$a$-require-Rfq$verifyClaimsHash$42 = false;
            String $i$a$-require-Rfq$verifyClaimsHash$42 = "privateData property is missing";
            throw new IllegalArgumentException($i$a$-require-Rfq$verifyClaimsHash$42.toString());
        }
        if (!(this.privateData.getClaims() != null)) {
            boolean bl = false;
            String string = "privateData.claims is missing";
            throw new IllegalArgumentException(string.toString());
        }
        String digest = Rfq.Companion.digestPrivateData(this.privateData.getSalt(), this.privateData.getClaims());
        if (!Intrinsics.areEqual((Object)digest, (Object)this.getData().getClaimsHash())) {
            boolean bl = false;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Private data integrity check failed: data.claimsHash does not match digest of privateData.claims");
            throw new IllegalArgumentException(((Object)illegalArgumentException).toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0006\u0010\u000f\u001a\u00020\u0006J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Ltbdex/sdk/protocol/models/Rfq$Companion;", "", "()V", "create", "Ltbdex/sdk/protocol/models/Rfq;", "to", "", "from", "rfqData", "Ltbdex/sdk/protocol/models/CreateRfqData;", "protocol", "externalId", "digestPrivateData", "salt", "value", "generateRandomSalt", "hashPrivateData", "Lkotlin/Pair;", "Ltbdex/sdk/protocol/models/RfqData;", "Ltbdex/sdk/protocol/models/RfqPrivateData;", "createRfqData", "parse", "payload", "requireAllPrivateData", "", "tbdex-protocol"})
    @SourceDebugExtension(value={"SMAP\nRfq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rfq.kt\ntbdex/sdk/protocol/models/Rfq$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rfq create(@NotNull String to, @NotNull String from, @NotNull CreateRfqData rfqData, @NotNull String protocol, @Nullable String externalId) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)rfqData, (String)"rfqData");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            String string = TypeId.generate((String)"rfq").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String id = string;
            Pair<RfqData, RfqPrivateData> pair = MessageKind.rfq;
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            Intrinsics.checkNotNull((Object)offsetDateTime);
            MessageMetadata metadata = new MessageMetadata(from, to, (MessageKind)pair, id, id, externalId, offsetDateTime, protocol);
            pair = this.hashPrivateData(rfqData);
            RfqData data = (RfqData)pair.component1();
            RfqPrivateData privateData = (RfqPrivateData)pair.component2();
            Validator.INSTANCE.validateData(data, "rfq");
            return new Rfq(metadata, data, privateData, null, 8, null);
        }

        public static /* synthetic */ Rfq create$default(Companion companion, String string, String string2, CreateRfqData createRfqData, String string3, String string4, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = "1.0";
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            return companion.create(string, string2, createRfqData, string3, string4);
        }

        @NotNull
        public final Rfq parse(@NotNull String payload, boolean requireAllPrivateData) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            JsonNode jsonMessage = Parser.INSTANCE.parseMessageToJsonNode(payload);
            String kind = jsonMessage.get("metadata").get("kind").asText();
            if (!Intrinsics.areEqual((Object)kind, (Object)"rfq")) {
                throw new IllegalArgumentException("Message must be an RFQ but message kind was " + kind);
            }
            Rfq rfq = (Rfq)Json.INSTANCE.getJsonMapper().convertValue((Object)jsonMessage, Rfq.class);
            rfq.verify();
            if (requireAllPrivateData) {
                rfq.verifyAllPrivateData();
            } else {
                rfq.verifyPresentPrivateData();
            }
            Intrinsics.checkNotNull((Object)rfq);
            return rfq;
        }

        public static /* synthetic */ Rfq parse$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parse(string, bl);
        }

        private final Pair<RfqData, RfqPrivateData> hashPrivateData(CreateRfqData createRfqData) {
            String string;
            String string2;
            String salt = this.generateRandomSalt();
            Map<String, Object> map = createRfqData.getPayin().getPaymentDetails();
            if (map != null) {
                Map<String, Object> it = map;
                boolean bl = false;
                string2 = Companion.digestPrivateData(salt, it);
            } else {
                string2 = null;
            }
            String payinPaymentDetailsHash = string2;
            Map<String, Object> map2 = createRfqData.getPayout().getPaymentDetails();
            if (map2 != null) {
                Map<String, Object> it = map2;
                boolean bl = false;
                string = Companion.digestPrivateData(salt, it);
            } else {
                string = null;
            }
            String payoutPaymentDetailsHash = string;
            String claimsHash = createRfqData.getClaims().isEmpty() ? null : this.digestPrivateData(salt, createRfqData.getClaims());
            RfqData hashedRfqData = new RfqData(createRfqData.getOfferingId(), new SelectedPayinMethod(createRfqData.getPayin().getKind(), payinPaymentDetailsHash, createRfqData.getPayin().getAmount()), new SelectedPayoutMethod(createRfqData.getPayout().getKind(), payoutPaymentDetailsHash), claimsHash);
            RfqPrivateData privateRfqData = new RfqPrivateData(salt, new PrivatePaymentDetails(createRfqData.getPayin().getPaymentDetails()), new PrivatePaymentDetails(createRfqData.getPayout().getPaymentDetails()), createRfqData.getClaims());
            return new Pair((Object)hashedRfqData, (Object)privateRfqData);
        }

        private final String digestPrivateData(String salt, Object value) {
            Object[] objectArray = new Object[]{salt, value};
            Object[] payload = objectArray;
            byte[] digest = SignatureVerifier.INSTANCE.digestOf(payload);
            return Convert.toBase64Url$default((Convert)new Convert((Object)digest, null, 2, null), (boolean)false, (int)1, null);
        }

        @NotNull
        public final String generateRandomSalt() {
            int byteArraySize = 16;
            SecureRandom secureRandom = new SecureRandom();
            byte[] byteArray = new byte[byteArraySize];
            secureRandom.nextBytes(byteArray);
            return Convert.toBase64Url$default((Convert)new Convert((Object)byteArray, null, 2, null), (boolean)false, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

