// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package tbdex.sdk.rust;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_tbdex_uniffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_tbdex_uniffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus();
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback);
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "tbdex_uniffi_aarch64_apple_darwin"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceKeyManagerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`publicJwk`: RustBuffer.ByValue,`uniffiOutReturn`: PointerByReference,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSignerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
@Structure.FieldOrder("getSigner", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceKeyManager(
    @JvmField internal var `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceKeyManager(`getSigner`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceKeyManager) {
        `getSigner` = other.`getSigner`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("sign", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSigner(
    @JvmField internal var `sign`: UniffiCallbackInterfaceSignerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `sign`: UniffiCallbackInterfaceSignerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSigner(`sign`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSigner) {
        `sign` = other.`sign`
        `uniffiFree` = other.`uniffiFree`
    }

}








































































































































































































































































































































// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "tbdex")
            .also { lib: UniffiLib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                uniffiCallbackInterfaceKeyManager.register(lib)
                uniffiCallbackInterfaceSigner.register(lib)
                }
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_tbdex_uniffi_fn_clone_balance(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_balance(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_balance_create(`from`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_balance_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_balance_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_balance_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_balance_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_balance_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_bearerdid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_bearerdid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_bearerdid_from_portable_did(`portableDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_bearerdid_new(`uri`: RustBuffer.ByValue,`keyManager`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_bearerdid_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_bearerdid_get_signer(`ptr`: Pointer,`keyId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_clone_cancel(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_cancel(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_cancel_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_cancel_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_cancel_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_cancel_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_cancel_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_cancel_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_close(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_close(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_close_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_close_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_close_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_close_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_close_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_close_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_createexchangerequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_createexchangerequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_createexchangerequestbody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_createexchangerequestbody_new(`message`: Pointer,`replyTo`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_createexchangerequestbody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_createexchangerequestbody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_errorresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_errorresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_errorresponsebody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_errorresponsebody_new(`message`: RustBuffer.ByValue,`details`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_errorresponsebody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_errorresponsebody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_getbalancesresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_getbalancesresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_getbalancesresponsebody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_getbalancesresponsebody_new(`balances`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_getbalancesresponsebody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_getbalancesresponsebody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_getexchangeresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_getexchangeresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_getexchangeresponsebody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_getexchangeresponsebody_new(`responseBodyData`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_getexchangeresponsebody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_getexchangeresponsebody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_getexchangesresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_getexchangesresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_getexchangesresponsebody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_getexchangesresponsebody_new(`data`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_getexchangesresponsebody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_getexchangesresponsebody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_getofferingsresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_getofferingsresponsebody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_getofferingsresponsebody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_getofferingsresponsebody_new(`offerings`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_getofferingsresponsebody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_getofferingsresponsebody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_inmemorykeymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_inmemorykeymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_inmemorykeymanager_new(uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_get_as_key_manager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_get_signer(`ptr`: Pointer,`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_import_private_jwk(`ptr`: Pointer,`privateKey`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_keymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_keymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_init_callback_vtable_keymanager(`vtable`: UniffiVTableCallbackInterfaceKeyManager,
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_keymanager_get_signer(`ptr`: Pointer,`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_clone_offering(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_offering(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_offering_create(`from`: RustBuffer.ByValue,`jsonSerializedData`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_offering_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_offering_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_offering_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_offering_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_offering_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_order(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_order(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_order_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_order_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_order_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_order_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_order_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_order_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_orderinstructions(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_orderinstructions(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_orderinstructions_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_orderinstructions_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_orderinstructions_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_orderinstructions_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_orderinstructions_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_orderinstructions_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_orderstatus(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_orderstatus(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_orderstatus_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_orderstatus_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_orderstatus_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_orderstatus_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_orderstatus_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_orderstatus_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_portabledid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_portabledid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_portabledid_new(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_portabledid_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_presentationdefinition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_presentationdefinition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_presentationdefinition_new(`jsonSerializedPresentationDefinition`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_presentationdefinition_get_json_serialized_presentation_definition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_presentationdefinition_select_credentials(`ptr`: Pointer,`vcJwts`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_quote(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_quote(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_quote_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`exchangeId`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_quote_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_quote_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_quote_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_quote_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_quote_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_replytorequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_replytorequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_replytorequestbody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_replytorequestbody_new(`kind`: RustBuffer.ByValue,`jsonSerializedMessage`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_replytorequestbody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_replytorequestbody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_rfq(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_rfq(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_rfq_create(`to`: RustBuffer.ByValue,`from`: RustBuffer.ByValue,`jsonSerializedCreateRfqData`: RustBuffer.ByValue,`protocol`: RustBuffer.ByValue,`externalId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_rfq_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_rfq_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_rfq_sign(`ptr`: Pointer,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_rfq_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_rfq_verify(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_rfq_verify_all_private_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_rfq_verify_offering_requirements(`ptr`: Pointer,`offering`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_rfq_verify_present_private_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_clone_signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_init_callback_vtable_signer(`vtable`: UniffiVTableCallbackInterfaceSigner,
    ): Unit
    fun uniffi_tbdex_uniffi_fn_method_signer_sign(`ptr`: Pointer,`payload`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_clone_updateexchangerequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_free_updateexchangerequestbody(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_constructor_updateexchangerequestbody_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_constructor_updateexchangerequestbody_new(`kind`: RustBuffer.ByValue,`jsonSerializedMessage`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_tbdex_uniffi_fn_method_updateexchangerequestbody_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_method_updateexchangerequestbody_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_func_create_exchange(`rfq`: Pointer,`replyTo`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_func_get_balances(`pfiDidUri`: RustBuffer.ByValue,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_func_get_exchange(`pfiDidUri`: RustBuffer.ByValue,`bearerDid`: Pointer,`exchangeId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_func_get_exchange_ids(`pfiDidUri`: RustBuffer.ByValue,`bearerDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_func_get_offerings(`pfiDidUri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_tbdex_uniffi_fn_func_submit_cancel(`cancel`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_fn_func_submit_order(`order`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun ffi_tbdex_uniffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_tbdex_uniffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_tbdex_uniffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun ffi_tbdex_uniffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_tbdex_uniffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_u8(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_u8(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_tbdex_uniffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_i8(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_i8(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_tbdex_uniffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_u16(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_u16(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_tbdex_uniffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_i16(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_i16(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_tbdex_uniffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_u32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_u32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_tbdex_uniffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_i32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_i32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_tbdex_uniffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_u64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_u64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_tbdex_uniffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_i64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_i64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_tbdex_uniffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_f32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_f32(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Float
    fun ffi_tbdex_uniffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_f64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_f64(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Double
    fun ffi_tbdex_uniffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_pointer(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_pointer(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun ffi_tbdex_uniffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_tbdex_uniffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_cancel_void(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_free_void(`handle`: Long,
    ): Unit
    fun ffi_tbdex_uniffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_tbdex_uniffi_checksum_func_create_exchange(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_get_balances(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_get_exchange(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_get_exchange_ids(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_get_offerings(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_submit_cancel(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_func_submit_order(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_balance_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_balance_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_balance_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_balance_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_bearerdid_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_bearerdid_get_signer(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_cancel_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_cancel_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_cancel_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_cancel_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_close_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_close_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_close_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_close_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_createexchangerequestbody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_createexchangerequestbody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_errorresponsebody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_errorresponsebody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getbalancesresponsebody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getbalancesresponsebody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getexchangeresponsebody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getexchangeresponsebody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getexchangesresponsebody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getexchangesresponsebody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getofferingsresponsebody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_getofferingsresponsebody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_get_as_key_manager(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_get_signer(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_import_private_jwk(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_keymanager_get_signer(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_offering_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_offering_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_offering_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_offering_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_order_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_order_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_order_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_order_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderinstructions_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderinstructions_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderinstructions_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderinstructions_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderstatus_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderstatus_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderstatus_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_orderstatus_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_portabledid_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_presentationdefinition_get_json_serialized_presentation_definition(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_presentationdefinition_select_credentials(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_quote_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_quote_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_quote_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_quote_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_replytorequestbody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_replytorequestbody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_verify(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_verify_all_private_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_verify_offering_requirements(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_rfq_verify_present_private_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_signer_sign(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_updateexchangerequestbody_get_data(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_method_updateexchangerequestbody_to_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_balance_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_balance_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_bearerdid_from_portable_did(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_bearerdid_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_cancel_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_cancel_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_close_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_close_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_createexchangerequestbody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_createexchangerequestbody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_errorresponsebody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_errorresponsebody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getbalancesresponsebody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getbalancesresponsebody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getexchangeresponsebody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getexchangeresponsebody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getexchangesresponsebody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getexchangesresponsebody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getofferingsresponsebody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_getofferingsresponsebody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_inmemorykeymanager_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_offering_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_offering_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_order_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_order_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_orderinstructions_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_orderinstructions_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_orderstatus_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_orderstatus_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_portabledid_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_presentationdefinition_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_quote_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_quote_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_replytorequestbody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_replytorequestbody_new(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_rfq_create(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_rfq_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_updateexchangerequestbody_from_json_string(
    ): Short
    fun uniffi_tbdex_uniffi_checksum_constructor_updateexchangerequestbody_new(
    ): Short
    fun ffi_tbdex_uniffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_tbdex_uniffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_tbdex_uniffi_checksum_func_create_exchange() != 61896.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_get_balances() != 23.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_get_exchange() != 35978.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_get_exchange_ids() != 44594.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_get_offerings() != 28498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_submit_cancel() != 12166.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_func_submit_order() != 1359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_balance_get_data() != 39037.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_balance_sign() != 54379.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_balance_to_json_string() != 18580.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_balance_verify() != 64077.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_bearerdid_get_data() != 7101.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_bearerdid_get_signer() != 22456.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_cancel_get_data() != 105.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_cancel_sign() != 4101.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_cancel_to_json_string() != 37921.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_cancel_verify() != 65342.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_close_get_data() != 41718.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_close_sign() != 59852.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_close_to_json_string() != 9967.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_close_verify() != 57917.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_createexchangerequestbody_get_data() != 33862.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_createexchangerequestbody_to_json_string() != 61746.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_errorresponsebody_get_data() != 51222.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_errorresponsebody_to_json_string() != 16077.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getbalancesresponsebody_get_data() != 50368.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getbalancesresponsebody_to_json_string() != 27806.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getexchangeresponsebody_get_data() != 50430.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getexchangeresponsebody_to_json_string() != 59710.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getexchangesresponsebody_get_data() != 18427.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getexchangesresponsebody_to_json_string() != 59017.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getofferingsresponsebody_get_data() != 26222.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_getofferingsresponsebody_to_json_string() != 15472.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_get_as_key_manager() != 181.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_get_signer() != 36148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_inmemorykeymanager_import_private_jwk() != 3278.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_keymanager_get_signer() != 55674.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_offering_get_data() != 20546.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_offering_sign() != 42409.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_offering_to_json_string() != 21259.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_offering_verify() != 30987.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_order_get_data() != 38200.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_order_sign() != 16796.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_order_to_json_string() != 53588.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_order_verify() != 47944.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderinstructions_get_data() != 38565.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderinstructions_sign() != 51485.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderinstructions_to_json_string() != 39014.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderinstructions_verify() != 4103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderstatus_get_data() != 26826.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderstatus_sign() != 2178.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderstatus_to_json_string() != 42493.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_orderstatus_verify() != 56745.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_portabledid_get_data() != 16147.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_presentationdefinition_get_json_serialized_presentation_definition() != 16906.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_presentationdefinition_select_credentials() != 31180.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_quote_get_data() != 53459.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_quote_sign() != 21947.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_quote_to_json_string() != 49963.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_quote_verify() != 43128.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_replytorequestbody_get_data() != 11854.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_replytorequestbody_to_json_string() != 33451.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_get_data() != 50070.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_sign() != 3822.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_to_json_string() != 60322.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_verify() != 29222.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_verify_all_private_data() != 5632.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_verify_offering_requirements() != 55911.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_rfq_verify_present_private_data() != 8587.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_signer_sign() != 42600.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_updateexchangerequestbody_get_data() != 53389.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_method_updateexchangerequestbody_to_json_string() != 57846.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_balance_create() != 39930.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_balance_from_json_string() != 25520.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_bearerdid_from_portable_did() != 56314.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_bearerdid_new() != 33593.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_cancel_create() != 5690.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_cancel_from_json_string() != 59371.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_close_create() != 20199.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_close_from_json_string() != 20779.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_createexchangerequestbody_from_json_string() != 9647.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_createexchangerequestbody_new() != 52537.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_errorresponsebody_from_json_string() != 2777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_errorresponsebody_new() != 27719.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getbalancesresponsebody_from_json_string() != 61702.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getbalancesresponsebody_new() != 51658.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getexchangeresponsebody_from_json_string() != 2697.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getexchangeresponsebody_new() != 13829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getexchangesresponsebody_from_json_string() != 36669.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getexchangesresponsebody_new() != 34532.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getofferingsresponsebody_from_json_string() != 61271.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_getofferingsresponsebody_new() != 63306.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_inmemorykeymanager_new() != 52263.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_offering_create() != 49339.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_offering_from_json_string() != 21106.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_order_create() != 44344.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_order_from_json_string() != 18477.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_orderinstructions_create() != 799.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_orderinstructions_from_json_string() != 2176.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_orderstatus_create() != 7053.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_orderstatus_from_json_string() != 7621.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_portabledid_new() != 39125.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_presentationdefinition_new() != 62739.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_quote_create() != 25928.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_quote_from_json_string() != 2463.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_replytorequestbody_from_json_string() != 56285.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_replytorequestbody_new() != 7836.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_rfq_create() != 28851.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_rfq_from_json_string() != 35318.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_updateexchangerequestbody_from_json_string() != 11043.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_tbdex_uniffi_checksum_constructor_updateexchangerequestbody_new() != 28121.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** Used to instantiate an interface without an actual pointer, for fakes in tests, mostly. */
object NoPointer

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


// The cleaner interface for Object finalization code to run.
// This is the entry point to any implementation that we're using.
//
// The cleaner registers objects and returns cleanables, so now we are
// defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
// different implmentations available at compile time.
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
public interface BalanceInterface {
    
    fun `getData`(): BalanceData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Balance: Disposable, AutoCloseable, BalanceInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_balance(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_balance(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): BalanceData {
            return FfiConverterTypeBalanceData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_balance_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_balance_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_balance_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_balance_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`from`: kotlin.String, `data`: BalanceDataData, `protocol`: kotlin.String?): Balance {
            return FfiConverterTypeBalance.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_balance_create(
        FfiConverterString.lower(`from`),FfiConverterTypeBalanceDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Balance {
            return FfiConverterTypeBalance.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_balance_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeBalance: FfiConverter<Balance, Pointer> {

    override fun lower(value: Balance): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Balance {
        return Balance(value)
    }

    override fun read(buf: ByteBuffer): Balance {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Balance) = 8UL

    override fun write(value: Balance, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface BearerDidInterface {
    
    fun `getData`(): BearerDidData
    
    fun `getSigner`(`keyId`: kotlin.String): Signer
    
    companion object
}

open class BearerDid: Disposable, AutoCloseable, BearerDidInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`uri`: kotlin.String, `keyManager`: KeyManager) :
        this(
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_bearerdid_new(
        FfiConverterString.lower(`uri`),FfiConverterTypeKeyManager.lower(`keyManager`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_bearerdid(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_bearerdid(pointer!!, status)
        }
    }

    override fun `getData`(): BearerDidData {
            return FfiConverterTypeBearerDidData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_bearerdid_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5RustCoreException::class)override fun `getSigner`(`keyId`: kotlin.String): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_bearerdid_get_signer(
        it, FfiConverterString.lower(`keyId`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5RustCoreException::class) fun `fromPortableDid`(`portableDid`: PortableDid): BearerDid {
            return FfiConverterTypeBearerDid.lift(
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_bearerdid_from_portable_did(
        FfiConverterTypePortableDid.lower(`portableDid`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeBearerDid: FfiConverter<BearerDid, Pointer> {

    override fun lower(value: BearerDid): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): BearerDid {
        return BearerDid(value)
    }

    override fun read(buf: ByteBuffer): BearerDid {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: BearerDid) = 8UL

    override fun write(value: BearerDid, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface CancelInterface {
    
    fun `getData`(): CancelData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Cancel: Disposable, AutoCloseable, CancelInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_cancel(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_cancel(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): CancelData {
            return FfiConverterTypeCancelData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_cancel_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_cancel_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_cancel_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_cancel_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `data`: CancelDataData, `protocol`: kotlin.String?, `externalId`: kotlin.String?): Cancel {
            return FfiConverterTypeCancel.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_cancel_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterTypeCancelDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Cancel {
            return FfiConverterTypeCancel.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_cancel_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeCancel: FfiConverter<Cancel, Pointer> {

    override fun lower(value: Cancel): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Cancel {
        return Cancel(value)
    }

    override fun read(buf: ByteBuffer): Cancel {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Cancel) = 8UL

    override fun write(value: Cancel, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface CloseInterface {
    
    fun `getData`(): CloseData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Close: Disposable, AutoCloseable, CloseInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_close(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_close(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): CloseData {
            return FfiConverterTypeCloseData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_close_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_close_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_close_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_close_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `data`: CloseDataData, `protocol`: kotlin.String?, `externalId`: kotlin.String?): Close {
            return FfiConverterTypeClose.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_close_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterTypeCloseDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Close {
            return FfiConverterTypeClose.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_close_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeClose: FfiConverter<Close, Pointer> {

    override fun lower(value: Close): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Close {
        return Close(value)
    }

    override fun read(buf: ByteBuffer): Close {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Close) = 8UL

    override fun write(value: Close, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface CreateExchangeRequestBodyInterface {
    
    fun `getData`(): CreateExchangeRequestBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class CreateExchangeRequestBody: Disposable, AutoCloseable, CreateExchangeRequestBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`message`: Rfq, `replyTo`: kotlin.String?) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_createexchangerequestbody_new(
        FfiConverterTypeRfq.lower(`message`),FfiConverterOptionalString.lower(`replyTo`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_createexchangerequestbody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_createexchangerequestbody(pointer!!, status)
        }
    }

    override fun `getData`(): CreateExchangeRequestBodyData {
            return FfiConverterTypeCreateExchangeRequestBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_createexchangerequestbody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_createexchangerequestbody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): CreateExchangeRequestBody {
            return FfiConverterTypeCreateExchangeRequestBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_createexchangerequestbody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeCreateExchangeRequestBody: FfiConverter<CreateExchangeRequestBody, Pointer> {

    override fun lower(value: CreateExchangeRequestBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): CreateExchangeRequestBody {
        return CreateExchangeRequestBody(value)
    }

    override fun read(buf: ByteBuffer): CreateExchangeRequestBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CreateExchangeRequestBody) = 8UL

    override fun write(value: CreateExchangeRequestBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ErrorResponseBodyInterface {
    
    fun `getData`(): ErrorResponseBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class ErrorResponseBody: Disposable, AutoCloseable, ErrorResponseBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`message`: kotlin.String, `details`: List<ErrorDetailData>?) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_errorresponsebody_new(
        FfiConverterString.lower(`message`),FfiConverterOptionalSequenceTypeErrorDetailData.lower(`details`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_errorresponsebody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_errorresponsebody(pointer!!, status)
        }
    }

    override fun `getData`(): ErrorResponseBodyData {
            return FfiConverterTypeErrorResponseBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_errorresponsebody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_errorresponsebody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): ErrorResponseBody {
            return FfiConverterTypeErrorResponseBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_errorresponsebody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeErrorResponseBody: FfiConverter<ErrorResponseBody, Pointer> {

    override fun lower(value: ErrorResponseBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ErrorResponseBody {
        return ErrorResponseBody(value)
    }

    override fun read(buf: ByteBuffer): ErrorResponseBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ErrorResponseBody) = 8UL

    override fun write(value: ErrorResponseBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface GetBalancesResponseBodyInterface {
    
    fun `getData`(): GetBalancesResponseBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class GetBalancesResponseBody: Disposable, AutoCloseable, GetBalancesResponseBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`balances`: List<Balance>) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getbalancesresponsebody_new(
        FfiConverterSequenceTypeBalance.lower(`balances`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_getbalancesresponsebody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_getbalancesresponsebody(pointer!!, status)
        }
    }

    override fun `getData`(): GetBalancesResponseBodyData {
            return FfiConverterTypeGetBalancesResponseBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getbalancesresponsebody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getbalancesresponsebody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): GetBalancesResponseBody {
            return FfiConverterTypeGetBalancesResponseBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getbalancesresponsebody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeGetBalancesResponseBody: FfiConverter<GetBalancesResponseBody, Pointer> {

    override fun lower(value: GetBalancesResponseBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GetBalancesResponseBody {
        return GetBalancesResponseBody(value)
    }

    override fun read(buf: ByteBuffer): GetBalancesResponseBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GetBalancesResponseBody) = 8UL

    override fun write(value: GetBalancesResponseBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface GetExchangeResponseBodyInterface {
    
    fun `getData`(): GetExchangeResponseBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class GetExchangeResponseBody: Disposable, AutoCloseable, GetExchangeResponseBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`responseBodyData`: GetExchangeResponseBodyData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getexchangeresponsebody_new(
        FfiConverterTypeGetExchangeResponseBodyData.lower(`responseBodyData`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_getexchangeresponsebody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_getexchangeresponsebody(pointer!!, status)
        }
    }

    override fun `getData`(): GetExchangeResponseBodyData {
            return FfiConverterTypeGetExchangeResponseBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getexchangeresponsebody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getexchangeresponsebody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): GetExchangeResponseBody {
            return FfiConverterTypeGetExchangeResponseBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getexchangeresponsebody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeGetExchangeResponseBody: FfiConverter<GetExchangeResponseBody, Pointer> {

    override fun lower(value: GetExchangeResponseBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GetExchangeResponseBody {
        return GetExchangeResponseBody(value)
    }

    override fun read(buf: ByteBuffer): GetExchangeResponseBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GetExchangeResponseBody) = 8UL

    override fun write(value: GetExchangeResponseBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface GetExchangesResponseBodyInterface {
    
    fun `getData`(): GetExchangesResponseBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class GetExchangesResponseBody: Disposable, AutoCloseable, GetExchangesResponseBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`data`: List<kotlin.String>) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getexchangesresponsebody_new(
        FfiConverterSequenceString.lower(`data`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_getexchangesresponsebody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_getexchangesresponsebody(pointer!!, status)
        }
    }

    override fun `getData`(): GetExchangesResponseBodyData {
            return FfiConverterTypeGetExchangesResponseBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getexchangesresponsebody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getexchangesresponsebody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): GetExchangesResponseBody {
            return FfiConverterTypeGetExchangesResponseBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getexchangesresponsebody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeGetExchangesResponseBody: FfiConverter<GetExchangesResponseBody, Pointer> {

    override fun lower(value: GetExchangesResponseBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GetExchangesResponseBody {
        return GetExchangesResponseBody(value)
    }

    override fun read(buf: ByteBuffer): GetExchangesResponseBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GetExchangesResponseBody) = 8UL

    override fun write(value: GetExchangesResponseBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface GetOfferingsResponseBodyInterface {
    
    fun `getData`(): GetOfferingsResponseBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class GetOfferingsResponseBody: Disposable, AutoCloseable, GetOfferingsResponseBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`offerings`: List<Offering>) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getofferingsresponsebody_new(
        FfiConverterSequenceTypeOffering.lower(`offerings`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_getofferingsresponsebody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_getofferingsresponsebody(pointer!!, status)
        }
    }

    override fun `getData`(): GetOfferingsResponseBodyData {
            return FfiConverterTypeGetOfferingsResponseBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getofferingsresponsebody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_getofferingsresponsebody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): GetOfferingsResponseBody {
            return FfiConverterTypeGetOfferingsResponseBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_getofferingsresponsebody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeGetOfferingsResponseBody: FfiConverter<GetOfferingsResponseBody, Pointer> {

    override fun lower(value: GetOfferingsResponseBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GetOfferingsResponseBody {
        return GetOfferingsResponseBody(value)
    }

    override fun read(buf: ByteBuffer): GetOfferingsResponseBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GetOfferingsResponseBody) = 8UL

    override fun write(value: GetOfferingsResponseBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface InMemoryKeyManagerInterface {
    
    fun `getAsKeyManager`(): KeyManager
    
    fun `getSigner`(`publicJwk`: JwkData): Signer
    
    fun `importPrivateJwk`(`privateKey`: JwkData): JwkData
    
    companion object
}

open class InMemoryKeyManager: Disposable, AutoCloseable, InMemoryKeyManagerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_inmemorykeymanager_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_inmemorykeymanager(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_inmemorykeymanager(pointer!!, status)
        }
    }

    override fun `getAsKeyManager`(): KeyManager {
            return FfiConverterTypeKeyManager.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_get_as_key_manager(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5RustCoreException::class)override fun `getSigner`(`publicJwk`: JwkData): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_get_signer(
        it, FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    }
    )
    }
    

    
    @Throws(Web5RustCoreException::class)override fun `importPrivateJwk`(`privateKey`: JwkData): JwkData {
            return FfiConverterTypeJwkData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_inmemorykeymanager_import_private_jwk(
        it, FfiConverterTypeJwkData.lower(`privateKey`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeInMemoryKeyManager: FfiConverter<InMemoryKeyManager, Pointer> {

    override fun lower(value: InMemoryKeyManager): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): InMemoryKeyManager {
        return InMemoryKeyManager(value)
    }

    override fun read(buf: ByteBuffer): InMemoryKeyManager {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: InMemoryKeyManager) = 8UL

    override fun write(value: InMemoryKeyManager, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface KeyManager {
    
    fun `getSigner`(`publicJwk`: JwkData): Signer
    
    companion object
}

open class KeyManagerImpl: Disposable, AutoCloseable, KeyManager {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_keymanager(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_keymanager(pointer!!, status)
        }
    }

    
    @Throws(Web5RustCoreException::class)override fun `getSigner`(`publicJwk`: JwkData): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_keymanager_get_signer(
        it, FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}
// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface: Any>: FfiConverter<CallbackInterface, Long> {
    internal val handleMap = UniffiHandleMap<CallbackInterface>()

    internal fun drop(handle: Long) {
        handleMap.remove(handle)
    }

    override fun lift(value: Long): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8UL

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceKeyManager {
    internal object `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0 {
        override fun callback(`uniffiHandle`: Long,`publicJwk`: RustBuffer.ByValue,`uniffiOutReturn`: PointerByReference,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeKeyManager.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`getSigner`(
                    FfiConverterTypeJwkData.lift(`publicJwk`),
                )
            }
            val writeReturn = { value: Signer -> uniffiOutReturn.setValue(FfiConverterTypeSigner.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5RustCoreException -> FfiConverterTypeWeb5RustCoreError.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeKeyManager.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceKeyManager.UniffiByValue(
        `getSigner`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_tbdex_uniffi_fn_init_callback_vtable_keymanager(vtable)
    }
}

public object FfiConverterTypeKeyManager: FfiConverter<KeyManager, Pointer> {
    internal val handleMap = UniffiHandleMap<KeyManager>()

    override fun lower(value: KeyManager): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): KeyManager {
        return KeyManagerImpl(value)
    }

    override fun read(buf: ByteBuffer): KeyManager {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: KeyManager) = 8UL

    override fun write(value: KeyManager, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface OfferingInterface {
    
    fun `getData`(): OfferingData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Offering: Disposable, AutoCloseable, OfferingInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_offering(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_offering(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): OfferingData {
            return FfiConverterTypeOfferingData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_offering_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_offering_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_offering_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_offering_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`from`: kotlin.String, `jsonSerializedData`: kotlin.String, `protocol`: kotlin.String?): Offering {
            return FfiConverterTypeOffering.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_offering_create(
        FfiConverterString.lower(`from`),FfiConverterString.lower(`jsonSerializedData`),FfiConverterOptionalString.lower(`protocol`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Offering {
            return FfiConverterTypeOffering.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_offering_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeOffering: FfiConverter<Offering, Pointer> {

    override fun lower(value: Offering): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Offering {
        return Offering(value)
    }

    override fun read(buf: ByteBuffer): Offering {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Offering) = 8UL

    override fun write(value: Offering, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface OrderInterface {
    
    fun `getData`(): OrderData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Order: Disposable, AutoCloseable, OrderInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_order(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_order(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): OrderData {
            return FfiConverterTypeOrderData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_order_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_order_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_order_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_order_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `protocol`: kotlin.String?, `externalId`: kotlin.String?): Order {
            return FfiConverterTypeOrder.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_order_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Order {
            return FfiConverterTypeOrder.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_order_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeOrder: FfiConverter<Order, Pointer> {

    override fun lower(value: Order): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Order {
        return Order(value)
    }

    override fun read(buf: ByteBuffer): Order {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Order) = 8UL

    override fun write(value: Order, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface OrderInstructionsInterface {
    
    fun `getData`(): OrderInstructionsData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class OrderInstructions: Disposable, AutoCloseable, OrderInstructionsInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_orderinstructions(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_orderinstructions(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): OrderInstructionsData {
            return FfiConverterTypeOrderInstructionsData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderinstructions_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderinstructions_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderinstructions_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderinstructions_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `data`: OrderInstructionsDataData, `protocol`: kotlin.String?, `externalId`: kotlin.String?): OrderInstructions {
            return FfiConverterTypeOrderInstructions.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_orderinstructions_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterTypeOrderInstructionsDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): OrderInstructions {
            return FfiConverterTypeOrderInstructions.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_orderinstructions_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeOrderInstructions: FfiConverter<OrderInstructions, Pointer> {

    override fun lower(value: OrderInstructions): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): OrderInstructions {
        return OrderInstructions(value)
    }

    override fun read(buf: ByteBuffer): OrderInstructions {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: OrderInstructions) = 8UL

    override fun write(value: OrderInstructions, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface OrderStatusInterface {
    
    fun `getData`(): OrderStatusData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class OrderStatus: Disposable, AutoCloseable, OrderStatusInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_orderstatus(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_orderstatus(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): OrderStatusData {
            return FfiConverterTypeOrderStatusData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderstatus_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderstatus_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderstatus_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_orderstatus_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `data`: OrderStatusDataData, `protocol`: kotlin.String?, `externalId`: kotlin.String?): OrderStatus {
            return FfiConverterTypeOrderStatus.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_orderstatus_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterTypeOrderStatusDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): OrderStatus {
            return FfiConverterTypeOrderStatus.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_orderstatus_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeOrderStatus: FfiConverter<OrderStatus, Pointer> {

    override fun lower(value: OrderStatus): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): OrderStatus {
        return OrderStatus(value)
    }

    override fun read(buf: ByteBuffer): OrderStatus {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: OrderStatus) = 8UL

    override fun write(value: OrderStatus, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface PortableDidInterface {
    
    fun `getData`(): PortableDidData
    
    companion object
}

open class PortableDid: Disposable, AutoCloseable, PortableDidInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`json`: kotlin.String) :
        this(
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_portabledid_new(
        FfiConverterString.lower(`json`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_portabledid(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_portabledid(pointer!!, status)
        }
    }

    override fun `getData`(): PortableDidData {
            return FfiConverterTypePortableDidData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_portabledid_get_data(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypePortableDid: FfiConverter<PortableDid, Pointer> {

    override fun lower(value: PortableDid): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PortableDid {
        return PortableDid(value)
    }

    override fun read(buf: ByteBuffer): PortableDid {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PortableDid) = 8UL

    override fun write(value: PortableDid, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface PresentationDefinitionInterface {
    
    fun `getJsonSerializedPresentationDefinition`(): kotlin.String
    
    fun `selectCredentials`(`vcJwts`: List<kotlin.String>): List<kotlin.String>
    
    companion object
}

open class PresentationDefinition: Disposable, AutoCloseable, PresentationDefinitionInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`jsonSerializedPresentationDefinition`: kotlin.String) :
        this(
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_presentationdefinition_new(
        FfiConverterString.lower(`jsonSerializedPresentationDefinition`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_presentationdefinition(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_presentationdefinition(pointer!!, status)
        }
    }

    
    @Throws(Web5RustCoreException::class)override fun `getJsonSerializedPresentationDefinition`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_presentationdefinition_get_json_serialized_presentation_definition(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5RustCoreException::class)override fun `selectCredentials`(`vcJwts`: List<kotlin.String>): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_presentationdefinition_select_credentials(
        it, FfiConverterSequenceString.lower(`vcJwts`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypePresentationDefinition: FfiConverter<PresentationDefinition, Pointer> {

    override fun lower(value: PresentationDefinition): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PresentationDefinition {
        return PresentationDefinition(value)
    }

    override fun read(buf: ByteBuffer): PresentationDefinition {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PresentationDefinition) = 8UL

    override fun write(value: PresentationDefinition, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface QuoteInterface {
    
    fun `getData`(): QuoteData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    companion object
}

open class Quote: Disposable, AutoCloseable, QuoteInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_quote(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_quote(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): QuoteData {
            return FfiConverterTypeQuoteData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_quote_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_quote_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_quote_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_quote_verify(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `exchangeId`: kotlin.String, `data`: QuoteDataData, `protocol`: kotlin.String?, `externalId`: kotlin.String?): Quote {
            return FfiConverterTypeQuote.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_quote_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`exchangeId`),FfiConverterTypeQuoteDataData.lower(`data`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Quote {
            return FfiConverterTypeQuote.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_quote_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeQuote: FfiConverter<Quote, Pointer> {

    override fun lower(value: Quote): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Quote {
        return Quote(value)
    }

    override fun read(buf: ByteBuffer): Quote {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Quote) = 8UL

    override fun write(value: Quote, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ReplyToRequestBodyInterface {
    
    fun `getData`(): ReplyToRequestBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class ReplyToRequestBody: Disposable, AutoCloseable, ReplyToRequestBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`kind`: MessageKind, `jsonSerializedMessage`: kotlin.String) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_replytorequestbody_new(
        FfiConverterTypeMessageKind.lower(`kind`),FfiConverterString.lower(`jsonSerializedMessage`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_replytorequestbody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_replytorequestbody(pointer!!, status)
        }
    }

    override fun `getData`(): ReplyToRequestBodyData {
            return FfiConverterTypeReplyToRequestBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_replytorequestbody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_replytorequestbody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): ReplyToRequestBody {
            return FfiConverterTypeReplyToRequestBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_replytorequestbody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeReplyToRequestBody: FfiConverter<ReplyToRequestBody, Pointer> {

    override fun lower(value: ReplyToRequestBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ReplyToRequestBody {
        return ReplyToRequestBody(value)
    }

    override fun read(buf: ByteBuffer): ReplyToRequestBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ReplyToRequestBody) = 8UL

    override fun write(value: ReplyToRequestBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RfqInterface {
    
    fun `getData`(): RfqData
    
    fun `sign`(`bearerDid`: BearerDid)
    
    fun `toJsonString`(): kotlin.String
    
    fun `verify`()
    
    fun `verifyAllPrivateData`()
    
    fun `verifyOfferingRequirements`(`offering`: Offering)
    
    fun `verifyPresentPrivateData`()
    
    companion object
}

open class Rfq: Disposable, AutoCloseable, RfqInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_rfq(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_rfq(pointer!!, status)
        }
    }

    
    @Throws(TbdexSdkException::class)override fun `getData`(): RfqData {
            return FfiConverterTypeRfqData.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `sign`(`bearerDid`: BearerDid)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_to_json_string(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `verify`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_verify(
        it, _status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `verifyAllPrivateData`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_verify_all_private_data(
        it, _status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `verifyOfferingRequirements`(`offering`: Offering)
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_verify_offering_requirements(
        it, FfiConverterTypeOffering.lower(`offering`),_status)
}
    }
    
    

    
    @Throws(TbdexSdkException::class)override fun `verifyPresentPrivateData`()
        = 
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_rfq_verify_present_private_data(
        it, _status)
}
    }
    
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `create`(`to`: kotlin.String, `from`: kotlin.String, `jsonSerializedCreateRfqData`: kotlin.String, `protocol`: kotlin.String?, `externalId`: kotlin.String?): Rfq {
            return FfiConverterTypeRfq.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_rfq_create(
        FfiConverterString.lower(`to`),FfiConverterString.lower(`from`),FfiConverterString.lower(`jsonSerializedCreateRfqData`),FfiConverterOptionalString.lower(`protocol`),FfiConverterOptionalString.lower(`externalId`),_status)
}
    )
    }
    

        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): Rfq {
            return FfiConverterTypeRfq.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_rfq_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeRfq: FfiConverter<Rfq, Pointer> {

    override fun lower(value: Rfq): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Rfq {
        return Rfq(value)
    }

    override fun read(buf: ByteBuffer): Rfq {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Rfq) = 8UL

    override fun write(value: Rfq, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Signer {
    
    fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray
    
    companion object
}

open class SignerImpl: Disposable, AutoCloseable, Signer {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_signer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_signer(pointer!!, status)
        }
    }

    
    @Throws(Web5RustCoreException::class)override fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray {
            return FfiConverterByteArray.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5RustCoreException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_signer_sign(
        it, FfiConverterByteArray.lower(`payload`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceSigner {
    internal object `sign`: UniffiCallbackInterfaceSignerMethod0 {
        override fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeSigner.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`sign`(
                    FfiConverterByteArray.lift(`payload`),
                )
            }
            val writeReturn = { value: kotlin.ByteArray -> uniffiOutReturn.setValue(FfiConverterByteArray.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5RustCoreException -> FfiConverterTypeWeb5RustCoreError.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeSigner.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceSigner.UniffiByValue(
        `sign`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_tbdex_uniffi_fn_init_callback_vtable_signer(vtable)
    }
}

public object FfiConverterTypeSigner: FfiConverter<Signer, Pointer> {
    internal val handleMap = UniffiHandleMap<Signer>()

    override fun lower(value: Signer): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): Signer {
        return SignerImpl(value)
    }

    override fun read(buf: ByteBuffer): Signer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Signer) = 8UL

    override fun write(value: Signer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface UpdateExchangeRequestBodyInterface {
    
    fun `getData`(): UpdateExchangeRequestBodyData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class UpdateExchangeRequestBody: Disposable, AutoCloseable, UpdateExchangeRequestBodyInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`kind`: MessageKind, `jsonSerializedMessage`: kotlin.String) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_updateexchangerequestbody_new(
        FfiConverterTypeMessageKind.lower(`kind`),FfiConverterString.lower(`jsonSerializedMessage`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_free_updateexchangerequestbody(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_clone_updateexchangerequestbody(pointer!!, status)
        }
    }

    override fun `getData`(): UpdateExchangeRequestBodyData {
            return FfiConverterTypeUpdateExchangeRequestBodyData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_updateexchangerequestbody_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(TbdexSdkException::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_method_updateexchangerequestbody_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(TbdexSdkException::class) fun `fromJsonString`(`json`: kotlin.String): UpdateExchangeRequestBody {
            return FfiConverterTypeUpdateExchangeRequestBody.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_constructor_updateexchangerequestbody_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeUpdateExchangeRequestBody: FfiConverter<UpdateExchangeRequestBody, Pointer> {

    override fun lower(value: UpdateExchangeRequestBody): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): UpdateExchangeRequestBody {
        return UpdateExchangeRequestBody(value)
    }

    override fun read(buf: ByteBuffer): UpdateExchangeRequestBody {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: UpdateExchangeRequestBody) = 8UL

    override fun write(value: UpdateExchangeRequestBody, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class BalanceData (
    var `metadata`: ResourceMetadataData, 
    var `data`: BalanceDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeBalanceData: FfiConverterRustBuffer<BalanceData> {
    override fun read(buf: ByteBuffer): BalanceData {
        return BalanceData(
            FfiConverterTypeResourceMetadataData.read(buf),
            FfiConverterTypeBalanceDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: BalanceData) = (
            FfiConverterTypeResourceMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeBalanceDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: BalanceData, buf: ByteBuffer) {
            FfiConverterTypeResourceMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeBalanceDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class BalanceDataData (
    var `currencyCode`: kotlin.String, 
    var `available`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeBalanceDataData: FfiConverterRustBuffer<BalanceDataData> {
    override fun read(buf: ByteBuffer): BalanceDataData {
        return BalanceDataData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: BalanceDataData) = (
            FfiConverterString.allocationSize(value.`currencyCode`) +
            FfiConverterString.allocationSize(value.`available`)
    )

    override fun write(value: BalanceDataData, buf: ByteBuffer) {
            FfiConverterString.write(value.`currencyCode`, buf)
            FfiConverterString.write(value.`available`, buf)
    }
}



data class BearerDidData (
    var `did`: DidData, 
    var `document`: DocumentData, 
    var `keyManager`: KeyManager
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`did`, 
        this.`document`, 
        this.`keyManager`)
    }
    
    companion object
}

public object FfiConverterTypeBearerDidData: FfiConverterRustBuffer<BearerDidData> {
    override fun read(buf: ByteBuffer): BearerDidData {
        return BearerDidData(
            FfiConverterTypeDidData.read(buf),
            FfiConverterTypeDocumentData.read(buf),
            FfiConverterTypeKeyManager.read(buf),
        )
    }

    override fun allocationSize(value: BearerDidData) = (
            FfiConverterTypeDidData.allocationSize(value.`did`) +
            FfiConverterTypeDocumentData.allocationSize(value.`document`) +
            FfiConverterTypeKeyManager.allocationSize(value.`keyManager`)
    )

    override fun write(value: BearerDidData, buf: ByteBuffer) {
            FfiConverterTypeDidData.write(value.`did`, buf)
            FfiConverterTypeDocumentData.write(value.`document`, buf)
            FfiConverterTypeKeyManager.write(value.`keyManager`, buf)
    }
}



data class CancelData (
    var `metadata`: MessageMetadataData, 
    var `data`: CancelDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeCancelData: FfiConverterRustBuffer<CancelData> {
    override fun read(buf: ByteBuffer): CancelData {
        return CancelData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeCancelDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CancelData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeCancelDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: CancelData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeCancelDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class CancelDataData (
    var `reason`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeCancelDataData: FfiConverterRustBuffer<CancelDataData> {
    override fun read(buf: ByteBuffer): CancelDataData {
        return CancelDataData(
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CancelDataData) = (
            FfiConverterString.allocationSize(value.`reason`)
    )

    override fun write(value: CancelDataData, buf: ByteBuffer) {
            FfiConverterString.write(value.`reason`, buf)
    }
}



data class CloseData (
    var `metadata`: MessageMetadataData, 
    var `data`: CloseDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeCloseData: FfiConverterRustBuffer<CloseData> {
    override fun read(buf: ByteBuffer): CloseData {
        return CloseData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeCloseDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CloseData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeCloseDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: CloseData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeCloseDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class CloseDataData (
    var `reason`: kotlin.String?, 
    var `success`: kotlin.Boolean?
) {
    
    companion object
}

public object FfiConverterTypeCloseDataData: FfiConverterRustBuffer<CloseDataData> {
    override fun read(buf: ByteBuffer): CloseDataData {
        return CloseDataData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: CloseDataData) = (
            FfiConverterOptionalString.allocationSize(value.`reason`) +
            FfiConverterOptionalBoolean.allocationSize(value.`success`)
    )

    override fun write(value: CloseDataData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`reason`, buf)
            FfiConverterOptionalBoolean.write(value.`success`, buf)
    }
}



data class CreateExchangeRequestBodyData (
    var `message`: Rfq, 
    var `replyTo`: kotlin.String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`message`, 
        this.`replyTo`)
    }
    
    companion object
}

public object FfiConverterTypeCreateExchangeRequestBodyData: FfiConverterRustBuffer<CreateExchangeRequestBodyData> {
    override fun read(buf: ByteBuffer): CreateExchangeRequestBodyData {
        return CreateExchangeRequestBodyData(
            FfiConverterTypeRfq.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: CreateExchangeRequestBodyData) = (
            FfiConverterTypeRfq.allocationSize(value.`message`) +
            FfiConverterOptionalString.allocationSize(value.`replyTo`)
    )

    override fun write(value: CreateExchangeRequestBodyData, buf: ByteBuffer) {
            FfiConverterTypeRfq.write(value.`message`, buf)
            FfiConverterOptionalString.write(value.`replyTo`, buf)
    }
}



data class DidData (
    var `uri`: kotlin.String, 
    var `url`: kotlin.String, 
    var `method`: kotlin.String, 
    var `id`: kotlin.String, 
    var `params`: Map<kotlin.String, kotlin.String>?, 
    var `path`: kotlin.String?, 
    var `query`: kotlin.String?, 
    var `fragment`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeDidData: FfiConverterRustBuffer<DidData> {
    override fun read(buf: ByteBuffer): DidData {
        return DidData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalMapStringString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: DidData) = (
            FfiConverterString.allocationSize(value.`uri`) +
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterString.allocationSize(value.`method`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalMapStringString.allocationSize(value.`params`) +
            FfiConverterOptionalString.allocationSize(value.`path`) +
            FfiConverterOptionalString.allocationSize(value.`query`) +
            FfiConverterOptionalString.allocationSize(value.`fragment`)
    )

    override fun write(value: DidData, buf: ByteBuffer) {
            FfiConverterString.write(value.`uri`, buf)
            FfiConverterString.write(value.`url`, buf)
            FfiConverterString.write(value.`method`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalMapStringString.write(value.`params`, buf)
            FfiConverterOptionalString.write(value.`path`, buf)
            FfiConverterOptionalString.write(value.`query`, buf)
            FfiConverterOptionalString.write(value.`fragment`, buf)
    }
}



data class DocumentData (
    var `id`: kotlin.String, 
    var `context`: List<kotlin.String>?, 
    var `controller`: List<kotlin.String>?, 
    var `alsoKnownAs`: List<kotlin.String>?, 
    var `verificationMethod`: List<VerificationMethodData>, 
    var `authentication`: List<kotlin.String>?, 
    var `assertionMethod`: List<kotlin.String>?, 
    var `keyAgreement`: List<kotlin.String>?, 
    var `capabilityInvocation`: List<kotlin.String>?, 
    var `capabilityDelegation`: List<kotlin.String>?, 
    var `service`: List<ServiceData>?
) {
    
    companion object
}

public object FfiConverterTypeDocumentData: FfiConverterRustBuffer<DocumentData> {
    override fun read(buf: ByteBuffer): DocumentData {
        return DocumentData(
            FfiConverterString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterSequenceTypeVerificationMethodData.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceTypeServiceData.read(buf),
        )
    }

    override fun allocationSize(value: DocumentData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`context`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`controller`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`alsoKnownAs`) +
            FfiConverterSequenceTypeVerificationMethodData.allocationSize(value.`verificationMethod`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`authentication`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`assertionMethod`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`keyAgreement`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`capabilityInvocation`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`capabilityDelegation`) +
            FfiConverterOptionalSequenceTypeServiceData.allocationSize(value.`service`)
    )

    override fun write(value: DocumentData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalSequenceString.write(value.`context`, buf)
            FfiConverterOptionalSequenceString.write(value.`controller`, buf)
            FfiConverterOptionalSequenceString.write(value.`alsoKnownAs`, buf)
            FfiConverterSequenceTypeVerificationMethodData.write(value.`verificationMethod`, buf)
            FfiConverterOptionalSequenceString.write(value.`authentication`, buf)
            FfiConverterOptionalSequenceString.write(value.`assertionMethod`, buf)
            FfiConverterOptionalSequenceString.write(value.`keyAgreement`, buf)
            FfiConverterOptionalSequenceString.write(value.`capabilityInvocation`, buf)
            FfiConverterOptionalSequenceString.write(value.`capabilityDelegation`, buf)
            FfiConverterOptionalSequenceTypeServiceData.write(value.`service`, buf)
    }
}



data class ErrorDetailData (
    var `id`: kotlin.String?, 
    var `message`: kotlin.String?, 
    var `path`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeErrorDetailData: FfiConverterRustBuffer<ErrorDetailData> {
    override fun read(buf: ByteBuffer): ErrorDetailData {
        return ErrorDetailData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ErrorDetailData) = (
            FfiConverterOptionalString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`message`) +
            FfiConverterOptionalString.allocationSize(value.`path`)
    )

    override fun write(value: ErrorDetailData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`message`, buf)
            FfiConverterOptionalString.write(value.`path`, buf)
    }
}



data class ErrorResponseBodyData (
    var `message`: kotlin.String, 
    var `details`: List<ErrorDetailData>?
) {
    
    companion object
}

public object FfiConverterTypeErrorResponseBodyData: FfiConverterRustBuffer<ErrorResponseBodyData> {
    override fun read(buf: ByteBuffer): ErrorResponseBodyData {
        return ErrorResponseBodyData(
            FfiConverterString.read(buf),
            FfiConverterOptionalSequenceTypeErrorDetailData.read(buf),
        )
    }

    override fun allocationSize(value: ErrorResponseBodyData) = (
            FfiConverterString.allocationSize(value.`message`) +
            FfiConverterOptionalSequenceTypeErrorDetailData.allocationSize(value.`details`)
    )

    override fun write(value: ErrorResponseBodyData, buf: ByteBuffer) {
            FfiConverterString.write(value.`message`, buf)
            FfiConverterOptionalSequenceTypeErrorDetailData.write(value.`details`, buf)
    }
}



data class ExchangeData (
    var `rfq`: Rfq, 
    var `quote`: Quote?, 
    var `order`: Order?, 
    var `orderInstructions`: OrderInstructions?, 
    var `cancel`: Cancel?, 
    var `orderStatuses`: List<OrderStatus>?, 
    var `close`: Close?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`rfq`, 
        this.`quote`, 
        this.`order`, 
        this.`orderInstructions`, 
        this.`cancel`, 
        this.`orderStatuses`, 
        this.`close`)
    }
    
    companion object
}

public object FfiConverterTypeExchangeData: FfiConverterRustBuffer<ExchangeData> {
    override fun read(buf: ByteBuffer): ExchangeData {
        return ExchangeData(
            FfiConverterTypeRfq.read(buf),
            FfiConverterOptionalTypeQuote.read(buf),
            FfiConverterOptionalTypeOrder.read(buf),
            FfiConverterOptionalTypeOrderInstructions.read(buf),
            FfiConverterOptionalTypeCancel.read(buf),
            FfiConverterOptionalSequenceTypeOrderStatus.read(buf),
            FfiConverterOptionalTypeClose.read(buf),
        )
    }

    override fun allocationSize(value: ExchangeData) = (
            FfiConverterTypeRfq.allocationSize(value.`rfq`) +
            FfiConverterOptionalTypeQuote.allocationSize(value.`quote`) +
            FfiConverterOptionalTypeOrder.allocationSize(value.`order`) +
            FfiConverterOptionalTypeOrderInstructions.allocationSize(value.`orderInstructions`) +
            FfiConverterOptionalTypeCancel.allocationSize(value.`cancel`) +
            FfiConverterOptionalSequenceTypeOrderStatus.allocationSize(value.`orderStatuses`) +
            FfiConverterOptionalTypeClose.allocationSize(value.`close`)
    )

    override fun write(value: ExchangeData, buf: ByteBuffer) {
            FfiConverterTypeRfq.write(value.`rfq`, buf)
            FfiConverterOptionalTypeQuote.write(value.`quote`, buf)
            FfiConverterOptionalTypeOrder.write(value.`order`, buf)
            FfiConverterOptionalTypeOrderInstructions.write(value.`orderInstructions`, buf)
            FfiConverterOptionalTypeCancel.write(value.`cancel`, buf)
            FfiConverterOptionalSequenceTypeOrderStatus.write(value.`orderStatuses`, buf)
            FfiConverterOptionalTypeClose.write(value.`close`, buf)
    }
}



data class GetBalancesResponseBodyData (
    var `data`: List<Balance>
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`data`)
    }
    
    companion object
}

public object FfiConverterTypeGetBalancesResponseBodyData: FfiConverterRustBuffer<GetBalancesResponseBodyData> {
    override fun read(buf: ByteBuffer): GetBalancesResponseBodyData {
        return GetBalancesResponseBodyData(
            FfiConverterSequenceTypeBalance.read(buf),
        )
    }

    override fun allocationSize(value: GetBalancesResponseBodyData) = (
            FfiConverterSequenceTypeBalance.allocationSize(value.`data`)
    )

    override fun write(value: GetBalancesResponseBodyData, buf: ByteBuffer) {
            FfiConverterSequenceTypeBalance.write(value.`data`, buf)
    }
}



data class GetExchangeResponseBodyData (
    var `data`: List<GetExchangeResponseBodyDataSerializedMessage>
) {
    
    companion object
}

public object FfiConverterTypeGetExchangeResponseBodyData: FfiConverterRustBuffer<GetExchangeResponseBodyData> {
    override fun read(buf: ByteBuffer): GetExchangeResponseBodyData {
        return GetExchangeResponseBodyData(
            FfiConverterSequenceTypeGetExchangeResponseBodyDataSerializedMessage.read(buf),
        )
    }

    override fun allocationSize(value: GetExchangeResponseBodyData) = (
            FfiConverterSequenceTypeGetExchangeResponseBodyDataSerializedMessage.allocationSize(value.`data`)
    )

    override fun write(value: GetExchangeResponseBodyData, buf: ByteBuffer) {
            FfiConverterSequenceTypeGetExchangeResponseBodyDataSerializedMessage.write(value.`data`, buf)
    }
}



data class GetExchangeResponseBodyDataSerializedMessage (
    var `kind`: MessageKind, 
    var `jsonSerialized`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeGetExchangeResponseBodyDataSerializedMessage: FfiConverterRustBuffer<GetExchangeResponseBodyDataSerializedMessage> {
    override fun read(buf: ByteBuffer): GetExchangeResponseBodyDataSerializedMessage {
        return GetExchangeResponseBodyDataSerializedMessage(
            FfiConverterTypeMessageKind.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: GetExchangeResponseBodyDataSerializedMessage) = (
            FfiConverterTypeMessageKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`jsonSerialized`)
    )

    override fun write(value: GetExchangeResponseBodyDataSerializedMessage, buf: ByteBuffer) {
            FfiConverterTypeMessageKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`jsonSerialized`, buf)
    }
}



data class GetExchangesResponseBodyData (
    var `data`: List<kotlin.String>
) {
    
    companion object
}

public object FfiConverterTypeGetExchangesResponseBodyData: FfiConverterRustBuffer<GetExchangesResponseBodyData> {
    override fun read(buf: ByteBuffer): GetExchangesResponseBodyData {
        return GetExchangesResponseBodyData(
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: GetExchangesResponseBodyData) = (
            FfiConverterSequenceString.allocationSize(value.`data`)
    )

    override fun write(value: GetExchangesResponseBodyData, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`data`, buf)
    }
}



data class GetOfferingsResponseBodyData (
    var `data`: List<Offering>
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`data`)
    }
    
    companion object
}

public object FfiConverterTypeGetOfferingsResponseBodyData: FfiConverterRustBuffer<GetOfferingsResponseBodyData> {
    override fun read(buf: ByteBuffer): GetOfferingsResponseBodyData {
        return GetOfferingsResponseBodyData(
            FfiConverterSequenceTypeOffering.read(buf),
        )
    }

    override fun allocationSize(value: GetOfferingsResponseBodyData) = (
            FfiConverterSequenceTypeOffering.allocationSize(value.`data`)
    )

    override fun write(value: GetOfferingsResponseBodyData, buf: ByteBuffer) {
            FfiConverterSequenceTypeOffering.write(value.`data`, buf)
    }
}



data class JwkData (
    var `alg`: kotlin.String?, 
    var `kty`: kotlin.String, 
    var `crv`: kotlin.String, 
    var `d`: kotlin.String?, 
    var `x`: kotlin.String, 
    var `y`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeJwkData: FfiConverterRustBuffer<JwkData> {
    override fun read(buf: ByteBuffer): JwkData {
        return JwkData(
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: JwkData) = (
            FfiConverterOptionalString.allocationSize(value.`alg`) +
            FfiConverterString.allocationSize(value.`kty`) +
            FfiConverterString.allocationSize(value.`crv`) +
            FfiConverterOptionalString.allocationSize(value.`d`) +
            FfiConverterString.allocationSize(value.`x`) +
            FfiConverterOptionalString.allocationSize(value.`y`)
    )

    override fun write(value: JwkData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`alg`, buf)
            FfiConverterString.write(value.`kty`, buf)
            FfiConverterString.write(value.`crv`, buf)
            FfiConverterOptionalString.write(value.`d`, buf)
            FfiConverterString.write(value.`x`, buf)
            FfiConverterOptionalString.write(value.`y`, buf)
    }
}



data class MessageMetadataData (
    var `from`: kotlin.String, 
    var `to`: kotlin.String, 
    var `kind`: MessageKind, 
    var `id`: kotlin.String, 
    var `exchangeId`: kotlin.String, 
    var `externalId`: kotlin.String?, 
    var `protocol`: kotlin.String, 
    var `createdAt`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeMessageMetadataData: FfiConverterRustBuffer<MessageMetadataData> {
    override fun read(buf: ByteBuffer): MessageMetadataData {
        return MessageMetadataData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeMessageKind.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: MessageMetadataData) = (
            FfiConverterString.allocationSize(value.`from`) +
            FfiConverterString.allocationSize(value.`to`) +
            FfiConverterTypeMessageKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`exchangeId`) +
            FfiConverterOptionalString.allocationSize(value.`externalId`) +
            FfiConverterString.allocationSize(value.`protocol`) +
            FfiConverterString.allocationSize(value.`createdAt`)
    )

    override fun write(value: MessageMetadataData, buf: ByteBuffer) {
            FfiConverterString.write(value.`from`, buf)
            FfiConverterString.write(value.`to`, buf)
            FfiConverterTypeMessageKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`exchangeId`, buf)
            FfiConverterOptionalString.write(value.`externalId`, buf)
            FfiConverterString.write(value.`protocol`, buf)
            FfiConverterString.write(value.`createdAt`, buf)
    }
}



data class OfferingData (
    var `metadata`: ResourceMetadataData, 
    var `jsonSerializedData`: kotlin.String, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeOfferingData: FfiConverterRustBuffer<OfferingData> {
    override fun read(buf: ByteBuffer): OfferingData {
        return OfferingData(
            FfiConverterTypeResourceMetadataData.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: OfferingData) = (
            FfiConverterTypeResourceMetadataData.allocationSize(value.`metadata`) +
            FfiConverterString.allocationSize(value.`jsonSerializedData`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: OfferingData, buf: ByteBuffer) {
            FfiConverterTypeResourceMetadataData.write(value.`metadata`, buf)
            FfiConverterString.write(value.`jsonSerializedData`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class OrderData (
    var `metadata`: MessageMetadataData, 
    var `data`: OrderDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeOrderData: FfiConverterRustBuffer<OrderData> {
    override fun read(buf: ByteBuffer): OrderData {
        return OrderData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeOrderDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: OrderData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeOrderDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: OrderData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeOrderDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



class OrderDataData {
    override fun equals(other: Any?): Boolean {
        return other is OrderDataData
    }

    override fun hashCode(): Int {
        return javaClass.hashCode()
    }

    companion object
}

public object FfiConverterTypeOrderDataData: FfiConverterRustBuffer<OrderDataData> {
    override fun read(buf: ByteBuffer): OrderDataData {
        return OrderDataData()
    }

    override fun allocationSize(value: OrderDataData) = 0UL

    override fun write(value: OrderDataData, buf: ByteBuffer) {
    }
}



data class OrderInstructionsData (
    var `metadata`: MessageMetadataData, 
    var `data`: OrderInstructionsDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeOrderInstructionsData: FfiConverterRustBuffer<OrderInstructionsData> {
    override fun read(buf: ByteBuffer): OrderInstructionsData {
        return OrderInstructionsData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeOrderInstructionsDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: OrderInstructionsData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeOrderInstructionsDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: OrderInstructionsData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeOrderInstructionsDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class OrderInstructionsDataData (
    var `payin`: PaymentInstructionData, 
    var `payout`: PaymentInstructionData
) {
    
    companion object
}

public object FfiConverterTypeOrderInstructionsDataData: FfiConverterRustBuffer<OrderInstructionsDataData> {
    override fun read(buf: ByteBuffer): OrderInstructionsDataData {
        return OrderInstructionsDataData(
            FfiConverterTypePaymentInstructionData.read(buf),
            FfiConverterTypePaymentInstructionData.read(buf),
        )
    }

    override fun allocationSize(value: OrderInstructionsDataData) = (
            FfiConverterTypePaymentInstructionData.allocationSize(value.`payin`) +
            FfiConverterTypePaymentInstructionData.allocationSize(value.`payout`)
    )

    override fun write(value: OrderInstructionsDataData, buf: ByteBuffer) {
            FfiConverterTypePaymentInstructionData.write(value.`payin`, buf)
            FfiConverterTypePaymentInstructionData.write(value.`payout`, buf)
    }
}



data class OrderStatusData (
    var `metadata`: MessageMetadataData, 
    var `data`: OrderStatusDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeOrderStatusData: FfiConverterRustBuffer<OrderStatusData> {
    override fun read(buf: ByteBuffer): OrderStatusData {
        return OrderStatusData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeOrderStatusDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: OrderStatusData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeOrderStatusDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: OrderStatusData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeOrderStatusDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class OrderStatusDataData (
    var `status`: OrderStatusStatus, 
    var `details`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeOrderStatusDataData: FfiConverterRustBuffer<OrderStatusDataData> {
    override fun read(buf: ByteBuffer): OrderStatusDataData {
        return OrderStatusDataData(
            FfiConverterTypeOrderStatusStatus.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: OrderStatusDataData) = (
            FfiConverterTypeOrderStatusStatus.allocationSize(value.`status`) +
            FfiConverterOptionalString.allocationSize(value.`details`)
    )

    override fun write(value: OrderStatusDataData, buf: ByteBuffer) {
            FfiConverterTypeOrderStatusStatus.write(value.`status`, buf)
            FfiConverterOptionalString.write(value.`details`, buf)
    }
}



data class PaymentInstructionData (
    var `link`: kotlin.String?, 
    var `instruction`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypePaymentInstructionData: FfiConverterRustBuffer<PaymentInstructionData> {
    override fun read(buf: ByteBuffer): PaymentInstructionData {
        return PaymentInstructionData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: PaymentInstructionData) = (
            FfiConverterOptionalString.allocationSize(value.`link`) +
            FfiConverterOptionalString.allocationSize(value.`instruction`)
    )

    override fun write(value: PaymentInstructionData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`link`, buf)
            FfiConverterOptionalString.write(value.`instruction`, buf)
    }
}



data class PortableDidData (
    var `didUri`: kotlin.String, 
    var `document`: DocumentData, 
    var `privateJwks`: List<JwkData>
) {
    
    companion object
}

public object FfiConverterTypePortableDidData: FfiConverterRustBuffer<PortableDidData> {
    override fun read(buf: ByteBuffer): PortableDidData {
        return PortableDidData(
            FfiConverterString.read(buf),
            FfiConverterTypeDocumentData.read(buf),
            FfiConverterSequenceTypeJwkData.read(buf),
        )
    }

    override fun allocationSize(value: PortableDidData) = (
            FfiConverterString.allocationSize(value.`didUri`) +
            FfiConverterTypeDocumentData.allocationSize(value.`document`) +
            FfiConverterSequenceTypeJwkData.allocationSize(value.`privateJwks`)
    )

    override fun write(value: PortableDidData, buf: ByteBuffer) {
            FfiConverterString.write(value.`didUri`, buf)
            FfiConverterTypeDocumentData.write(value.`document`, buf)
            FfiConverterSequenceTypeJwkData.write(value.`privateJwks`, buf)
    }
}



data class QuoteData (
    var `metadata`: MessageMetadataData, 
    var `data`: QuoteDataData, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeQuoteData: FfiConverterRustBuffer<QuoteData> {
    override fun read(buf: ByteBuffer): QuoteData {
        return QuoteData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterTypeQuoteDataData.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: QuoteData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterTypeQuoteDataData.allocationSize(value.`data`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: QuoteData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterTypeQuoteDataData.write(value.`data`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class QuoteDataData (
    var `expiresAt`: kotlin.String, 
    var `payoutUnitsPerPayinUnit`: kotlin.String, 
    var `payin`: QuoteDetailsData, 
    var `payout`: QuoteDetailsData
) {
    
    companion object
}

public object FfiConverterTypeQuoteDataData: FfiConverterRustBuffer<QuoteDataData> {
    override fun read(buf: ByteBuffer): QuoteDataData {
        return QuoteDataData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeQuoteDetailsData.read(buf),
            FfiConverterTypeQuoteDetailsData.read(buf),
        )
    }

    override fun allocationSize(value: QuoteDataData) = (
            FfiConverterString.allocationSize(value.`expiresAt`) +
            FfiConverterString.allocationSize(value.`payoutUnitsPerPayinUnit`) +
            FfiConverterTypeQuoteDetailsData.allocationSize(value.`payin`) +
            FfiConverterTypeQuoteDetailsData.allocationSize(value.`payout`)
    )

    override fun write(value: QuoteDataData, buf: ByteBuffer) {
            FfiConverterString.write(value.`expiresAt`, buf)
            FfiConverterString.write(value.`payoutUnitsPerPayinUnit`, buf)
            FfiConverterTypeQuoteDetailsData.write(value.`payin`, buf)
            FfiConverterTypeQuoteDetailsData.write(value.`payout`, buf)
    }
}



data class QuoteDetailsData (
    var `currencyCode`: kotlin.String, 
    var `subtotal`: kotlin.String, 
    var `total`: kotlin.String, 
    var `fee`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeQuoteDetailsData: FfiConverterRustBuffer<QuoteDetailsData> {
    override fun read(buf: ByteBuffer): QuoteDetailsData {
        return QuoteDetailsData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: QuoteDetailsData) = (
            FfiConverterString.allocationSize(value.`currencyCode`) +
            FfiConverterString.allocationSize(value.`subtotal`) +
            FfiConverterString.allocationSize(value.`total`) +
            FfiConverterOptionalString.allocationSize(value.`fee`)
    )

    override fun write(value: QuoteDetailsData, buf: ByteBuffer) {
            FfiConverterString.write(value.`currencyCode`, buf)
            FfiConverterString.write(value.`subtotal`, buf)
            FfiConverterString.write(value.`total`, buf)
            FfiConverterOptionalString.write(value.`fee`, buf)
    }
}



data class ReplyToRequestBodyData (
    var `kind`: MessageKind, 
    var `jsonSerializedMessage`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeReplyToRequestBodyData: FfiConverterRustBuffer<ReplyToRequestBodyData> {
    override fun read(buf: ByteBuffer): ReplyToRequestBodyData {
        return ReplyToRequestBodyData(
            FfiConverterTypeMessageKind.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: ReplyToRequestBodyData) = (
            FfiConverterTypeMessageKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`jsonSerializedMessage`)
    )

    override fun write(value: ReplyToRequestBodyData, buf: ByteBuffer) {
            FfiConverterTypeMessageKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`jsonSerializedMessage`, buf)
    }
}



data class ResourceMetadataData (
    var `kind`: ResourceKind, 
    var `from`: kotlin.String, 
    var `id`: kotlin.String, 
    var `protocol`: kotlin.String, 
    var `createdAt`: kotlin.String, 
    var `updatedAt`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeResourceMetadataData: FfiConverterRustBuffer<ResourceMetadataData> {
    override fun read(buf: ByteBuffer): ResourceMetadataData {
        return ResourceMetadataData(
            FfiConverterTypeResourceKind.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ResourceMetadataData) = (
            FfiConverterTypeResourceKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`from`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`protocol`) +
            FfiConverterString.allocationSize(value.`createdAt`) +
            FfiConverterOptionalString.allocationSize(value.`updatedAt`)
    )

    override fun write(value: ResourceMetadataData, buf: ByteBuffer) {
            FfiConverterTypeResourceKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`from`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`protocol`, buf)
            FfiConverterString.write(value.`createdAt`, buf)
            FfiConverterOptionalString.write(value.`updatedAt`, buf)
    }
}



data class RfqData (
    var `metadata`: MessageMetadataData, 
    var `jsonSerializedData`: kotlin.String, 
    var `jsonSerializedPrivateData`: kotlin.String?, 
    var `signature`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeRfqData: FfiConverterRustBuffer<RfqData> {
    override fun read(buf: ByteBuffer): RfqData {
        return RfqData(
            FfiConverterTypeMessageMetadataData.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RfqData) = (
            FfiConverterTypeMessageMetadataData.allocationSize(value.`metadata`) +
            FfiConverterString.allocationSize(value.`jsonSerializedData`) +
            FfiConverterOptionalString.allocationSize(value.`jsonSerializedPrivateData`) +
            FfiConverterString.allocationSize(value.`signature`)
    )

    override fun write(value: RfqData, buf: ByteBuffer) {
            FfiConverterTypeMessageMetadataData.write(value.`metadata`, buf)
            FfiConverterString.write(value.`jsonSerializedData`, buf)
            FfiConverterOptionalString.write(value.`jsonSerializedPrivateData`, buf)
            FfiConverterString.write(value.`signature`, buf)
    }
}



data class ServiceData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String, 
    var `serviceEndpoint`: List<kotlin.String>
) {
    
    companion object
}

public object FfiConverterTypeServiceData: FfiConverterRustBuffer<ServiceData> {
    override fun read(buf: ByteBuffer): ServiceData {
        return ServiceData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ServiceData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`) +
            FfiConverterSequenceString.allocationSize(value.`serviceEndpoint`)
    )

    override fun write(value: ServiceData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
            FfiConverterSequenceString.write(value.`serviceEndpoint`, buf)
    }
}



data class UpdateExchangeRequestBodyData (
    var `kind`: MessageKind, 
    var `jsonSerializedMessage`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeUpdateExchangeRequestBodyData: FfiConverterRustBuffer<UpdateExchangeRequestBodyData> {
    override fun read(buf: ByteBuffer): UpdateExchangeRequestBodyData {
        return UpdateExchangeRequestBodyData(
            FfiConverterTypeMessageKind.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: UpdateExchangeRequestBodyData) = (
            FfiConverterTypeMessageKind.allocationSize(value.`kind`) +
            FfiConverterString.allocationSize(value.`jsonSerializedMessage`)
    )

    override fun write(value: UpdateExchangeRequestBodyData, buf: ByteBuffer) {
            FfiConverterTypeMessageKind.write(value.`kind`, buf)
            FfiConverterString.write(value.`jsonSerializedMessage`, buf)
    }
}



data class VerificationMethodData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String, 
    var `controller`: kotlin.String, 
    var `publicKeyJwk`: JwkData
) {
    
    companion object
}

public object FfiConverterTypeVerificationMethodData: FfiConverterRustBuffer<VerificationMethodData> {
    override fun read(buf: ByteBuffer): VerificationMethodData {
        return VerificationMethodData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeJwkData.read(buf),
        )
    }

    override fun allocationSize(value: VerificationMethodData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`) +
            FfiConverterString.allocationSize(value.`controller`) +
            FfiConverterTypeJwkData.allocationSize(value.`publicKeyJwk`)
    )

    override fun write(value: VerificationMethodData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
            FfiConverterString.write(value.`controller`, buf)
            FfiConverterTypeJwkData.write(value.`publicKeyJwk`, buf)
    }
}




enum class MessageKind {
    
    RFQ,
    QUOTE,
    ORDER,
    ORDER_INSTRUCTIONS,
    CANCEL,
    ORDER_STATUS,
    CLOSE;
    companion object
}


public object FfiConverterTypeMessageKind: FfiConverterRustBuffer<MessageKind> {
    override fun read(buf: ByteBuffer) = try {
        MessageKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MessageKind) = 4UL

    override fun write(value: MessageKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class OrderStatusStatus {
    
    PAYIN_PENDING,
    PAYIN_INITIATED,
    PAYIN_SETTLED,
    PAYIN_FAILED,
    PAYIN_EXPIRED,
    PAYOUT_PENDING,
    PAYOUT_INITIATED,
    PAYOUT_SETTLED,
    PAYOUT_FAILED,
    REFUND_PENDING,
    REFUND_INITIATED,
    REFUND_SETTLED,
    REFUND_FAILED;
    companion object
}


public object FfiConverterTypeOrderStatusStatus: FfiConverterRustBuffer<OrderStatusStatus> {
    override fun read(buf: ByteBuffer) = try {
        OrderStatusStatus.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: OrderStatusStatus) = 4UL

    override fun write(value: OrderStatusStatus, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class ResourceKind {
    
    OFFERING,
    BALANCE;
    companion object
}


public object FfiConverterTypeResourceKind: FfiConverterRustBuffer<ResourceKind> {
    override fun read(buf: ByteBuffer) = try {
        ResourceKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: ResourceKind) = 4UL

    override fun write(value: ResourceKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class TbdexSdkException: Exception() {
    
    class Exception(
        
        val `type`: kotlin.String, 
        
        val `variant`: kotlin.String, 
        
        val `msg`: kotlin.String
        ) : TbdexSdkException() {
        override val message
            get() = "type=${ `type` }, variant=${ `variant` }, msg=${ `msg` }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<TbdexSdkException> {
        override fun lift(error_buf: RustBuffer.ByValue): TbdexSdkException = FfiConverterTypeTbdexSdkError.lift(error_buf)
    }

    
}

public object FfiConverterTypeTbdexSdkError : FfiConverterRustBuffer<TbdexSdkException> {
    override fun read(buf: ByteBuffer): TbdexSdkException {
        

        return when(buf.getInt()) {
            1 -> TbdexSdkException.Exception(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TbdexSdkException): ULong {
        return when(value) {
            is TbdexSdkException.Exception -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`type`)
                + FfiConverterString.allocationSize(value.`variant`)
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: TbdexSdkException, buf: ByteBuffer) {
        when(value) {
            is TbdexSdkException.Exception -> {
                buf.putInt(1)
                FfiConverterString.write(value.`type`, buf)
                FfiConverterString.write(value.`variant`, buf)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}





sealed class Web5RustCoreException: Exception() {
    
    class Exception(
        
        val `type`: kotlin.String, 
        
        val `variant`: kotlin.String, 
        
        val `msg`: kotlin.String
        ) : Web5RustCoreException() {
        override val message
            get() = "type=${ `type` }, variant=${ `variant` }, msg=${ `msg` }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<Web5RustCoreException> {
        override fun lift(error_buf: RustBuffer.ByValue): Web5RustCoreException = FfiConverterTypeWeb5RustCoreError.lift(error_buf)
    }

    
}

public object FfiConverterTypeWeb5RustCoreError : FfiConverterRustBuffer<Web5RustCoreException> {
    override fun read(buf: ByteBuffer): Web5RustCoreException {
        

        return when(buf.getInt()) {
            1 -> Web5RustCoreException.Exception(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: Web5RustCoreException): ULong {
        return when(value) {
            is Web5RustCoreException.Exception -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`type`)
                + FfiConverterString.allocationSize(value.`variant`)
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: Web5RustCoreException, buf: ByteBuffer) {
        when(value) {
            is Web5RustCoreException.Exception -> {
                buf.putInt(1)
                FfiConverterString.write(value.`type`, buf)
                FfiConverterString.write(value.`variant`, buf)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<kotlin.Boolean?> {
    override fun read(buf: ByteBuffer): kotlin.Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: kotlin.Boolean?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeCancel: FfiConverterRustBuffer<Cancel?> {
    override fun read(buf: ByteBuffer): Cancel? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeCancel.read(buf)
    }

    override fun allocationSize(value: Cancel?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeCancel.allocationSize(value)
        }
    }

    override fun write(value: Cancel?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeCancel.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClose: FfiConverterRustBuffer<Close?> {
    override fun read(buf: ByteBuffer): Close? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClose.read(buf)
    }

    override fun allocationSize(value: Close?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeClose.allocationSize(value)
        }
    }

    override fun write(value: Close?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClose.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeOrder: FfiConverterRustBuffer<Order?> {
    override fun read(buf: ByteBuffer): Order? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeOrder.read(buf)
    }

    override fun allocationSize(value: Order?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeOrder.allocationSize(value)
        }
    }

    override fun write(value: Order?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeOrder.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeOrderInstructions: FfiConverterRustBuffer<OrderInstructions?> {
    override fun read(buf: ByteBuffer): OrderInstructions? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeOrderInstructions.read(buf)
    }

    override fun allocationSize(value: OrderInstructions?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeOrderInstructions.allocationSize(value)
        }
    }

    override fun write(value: OrderInstructions?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeOrderInstructions.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeQuote: FfiConverterRustBuffer<Quote?> {
    override fun read(buf: ByteBuffer): Quote? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeQuote.read(buf)
    }

    override fun allocationSize(value: Quote?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeQuote.allocationSize(value)
        }
    }

    override fun write(value: Quote?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeQuote.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<kotlin.String>?> {
    override fun read(buf: ByteBuffer): List<kotlin.String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<kotlin.String>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<kotlin.String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeOrderStatus: FfiConverterRustBuffer<List<OrderStatus>?> {
    override fun read(buf: ByteBuffer): List<OrderStatus>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeOrderStatus.read(buf)
    }

    override fun allocationSize(value: List<OrderStatus>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeOrderStatus.allocationSize(value)
        }
    }

    override fun write(value: List<OrderStatus>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeOrderStatus.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeErrorDetailData: FfiConverterRustBuffer<List<ErrorDetailData>?> {
    override fun read(buf: ByteBuffer): List<ErrorDetailData>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeErrorDetailData.read(buf)
    }

    override fun allocationSize(value: List<ErrorDetailData>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeErrorDetailData.allocationSize(value)
        }
    }

    override fun write(value: List<ErrorDetailData>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeErrorDetailData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeServiceData: FfiConverterRustBuffer<List<ServiceData>?> {
    override fun read(buf: ByteBuffer): List<ServiceData>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeServiceData.read(buf)
    }

    override fun allocationSize(value: List<ServiceData>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeServiceData.allocationSize(value)
        }
    }

    override fun write(value: List<ServiceData>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeServiceData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalMapStringString: FfiConverterRustBuffer<Map<kotlin.String, kotlin.String>?> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterMapStringString.read(buf)
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.String>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterMapStringString.allocationSize(value)
        }
    }

    override fun write(value: Map<kotlin.String, kotlin.String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterMapStringString.write(value, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeBalance: FfiConverterRustBuffer<List<Balance>> {
    override fun read(buf: ByteBuffer): List<Balance> {
        val len = buf.getInt()
        return List<Balance>(len) {
            FfiConverterTypeBalance.read(buf)
        }
    }

    override fun allocationSize(value: List<Balance>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeBalance.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Balance>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeBalance.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeOffering: FfiConverterRustBuffer<List<Offering>> {
    override fun read(buf: ByteBuffer): List<Offering> {
        val len = buf.getInt()
        return List<Offering>(len) {
            FfiConverterTypeOffering.read(buf)
        }
    }

    override fun allocationSize(value: List<Offering>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeOffering.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Offering>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeOffering.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeOrderStatus: FfiConverterRustBuffer<List<OrderStatus>> {
    override fun read(buf: ByteBuffer): List<OrderStatus> {
        val len = buf.getInt()
        return List<OrderStatus>(len) {
            FfiConverterTypeOrderStatus.read(buf)
        }
    }

    override fun allocationSize(value: List<OrderStatus>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeOrderStatus.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<OrderStatus>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeOrderStatus.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeErrorDetailData: FfiConverterRustBuffer<List<ErrorDetailData>> {
    override fun read(buf: ByteBuffer): List<ErrorDetailData> {
        val len = buf.getInt()
        return List<ErrorDetailData>(len) {
            FfiConverterTypeErrorDetailData.read(buf)
        }
    }

    override fun allocationSize(value: List<ErrorDetailData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeErrorDetailData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ErrorDetailData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeErrorDetailData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeGetExchangeResponseBodyDataSerializedMessage: FfiConverterRustBuffer<List<GetExchangeResponseBodyDataSerializedMessage>> {
    override fun read(buf: ByteBuffer): List<GetExchangeResponseBodyDataSerializedMessage> {
        val len = buf.getInt()
        return List<GetExchangeResponseBodyDataSerializedMessage>(len) {
            FfiConverterTypeGetExchangeResponseBodyDataSerializedMessage.read(buf)
        }
    }

    override fun allocationSize(value: List<GetExchangeResponseBodyDataSerializedMessage>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeGetExchangeResponseBodyDataSerializedMessage.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<GetExchangeResponseBodyDataSerializedMessage>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeGetExchangeResponseBodyDataSerializedMessage.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeJwkData: FfiConverterRustBuffer<List<JwkData>> {
    override fun read(buf: ByteBuffer): List<JwkData> {
        val len = buf.getInt()
        return List<JwkData>(len) {
            FfiConverterTypeJwkData.read(buf)
        }
    }

    override fun allocationSize(value: List<JwkData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeJwkData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<JwkData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeJwkData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeServiceData: FfiConverterRustBuffer<List<ServiceData>> {
    override fun read(buf: ByteBuffer): List<ServiceData> {
        val len = buf.getInt()
        return List<ServiceData>(len) {
            FfiConverterTypeServiceData.read(buf)
        }
    }

    override fun allocationSize(value: List<ServiceData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeServiceData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ServiceData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeServiceData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeVerificationMethodData: FfiConverterRustBuffer<List<VerificationMethodData>> {
    override fun read(buf: ByteBuffer): List<VerificationMethodData> {
        val len = buf.getInt()
        return List<VerificationMethodData>(len) {
            FfiConverterTypeVerificationMethodData.read(buf)
        }
    }

    override fun allocationSize(value: List<VerificationMethodData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeVerificationMethodData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<VerificationMethodData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeVerificationMethodData.write(it, buf)
        }
    }
}



public object FfiConverterMapStringString: FfiConverterRustBuffer<Map<kotlin.String, kotlin.String>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.String> {
        val len = buf.getInt()
        return buildMap<kotlin.String, kotlin.String>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterString.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.String>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterString.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterString.write(v, buf)
        }
    }
}
    @Throws(TbdexSdkException::class) fun `createExchange`(`rfq`: Rfq, `replyTo`: kotlin.String?)
        = 
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_create_exchange(
        FfiConverterTypeRfq.lower(`rfq`),FfiConverterOptionalString.lower(`replyTo`),_status)
}
    
    

    @Throws(TbdexSdkException::class) fun `getBalances`(`pfiDidUri`: kotlin.String, `bearerDid`: BearerDid): List<Balance> {
            return FfiConverterSequenceTypeBalance.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_get_balances(
        FfiConverterString.lower(`pfiDidUri`),FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    )
    }
    

    @Throws(TbdexSdkException::class) fun `getExchange`(`pfiDidUri`: kotlin.String, `bearerDid`: BearerDid, `exchangeId`: kotlin.String): ExchangeData {
            return FfiConverterTypeExchangeData.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_get_exchange(
        FfiConverterString.lower(`pfiDidUri`),FfiConverterTypeBearerDid.lower(`bearerDid`),FfiConverterString.lower(`exchangeId`),_status)
}
    )
    }
    

    @Throws(TbdexSdkException::class) fun `getExchangeIds`(`pfiDidUri`: kotlin.String, `bearerDid`: BearerDid): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_get_exchange_ids(
        FfiConverterString.lower(`pfiDidUri`),FfiConverterTypeBearerDid.lower(`bearerDid`),_status)
}
    )
    }
    

    @Throws(TbdexSdkException::class) fun `getOfferings`(`pfiDidUri`: kotlin.String): List<Offering> {
            return FfiConverterSequenceTypeOffering.lift(
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_get_offerings(
        FfiConverterString.lower(`pfiDidUri`),_status)
}
    )
    }
    

    @Throws(TbdexSdkException::class) fun `submitCancel`(`cancel`: Cancel)
        = 
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_submit_cancel(
        FfiConverterTypeCancel.lower(`cancel`),_status)
}
    
    

    @Throws(TbdexSdkException::class) fun `submitOrder`(`order`: Order)
        = 
    uniffiRustCallWithError(TbdexSdkException) { _status ->
    UniffiLib.INSTANCE.uniffi_tbdex_uniffi_fn_func_submit_order(
        FfiConverterTypeOrder.lower(`order`),_status)
}
    
    


