package tbdex.sdk.messages

import tbdex.sdk.http.ReplyToMessage
import tbdex.sdk.rust.PaymentInstructionData as RustCorePaymentInstruction
import tbdex.sdk.rust.QuoteDetailsData as RustCoreQuoteDetails
import tbdex.sdk.rust.Quote as RustCoreQuote
import tbdex.sdk.rust.QuoteDataData as RustCoreQuoteData
import web5.sdk.dids.BearerDid

typealias QuoteData = RustCoreQuoteData
typealias QuoteDetails = RustCoreQuoteDetails
typealias PaymentInstruction = RustCorePaymentInstruction

class Quote private constructor(
    val metadata: MessageMetadata,
    val data: QuoteData,
    val signature: String,
    internal val rustCoreQuote: RustCoreQuote
): Message, ReplyToMessage {
    companion object {
        fun create(
            to: String,
            from: String,
            exchangeId: String,
            data: QuoteData,
            protocol: String? = null,
            externalId: String? = null
        ): Quote {
            val rustCoreQuote = RustCoreQuote.create(to, from, exchangeId, data, protocol, externalId)
            val rustCoreData = rustCoreQuote.getData()
            return Quote(rustCoreData.metadata, rustCoreData.data, rustCoreData.signature, rustCoreQuote)
        }

        fun fromJsonString(json: String): Quote {
            val rustCoreQuote = RustCoreQuote.fromJsonString(json)
            val rustCoreData = rustCoreQuote.getData()
            return Quote(rustCoreData.metadata, rustCoreData.data, rustCoreData.signature, rustCoreQuote)
        }

        internal fun fromRustCoreQuote(rustCoreQuote: RustCoreQuote): Quote {
            val rustCoreData = rustCoreQuote.getData()
            return Quote(rustCoreData.metadata, rustCoreData.data, rustCoreData.signature, rustCoreQuote)
        }
    }

    fun toJsonString(): String {
        return this.rustCoreQuote.toJsonString()
    }

    fun sign(bearerDid: BearerDid) {
        this.rustCoreQuote.sign(bearerDid.rustCoreBearerDid)
    }

    fun verify() {
        this.rustCoreQuote.verify()
    }
}