/*
 * Decompiled with CFR 0.152.
 */
package tbdex.sdk.rust;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tbdex.sdk.rust.JwkData;
import tbdex.sdk.rust.KeyManager;
import tbdex.sdk.rust.Signer;
import tbdex.sdk.rust.ToInnerSigner;
import tbdex.sdk.rust.Web5Kt;
import web5.sdk.crypto.keys.Jwk;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltbdex/sdk/rust/ToInnerKeyManager;", "Ltbdex/sdk/rust/KeyManager;", "keyManager", "Lweb5/sdk/crypto/keys/KeyManager;", "(Lweb5/sdk/crypto/keys/KeyManager;)V", "getSigner", "Ltbdex/sdk/rust/Signer;", "publicJwk", "Ltbdex/sdk/rust/JwkData;", "importPrivateJwk", "privateJwk", "tbdex"})
public final class ToInnerKeyManager
implements KeyManager {
    @NotNull
    private final web5.sdk.crypto.keys.KeyManager keyManager;

    public ToInnerKeyManager(@NotNull web5.sdk.crypto.keys.KeyManager keyManager) {
        Intrinsics.checkNotNullParameter(keyManager, "keyManager");
        this.keyManager = keyManager;
    }

    @Override
    @NotNull
    public JwkData importPrivateJwk(@NotNull JwkData privateJwk) {
        Intrinsics.checkNotNullParameter(privateJwk, "privateJwk");
        Jwk jwk = this.keyManager.importPrivateJwk(Web5Kt.toWeb5(privateJwk));
        return Web5Kt.fromWeb5(JwkData.Companion, jwk);
    }

    @Override
    @NotNull
    public Signer getSigner(@NotNull JwkData publicJwk) {
        Intrinsics.checkNotNullParameter(publicJwk, "publicJwk");
        web5.sdk.crypto.signers.Signer signer = this.keyManager.getSigner(Web5Kt.toWeb5(publicJwk));
        ToInnerSigner innerSigner = new ToInnerSigner(signer);
        return innerSigner;
    }
}

