/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.keys;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.Web5Exception;
import web5.sdk.rust.JwkData;
import web5.sdk.rust.Web5Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0006\u0010\u001b\u001a\u00020\u0003JK\u0010\u001c\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006$"}, d2={"Lweb5/sdk/crypto/keys/Jwk;", "", "alg", "", "kty", "crv", "x", "y", "d", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "getCrv", "getD", "getKty", "rustCoreJwkData", "Lweb5/sdk/rust/JwkData;", "getRustCoreJwkData$web5", "()Lweb5/sdk/rust/JwkData;", "getX", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "computeThumbprint", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "web5"})
public final class Jwk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String alg;
    @NotNull
    private final String kty;
    @NotNull
    private final String crv;
    @NotNull
    private final String x;
    @Nullable
    private final String y;
    @Nullable
    private final String d;
    @NotNull
    private final JwkData rustCoreJwkData;

    public Jwk(@Nullable String alg, @NotNull String kty, @NotNull String crv, @NotNull String x, @Nullable String y, @Nullable String d) {
        Intrinsics.checkNotNullParameter(kty, "kty");
        Intrinsics.checkNotNullParameter(crv, "crv");
        Intrinsics.checkNotNullParameter(x, "x");
        this.alg = alg;
        this.kty = kty;
        this.crv = crv;
        this.x = x;
        this.y = y;
        this.d = d;
        this.rustCoreJwkData = new JwkData(this.alg, this.kty, this.crv, this.d, this.x, this.y);
    }

    public /* synthetic */ Jwk(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        this(string, string2, string3, string4, string5, string6);
    }

    @Nullable
    public final String getAlg() {
        return this.alg;
    }

    @NotNull
    public final String getKty() {
        return this.kty;
    }

    @NotNull
    public final String getCrv() {
        return this.crv;
    }

    @NotNull
    public final String getX() {
        return this.x;
    }

    @Nullable
    public final String getY() {
        return this.y;
    }

    @Nullable
    public final String getD() {
        return this.d;
    }

    @NotNull
    public final JwkData getRustCoreJwkData$web5() {
        return this.rustCoreJwkData;
    }

    @NotNull
    public final String computeThumbprint() {
        try {
            web5.sdk.rust.Jwk rustCoreJwk = new web5.sdk.rust.Jwk(this.rustCoreJwkData);
            return rustCoreJwk.computeThumbprint();
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }

    @Nullable
    public final String component1() {
        return this.alg;
    }

    @NotNull
    public final String component2() {
        return this.kty;
    }

    @NotNull
    public final String component3() {
        return this.crv;
    }

    @NotNull
    public final String component4() {
        return this.x;
    }

    @Nullable
    public final String component5() {
        return this.y;
    }

    @Nullable
    public final String component6() {
        return this.d;
    }

    @NotNull
    public final Jwk copy(@Nullable String alg, @NotNull String kty, @NotNull String crv, @NotNull String x, @Nullable String y, @Nullable String d) {
        Intrinsics.checkNotNullParameter(kty, "kty");
        Intrinsics.checkNotNullParameter(crv, "crv");
        Intrinsics.checkNotNullParameter(x, "x");
        return new Jwk(alg, kty, crv, x, y, d);
    }

    public static /* synthetic */ Jwk copy$default(Jwk jwk, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            string = jwk.alg;
        }
        if ((n & 2) != 0) {
            string2 = jwk.kty;
        }
        if ((n & 4) != 0) {
            string3 = jwk.crv;
        }
        if ((n & 8) != 0) {
            string4 = jwk.x;
        }
        if ((n & 0x10) != 0) {
            string5 = jwk.y;
        }
        if ((n & 0x20) != 0) {
            string6 = jwk.d;
        }
        return jwk.copy(string, string2, string3, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        return "Jwk(alg=" + this.alg + ", kty=" + this.kty + ", crv=" + this.crv + ", x=" + this.x + ", y=" + this.y + ", d=" + this.d + ")";
    }

    public int hashCode() {
        int result2 = this.alg == null ? 0 : this.alg.hashCode();
        result2 = result2 * 31 + this.kty.hashCode();
        result2 = result2 * 31 + this.crv.hashCode();
        result2 = result2 * 31 + this.x.hashCode();
        result2 = result2 * 31 + (this.y == null ? 0 : this.y.hashCode());
        result2 = result2 * 31 + (this.d == null ? 0 : this.d.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Jwk)) {
            return false;
        }
        Jwk jwk = (Jwk)other;
        if (!Intrinsics.areEqual(this.alg, jwk.alg)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.kty, jwk.kty)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.crv, jwk.crv)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.x, jwk.x)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.y, jwk.y)) {
            return false;
        }
        return Intrinsics.areEqual(this.d, jwk.d);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lweb5/sdk/crypto/keys/Jwk$Companion;", "", "()V", "fromRustCoreJwkData", "Lweb5/sdk/crypto/keys/Jwk;", "rustCoreJwkData", "Lweb5/sdk/rust/JwkData;", "fromRustCoreJwkData$web5", "web5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Jwk fromRustCoreJwkData$web5(@NotNull JwkData rustCoreJwkData) {
            Intrinsics.checkNotNullParameter(rustCoreJwkData, "rustCoreJwkData");
            return new Jwk(rustCoreJwkData.getAlg(), rustCoreJwkData.getKty(), rustCoreJwkData.getCrv(), rustCoreJwkData.getX(), rustCoreJwkData.getY(), rustCoreJwkData.getD());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

