/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.keys;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.crypto.keys.Jwk;
import web5.sdk.crypto.keys.KeyManager;
import web5.sdk.crypto.signers.ToInnerSigner;
import web5.sdk.rust.JwkData;
import web5.sdk.rust.Signer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lweb5/sdk/crypto/keys/ToInnerKeyManager;", "Lweb5/sdk/rust/KeyManager;", "keyManager", "Lweb5/sdk/crypto/keys/KeyManager;", "(Lweb5/sdk/crypto/keys/KeyManager;)V", "getSigner", "Lweb5/sdk/rust/Signer;", "publicJwk", "Lweb5/sdk/rust/JwkData;", "importPrivateJwk", "privateJwk", "web5"})
public final class ToInnerKeyManager
implements web5.sdk.rust.KeyManager {
    @NotNull
    private final KeyManager keyManager;

    public ToInnerKeyManager(@NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter(keyManager, "keyManager");
        this.keyManager = keyManager;
    }

    @Override
    @NotNull
    public JwkData importPrivateJwk(@NotNull JwkData privateJwk) {
        Intrinsics.checkNotNullParameter(privateJwk, "privateJwk");
        Jwk rustCoreJwkData = Jwk.Companion.fromRustCoreJwkData$web5(privateJwk);
        Jwk jwk = this.keyManager.importPrivateJwk(rustCoreJwkData);
        return jwk.getRustCoreJwkData$web5();
    }

    @Override
    @NotNull
    public Signer getSigner(@NotNull JwkData publicJwk) {
        Intrinsics.checkNotNullParameter(publicJwk, "publicJwk");
        Jwk jwk = Jwk.Companion.fromRustCoreJwkData$web5(publicJwk);
        web5.sdk.crypto.signers.Signer signer = this.keyManager.getSigner(jwk);
        ToInnerSigner innerSigner = new ToInnerSigner(signer);
        return innerSigner;
    }
}

