/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.vc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.Json;
import web5.sdk.Web5Exception;
import web5.sdk.dids.BearerDid;
import web5.sdk.rust.CredentialSchemaData;
import web5.sdk.rust.CredentialStatusData;
import web5.sdk.rust.VerifiableCredential;
import web5.sdk.rust.VerifiableCredentialCreateOptionsData;
import web5.sdk.rust.VerifiableCredentialData;
import web5.sdk.rust.Web5Exception;
import web5.sdk.vc.CredentialSchema;
import web5.sdk.vc.CredentialStatus;
import web5.sdk.vc.CredentialSubject;
import web5.sdk.vc.Issuer;
import web5.sdk.vc.VerifiableCredentialCreateOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB\u008d\u0001\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u001c\b\u0002\u0010\u0012\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013\u0018\u00010\u0003\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001d\u0010+\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013\u0018\u00010\u0003H\u00c6\u0003J\u000e\u0010,\u001a\u00020\u0015H\u00c0\u0003\u00a2\u0006\u0002\b-J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0004H\u00c6\u0003J\t\u00100\u001a\u00020\bH\u00c6\u0003J\t\u00101\u001a\u00020\nH\u00c6\u0003J\t\u00102\u001a\u00020\fH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u009d\u0001\u00106\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u001c\b\u0002\u0010\u0012\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u00c6\u0001J\u0013\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020;H\u00d6\u0001J\u001a\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u0004J\t\u0010@\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR%\u0010\u0012\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0013\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018\u00a8\u0006B"}, d2={"Lweb5/sdk/vc/VerifiableCredential;", "", "context", "", "", "type", "id", "issuer", "Lweb5/sdk/vc/Issuer;", "credentialSubject", "Lweb5/sdk/vc/CredentialSubject;", "issuanceDate", "Ljava/util/Date;", "expirationDate", "credentialStatus", "Lweb5/sdk/vc/CredentialStatus;", "credentialSchema", "Lweb5/sdk/vc/CredentialSchema;", "evidence", "", "rustCoreVerifiableCredential", "Lweb5/sdk/rust/VerifiableCredential;", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lweb5/sdk/vc/Issuer;Lweb5/sdk/vc/CredentialSubject;Ljava/util/Date;Ljava/util/Date;Lweb5/sdk/vc/CredentialStatus;Lweb5/sdk/vc/CredentialSchema;Ljava/util/List;Lweb5/sdk/rust/VerifiableCredential;)V", "getContext", "()Ljava/util/List;", "getCredentialSchema", "()Lweb5/sdk/vc/CredentialSchema;", "getCredentialStatus", "()Lweb5/sdk/vc/CredentialStatus;", "getCredentialSubject", "()Lweb5/sdk/vc/CredentialSubject;", "getEvidence", "getExpirationDate", "()Ljava/util/Date;", "getId", "()Ljava/lang/String;", "getIssuanceDate", "getIssuer", "()Lweb5/sdk/vc/Issuer;", "getRustCoreVerifiableCredential$web5", "()Lweb5/sdk/rust/VerifiableCredential;", "getType", "component1", "component10", "component11", "component11$web5", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "sign", "bearerDid", "Lweb5/sdk/dids/BearerDid;", "verificationMethodId", "toString", "Companion", "web5"})
public final class VerifiableCredential {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> context;
    @NotNull
    private final List<String> type;
    @NotNull
    private final String id;
    @NotNull
    private final Issuer issuer;
    @NotNull
    private final CredentialSubject credentialSubject;
    @NotNull
    private final Date issuanceDate;
    @Nullable
    private final Date expirationDate;
    @Nullable
    private final CredentialStatus credentialStatus;
    @Nullable
    private final CredentialSchema credentialSchema;
    @Nullable
    private final List<Map<String, Object>> evidence;
    @NotNull
    private final web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential;

    private VerifiableCredential(List<String> context, List<String> type2, String id, Issuer issuer, CredentialSubject credentialSubject, Date issuanceDate, Date expirationDate, CredentialStatus credentialStatus, CredentialSchema credentialSchema, List<? extends Map<String, ? extends Object>> evidence, web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential) {
        this.context = context;
        this.type = type2;
        this.id = id;
        this.issuer = issuer;
        this.credentialSubject = credentialSubject;
        this.issuanceDate = issuanceDate;
        this.expirationDate = expirationDate;
        this.credentialStatus = credentialStatus;
        this.credentialSchema = credentialSchema;
        this.evidence = evidence;
        this.rustCoreVerifiableCredential = rustCoreVerifiableCredential;
    }

    /* synthetic */ VerifiableCredential(List list, List list2, String string, Issuer issuer, CredentialSubject credentialSubject, Date date, Date date2, CredentialStatus credentialStatus, CredentialSchema credentialSchema, List list3, web5.sdk.rust.VerifiableCredential verifiableCredential, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x40) != 0) {
            date2 = null;
        }
        if ((n & 0x80) != 0) {
            credentialStatus = null;
        }
        if ((n & 0x100) != 0) {
            credentialSchema = null;
        }
        if ((n & 0x200) != 0) {
            list3 = null;
        }
        this(list, list2, string, issuer, credentialSubject, date, date2, credentialStatus, credentialSchema, list3, verifiableCredential);
    }

    @NotNull
    public final List<String> getContext() {
        return this.context;
    }

    @NotNull
    public final List<String> getType() {
        return this.type;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Issuer getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final CredentialSubject getCredentialSubject() {
        return this.credentialSubject;
    }

    @NotNull
    public final Date getIssuanceDate() {
        return this.issuanceDate;
    }

    @Nullable
    public final Date getExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public final CredentialStatus getCredentialStatus() {
        return this.credentialStatus;
    }

    @Nullable
    public final CredentialSchema getCredentialSchema() {
        return this.credentialSchema;
    }

    @Nullable
    public final List<Map<String, Object>> getEvidence() {
        return this.evidence;
    }

    @NotNull
    public final web5.sdk.rust.VerifiableCredential getRustCoreVerifiableCredential$web5() {
        return this.rustCoreVerifiableCredential;
    }

    @NotNull
    public final String sign(@NotNull BearerDid bearerDid, @Nullable String verificationMethodId) {
        Intrinsics.checkNotNullParameter(bearerDid, "bearerDid");
        try {
            return this.rustCoreVerifiableCredential.sign(bearerDid.getRustCoreBearerDid$web5(), verificationMethodId);
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }

    public static /* synthetic */ String sign$default(VerifiableCredential verifiableCredential, BearerDid bearerDid, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return verifiableCredential.sign(bearerDid, string);
    }

    @NotNull
    public final List<String> component1() {
        return this.context;
    }

    @NotNull
    public final List<String> component2() {
        return this.type;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final Issuer component4() {
        return this.issuer;
    }

    @NotNull
    public final CredentialSubject component5() {
        return this.credentialSubject;
    }

    @NotNull
    public final Date component6() {
        return this.issuanceDate;
    }

    @Nullable
    public final Date component7() {
        return this.expirationDate;
    }

    @Nullable
    public final CredentialStatus component8() {
        return this.credentialStatus;
    }

    @Nullable
    public final CredentialSchema component9() {
        return this.credentialSchema;
    }

    @Nullable
    public final List<Map<String, Object>> component10() {
        return this.evidence;
    }

    @NotNull
    public final web5.sdk.rust.VerifiableCredential component11$web5() {
        return this.rustCoreVerifiableCredential;
    }

    @NotNull
    public final VerifiableCredential copy(@NotNull List<String> context, @NotNull List<String> type2, @NotNull String id, @NotNull Issuer issuer, @NotNull CredentialSubject credentialSubject, @NotNull Date issuanceDate, @Nullable Date expirationDate, @Nullable CredentialStatus credentialStatus, @Nullable CredentialSchema credentialSchema, @Nullable List<? extends Map<String, ? extends Object>> evidence, @NotNull web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(issuer, "issuer");
        Intrinsics.checkNotNullParameter(credentialSubject, "credentialSubject");
        Intrinsics.checkNotNullParameter(issuanceDate, "issuanceDate");
        Intrinsics.checkNotNullParameter(rustCoreVerifiableCredential, "rustCoreVerifiableCredential");
        return new VerifiableCredential(context, type2, id, issuer, credentialSubject, issuanceDate, expirationDate, credentialStatus, credentialSchema, evidence, rustCoreVerifiableCredential);
    }

    public static /* synthetic */ VerifiableCredential copy$default(VerifiableCredential verifiableCredential, List list, List list2, String string, Issuer issuer, CredentialSubject credentialSubject, Date date, Date date2, CredentialStatus credentialStatus, CredentialSchema credentialSchema, List list3, web5.sdk.rust.VerifiableCredential verifiableCredential2, int n, Object object) {
        if ((n & 1) != 0) {
            list = verifiableCredential.context;
        }
        if ((n & 2) != 0) {
            list2 = verifiableCredential.type;
        }
        if ((n & 4) != 0) {
            string = verifiableCredential.id;
        }
        if ((n & 8) != 0) {
            issuer = verifiableCredential.issuer;
        }
        if ((n & 0x10) != 0) {
            credentialSubject = verifiableCredential.credentialSubject;
        }
        if ((n & 0x20) != 0) {
            date = verifiableCredential.issuanceDate;
        }
        if ((n & 0x40) != 0) {
            date2 = verifiableCredential.expirationDate;
        }
        if ((n & 0x80) != 0) {
            credentialStatus = verifiableCredential.credentialStatus;
        }
        if ((n & 0x100) != 0) {
            credentialSchema = verifiableCredential.credentialSchema;
        }
        if ((n & 0x200) != 0) {
            list3 = verifiableCredential.evidence;
        }
        if ((n & 0x400) != 0) {
            verifiableCredential2 = verifiableCredential.rustCoreVerifiableCredential;
        }
        return verifiableCredential.copy(list, list2, string, issuer, credentialSubject, date, date2, credentialStatus, credentialSchema, list3, verifiableCredential2);
    }

    @NotNull
    public String toString() {
        return "VerifiableCredential(context=" + this.context + ", type=" + this.type + ", id=" + this.id + ", issuer=" + this.issuer + ", credentialSubject=" + this.credentialSubject + ", issuanceDate=" + this.issuanceDate + ", expirationDate=" + this.expirationDate + ", credentialStatus=" + this.credentialStatus + ", credentialSchema=" + this.credentialSchema + ", evidence=" + this.evidence + ", rustCoreVerifiableCredential=" + this.rustCoreVerifiableCredential + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.context).hashCode();
        result2 = result2 * 31 + ((Object)this.type).hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.issuer.hashCode();
        result2 = result2 * 31 + this.credentialSubject.hashCode();
        result2 = result2 * 31 + this.issuanceDate.hashCode();
        result2 = result2 * 31 + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        result2 = result2 * 31 + (this.credentialStatus == null ? 0 : this.credentialStatus.hashCode());
        result2 = result2 * 31 + (this.credentialSchema == null ? 0 : this.credentialSchema.hashCode());
        result2 = result2 * 31 + (this.evidence == null ? 0 : ((Object)this.evidence).hashCode());
        result2 = result2 * 31 + this.rustCoreVerifiableCredential.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VerifiableCredential)) {
            return false;
        }
        VerifiableCredential verifiableCredential = (VerifiableCredential)other;
        if (!Intrinsics.areEqual(this.context, verifiableCredential.context)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, verifiableCredential.type)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.id, verifiableCredential.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.issuer, verifiableCredential.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.credentialSubject, verifiableCredential.credentialSubject)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.issuanceDate, verifiableCredential.issuanceDate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expirationDate, verifiableCredential.expirationDate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.credentialStatus, verifiableCredential.credentialStatus)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.credentialSchema, verifiableCredential.credentialSchema)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.evidence, verifiableCredential.evidence)) {
            return false;
        }
        return Intrinsics.areEqual(this.rustCoreVerifiableCredential, verifiableCredential.rustCoreVerifiableCredential);
    }

    public /* synthetic */ VerifiableCredential(List context, List type2, String id, Issuer issuer, CredentialSubject credentialSubject, Date issuanceDate, Date expirationDate, CredentialStatus credentialStatus, CredentialSchema credentialSchema, List evidence, web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential, DefaultConstructorMarker $constructor_marker) {
        this(context, type2, id, issuer, credentialSubject, issuanceDate, expirationDate, credentialStatus, credentialSchema, evidence, rustCoreVerifiableCredential);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lweb5/sdk/vc/VerifiableCredential$Companion;", "", "()V", "create", "Lweb5/sdk/vc/VerifiableCredential;", "issuer", "Lweb5/sdk/vc/Issuer;", "credentialSubject", "Lweb5/sdk/vc/CredentialSubject;", "options", "Lweb5/sdk/vc/VerifiableCredentialCreateOptions;", "fromRustCore", "rustCoreVerifiableCredential", "Lweb5/sdk/rust/VerifiableCredential;", "fromRustCore$web5", "fromVcJwt", "vcJwt", "", "verify", "", "web5"})
    @SourceDebugExtension(value={"SMAP\nVerifiableCredential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/vc/VerifiableCredential$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,340:1\n1#2:341\n56#3:342\n49#3:343\n56#3:344\n49#3:345\n56#3:346\n49#3:347\n*S KotlinDebug\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/vc/VerifiableCredential$Companion\n*L\n101#1:342\n101#1:343\n164#1:344\n164#1:345\n205#1:346\n205#1:347\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VerifiableCredential fromRustCore$web5(@NotNull web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential) {
            CredentialSchema credentialSchema;
            CredentialStatus credentialStatus;
            CredentialStatus credentialStatus2;
            Date date;
            Date date2;
            List<String> list;
            List<String> list2;
            String string;
            Issuer issuer;
            CredentialSubject credentialSubject;
            Date date3;
            List list3;
            Object it;
            Intrinsics.checkNotNullParameter(rustCoreVerifiableCredential, "rustCoreVerifiableCredential");
            VerifiableCredentialData data2 = rustCoreVerifiableCredential.getData();
            Issuer issuer2 = Json.INSTANCE.getJsonMapper().readValue(data2.getJsonSerializedIssuer(), Issuer.class);
            CredentialSubject credentialSubject2 = Json.INSTANCE.getJsonMapper().readValue(data2.getJsonSerializedCredentialSubject(), CredentialSubject.class);
            String string2 = data2.getJsonSerializedEvidence();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = Json.INSTANCE.getJsonMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                list3 = (List)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<List<? extends Map<String, ? extends Object>>>(){});
            } else {
                list3 = null;
            }
            List evidence = list3;
            List<String> list4 = data2.getContext();
            List<String> list5 = data2.getType();
            String string3 = data2.getId();
            Intrinsics.checkNotNull(issuer2);
            Issuer issuer3 = issuer2;
            Intrinsics.checkNotNull(credentialSubject2);
            CredentialSubject credentialSubject3 = credentialSubject2;
            Date date4 = Date.from(data2.getIssuanceDate());
            Date date5 = date4;
            Intrinsics.checkNotNullExpressionValue(date4, "from(...)");
            Instant instant = data2.getExpirationDate();
            if (instant != null) {
                it = instant;
                date3 = date5;
                credentialSubject = credentialSubject3;
                issuer = issuer3;
                string = string3;
                list2 = list5;
                list = list4;
                boolean bl = false;
                date2 = Date.from((Instant)it);
                list4 = list;
                list5 = list2;
                string3 = string;
                issuer3 = issuer;
                credentialSubject3 = credentialSubject;
                date5 = date3;
                date = date2;
            } else {
                date = null;
            }
            CredentialStatusData credentialStatusData = data2.getCredentialStatus();
            if (credentialStatusData != null) {
                it = credentialStatusData;
                date2 = date;
                date3 = date5;
                credentialSubject = credentialSubject3;
                issuer = issuer3;
                string = string3;
                list2 = list5;
                list = list4;
                boolean bl = false;
                credentialStatus2 = new CredentialStatus(((CredentialStatusData)it).getId(), ((CredentialStatusData)it).getType(), ((CredentialStatusData)it).getStatusPurpose(), ((CredentialStatusData)it).getStatusListIndex(), ((CredentialStatusData)it).getStatusListCredential());
                list4 = list;
                list5 = list2;
                string3 = string;
                issuer3 = issuer;
                credentialSubject3 = credentialSubject;
                date5 = date3;
                date = date2;
                credentialStatus = credentialStatus2;
            } else {
                credentialStatus = null;
            }
            CredentialSchemaData credentialSchemaData = data2.getCredentialSchema();
            if (credentialSchemaData != null) {
                it = credentialSchemaData;
                credentialStatus2 = credentialStatus;
                date2 = date;
                date3 = date5;
                credentialSubject = credentialSubject3;
                issuer = issuer3;
                string = string3;
                list2 = list5;
                list = list4;
                boolean bl = false;
                CredentialSchema credentialSchema2 = new CredentialSchema(((CredentialSchemaData)it).getId(), ((CredentialSchemaData)it).getType());
                list4 = list;
                list5 = list2;
                string3 = string;
                issuer3 = issuer;
                credentialSubject3 = credentialSubject;
                date5 = date3;
                date = date2;
                credentialStatus = credentialStatus2;
                credentialSchema = credentialSchema2;
            } else {
                credentialSchema = null;
            }
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            web5.sdk.rust.VerifiableCredential verifiableCredential = rustCoreVerifiableCredential;
            List list6 = evidence;
            CredentialSchema credentialSchema3 = credentialSchema;
            CredentialStatus credentialStatus3 = credentialStatus;
            Date date6 = date;
            Date date7 = date5;
            CredentialSubject credentialSubject4 = credentialSubject3;
            Issuer issuer4 = issuer3;
            String string4 = string3;
            List<String> list7 = list5;
            List<String> list8 = list4;
            return new VerifiableCredential(list8, list7, string4, issuer4, credentialSubject4, date7, date6, credentialStatus3, credentialSchema3, list6, verifiableCredential, defaultConstructorMarker2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VerifiableCredential create(@NotNull Issuer issuer, @NotNull CredentialSubject credentialSubject, @Nullable VerifiableCredentialCreateOptions options2) {
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(credentialSubject, "credentialSubject");
            try {
                Object object;
                Object object2;
                Comparable<Instant> comparable;
                List<String> list;
                String string;
                List list2;
                Object it;
                CredentialSchemaData credentialSchemaData;
                Object object3;
                CredentialStatusData credentialStatusData;
                Object object4;
                VerifiableCredential.Companion companion;
                String string2;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Comparable<Instant> comparable2;
                Object object9;
                String string3;
                String jsonSerializedIssuer = Json.INSTANCE.stringify(issuer);
                String jsonSerializedCredentialSubject = Json.INSTANCE.stringify(credentialSubject);
                Object object10 = options2;
                if (object10 != null && (object10 = ((VerifiableCredentialCreateOptions)object10).getEvidence()) != null) {
                    Object it2 = object10;
                    boolean bl = false;
                    string3 = Json.INSTANCE.stringify(it2);
                } else {
                    string3 = null;
                }
                String jsonSerializedEvidence = string3;
                VerifiableCredential.Companion companion2 = web5.sdk.rust.VerifiableCredential.Companion;
                String string4 = jsonSerializedIssuer;
                String string5 = jsonSerializedCredentialSubject;
                VerifiableCredentialCreateOptions verifiableCredentialCreateOptions = options2;
                String string6 = verifiableCredentialCreateOptions != null ? verifiableCredentialCreateOptions.getId() : null;
                VerifiableCredentialCreateOptions verifiableCredentialCreateOptions2 = options2;
                List<String> list3 = verifiableCredentialCreateOptions2 != null ? verifiableCredentialCreateOptions2.getContext() : null;
                VerifiableCredentialCreateOptions verifiableCredentialCreateOptions3 = options2;
                List<String> list4 = verifiableCredentialCreateOptions3 != null ? verifiableCredentialCreateOptions3.getType() : null;
                Object object11 = options2;
                Instant instant = object11 != null && (object11 = ((VerifiableCredentialCreateOptions)object11).getIssuanceDate()) != null ? ((Date)object11).toInstant() : null;
                Object object12 = options2;
                Instant instant2 = object12 != null && (object12 = ((VerifiableCredentialCreateOptions)object12).getExpirationDate()) != null ? ((Date)object12).toInstant() : null;
                Object object13 = options2;
                if (object13 != null && (object13 = ((VerifiableCredentialCreateOptions)object13).getCredentialStatus()) != null) {
                    void it3;
                    Object bl = object13;
                    object9 = instant2;
                    comparable2 = instant;
                    object8 = list4;
                    object7 = list3;
                    object6 = string6;
                    object5 = string5;
                    string2 = string4;
                    companion = companion2;
                    boolean bl2 = false;
                    object4 = new CredentialStatusData(it3.getId(), it3.getType(), it3.getStatusPurpose(), it3.getStatusListIndex(), it3.getStatusListCredential());
                    companion2 = companion;
                    string4 = string2;
                    string5 = object5;
                    string6 = object6;
                    list3 = object7;
                    list4 = object8;
                    instant = comparable2;
                    instant2 = object9;
                    credentialStatusData = object4;
                } else {
                    credentialStatusData = null;
                }
                if ((object3 = options2) != null && (object3 = ((VerifiableCredentialCreateOptions)object3).getCredentialSchema()) != null) {
                    Object it3 = object3;
                    object4 = credentialStatusData;
                    object9 = instant2;
                    comparable2 = instant;
                    object8 = list4;
                    object7 = list3;
                    object6 = string6;
                    object5 = string5;
                    string2 = string4;
                    companion = companion2;
                    boolean bl = false;
                    CredentialSchemaData credentialSchemaData2 = new CredentialSchemaData(((CredentialSchema)it3).getId(), ((CredentialSchema)it3).getType());
                    companion2 = companion;
                    string4 = string2;
                    string5 = object5;
                    string6 = object6;
                    list3 = object7;
                    list4 = object8;
                    instant = comparable2;
                    instant2 = object9;
                    credentialStatusData = object4;
                    credentialSchemaData = credentialSchemaData2;
                } else {
                    credentialSchemaData = null;
                }
                String string7 = jsonSerializedEvidence;
                CredentialSchemaData credentialSchemaData3 = credentialSchemaData;
                CredentialStatusData credentialStatusData2 = credentialStatusData;
                Instant instant3 = instant2;
                Instant instant4 = instant;
                List<String> list5 = list4;
                List<String> list6 = list3;
                String string8 = string6;
                web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential = companion2.create(string4, string5, new VerifiableCredentialCreateOptionsData(string8, list6, list5, instant4, instant3, credentialStatusData2, credentialSchemaData3, string7));
                VerifiableCredentialData data2 = rustCoreVerifiableCredential.getData();
                String string9 = data2.getJsonSerializedEvidence();
                if (string9 != null) {
                    it = string9;
                    boolean bl = false;
                    ObjectMapper $this$readValue$iv = Json.INSTANCE.getJsonMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    list2 = (List)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<List<? extends Map<String, ? extends Object>>>(){});
                } else {
                    list2 = null;
                }
                List evidence = list2;
                Object object14 = data2.getContext();
                List<String> list7 = data2.getType();
                String string10 = data2.getId();
                Object object15 = issuer;
                Object object16 = credentialSubject;
                Date date = Date.from(data2.getIssuanceDate());
                Object object17 = date;
                Intrinsics.checkNotNullExpressionValue(date, "from(...)");
                Instant instant5 = data2.getExpirationDate();
                if (instant5 != null) {
                    it = instant5;
                    object8 = object17;
                    object7 = object16;
                    object6 = object15;
                    string = string10;
                    list = list7;
                    object5 = object14;
                    boolean bl = false;
                    comparable2 = Date.from((Instant)it);
                    object14 = object5;
                    list7 = list;
                    string10 = string;
                    object15 = object6;
                    object16 = object7;
                    object17 = object8;
                    comparable = comparable2;
                } else {
                    comparable = null;
                }
                CredentialStatusData credentialStatusData3 = data2.getCredentialStatus();
                if (credentialStatusData3 != null) {
                    it = credentialStatusData3;
                    comparable2 = comparable;
                    object8 = object17;
                    object7 = object16;
                    object6 = object15;
                    string = string10;
                    list = list7;
                    object5 = object14;
                    boolean bl = false;
                    object9 = new CredentialStatus(((CredentialStatusData)it).getId(), ((CredentialStatusData)it).getType(), ((CredentialStatusData)it).getStatusPurpose(), ((CredentialStatusData)it).getStatusListIndex(), ((CredentialStatusData)it).getStatusListCredential());
                    object14 = object5;
                    list7 = list;
                    string10 = string;
                    object15 = object6;
                    object16 = object7;
                    object17 = object8;
                    comparable = comparable2;
                    object2 = object9;
                } else {
                    object2 = null;
                }
                CredentialSchemaData credentialSchemaData4 = data2.getCredentialSchema();
                if (credentialSchemaData4 != null) {
                    it = credentialSchemaData4;
                    object9 = object2;
                    comparable2 = comparable;
                    object8 = object17;
                    object7 = object16;
                    object6 = object15;
                    string = string10;
                    list = list7;
                    object5 = object14;
                    boolean bl = false;
                    object4 = new CredentialSchema(((CredentialSchemaData)it).getId(), ((CredentialSchemaData)it).getType());
                    object14 = object5;
                    list7 = list;
                    string10 = string;
                    object15 = object6;
                    object16 = object7;
                    object17 = object8;
                    comparable = comparable2;
                    object2 = object9;
                    object = object4;
                } else {
                    object = null;
                }
                DefaultConstructorMarker defaultConstructorMarker2 = null;
                web5.sdk.rust.VerifiableCredential verifiableCredential = rustCoreVerifiableCredential;
                List list8 = evidence;
                Object object18 = object;
                Object object19 = object2;
                Comparable<Instant> comparable3 = comparable;
                Object object20 = object17;
                Object object21 = object16;
                Object object22 = object15;
                String string11 = string10;
                List<String> list9 = list7;
                Object object23 = object14;
                return new VerifiableCredential((List)object23, list9, string11, (Issuer)object22, (CredentialSubject)object21, (Date)object20, (Date)comparable3, (CredentialStatus)object19, (CredentialSchema)object18, list8, verifiableCredential, defaultConstructorMarker2);
            }
            catch (Web5Exception.Exception e) {
                throw Web5Exception.Companion.fromRustCore$web5(e);
            }
        }

        public static /* synthetic */ VerifiableCredential create$default(Companion companion, Issuer issuer, CredentialSubject credentialSubject, VerifiableCredentialCreateOptions verifiableCredentialCreateOptions, int n, Object object) {
            if ((n & 4) != 0) {
                verifiableCredentialCreateOptions = null;
            }
            return companion.create(issuer, credentialSubject, verifiableCredentialCreateOptions);
        }

        @NotNull
        public final VerifiableCredential fromVcJwt(@NotNull String vcJwt, boolean verify2) {
            Intrinsics.checkNotNullParameter(vcJwt, "vcJwt");
            try {
                CredentialSchema credentialSchema;
                CredentialStatus credentialStatus;
                CredentialStatus credentialStatus2;
                Date date;
                Date date2;
                List<String> list;
                List<String> list2;
                String string;
                Issuer issuer;
                CredentialSubject credentialSubject;
                Date date3;
                List list3;
                Object it;
                web5.sdk.rust.VerifiableCredential rustCoreVerifiableCredential = web5.sdk.rust.VerifiableCredential.Companion.fromVcJwt(vcJwt, verify2);
                VerifiableCredentialData data2 = rustCoreVerifiableCredential.getData();
                Issuer issuer2 = Json.INSTANCE.getJsonMapper().readValue(data2.getJsonSerializedIssuer(), Issuer.class);
                CredentialSubject credentialSubject2 = Json.INSTANCE.getJsonMapper().readValue(data2.getJsonSerializedCredentialSubject(), CredentialSubject.class);
                String string2 = data2.getJsonSerializedEvidence();
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    ObjectMapper $this$readValue$iv = Json.INSTANCE.getJsonMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    list3 = (List)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<List<? extends Map<String, ? extends Object>>>(){});
                } else {
                    list3 = null;
                }
                List evidence = list3;
                List<String> list4 = data2.getContext();
                List<String> list5 = data2.getType();
                String string3 = data2.getId();
                Intrinsics.checkNotNull(issuer2);
                Issuer issuer3 = issuer2;
                Intrinsics.checkNotNull(credentialSubject2);
                CredentialSubject credentialSubject3 = credentialSubject2;
                Date date4 = Date.from(data2.getIssuanceDate());
                Date date5 = date4;
                Intrinsics.checkNotNullExpressionValue(date4, "from(...)");
                Instant instant = data2.getExpirationDate();
                if (instant != null) {
                    it = instant;
                    date3 = date5;
                    credentialSubject = credentialSubject3;
                    issuer = issuer3;
                    string = string3;
                    list2 = list5;
                    list = list4;
                    boolean bl = false;
                    date2 = Date.from((Instant)it);
                    list4 = list;
                    list5 = list2;
                    string3 = string;
                    issuer3 = issuer;
                    credentialSubject3 = credentialSubject;
                    date5 = date3;
                    date = date2;
                } else {
                    date = null;
                }
                CredentialStatusData credentialStatusData = data2.getCredentialStatus();
                if (credentialStatusData != null) {
                    it = credentialStatusData;
                    date2 = date;
                    date3 = date5;
                    credentialSubject = credentialSubject3;
                    issuer = issuer3;
                    string = string3;
                    list2 = list5;
                    list = list4;
                    boolean bl = false;
                    credentialStatus2 = new CredentialStatus(((CredentialStatusData)it).getId(), ((CredentialStatusData)it).getType(), ((CredentialStatusData)it).getStatusPurpose(), ((CredentialStatusData)it).getStatusListIndex(), ((CredentialStatusData)it).getStatusListCredential());
                    list4 = list;
                    list5 = list2;
                    string3 = string;
                    issuer3 = issuer;
                    credentialSubject3 = credentialSubject;
                    date5 = date3;
                    date = date2;
                    credentialStatus = credentialStatus2;
                } else {
                    credentialStatus = null;
                }
                CredentialSchemaData credentialSchemaData = data2.getCredentialSchema();
                if (credentialSchemaData != null) {
                    it = credentialSchemaData;
                    credentialStatus2 = credentialStatus;
                    date2 = date;
                    date3 = date5;
                    credentialSubject = credentialSubject3;
                    issuer = issuer3;
                    string = string3;
                    list2 = list5;
                    list = list4;
                    boolean bl = false;
                    CredentialSchema credentialSchema2 = new CredentialSchema(((CredentialSchemaData)it).getId(), ((CredentialSchemaData)it).getType());
                    list4 = list;
                    list5 = list2;
                    string3 = string;
                    issuer3 = issuer;
                    credentialSubject3 = credentialSubject;
                    date5 = date3;
                    date = date2;
                    credentialStatus = credentialStatus2;
                    credentialSchema = credentialSchema2;
                } else {
                    credentialSchema = null;
                }
                DefaultConstructorMarker defaultConstructorMarker2 = null;
                web5.sdk.rust.VerifiableCredential verifiableCredential = rustCoreVerifiableCredential;
                List list6 = evidence;
                CredentialSchema credentialSchema3 = credentialSchema;
                CredentialStatus credentialStatus3 = credentialStatus;
                Date date6 = date;
                Date date7 = date5;
                CredentialSubject credentialSubject4 = credentialSubject3;
                Issuer issuer4 = issuer3;
                String string4 = string3;
                List<String> list7 = list5;
                List<String> list8 = list4;
                return new VerifiableCredential(list8, list7, string4, issuer4, credentialSubject4, date7, date6, credentialStatus3, credentialSchema3, list6, verifiableCredential, defaultConstructorMarker2);
            }
            catch (Web5Exception.Exception e) {
                throw Web5Exception.Companion.fromRustCore$web5(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

