/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.agent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bJ\"\u0010\u000e\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lxyz/block/trailblaze/agent/util/ElementRetriever;", "", "<init>", "()V", "TAG", "", "getTextByResourceId", "currentViewHierarchy", "Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "resourceId", "index", "", "getTextByContentDescription", "contentDescription", "getTextByText", "text", "findNodes", "", "node", "predicate", "Lkotlin/Function1;", "", "extractTextFromNode", "trailblaze-agent"})
@SourceDebugExtension(value={"SMAP\nElementRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementRetriever.kt\nxyz/block/trailblaze/agent/util/ElementRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1869#2,2:149\n*S KotlinDebug\n*F\n+ 1 ElementRetriever.kt\nxyz/block/trailblaze/agent/util/ElementRetriever\n*L\n126#1:149,2\n*E\n"})
public final class ElementRetriever {
    @NotNull
    public static final ElementRetriever INSTANCE = new ElementRetriever();
    @NotNull
    private static final String TAG = "ElementRetriever";

    private ElementRetriever() {
    }

    @NotNull
    public final String getTextByResourceId(@Nullable ViewHierarchyTreeNode currentViewHierarchy, @NotNull String resourceId, int index) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        System.out.println((Object)("ElementRetriever: Getting text by resource ID: " + resourceId + ", index: " + index));
        if (currentViewHierarchy == null) {
            System.out.println((Object)"ElementRetriever: Error - View hierarchy is null");
            return "Error: View hierarchy not set";
        }
        List<ViewHierarchyTreeNode> nodes = this.findNodes(currentViewHierarchy, (Function1<? super ViewHierarchyTreeNode, Boolean>)((Function1)arg_0 -> ElementRetriever.getTextByResourceId$lambda$0(resourceId, arg_0)));
        if (nodes.isEmpty()) {
            System.out.println((Object)("ElementRetriever: No nodes found for resource ID: " + resourceId));
            return "Element not found for resource ID: " + resourceId;
        }
        System.out.println((Object)("ElementRetriever: Found " + nodes.size() + " nodes with resource ID: " + resourceId));
        if (index < nodes.size()) {
            ViewHierarchyTreeNode node = nodes.get(index);
            System.out.println((Object)("ElementRetriever: Using node at index " + index + " with resourceId: " + node.getResourceId() + ", text: " + node.getText() + ", accessibilityText: " + node.getAccessibilityText()));
            object = this.extractTextFromNode(node);
            if (object == null) {
                object = "No text found for resource ID: " + resourceId + " at index " + index;
            }
        } else {
            System.out.println((Object)("ElementRetriever: Index " + index + " out of bounds for resource ID: " + resourceId + " (max index: " + (nodes.size() - 1) + ")"));
            object = "Index out of bounds for resource ID: " + resourceId;
        }
        return object;
    }

    public static /* synthetic */ String getTextByResourceId$default(ElementRetriever elementRetriever, ViewHierarchyTreeNode viewHierarchyTreeNode, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return elementRetriever.getTextByResourceId(viewHierarchyTreeNode, string, n);
    }

    @NotNull
    public final String getTextByContentDescription(@Nullable ViewHierarchyTreeNode currentViewHierarchy, @NotNull String contentDescription, int index) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)contentDescription, (String)"contentDescription");
        System.out.println((Object)("ElementRetriever: Getting text by content description: " + contentDescription + ", index: " + index));
        List<ViewHierarchyTreeNode> nodes = this.findNodes(currentViewHierarchy, (Function1<? super ViewHierarchyTreeNode, Boolean>)((Function1)arg_0 -> ElementRetriever.getTextByContentDescription$lambda$1(contentDescription, arg_0)));
        if (nodes.isEmpty()) {
            return "Element not found for content description: " + contentDescription;
        }
        if (index < nodes.size()) {
            object = this.extractTextFromNode(nodes.get(index));
            if (object == null) {
                object = "No text found for content description: " + contentDescription + " at index " + index;
            }
        } else {
            object = "Index out of bounds for content description: " + contentDescription;
        }
        return object;
    }

    public static /* synthetic */ String getTextByContentDescription$default(ElementRetriever elementRetriever, ViewHierarchyTreeNode viewHierarchyTreeNode, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return elementRetriever.getTextByContentDescription(viewHierarchyTreeNode, string, n);
    }

    @NotNull
    public final String getTextByText(@Nullable ViewHierarchyTreeNode currentViewHierarchy, @NotNull String text, int index) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        System.out.println((Object)("ElementRetriever: Getting text by text: " + text + ", index: " + index));
        List<ViewHierarchyTreeNode> nodes = this.findNodes(currentViewHierarchy, (Function1<? super ViewHierarchyTreeNode, Boolean>)((Function1)arg_0 -> ElementRetriever.getTextByText$lambda$2(text, arg_0)));
        if (nodes.isEmpty()) {
            return "Element not found for text: " + text;
        }
        return index < nodes.size() ? text : "Index out of bounds for text: " + text;
    }

    public static /* synthetic */ String getTextByText$default(ElementRetriever elementRetriever, ViewHierarchyTreeNode viewHierarchyTreeNode, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return elementRetriever.getTextByText(viewHierarchyTreeNode, string, n);
    }

    private final List<ViewHierarchyTreeNode> findNodes(ViewHierarchyTreeNode node, Function1<? super ViewHierarchyTreeNode, Boolean> predicate) {
        List results = new ArrayList();
        if (node == null) {
            return results;
        }
        if (((Boolean)predicate.invoke((Object)node)).booleanValue()) {
            results.add(node);
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewHierarchyTreeNode child = (ViewHierarchyTreeNode)element$iv;
            boolean bl = false;
            results.addAll((Collection)INSTANCE.findNodes(child, predicate));
        }
        return results;
    }

    private final String extractTextFromNode(ViewHierarchyTreeNode node) {
        String nodeText = node.getText();
        if (nodeText != null && ((CharSequence)nodeText).length() > 0) {
            return nodeText;
        }
        String nodeContentDesc = node.getAccessibilityText();
        return nodeContentDesc;
    }

    private static final boolean getTextByResourceId$lambda$0(String $resourceId, ViewHierarchyTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getResourceId(), (Object)$resourceId);
    }

    private static final boolean getTextByContentDescription$lambda$1(String $contentDescription, ViewHierarchyTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getAccessibilityText(), (Object)$contentDescription);
    }

    private static final boolean getTextByText$lambda$2(String $text, ViewHierarchyTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getText(), (Object)$text);
    }
}

