/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.agent;

import ai.koog.prompt.executor.clients.LLMClient;
import ai.koog.prompt.llm.LLModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.jetbrains.annotations.NotNull;
import xyz.block.trailblaze.MaestroTrailblazeAgent;
import xyz.block.trailblaze.agent.TrailblazeElementComparator;
import xyz.block.trailblaze.agent.TrailblazeRunner;
import xyz.block.trailblaze.agent.model.AgentTaskStatus;
import xyz.block.trailblaze.agent.model.MixedModeTestCase;
import xyz.block.trailblaze.agent.model.StaticObjective;
import xyz.block.trailblaze.agent.model.TestObjective;
import xyz.block.trailblaze.agent.model.TrailblazePromptStep;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.TrailblazeAgent;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.exception.TrailblazeToolExecutionException;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.client.TrailblazeLogger;
import xyz.block.trailblaze.maestro.MaestroYamlParser;
import xyz.block.trailblaze.toolcalls.TrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;
import xyz.block.trailblaze.toolcalls.commands.BooleanAssertionTrailblazeTool;
import xyz.block.trailblaze.toolcalls.commands.StringEvaluationTrailblazeTool;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00110\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010$\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u001c2\u0006\u0010$\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u001c2\u0006\u0010$\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u00109\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000bH\u0002J\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lxyz/block/trailblaze/agent/MixedModeExecutor;", "", "llmModel", "Lai/koog/prompt/llm/LLModel;", "llmClient", "Lai/koog/prompt/executor/clients/LLMClient;", "screenStateProvider", "Lkotlin/Function0;", "Lxyz/block/trailblaze/api/ScreenState;", "runYamlFlowFunction", "Lkotlin/Function1;", "", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "trailblazeRunner", "Lxyz/block/trailblaze/agent/TrailblazeRunner;", "additionalTrailblazeTools", "", "Lkotlin/reflect/KClass;", "Lxyz/block/trailblaze/toolcalls/TrailblazeTool;", "<init>", "(Lai/koog/prompt/llm/LLModel;Lai/koog/prompt/executor/clients/LLMClient;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lxyz/block/trailblaze/agent/TrailblazeRunner;Ljava/util/List;)V", "variables", "", "numberRegex", "Lkotlin/text/Regex;", "elementComparator", "Lxyz/block/trailblaze/agent/TrailblazeElementComparator;", "runMixedMode", "", "yamlContent", "executeRecordedSteps", "", "handleTrailblazePrompt", "prompt", "Lxyz/block/trailblaze/agent/model/TestObjective$TrailblazeObjective$TrailblazePrompt;", "handleTrailblazeCommand", "objective", "Lxyz/block/trailblaze/agent/model/TestObjective$TrailblazeObjective$TrailblazeCommand;", "handleRememberTextCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberTextCommand;", "handleRememberNumberCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberNumberCommand;", "handleRememberWithAICommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberWithAiCommand;", "handleAssertEqualsCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertEqualsCommand;", "handleAssertNotEqualsCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertNotEqualsCommand;", "handleAssertWithAICommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertWithAiCommand;", "handleAssertMathCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertMathCommand;", "handleMaestroCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$MaestroCommand;", "agent", "Lxyz/block/trailblaze/MaestroTrailblazeAgent;", "evaluateUiAssertion", "getDirectAnswer", "interpolateVariables", "input", "processDynamicExtractions", "expression", "trailblaze-agent"})
@SourceDebugExtension(value={"SMAP\nMixedModeExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeExecutor.kt\nxyz/block/trailblaze/agent/MixedModeExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,339:1\n1869#2,2:340\n1869#2:342\n1869#2,2:343\n1870#2:345\n1321#3,2:346\n*S KotlinDebug\n*F\n+ 1 MixedModeExecutor.kt\nxyz/block/trailblaze/agent/MixedModeExecutor\n*L\n72#1:340,2\n114#1:342\n115#1:343,2\n114#1:345\n278#1:346,2\n*E\n"})
public final class MixedModeExecutor {
    @NotNull
    private final Function0<ScreenState> screenStateProvider;
    @NotNull
    private final Function1<String, TrailblazeToolResult> runYamlFlowFunction;
    @NotNull
    private final TrailblazeRunner trailblazeRunner;
    @NotNull
    private final List<KClass<? extends TrailblazeTool>> additionalTrailblazeTools;
    @NotNull
    private final Map<String, String> variables;
    @NotNull
    private final Regex numberRegex;
    @NotNull
    private final TrailblazeElementComparator elementComparator;

    public MixedModeExecutor(@NotNull LLModel llmModel, @NotNull LLMClient llmClient, @NotNull Function0<? extends ScreenState> screenStateProvider, @NotNull Function1<? super String, ? extends TrailblazeToolResult> runYamlFlowFunction, @NotNull TrailblazeRunner trailblazeRunner, @NotNull List<? extends KClass<? extends TrailblazeTool>> additionalTrailblazeTools) {
        Intrinsics.checkNotNullParameter((Object)llmModel, (String)"llmModel");
        Intrinsics.checkNotNullParameter((Object)llmClient, (String)"llmClient");
        Intrinsics.checkNotNullParameter(screenStateProvider, (String)"screenStateProvider");
        Intrinsics.checkNotNullParameter(runYamlFlowFunction, (String)"runYamlFlowFunction");
        Intrinsics.checkNotNullParameter((Object)trailblazeRunner, (String)"trailblazeRunner");
        Intrinsics.checkNotNullParameter(additionalTrailblazeTools, (String)"additionalTrailblazeTools");
        this.screenStateProvider = screenStateProvider;
        this.runYamlFlowFunction = runYamlFlowFunction;
        this.trailblazeRunner = trailblazeRunner;
        this.additionalTrailblazeTools = additionalTrailblazeTools;
        this.variables = new LinkedHashMap();
        this.numberRegex = new Regex("-?(?:\\d{1,3}(?:,\\d{1,3})+|\\d+)(?:\\.\\d+)?");
        Function0<ScreenState> function0 = this.screenStateProvider;
        this.elementComparator = new TrailblazeElementComparator(function0, llmModel, llmClient, null, null, 24, null);
    }

    public /* synthetic */ MixedModeExecutor(LLModel lLModel, LLMClient lLMClient, Function0 function0, Function1 function1, TrailblazeRunner trailblazeRunner, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(lLModel, lLMClient, (Function0<? extends ScreenState>)function0, (Function1<? super String, ? extends TrailblazeToolResult>)function1, trailblazeRunner, list);
    }

    public final void runMixedMode(@NotNull String yamlContent, boolean executeRecordedSteps) {
        Intrinsics.checkNotNullParameter((Object)yamlContent, (String)"yamlContent");
        MixedModeTestCase testCase = new MixedModeTestCase(yamlContent, executeRecordedSteps, this.additionalTrailblazeTools);
        String string = testCase.getContextString();
        if (string != null) {
            String context = string;
            boolean bl = false;
            this.trailblazeRunner.appendToSystemPrompt("\n## Here is some additional context that you can use to complete the test:\n\n" + context);
        }
        Iterable $this$forEach$iv = testCase.getObjectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestObjective objective = (TestObjective)element$iv;
            boolean bl = false;
            TestObjective testObjective = objective;
            if (testObjective instanceof TestObjective.AssertEqualsCommand) {
                this.handleAssertEqualsCommand((TestObjective.AssertEqualsCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.AssertMathCommand) {
                this.handleAssertMathCommand((TestObjective.AssertMathCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.AssertNotEqualsCommand) {
                this.handleAssertNotEqualsCommand((TestObjective.AssertNotEqualsCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.AssertWithAiCommand) {
                this.handleAssertWithAICommand((TestObjective.AssertWithAiCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.MaestroCommand) {
                TestObjective.MaestroCommand maestroCommand = (TestObjective.MaestroCommand)objective;
                TrailblazeAgent trailblazeAgent = this.trailblazeRunner.getAgent();
                Intrinsics.checkNotNull((Object)trailblazeAgent, (String)"null cannot be cast to non-null type xyz.block.trailblaze.MaestroTrailblazeAgent");
                this.handleMaestroCommand(maestroCommand, (MaestroTrailblazeAgent)trailblazeAgent);
                continue;
            }
            if (testObjective instanceof TestObjective.RememberNumberCommand) {
                this.handleRememberNumberCommand((TestObjective.RememberNumberCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.RememberTextCommand) {
                this.handleRememberTextCommand((TestObjective.RememberTextCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.RememberWithAiCommand) {
                this.handleRememberWithAICommand((TestObjective.RememberWithAiCommand)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.TrailblazeObjective.TrailblazePrompt) {
                this.handleTrailblazePrompt((TestObjective.TrailblazeObjective.TrailblazePrompt)objective);
                continue;
            }
            if (testObjective instanceof TestObjective.TrailblazeObjective.TrailblazeCommand) {
                this.handleTrailblazeCommand((TestObjective.TrailblazeObjective.TrailblazeCommand)objective);
                continue;
            }
            throw new TrailblazeException("Unknown objective type for mixed mode");
        }
    }

    public static /* synthetic */ void runMixedMode$default(MixedModeExecutor mixedModeExecutor, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        mixedModeExecutor.runMixedMode(string, bl);
    }

    private final void handleTrailblazePrompt(TestObjective.TrailblazeObjective.TrailblazePrompt prompt) {
        AgentTaskStatus trailblazeRunnerResult = this.trailblazeRunner.run(prompt);
        if (trailblazeRunnerResult instanceof AgentTaskStatus.Success.ObjectiveComplete) {
            System.out.println((Object)("AI Task completed successfully: " + ((AgentTaskStatus.Success.ObjectiveComplete)trailblazeRunnerResult).getLlmExplanation()));
        } else if (trailblazeRunnerResult instanceof AgentTaskStatus.Success) {
            System.out.println((Object)("AI Task succeeded: " + trailblazeRunnerResult));
        } else {
            throw new TrailblazeException(trailblazeRunnerResult.toString());
        }
    }

    private final void handleTrailblazeCommand(TestObjective.TrailblazeObjective.TrailblazeCommand objective) {
        Iterable $this$forEach$iv = objective.getTools();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StaticObjective staticObjective = (StaticObjective)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = staticObjective.getTools();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TrailblazeTool tool = (TrailblazeTool)element$iv2;
                boolean bl2 = false;
                this.trailblazeRunner.handleTrailblazeToolForPrompt(tool, null, new TrailblazePromptStep("", null, 0, null, false, 30, null), (ScreenState)this.screenStateProvider.invoke());
            }
        }
    }

    private final void handleRememberTextCommand(TestObjective.RememberTextCommand objective) {
        String interpolatedPrompt = this.interpolateVariables(objective.getPromptWithVars());
        String string = this.elementComparator.getElementValue(interpolatedPrompt);
        if (string == null) {
            throw new TrailblazeException("Failed to find element for prompt: " + objective.getPromptWithVars());
        }
        String extractedValue = string;
        this.variables.put(objective.getVariableName(), extractedValue);
    }

    private final void handleRememberNumberCommand(TestObjective.RememberNumberCommand objective) {
        String interpolatedPrompt = this.interpolateVariables(objective.getPromptWithVars());
        String string = this.elementComparator.getElementValue(interpolatedPrompt);
        if (string == null) {
            throw new TrailblazeException("Failed to find element for prompt: " + objective.getPromptWithVars());
        }
        String extractedValue = string;
        MatchResult numberMatch = Regex.find$default((Regex)this.numberRegex, (CharSequence)extractedValue, (int)0, (int)2, null);
        Object object = numberMatch;
        if (object == null || (object = object.getValue()) == null || (object = StringsKt.replace$default((String)object, (String)",", (String)"", (boolean)false, (int)4, null)) == null) {
            object = "0";
        }
        Object numberString = object;
        this.variables.put(objective.getVariableName(), (String)numberString);
    }

    private final void handleRememberWithAICommand(TestObjective.RememberWithAiCommand objective) {
        String interpolatedPrompt = this.interpolateVariables(objective.getPromptWithVars());
        String answer = this.getDirectAnswer(interpolatedPrompt);
        this.variables.put(objective.getVariableName(), answer);
    }

    private final void handleAssertEqualsCommand(TestObjective.AssertEqualsCommand objective) {
        String expected;
        String actual = this.interpolateVariables(objective.getActual());
        if (!Intrinsics.areEqual((Object)actual, (Object)(expected = this.interpolateVariables(objective.getExpected())))) {
            throw new TrailblazeException("Assertion failed: Expected '" + objective.getExpected() + "', but got '" + objective.getActual() + "'");
        }
    }

    private final void handleAssertNotEqualsCommand(TestObjective.AssertNotEqualsCommand objective) {
        String expected;
        String actual = this.interpolateVariables(objective.getActual());
        if (Intrinsics.areEqual((Object)actual, (Object)(expected = this.interpolateVariables(objective.getExpected())))) {
            throw new TrailblazeException("Assertion failed: Expected '" + objective.getExpected() + "' to NOT equal '" + objective.getActual() + "', but they are equal");
        }
    }

    private final void handleAssertWithAICommand(TestObjective.AssertWithAiCommand objective) {
        String interpolatedPrompt = this.interpolateVariables(objective.getPromptWithVars());
        String response = this.evaluateUiAssertion(interpolatedPrompt);
        System.out.println((Object)("assertWithAI result for '" + interpolatedPrompt + "': " + response));
        if (!Intrinsics.areEqual((Object)response, (Object)"true")) {
            throw new TrailblazeException("AI assertion failed: " + interpolatedPrompt);
        }
    }

    private final void handleAssertMathCommand(TestObjective.AssertMathCommand objective) {
        String interpolatedExpression = this.processDynamicExtractions(objective.getExpression());
        try {
            double result = new ExpressionBuilder(interpolatedExpression).build().evaluate();
            double expectedValue = Double.parseDouble(objective.getExpected());
            if (Math.abs(result - expectedValue) > 1.0E-4) {
                throw new TrailblazeException("Math assertion failed: Expression '" + interpolatedExpression + "' evaluated to " + result + ", expected " + expectedValue);
            }
        }
        catch (Exception e) {
            if (e instanceof TrailblazeException) {
                throw e;
            }
            throw new TrailblazeException("Math assertion failed: Error evaluating expression - " + e.getMessage());
        }
    }

    private final void handleMaestroCommand(TestObjective.MaestroCommand objective, MaestroTrailblazeAgent agent) {
        String interpolatedMaestroYaml = this.interpolateVariables(objective.getMaestroCommandWithVars());
        TrailblazeLogger.INSTANCE.log((TrailblazeLog)new TrailblazeLog.TopLevelMaestroCommandLog(interpolatedMaestroYaml, TrailblazeLogger.INSTANCE.getCurrentSessionId(), Clock.System.INSTANCE.now()));
        TrailblazeToolResult result = MaestroTrailblazeAgent.runMaestroCommands$default((MaestroTrailblazeAgent)agent, (List)MaestroYamlParser.parseYaml$default((MaestroYamlParser)MaestroYamlParser.INSTANCE, (String)interpolatedMaestroYaml, null, (int)2, null), null, (int)2, null);
        if (result instanceof TrailblazeToolResult.Error) {
            throw new TrailblazeToolExecutionException((TrailblazeToolResult.Error)result);
        }
    }

    private final String evaluateUiAssertion(String prompt) {
        BooleanAssertionTrailblazeTool result = this.elementComparator.evaluateBoolean(prompt);
        System.out.println((Object)("UI Assertion result: " + result.getResult() + ", reason: " + result.getReason()));
        return result.getResult() ? "true" : "false";
    }

    private final String getDirectAnswer(String prompt) {
        StringEvaluationTrailblazeTool result = this.elementComparator.evaluateString(prompt);
        System.out.println((Object)("UI Evaluation result: " + result.getResult() + ", reason: " + result.getReason()));
        return result.getResult();
    }

    private final String interpolateVariables(String input) {
        String result = null;
        result = input;
        Regex[] regexArray = new Regex[]{new Regex("\\$\\{([^}]+)\\}"), new Regex("\\{\\{([^}]+)\\}\\}")};
        List patterns = CollectionsKt.listOf((Object[])regexArray);
        for (Regex pattern : patterns) {
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)pattern, (CharSequence)result, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult matchResult = (MatchResult)element$iv;
                boolean bl = false;
                String variableName = (String)matchResult.getGroupValues().get(1);
                String string = this.variables.get(variableName);
                if (string == null) {
                    string = "";
                }
                String variableValue = string;
                result = StringsKt.replace$default((String)result, (String)matchResult.getValue(), (String)variableValue, (boolean)false, (int)4, null);
            }
        }
        return result;
    }

    private final String processDynamicExtractions(String expression) {
        System.out.println((Object)("Processing dynamic extractions in: " + expression));
        String interpolatedExpression = expression;
        Regex dynamicExtractPattern = new Regex("\\[\\[([^\\]]+)\\]\\]");
        Sequence matches = Regex.findAll$default((Regex)dynamicExtractPattern, (CharSequence)interpolatedExpression, (int)0, (int)2, null);
        for (MatchResult match : matches) {
            String fullMatch = match.getValue();
            String prompt = (String)match.getGroupValues().get(1);
            System.out.println((Object)("Found dynamic extraction pattern: " + fullMatch + " with prompt: " + prompt));
            String extractedValue = this.elementComparator.getElementValue(prompt);
            if (extractedValue != null) {
                Double numberValue = this.elementComparator.extractNumberFromString(extractedValue);
                if (numberValue != null) {
                    System.out.println((Object)("Extracted value " + numberValue + " for prompt '" + prompt + "'"));
                    interpolatedExpression = StringsKt.replace$default((String)interpolatedExpression, (String)fullMatch, (String)numberValue.toString(), (boolean)false, (int)4, null);
                    continue;
                }
                System.out.println((Object)("Could not extract a number from: " + extractedValue + " for prompt: " + prompt));
                throw new TrailblazeException("Could not extract a numeric value for prompt: " + prompt);
            }
            System.out.println((Object)("Failed to find element for prompt: " + prompt));
            throw new TrailblazeException("Failed to find element for prompt: " + prompt);
        }
        String finalExpression = this.interpolateVariables(interpolatedExpression);
        System.out.println((Object)("Final interpolated expression: " + finalExpression));
        return finalExpression;
    }
}

