/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.android.maestro;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.KeyCode;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.api.MaestroDriverActionType;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.client.TrailblazeLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J \u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J.\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J$\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001bH\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020$H\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010+\u001a\u00020$H\u0016J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0010H\u0096\u0001J\t\u0010/\u001a\u00020\tH\u0096\u0001J\t\u00100\u001a\u00020\tH\u0096\u0001J\u0011\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0096\u0001J\t\u00105\u001a\u000206H\u0096\u0001J\u0011\u00107\u001a\u00020\t2\u0006\u00108\u001a\u000209H\u0096\u0001J\t\u0010:\u001a\u00020\tH\u0096\u0001J\t\u0010;\u001a\u000204H\u0096\u0001J\t\u0010<\u001a\u000204H\u0096\u0001J\t\u0010=\u001a\u000204H\u0096\u0001J\t\u0010>\u001a\u000204H\u0096\u0001J\t\u0010?\u001a\u00020\u0015H\u0096\u0001J\t\u0010@\u001a\u00020\tH\u0096\u0001J+\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010C\u001a\u0002042\u0006\u0010D\u001a\u000204H\u0096\u0001J\u0011\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020GH\u0096\u0001J\t\u0010H\u001a\u00020\tH\u0096\u0001J\t\u0010I\u001a\u00020\tH\u0096\u0001J\u0011\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u000204H\u0096\u0001J\u0011\u0010L\u001a\u00020\t2\u0006\u0010K\u001a\u000204H\u0096\u0001J\u0019\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020OH\u0096\u0001J\u0019\u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020\u00152\u0006\u0010S\u001a\u000209H\u0096\u0001J\u0011\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0096\u0001J!\u0010\"\u001a\u00020\t2\u0006\u0010X\u001a\u00020$2\u0006\u0010Y\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0096\u0001J\u0019\u0010Z\u001a\u00020\t2\u0006\u0010V\u001a\u00020W2\u0006\u0010[\u001a\u000204H\u0096\u0001J0\u0010\\\u001a\u0004\u0018\u00010]2\b\u0010^\u001a\u0004\u0018\u00010]2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010_\u001a\u0004\u0018\u000109H\u0096\u0001\u00a2\u0006\u0004\b`\u0010aJ\u0011\u0010b\u001a\u0002042\u0006\u0010_\u001a\u00020(H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lxyz/block/trailblaze/android/maestro/LoggingDriver;", "Lmaestro/Driver;", "delegate", "screenStateProvider", "Lkotlin/Function0;", "Lxyz/block/trailblaze/api/ScreenState;", "<init>", "(Lmaestro/Driver;Lkotlin/jvm/functions/Function0;)V", "logActionWithScreenshot", "", "action", "Lxyz/block/trailblaze/api/MaestroDriverActionType;", "block", "logActionWithoutScreenshot", "addMedia", "mediaFiles", "", "Ljava/io/File;", "backPress", "clearAppState", "appId", "", "inputText", "text", "killApp", "launchApp", "launchArguments", "", "", "sessionId", "Ljava/util/UUID;", "setPermissions", "permissions", "stopApp", "swipe", "elementPoint", "Lmaestro/Point;", "direction", "Lmaestro/SwipeDirection;", "durationMs", "", "swipeDirection", "tap", "point", "longPress", "capabilities", "Lmaestro/Capability;", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "excludeKeyboardElements", "", "deviceInfo", "Lmaestro/DeviceInfo;", "eraseText", "charactersToErase", "", "hideKeyboard", "isAirplaneModeEnabled", "isKeyboardVisible", "isShutdown", "isUnicodeInputSupported", "name", "open", "openLink", "link", "autoVerify", "browser", "pressKey", "code", "Lmaestro/KeyCode;", "resetProxy", "scrollVertical", "setAirplaneMode", "enabled", "setAndroidChromeDevToolsEnabled", "setLocation", "latitude", "", "longitude", "setProxy", "host", "port", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "start", "end", "takeScreenshot", "compressed", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "timeoutMs", "waitForAppToSettle-5RpGHs4", "(Lmaestro/TreeNode;Ljava/lang/String;Ljava/lang/Integer;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "trailblaze-common"})
@SourceDebugExtension(value={"SMAP\nLoggingDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingDriver.kt\nxyz/block/trailblaze/android/maestro/LoggingDriver\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,126:1\n29#2,3:127\n29#2,3:131\n1#3:130\n1563#4:134\n1634#4,3:135\n538#5:138\n523#5,6:139\n*S KotlinDebug\n*F\n+ 1 LoggingDriver.kt\nxyz/block/trailblaze/android/maestro/LoggingDriver\n*L\n26#1:127,3\n47#1:131,3\n64#1:134\n64#1:135,3\n93#1:138\n93#1:139,6\n*E\n"})
public final class LoggingDriver
implements Driver {
    @NotNull
    private final Driver delegate;
    @NotNull
    private final Function0<ScreenState> screenStateProvider;

    public LoggingDriver(@NotNull Driver delegate, @NotNull Function0<? extends ScreenState> screenStateProvider) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(screenStateProvider, (String)"screenStateProvider");
        this.delegate = delegate;
        this.screenStateProvider = screenStateProvider;
    }

    private final void logActionWithScreenshot(MaestroDriverActionType action, Function0<Unit> block) {
        String string;
        ScreenState screenState = (ScreenState)this.screenStateProvider.invoke();
        Instant startTime = Clock.System.INSTANCE.now();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        block.invoke();
        long executionTimeMs = System.currentTimeMillis() - start$iv;
        byte[] byArray = screenState.getScreenshotBytes();
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl2 = false;
            string = TrailblazeLogger.INSTANCE.logScreenshot(it);
        } else {
            string = null;
        }
        String screenshotFilename = string;
        ViewHierarchyTreeNode viewHierarchyTreeNode = screenState.getViewHierarchy();
        String string2 = TrailblazeLogger.INSTANCE.getCurrentSessionId();
        int n = screenState.getDeviceWidth();
        int n2 = screenState.getDeviceHeight();
        TrailblazeLogger.INSTANCE.log((TrailblazeLog)new TrailblazeLog.MaestroDriverLog(viewHierarchyTreeNode, screenshotFilename, action, executionTimeMs, string2, startTime, n2, n));
    }

    static /* synthetic */ void logActionWithScreenshot$default(LoggingDriver loggingDriver, MaestroDriverActionType maestroDriverActionType, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = LoggingDriver::logActionWithScreenshot$lambda$0;
        }
        loggingDriver.logActionWithScreenshot(maestroDriverActionType, (Function0<Unit>)function0);
    }

    private final void logActionWithoutScreenshot(MaestroDriverActionType action, Function0<Unit> block) {
        ScreenState screenState = (ScreenState)this.screenStateProvider.invoke();
        Instant startTime = Clock.System.INSTANCE.now();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        block.invoke();
        long executionTimeMs = System.currentTimeMillis() - start$iv;
        String string = TrailblazeLogger.INSTANCE.getCurrentSessionId();
        int n = screenState.getDeviceWidth();
        int n2 = screenState.getDeviceHeight();
        TrailblazeLogger.INSTANCE.log((TrailblazeLog)new TrailblazeLog.MaestroDriverLog(null, null, action, executionTimeMs, string, startTime, n2, n));
    }

    static /* synthetic */ void logActionWithoutScreenshot$default(LoggingDriver loggingDriver, MaestroDriverActionType maestroDriverActionType, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = LoggingDriver::logActionWithoutScreenshot$lambda$3;
        }
        loggingDriver.logActionWithoutScreenshot(maestroDriverActionType, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public void addMedia(@NotNull List<? extends File> mediaFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(mediaFiles, (String)"mediaFiles");
        Iterable iterable = mediaFiles;
        LoggingDriver loggingDriver = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalPath());
        }
        List list = (List)destination$iv$iv;
        loggingDriver.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.AddMedia(list), (Function0<Unit>)((Function0)() -> LoggingDriver.addMedia$lambda$6(this, mediaFiles)));
    }

    public void backPress() {
        this.logActionWithScreenshot((MaestroDriverActionType)MaestroDriverActionType.BackPress.INSTANCE, (Function0<Unit>)((Function0)() -> LoggingDriver.backPress$lambda$7(this)));
    }

    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.logActionWithoutScreenshot((MaestroDriverActionType)new MaestroDriverActionType.ClearAppState(appId), (Function0<Unit>)((Function0)() -> LoggingDriver.clearAppState$lambda$8(this, appId)));
    }

    public void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.EnterText(text), (Function0<Unit>)((Function0)() -> LoggingDriver.inputText$lambda$9(this, text)));
    }

    public void killApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.logActionWithoutScreenshot((MaestroDriverActionType)new MaestroDriverActionType.KillApp(appId), (Function0<Unit>)((Function0)() -> LoggingDriver.killApp$lambda$10(this, appId)));
    }

    public void launchApp(@NotNull String appId, @NotNull Map<String, ? extends Object> launchArguments, @Nullable UUID sessionId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        this.logActionWithoutScreenshot((MaestroDriverActionType)new MaestroDriverActionType.LaunchApp(appId), (Function0<Unit>)((Function0)() -> LoggingDriver.launchApp$lambda$11(this, appId, launchArguments, sessionId)));
    }

    /*
     * WARNING - void declaration
     */
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Map<String, String> $this$filter$iv = permissions;
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getKey(), (Object)"all"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filteredPermissions = destination$iv$iv;
        if (!filteredPermissions.isEmpty()) {
            this.logActionWithoutScreenshot((MaestroDriverActionType)new MaestroDriverActionType.GrantPermissions(appId, permissions), (Function0<Unit>)((Function0)() -> LoggingDriver.setPermissions$lambda$13(this, appId, permissions)));
        }
    }

    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.logActionWithoutScreenshot((MaestroDriverActionType)new MaestroDriverActionType.StopApp(appId), (Function0<Unit>)((Function0)() -> LoggingDriver.stopApp$lambda$14(this, appId)));
    }

    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.Swipe(direction.name(), durationMs), (Function0<Unit>)((Function0)() -> LoggingDriver.swipe$lambda$15(this, elementPoint, direction, durationMs)));
    }

    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)swipeDirection, (String)"swipeDirection");
        this.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.Swipe(swipeDirection.name(), durationMs), (Function0<Unit>)((Function0)() -> LoggingDriver.swipe$lambda$16(this, swipeDirection, durationMs)));
    }

    public void tap(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.TapPoint(point.getX(), point.getY()), (Function0<Unit>)((Function0)() -> LoggingDriver.tap$lambda$17(this, point)));
    }

    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.logActionWithScreenshot((MaestroDriverActionType)new MaestroDriverActionType.LongPressPoint(point.getX(), point.getY()), (Function0<Unit>)((Function0)() -> LoggingDriver.longPress$lambda$18(this, point)));
    }

    @NotNull
    public List<Capability> capabilities() {
        return this.delegate.capabilities();
    }

    public void clearKeychain() {
        this.delegate.clearKeychain();
    }

    public void close() {
        this.delegate.close();
    }

    @NotNull
    public TreeNode contentDescriptor(boolean excludeKeyboardElements) {
        return this.delegate.contentDescriptor(excludeKeyboardElements);
    }

    @NotNull
    public DeviceInfo deviceInfo() {
        return this.delegate.deviceInfo();
    }

    public void eraseText(int charactersToErase) {
        this.delegate.eraseText(charactersToErase);
    }

    public void hideKeyboard() {
        this.delegate.hideKeyboard();
    }

    public boolean isAirplaneModeEnabled() {
        return this.delegate.isAirplaneModeEnabled();
    }

    public boolean isKeyboardVisible() {
        return this.delegate.isKeyboardVisible();
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isUnicodeInputSupported() {
        return this.delegate.isUnicodeInputSupported();
    }

    @NotNull
    public String name() {
        return this.delegate.name();
    }

    public void open() {
        this.delegate.open();
    }

    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.delegate.openLink(link, appId, autoVerify, browser);
    }

    public void pressKey(@NotNull KeyCode code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.delegate.pressKey(code);
    }

    public void resetProxy() {
        this.delegate.resetProxy();
    }

    public void scrollVertical() {
        this.delegate.scrollVertical();
    }

    public void setAirplaneMode(boolean enabled) {
        this.delegate.setAirplaneMode(enabled);
    }

    public void setAndroidChromeDevToolsEnabled(boolean enabled) {
        this.delegate.setAndroidChromeDevToolsEnabled(enabled);
    }

    public void setLocation(double latitude, double longitude) {
        this.delegate.setLocation(latitude, longitude);
    }

    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.delegate.setProxy(host, port);
    }

    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return this.delegate.startScreenRecording(out);
    }

    public void swipe(@NotNull Point start, @NotNull Point end, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.delegate.swipe(start, end, durationMs);
    }

    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.delegate.takeScreenshot(out, compressed);
    }

    @Nullable
    public TreeNode waitForAppToSettle-5RpGHs4(@Nullable TreeNode initialHierarchy, @Nullable String appId, @Nullable Integer timeoutMs) {
        return this.delegate.waitForAppToSettle-5RpGHs4(initialHierarchy, appId, timeoutMs);
    }

    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        return this.delegate.waitUntilScreenIsStatic(timeoutMs);
    }

    private static final Unit logActionWithScreenshot$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit logActionWithoutScreenshot$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit addMedia$lambda$6(LoggingDriver this$0, List $mediaFiles) {
        this$0.delegate.addMedia($mediaFiles);
        return Unit.INSTANCE;
    }

    private static final Unit backPress$lambda$7(LoggingDriver this$0) {
        this$0.delegate.backPress();
        return Unit.INSTANCE;
    }

    private static final Unit clearAppState$lambda$8(LoggingDriver this$0, String $appId) {
        this$0.delegate.clearAppState($appId);
        return Unit.INSTANCE;
    }

    private static final Unit inputText$lambda$9(LoggingDriver this$0, String $text) {
        this$0.delegate.inputText($text);
        return Unit.INSTANCE;
    }

    private static final Unit killApp$lambda$10(LoggingDriver this$0, String $appId) {
        this$0.delegate.killApp($appId);
        return Unit.INSTANCE;
    }

    private static final Unit launchApp$lambda$11(LoggingDriver this$0, String $appId, Map $launchArguments, UUID $sessionId) {
        this$0.delegate.launchApp($appId, $launchArguments, $sessionId);
        return Unit.INSTANCE;
    }

    private static final Unit setPermissions$lambda$13(LoggingDriver this$0, String $appId, Map $permissions) {
        this$0.delegate.setPermissions($appId, $permissions);
        return Unit.INSTANCE;
    }

    private static final Unit stopApp$lambda$14(LoggingDriver this$0, String $appId) {
        this$0.delegate.stopApp($appId);
        return Unit.INSTANCE;
    }

    private static final Unit swipe$lambda$15(LoggingDriver this$0, Point $elementPoint, SwipeDirection $direction, long $durationMs) {
        this$0.delegate.swipe($elementPoint, $direction, $durationMs);
        return Unit.INSTANCE;
    }

    private static final Unit swipe$lambda$16(LoggingDriver this$0, SwipeDirection $swipeDirection, long $durationMs) {
        this$0.delegate.swipe($swipeDirection, $durationMs);
        return Unit.INSTANCE;
    }

    private static final Unit tap$lambda$17(LoggingDriver this$0, Point $point) {
        this$0.delegate.tap($point);
        return Unit.INSTANCE;
    }

    private static final Unit longPress$lambda$18(LoggingDriver this$0, Point $point) {
        this$0.delegate.tap($point);
        return Unit.INSTANCE;
    }
}

