/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.llm;

import ai.koog.prompt.message.Message;
import ai.koog.prompt.message.ResponseMetaInfo;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.llm.LlmModel;
import xyz.block.trailblaze.llm.LlmRequestUsageAndCost$;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 02\u00020\u0001:\u000201B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fBM\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0006\u0010\u001b\u001a\u00020\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003JE\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u000eH\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J%\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0001\u00a2\u0006\u0002\b/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u00062"}, d2={"Lxyz/block/trailblaze/llm/LlmRequestUsageAndCost;", "", "modelName", "", "inputTokens", "", "outputTokens", "promptCost", "", "completionCost", "totalCost", "<init>", "(Ljava/lang/String;JJDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JJDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getModelName", "()Ljava/lang/String;", "getInputTokens", "()J", "getOutputTokens", "getPromptCost", "()D", "getCompletionCost", "getTotalCost", "debugString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "Companion", "$serializer", "trailblaze-common"})
public final class LlmRequestUsageAndCost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String modelName;
    private final long inputTokens;
    private final long outputTokens;
    private final double promptCost;
    private final double completionCost;
    private final double totalCost;

    public LlmRequestUsageAndCost(@NotNull String modelName, long inputTokens, long outputTokens, double promptCost, double completionCost, double totalCost) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        this.modelName = modelName;
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.promptCost = promptCost;
        this.completionCost = completionCost;
        this.totalCost = totalCost;
    }

    public /* synthetic */ LlmRequestUsageAndCost(String string, long l, long l2, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d3 = d + d2;
        }
        this(string, l, l2, d, d2, d3);
    }

    @NotNull
    public final String getModelName() {
        return this.modelName;
    }

    public final long getInputTokens() {
        return this.inputTokens;
    }

    public final long getOutputTokens() {
        return this.outputTokens;
    }

    public final double getPromptCost() {
        return this.promptCost;
    }

    public final double getCompletionCost() {
        return this.completionCost;
    }

    public final double getTotalCost() {
        return this.totalCost;
    }

    @NotNull
    public final String debugString() {
        StringBuilder stringBuilder;
        StringBuilder $this$debugString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$debugString_u24lambda_u240.append("Model: " + this.modelName).append('\n');
        if (this.inputTokens == 0L && this.outputTokens == 0L) {
            v0 = $this$debugString_u24lambda_u240.append("Usage not available.").append('\n');
        } else {
            $this$debugString_u24lambda_u240.append("Prompt Tokens: " + this.inputTokens).append('\n');
            $this$debugString_u24lambda_u240.append("Completion Tokens: " + this.outputTokens).append('\n');
            StringBuilder stringBuilder2 = $this$debugString_u24lambda_u240;
            Object object = "%.6f";
            Object[] objectArray = new Object[]{this.promptCost};
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            object = "Prompt Cost: $" + string;
            stringBuilder2.append((String)object).append('\n');
            stringBuilder2 = $this$debugString_u24lambda_u240;
            object = "%.6f";
            objectArray = new Object[]{this.completionCost};
            String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            object = "Completion Cost: $" + string2;
            stringBuilder2.append((String)object).append('\n');
            stringBuilder2 = $this$debugString_u24lambda_u240;
            object = "%.6f";
            objectArray = new Object[]{this.totalCost};
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            object = "Total Cost: $" + string3;
            v0 = stringBuilder2.append((String)object).append('\n');
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String component1() {
        return this.modelName;
    }

    public final long component2() {
        return this.inputTokens;
    }

    public final long component3() {
        return this.outputTokens;
    }

    public final double component4() {
        return this.promptCost;
    }

    public final double component5() {
        return this.completionCost;
    }

    public final double component6() {
        return this.totalCost;
    }

    @NotNull
    public final LlmRequestUsageAndCost copy(@NotNull String modelName, long inputTokens, long outputTokens, double promptCost, double completionCost, double totalCost) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return new LlmRequestUsageAndCost(modelName, inputTokens, outputTokens, promptCost, completionCost, totalCost);
    }

    public static /* synthetic */ LlmRequestUsageAndCost copy$default(LlmRequestUsageAndCost llmRequestUsageAndCost, String string, long l, long l2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            string = llmRequestUsageAndCost.modelName;
        }
        if ((n & 2) != 0) {
            l = llmRequestUsageAndCost.inputTokens;
        }
        if ((n & 4) != 0) {
            l2 = llmRequestUsageAndCost.outputTokens;
        }
        if ((n & 8) != 0) {
            d = llmRequestUsageAndCost.promptCost;
        }
        if ((n & 0x10) != 0) {
            d2 = llmRequestUsageAndCost.completionCost;
        }
        if ((n & 0x20) != 0) {
            d3 = llmRequestUsageAndCost.totalCost;
        }
        return llmRequestUsageAndCost.copy(string, l, l2, d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "LlmRequestUsageAndCost(modelName=" + this.modelName + ", inputTokens=" + this.inputTokens + ", outputTokens=" + this.outputTokens + ", promptCost=" + this.promptCost + ", completionCost=" + this.completionCost + ", totalCost=" + this.totalCost + ")";
    }

    public int hashCode() {
        int result = this.modelName.hashCode();
        result = result * 31 + Long.hashCode(this.inputTokens);
        result = result * 31 + Long.hashCode(this.outputTokens);
        result = result * 31 + Double.hashCode(this.promptCost);
        result = result * 31 + Double.hashCode(this.completionCost);
        result = result * 31 + Double.hashCode(this.totalCost);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LlmRequestUsageAndCost)) {
            return false;
        }
        LlmRequestUsageAndCost llmRequestUsageAndCost = (LlmRequestUsageAndCost)other;
        if (!Intrinsics.areEqual((Object)this.modelName, (Object)llmRequestUsageAndCost.modelName)) {
            return false;
        }
        if (this.inputTokens != llmRequestUsageAndCost.inputTokens) {
            return false;
        }
        if (this.outputTokens != llmRequestUsageAndCost.outputTokens) {
            return false;
        }
        if (Double.compare(this.promptCost, llmRequestUsageAndCost.promptCost) != 0) {
            return false;
        }
        if (Double.compare(this.completionCost, llmRequestUsageAndCost.completionCost) != 0) {
            return false;
        }
        return Double.compare(this.totalCost, llmRequestUsageAndCost.totalCost) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(LlmRequestUsageAndCost self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.modelName);
        output.encodeLongElement(serialDesc, 1, self.inputTokens);
        output.encodeLongElement(serialDesc, 2, self.outputTokens);
        output.encodeDoubleElement(serialDesc, 3, self.promptCost);
        output.encodeDoubleElement(serialDesc, 4, self.completionCost);
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : Double.compare(self.totalCost, self.promptCost + self.completionCost) != 0) {
            output.encodeDoubleElement(serialDesc, 5, self.totalCost);
        }
    }

    public /* synthetic */ LlmRequestUsageAndCost(int seen0, String modelName, long inputTokens, long outputTokens, double promptCost, double completionCost, double totalCost, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.modelName = modelName;
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.promptCost = promptCost;
        this.completionCost = completionCost;
        this.totalCost = (seen0 & 0x20) == 0 ? this.promptCost + this.completionCost : totalCost;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a8\u0006\f"}, d2={"Lxyz/block/trailblaze/llm/LlmRequestUsageAndCost$Companion;", "", "<init>", "()V", "calculateCost", "Lxyz/block/trailblaze/llm/LlmRequestUsageAndCost;", "", "Lai/koog/prompt/message/Message$Response;", "llmModelId", "", "serializer", "Lkotlinx/serialization/KSerializer;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LlmRequestUsageAndCost calculateCost(@NotNull List<? extends Message.Response> $this$calculateCost, @NotNull String llmModelId) {
            Intrinsics.checkNotNullParameter($this$calculateCost, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)llmModelId, (String)"llmModelId");
            ResponseMetaInfo usage = ((Message.Response)CollectionsKt.last($this$calculateCost)).getMetaInfo();
            String modelName = llmModelId;
            LlmModel llmModel = LlmModel.Companion.getModelByName(modelName);
            if (llmModel == null) {
                llmModel = LlmModel.GPT_4_1;
            }
            LlmModel pricing = llmModel;
            Integer n = usage.getInputTokensCount();
            long promptTokens = n != null ? (long)n.intValue() : 0L;
            Integer n2 = usage.getOutputTokensCount();
            long completionTokens = n2 != null ? (long)n2.intValue() : 0L;
            double promptCost = (double)promptTokens * pricing.getInputCostPerOneMillionTokens() / 1000000.0;
            double completionCost = (double)completionTokens * pricing.getOutputCostPerOneMillionTokens() / 1000000.0;
            return new LlmRequestUsageAndCost(llmModelId, promptTokens, completionTokens, promptCost, completionCost, 0.0, 32, null);
        }

        @NotNull
        public final KSerializer<LlmRequestUsageAndCost> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

