/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.recording;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import xyz.block.trailblaze.util.TemplatingUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u0002J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u000e\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/block/trailblaze/recording/TrailblazeResourceCacheUtil;", "", "<init>", "()V", "hashString", "", "input", "algorithm", "getFilenameWithExtensionForCache", "testDescription", "Lorg/junit/runner/Description;", "prompt", "key", "cleanKey", "getKeyOrHash", "getFilenameWithoutExtensionForCache", "readCacheForTest", "filenameWithoutExtensionForCache", "TRAILBLAZE_RECORDINGS_DIR_NAME", "trailblaze-common"})
public final class TrailblazeResourceCacheUtil {
    @NotNull
    public static final TrailblazeResourceCacheUtil INSTANCE = new TrailblazeResourceCacheUtil();
    @NotNull
    public static final String TRAILBLAZE_RECORDINGS_DIR_NAME = "trailblaze_recordings";

    private TrailblazeResourceCacheUtil() {
    }

    private final String hashString(String input, String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = messageDigest.digest(byArray);
        Intrinsics.checkNotNull((Object)bytes);
        String hash = ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, TrailblazeResourceCacheUtil::hashString$lambda$0, (int)30, null);
        String string2 = hash.substring(0, 7);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    static /* synthetic */ String hashString$default(TrailblazeResourceCacheUtil trailblazeResourceCacheUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "SHA-256";
        }
        return trailblazeResourceCacheUtil.hashString(string, string2);
    }

    @NotNull
    public final String getFilenameWithExtensionForCache(@NotNull Description testDescription, @NotNull String prompt, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)testDescription, (String)"testDescription");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getFilenameWithoutExtensionForCache(testDescription, prompt, key) + ".yaml";
    }

    public static /* synthetic */ String getFilenameWithExtensionForCache$default(TrailblazeResourceCacheUtil trailblazeResourceCacheUtil, Description description, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return trailblazeResourceCacheUtil.getFilenameWithExtensionForCache(description, string, string2);
    }

    @Nullable
    public final String cleanKey(@Nullable String key) {
        String string;
        String string2;
        CharSequence charSequence;
        Regex regex;
        String string3 = key;
        if (string3 != null && (string3 = (regex = new Regex("[^a-zA-Z0-9]")).replace(charSequence = (CharSequence)string3, string2 = "_")) != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String getKeyOrHash(@Nullable String key, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String string = this.cleanKey(key);
        if (string == null) {
            string = TrailblazeResourceCacheUtil.hashString$default(this, prompt, null, 2, null);
        }
        return string;
    }

    @NotNull
    public final String getFilenameWithoutExtensionForCache(@NotNull Description testDescription, @NotNull String prompt, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)testDescription, (String)"testDescription");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String computedKey = this.getKeyOrHash(key, prompt);
        return testDescription.getClassName() + "_" + testDescription.getMethodName() + "-" + computedKey;
    }

    public static /* synthetic */ String getFilenameWithoutExtensionForCache$default(TrailblazeResourceCacheUtil trailblazeResourceCacheUtil, Description description, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return trailblazeResourceCacheUtil.getFilenameWithoutExtensionForCache(description, string, string2);
    }

    @Nullable
    public final String readCacheForTest(@NotNull String filenameWithoutExtensionForCache) {
        Intrinsics.checkNotNullParameter((Object)filenameWithoutExtensionForCache, (String)"filenameWithoutExtensionForCache");
        String resourceFileName = "trailblaze_recordings/" + filenameWithoutExtensionForCache + ".yaml";
        String yaml = TemplatingUtil.INSTANCE.getResourceAsText(resourceFileName);
        return yaml;
    }

    private static final CharSequence hashString$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

