/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.toolcalls.commands;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.DelegatingTrailblazeTool;
import xyz.block.trailblaze.toolcalls.ExecutableTrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeToolClass;
import xyz.block.trailblaze.toolcalls.TrailblazeToolExecutionContext;
import xyz.block.trailblaze.toolcalls.commands.TapOnElementByNodeIdTrailblazeTool$;
import xyz.block.trailblaze.toolcalls.commands.TapSelectorKt;

@Serializable
@TrailblazeToolClass(name="tapOnElementByNodeId")
@LLMDescription(description="\nProvide the nodeId of the element you want to tap on in the nodeId parameter.\n")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 02\u00020\u0001:\u0002/0B%\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB5\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0003H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u000bH\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J%\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0001\u00a2\u0006\u0002\b.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/TapOnElementByNodeIdTrailblazeTool;", "Lxyz/block/trailblaze/toolcalls/DelegatingTrailblazeTool;", "reason", "", "nodeId", "", "longPress", "", "<init>", "(Ljava/lang/String;JZ)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getReason", "()Ljava/lang/String;", "getNodeId", "()J", "getLongPress", "()Z", "prettyPrintViewHierarchy", "node", "Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "indent", "toExecutableTrailblazeTools", "", "Lxyz/block/trailblaze/toolcalls/ExecutableTrailblazeTool;", "executionContext", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolExecutionContext;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "$serializer", "Companion", "trailblaze-common"})
@SourceDebugExtension(value={"SMAP\nTapOnElementByNodeIdTrailblazeTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TapOnElementByNodeIdTrailblazeTool.kt\nxyz/block/trailblaze/toolcalls/commands/TapOnElementByNodeIdTrailblazeTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 TapOnElementByNodeIdTrailblazeTool.kt\nxyz/block/trailblaze/toolcalls/commands/TapOnElementByNodeIdTrailblazeTool\n*L\n36#1:76,2\n*E\n"})
public final class TapOnElementByNodeIdTrailblazeTool
implements DelegatingTrailblazeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String reason;
    private final long nodeId;
    private final boolean longPress;

    public TapOnElementByNodeIdTrailblazeTool(@LLMDescription(description="Reasoning on why this element was chosen. Do NOT restate the nodeId.") @NotNull String reason, @LLMDescription(description="The nodeId of the element in the view hierarchy that will be tapped on. Do NOT use the nodeId 0.") long nodeId, @LLMDescription(description="A standard tap is default, but return 'true' to perform a long press instead.") boolean longPress) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        this.nodeId = nodeId;
        this.longPress = longPress;
    }

    public /* synthetic */ TapOnElementByNodeIdTrailblazeTool(String string, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, l, bl);
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    public final boolean getLongPress() {
        return this.longPress;
    }

    private final String prettyPrintViewHierarchy(ViewHierarchyTreeNode node, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent + "- nodeId=" + node.getNodeId() + ", text='" + node.getText() + "', accessibilityText='" + node.getAccessibilityText() + "', bounds=" + node.getBounds() + "\n");
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewHierarchyTreeNode child = (ViewHierarchyTreeNode)element$iv;
            boolean bl = false;
            builder.append(this.prettyPrintViewHierarchy(child, indent + "  "));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String prettyPrintViewHierarchy$default(TapOnElementByNodeIdTrailblazeTool tapOnElementByNodeIdTrailblazeTool, ViewHierarchyTreeNode viewHierarchyTreeNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return tapOnElementByNodeIdTrailblazeTool.prettyPrintViewHierarchy(viewHierarchyTreeNode, string);
    }

    @Override
    @NotNull
    public List<ExecutableTrailblazeTool> toExecutableTrailblazeTools(@NotNull TrailblazeToolExecutionContext executionContext) {
        ScreenState screenState;
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        TapOnElementByNodeIdTrailblazeTool trailblazeTool = this;
        ScreenState screenState2 = screenState = executionContext.getScreenState();
        if ((screenState2 != null ? screenState2.getViewHierarchy() : null) == null) {
            throw new TrailblazeException("No View Hierarchy available when processing " + trailblazeTool);
        }
        ViewHierarchyTreeNode matchingNode = ViewHierarchyTreeNode.Companion.dfs(screenState.getViewHierarchy(), arg_0 -> TapOnElementByNodeIdTrailblazeTool.toExecutableTrailblazeTools$lambda$1(trailblazeTool, arg_0));
        if (matchingNode == null) {
            throw new TrailblazeException("TapOnElementByNodeId: No node found with nodeId=" + trailblazeTool.nodeId + ".  " + trailblazeTool);
        }
        System.out.println((Object)("Full View Hierarchy:\n" + TapOnElementByNodeIdTrailblazeTool.prettyPrintViewHierarchy$default(this, screenState.getViewHierarchy(), null, 2, null)));
        System.out.println((Object)("TapOnElementByNodeId: Looking for nodeId=" + trailblazeTool.nodeId));
        System.out.println((Object)("TapOnElementByNodeId: Found node: text='" + matchingNode.getText() + "', accessibilityText='" + matchingNode.getAccessibilityText() + "', bounds=" + matchingNode.getBounds()));
        ExecutableTrailblazeTool bestTapTrailblazeToolForNode = TapSelectorKt.findBestTapTrailblazeToolForNode(screenState.getViewHierarchyOriginal(), matchingNode, trailblazeTool.longPress);
        System.out.println((Object)("Selected TrailblazeTool: " + bestTapTrailblazeToolForNode));
        return CollectionsKt.listOf((Object)bestTapTrailblazeToolForNode);
    }

    @NotNull
    public final String component1() {
        return this.reason;
    }

    public final long component2() {
        return this.nodeId;
    }

    public final boolean component3() {
        return this.longPress;
    }

    @NotNull
    public final TapOnElementByNodeIdTrailblazeTool copy(@LLMDescription(description="Reasoning on why this element was chosen. Do NOT restate the nodeId.") @NotNull String reason, @LLMDescription(description="The nodeId of the element in the view hierarchy that will be tapped on. Do NOT use the nodeId 0.") long nodeId, @LLMDescription(description="A standard tap is default, but return 'true' to perform a long press instead.") boolean longPress) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new TapOnElementByNodeIdTrailblazeTool(reason, nodeId, longPress);
    }

    public static /* synthetic */ TapOnElementByNodeIdTrailblazeTool copy$default(TapOnElementByNodeIdTrailblazeTool tapOnElementByNodeIdTrailblazeTool, String string, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = tapOnElementByNodeIdTrailblazeTool.reason;
        }
        if ((n & 2) != 0) {
            l = tapOnElementByNodeIdTrailblazeTool.nodeId;
        }
        if ((n & 4) != 0) {
            bl = tapOnElementByNodeIdTrailblazeTool.longPress;
        }
        return tapOnElementByNodeIdTrailblazeTool.copy(string, l, bl);
    }

    @NotNull
    public String toString() {
        return "TapOnElementByNodeIdTrailblazeTool(reason=" + this.reason + ", nodeId=" + this.nodeId + ", longPress=" + this.longPress + ")";
    }

    public int hashCode() {
        int result = this.reason.hashCode();
        result = result * 31 + Long.hashCode(this.nodeId);
        result = result * 31 + Boolean.hashCode(this.longPress);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TapOnElementByNodeIdTrailblazeTool)) {
            return false;
        }
        TapOnElementByNodeIdTrailblazeTool tapOnElementByNodeIdTrailblazeTool = (TapOnElementByNodeIdTrailblazeTool)other;
        if (!Intrinsics.areEqual((Object)this.reason, (Object)tapOnElementByNodeIdTrailblazeTool.reason)) {
            return false;
        }
        if (this.nodeId != tapOnElementByNodeIdTrailblazeTool.nodeId) {
            return false;
        }
        return this.longPress == tapOnElementByNodeIdTrailblazeTool.longPress;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(TapOnElementByNodeIdTrailblazeTool self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.reason, (Object)"")) {
            output.encodeStringElement(serialDesc, 0, self.reason);
        }
        output.encodeLongElement(serialDesc, 1, self.nodeId);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.longPress) {
            output.encodeBooleanElement(serialDesc, 2, self.longPress);
        }
    }

    public /* synthetic */ TapOnElementByNodeIdTrailblazeTool(int seen0, String reason, long nodeId, boolean longPress, SerializationConstructorMarker serializationConstructorMarker) {
        if (2 != (2 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)2, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.reason = (seen0 & 1) == 0 ? "" : reason;
        this.nodeId = nodeId;
        this.longPress = (seen0 & 4) == 0 ? false : longPress;
    }

    private static final boolean toExecutableTrailblazeTools$lambda$1(TapOnElementByNodeIdTrailblazeTool $trailblazeTool, ViewHierarchyTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNodeId() == $trailblazeTool.nodeId;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/TapOnElementByNodeIdTrailblazeTool$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/block/trailblaze/toolcalls/commands/TapOnElementByNodeIdTrailblazeTool;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<TapOnElementByNodeIdTrailblazeTool> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

