/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.toolcalls.commands.memory;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.AgentMemory;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.TrailblazeToolClass;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;
import xyz.block.trailblaze.toolcalls.commands.memory.AssertMathTrailblazeTool$;
import xyz.block.trailblaze.toolcalls.commands.memory.MemoryTrailblazeTool;
import xyz.block.trailblaze.utils.ElementComparator;

@Serializable
@TrailblazeToolClass(name="assertMath")
@LLMDescription(description="\nThis will calculate the result of an expression and compare it to the expected output value.\n      ")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006)"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/AssertMathTrailblazeTool;", "Lxyz/block/trailblaze/toolcalls/commands/memory/MemoryTrailblazeTool;", "expression", "", "expected", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getExpression", "()Ljava/lang/String;", "getExpected", "execute", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "memory", "Lxyz/block/trailblaze/AgentMemory;", "elementComparator", "Lxyz/block/trailblaze/utils/ElementComparator;", "processDynamicExtractions", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "$serializer", "Companion", "trailblaze-common"})
public final class AssertMathTrailblazeTool
implements MemoryTrailblazeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    @NotNull
    private final String expected;

    public AssertMathTrailblazeTool(@NotNull String expression, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.expression = expression;
        this.expected = expected;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final String getExpected() {
        return this.expected;
    }

    @Override
    @NotNull
    public TrailblazeToolResult execute(@NotNull AgentMemory memory, @NotNull ElementComparator elementComparator) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        Intrinsics.checkNotNullParameter((Object)elementComparator, (String)"elementComparator");
        String interpolatedExpression = this.processDynamicExtractions(this.expression, memory, elementComparator);
        try {
            double result = new ExpressionBuilder(interpolatedExpression).build().evaluate();
            double expectedValue = Double.parseDouble(this.expected);
            if (Math.abs(result - expectedValue) > 1.0E-4) {
                throw new TrailblazeException("Math assertion failed: Expression '" + interpolatedExpression + "' evaluated to " + result + ", expected " + expectedValue);
            }
        }
        catch (Exception e) {
            if (e instanceof TrailblazeException) {
                throw e;
            }
            throw new TrailblazeException("Math assertion failed: Error evaluating expression - " + e.getMessage());
        }
        return (TrailblazeToolResult)TrailblazeToolResult.Success.INSTANCE;
    }

    private final String processDynamicExtractions(String expression, AgentMemory memory, ElementComparator elementComparator) {
        System.out.println((Object)("Processing dynamic extractions in: " + expression));
        String interpolatedExpression = expression;
        Regex dynamicExtractPattern = new Regex("\\[\\[([^\\]]+)\\]\\]");
        Sequence matches = Regex.findAll$default((Regex)dynamicExtractPattern, (CharSequence)interpolatedExpression, (int)0, (int)2, null);
        for (MatchResult match : matches) {
            String fullMatch = match.getValue();
            String prompt = (String)match.getGroupValues().get(1);
            System.out.println((Object)("Found dynamic extraction pattern: " + fullMatch + " with prompt: " + prompt));
            String extractedValue = elementComparator.getElementValue(prompt);
            if (extractedValue != null) {
                Double numberValue = elementComparator.extractNumberFromString(extractedValue);
                if (numberValue != null) {
                    System.out.println((Object)("Extracted value " + numberValue + " for prompt '" + prompt + "'"));
                    interpolatedExpression = StringsKt.replace$default((String)interpolatedExpression, (String)fullMatch, (String)numberValue.toString(), (boolean)false, (int)4, null);
                    continue;
                }
                System.out.println((Object)("Could not extract a number from: " + extractedValue + " for prompt: " + prompt));
                throw new TrailblazeException("Could not extract a numeric value for prompt: " + prompt);
            }
            System.out.println((Object)("Failed to find element for prompt: " + prompt));
            throw new TrailblazeException("Failed to find element for prompt: " + prompt);
        }
        String finalExpression = memory.interpolateVariables(interpolatedExpression);
        System.out.println((Object)("Final interpolated expression: " + finalExpression));
        return finalExpression;
    }

    @NotNull
    public final String component1() {
        return this.expression;
    }

    @NotNull
    public final String component2() {
        return this.expected;
    }

    @NotNull
    public final AssertMathTrailblazeTool copy(@NotNull String expression, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new AssertMathTrailblazeTool(expression, expected);
    }

    public static /* synthetic */ AssertMathTrailblazeTool copy$default(AssertMathTrailblazeTool assertMathTrailblazeTool, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = assertMathTrailblazeTool.expression;
        }
        if ((n & 2) != 0) {
            string2 = assertMathTrailblazeTool.expected;
        }
        return assertMathTrailblazeTool.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "AssertMathTrailblazeTool(expression=" + this.expression + ", expected=" + this.expected + ")";
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = result * 31 + this.expected.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AssertMathTrailblazeTool)) {
            return false;
        }
        AssertMathTrailblazeTool assertMathTrailblazeTool = (AssertMathTrailblazeTool)other;
        if (!Intrinsics.areEqual((Object)this.expression, (Object)assertMathTrailblazeTool.expression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expected, (Object)assertMathTrailblazeTool.expected);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(AssertMathTrailblazeTool self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.expression);
        output.encodeStringElement(serialDesc, 1, self.expected);
    }

    public /* synthetic */ AssertMathTrailblazeTool(int seen0, String expression, String expected, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.expression = expression;
        this.expected = expected;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/AssertMathTrailblazeTool$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/block/trailblaze/toolcalls/commands/memory/AssertMathTrailblazeTool;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AssertMathTrailblazeTool> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

