/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.toolcalls.commands.memory;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.AgentMemory;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.TrailblazeToolClass;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;
import xyz.block.trailblaze.toolcalls.commands.BooleanAssertionTrailblazeTool;
import xyz.block.trailblaze.toolcalls.commands.memory.AssertWithAiTrailblazeTool$;
import xyz.block.trailblaze.toolcalls.commands.memory.MemoryTrailblazeTool;
import xyz.block.trailblaze.utils.ElementComparator;

@Serializable
@TrailblazeToolClass(name="assertWithAi")
@LLMDescription(description="\nThis tool will interpolate the natural language prompt with any included variables, then use that\ninterpolated prompt to verify the current state of the screen using AI.\n      ")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/AssertWithAiTrailblazeTool;", "Lxyz/block/trailblaze/toolcalls/commands/memory/MemoryTrailblazeTool;", "prompt", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPrompt", "()Ljava/lang/String;", "execute", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "memory", "Lxyz/block/trailblaze/AgentMemory;", "elementComparator", "Lxyz/block/trailblaze/utils/ElementComparator;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "$serializer", "Companion", "trailblaze-common"})
public final class AssertWithAiTrailblazeTool
implements MemoryTrailblazeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prompt;

    public AssertWithAiTrailblazeTool(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        this.prompt = prompt;
    }

    @NotNull
    public final String getPrompt() {
        return this.prompt;
    }

    @Override
    @NotNull
    public TrailblazeToolResult execute(@NotNull AgentMemory memory, @NotNull ElementComparator elementComparator) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        Intrinsics.checkNotNullParameter((Object)elementComparator, (String)"elementComparator");
        String interpolatedPrompt = memory.interpolateVariables(this.prompt);
        BooleanAssertionTrailblazeTool evaluation = elementComparator.evaluateBoolean(this.prompt);
        System.out.println((Object)("UI Assertion result: " + evaluation.getResult() + ", reason: " + evaluation.getReason()));
        if (!evaluation.getResult()) {
            throw new TrailblazeException("AI assertion failed: " + interpolatedPrompt);
        }
        return (TrailblazeToolResult)TrailblazeToolResult.Success.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.prompt;
    }

    @NotNull
    public final AssertWithAiTrailblazeTool copy(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return new AssertWithAiTrailblazeTool(prompt);
    }

    public static /* synthetic */ AssertWithAiTrailblazeTool copy$default(AssertWithAiTrailblazeTool assertWithAiTrailblazeTool, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = assertWithAiTrailblazeTool.prompt;
        }
        return assertWithAiTrailblazeTool.copy(string);
    }

    @NotNull
    public String toString() {
        return "AssertWithAiTrailblazeTool(prompt=" + this.prompt + ")";
    }

    public int hashCode() {
        return this.prompt.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AssertWithAiTrailblazeTool)) {
            return false;
        }
        AssertWithAiTrailblazeTool assertWithAiTrailblazeTool = (AssertWithAiTrailblazeTool)other;
        return Intrinsics.areEqual((Object)this.prompt, (Object)assertWithAiTrailblazeTool.prompt);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(AssertWithAiTrailblazeTool self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.prompt);
    }

    public /* synthetic */ AssertWithAiTrailblazeTool(int seen0, String prompt, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.prompt = prompt;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/AssertWithAiTrailblazeTool$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/block/trailblaze/toolcalls/commands/memory/AssertWithAiTrailblazeTool;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AssertWithAiTrailblazeTool> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

