/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.toolcalls.commands.memory;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.AgentMemory;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.TrailblazeToolClass;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;
import xyz.block.trailblaze.toolcalls.commands.memory.MemoryTrailblazeTool;
import xyz.block.trailblaze.toolcalls.commands.memory.RememberNumberTrailblazeTool$;
import xyz.block.trailblaze.utils.ElementComparator;
import xyz.block.trailblaze.utils.NumberUtilKt;

@Serializable
@TrailblazeToolClass(name="rememberNumber")
@LLMDescription(description="\nThis will find a number on the current screen using the natural language prompt parameter.\nOnce the number is found it will be saved for future test operations under the variable parameter.\n      ")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006("}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/RememberNumberTrailblazeTool;", "Lxyz/block/trailblaze/toolcalls/commands/memory/MemoryTrailblazeTool;", "prompt", "", "variable", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPrompt", "()Ljava/lang/String;", "getVariable", "execute", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "memory", "Lxyz/block/trailblaze/AgentMemory;", "elementComparator", "Lxyz/block/trailblaze/utils/ElementComparator;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "$serializer", "Companion", "trailblaze-common"})
public final class RememberNumberTrailblazeTool
implements MemoryTrailblazeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prompt;
    @NotNull
    private final String variable;

    public RememberNumberTrailblazeTool(@NotNull String prompt, @NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.prompt = prompt;
        this.variable = variable;
    }

    @NotNull
    public final String getPrompt() {
        return this.prompt;
    }

    @NotNull
    public final String getVariable() {
        return this.variable;
    }

    @Override
    @NotNull
    public TrailblazeToolResult execute(@NotNull AgentMemory memory, @NotNull ElementComparator elementComparator) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        Intrinsics.checkNotNullParameter((Object)elementComparator, (String)"elementComparator");
        String interpolatedPrompt = memory.interpolateVariables(this.prompt);
        String string = elementComparator.getElementValue(interpolatedPrompt);
        if (string == null) {
            throw new TrailblazeException("Failed to find element for prompt: " + this.prompt);
        }
        String extractedValue = string;
        String string2 = NumberUtilKt.parseNumberString(extractedValue);
        if (string2 == null) {
            throw new TrailblazeException("Failed to parse number for extracted value: " + extractedValue + " from prompt: " + this.prompt);
        }
        String numberOutput = string2;
        memory.remember(this.variable, numberOutput);
        return (TrailblazeToolResult)TrailblazeToolResult.Success.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.prompt;
    }

    @NotNull
    public final String component2() {
        return this.variable;
    }

    @NotNull
    public final RememberNumberTrailblazeTool copy(@NotNull String prompt, @NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return new RememberNumberTrailblazeTool(prompt, variable);
    }

    public static /* synthetic */ RememberNumberTrailblazeTool copy$default(RememberNumberTrailblazeTool rememberNumberTrailblazeTool, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = rememberNumberTrailblazeTool.prompt;
        }
        if ((n & 2) != 0) {
            string2 = rememberNumberTrailblazeTool.variable;
        }
        return rememberNumberTrailblazeTool.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "RememberNumberTrailblazeTool(prompt=" + this.prompt + ", variable=" + this.variable + ")";
    }

    public int hashCode() {
        int result = this.prompt.hashCode();
        result = result * 31 + this.variable.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RememberNumberTrailblazeTool)) {
            return false;
        }
        RememberNumberTrailblazeTool rememberNumberTrailblazeTool = (RememberNumberTrailblazeTool)other;
        if (!Intrinsics.areEqual((Object)this.prompt, (Object)rememberNumberTrailblazeTool.prompt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.variable, (Object)rememberNumberTrailblazeTool.variable);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(RememberNumberTrailblazeTool self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.prompt);
        output.encodeStringElement(serialDesc, 1, self.variable);
    }

    public /* synthetic */ RememberNumberTrailblazeTool(int seen0, String prompt, String variable, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.prompt = prompt;
        this.variable = variable;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/memory/RememberNumberTrailblazeTool$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/block/trailblaze/toolcalls/commands/memory/RememberNumberTrailblazeTool;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<RememberNumberTrailblazeTool> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

