/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import maestro.orchestra.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.AgentMemory;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.TrailblazeAgent;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.client.TrailblazeLogger;
import xyz.block.trailblaze.toolcalls.DelegatingTrailblazeTool;
import xyz.block.trailblaze.toolcalls.ExecutableTrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeToolExecutionContext;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;
import xyz.block.trailblaze.toolcalls.TrailblazeToolsKt;
import xyz.block.trailblaze.toolcalls.commands.memory.MemoryTrailblazeTool;
import xyz.block.trailblaze.utils.ElementComparator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH$J\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJD\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0007\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u001e\u0010\"\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007H\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lxyz/block/trailblaze/MaestroTrailblazeAgent;", "Lxyz/block/trailblaze/api/TrailblazeAgent;", "<init>", "()V", "executeMaestroCommands", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "commands", "", "Lmaestro/orchestra/Command;", "llmResponseId", "", "memory", "Lxyz/block/trailblaze/AgentMemory;", "getMemory", "()Lxyz/block/trailblaze/AgentMemory;", "clearMemory", "", "runMaestroCommands", "maestroCommands", "runTrailblazeTools", "Lkotlin/Pair;", "Lxyz/block/trailblaze/toolcalls/TrailblazeTool;", "tools", "screenState", "Lxyz/block/trailblaze/api/ScreenState;", "elementComparator", "Lxyz/block/trailblaze/utils/ElementComparator;", "handleExecutableTool", "trailblazeTool", "Lxyz/block/trailblaze/toolcalls/ExecutableTrailblazeTool;", "trailblazeExecutionContext", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolExecutionContext;", "logTrailblazeTool", "trailblazeToolResult", "logDelegatingTrailblazeTool", "Lxyz/block/trailblaze/toolcalls/DelegatingTrailblazeTool;", "executableTools", "trailblaze-common"})
@SourceDebugExtension(value={"SMAP\nMaestroTrailblazeAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaestroTrailblazeAgent.kt\nxyz/block/trailblaze/MaestroTrailblazeAgent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1869#2,2:156\n*S KotlinDebug\n*F\n+ 1 MaestroTrailblazeAgent.kt\nxyz/block/trailblaze/MaestroTrailblazeAgent\n*L\n43#1:156,2\n*E\n"})
public abstract class MaestroTrailblazeAgent
implements TrailblazeAgent {
    @NotNull
    private final AgentMemory memory = new AgentMemory();

    @NotNull
    protected abstract TrailblazeToolResult executeMaestroCommands(@NotNull List<? extends Command> var1, @Nullable String var2);

    @NotNull
    public final AgentMemory getMemory() {
        return this.memory;
    }

    public final void clearMemory() {
        this.memory.clear();
    }

    @NotNull
    public final TrailblazeToolResult runMaestroCommands(@NotNull List<? extends Command> maestroCommands, @Nullable String llmResponseId) {
        Intrinsics.checkNotNullParameter(maestroCommands, (String)"maestroCommands");
        Iterable $this$forEach$iv = maestroCommands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Command command = (Command)element$iv;
            boolean bl = false;
            TrailblazeToolResult result = this.executeMaestroCommands(CollectionsKt.listOf((Object)command), llmResponseId);
            if (Intrinsics.areEqual((Object)result, (Object)TrailblazeToolResult.Success.INSTANCE)) continue;
            return result;
        }
        return (TrailblazeToolResult)TrailblazeToolResult.Success.INSTANCE;
    }

    public static /* synthetic */ TrailblazeToolResult runMaestroCommands$default(MaestroTrailblazeAgent maestroTrailblazeAgent, List list, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runMaestroCommands");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return maestroTrailblazeAgent.runMaestroCommands(list, string);
    }

    @Override
    @NotNull
    public Pair<List<TrailblazeTool>, TrailblazeToolResult> runTrailblazeTools(@NotNull List<? extends TrailblazeTool> tools, @Nullable String llmResponseId, @Nullable ScreenState screenState, @NotNull ElementComparator elementComparator) {
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter((Object)elementComparator, (String)"elementComparator");
        TrailblazeToolExecutionContext trailblazeExecutionContext = new TrailblazeToolExecutionContext(screenState, llmResponseId, this);
        List toolsExecuted = new ArrayList();
        for (TrailblazeTool trailblazeTool : tools) {
            StringBuilder stringBuilder;
            TrailblazeTool trailblazeTool2 = trailblazeTool;
            if (trailblazeTool2 instanceof ExecutableTrailblazeTool) {
                toolsExecuted.add(trailblazeTool);
                TrailblazeToolResult result = this.handleExecutableTool((ExecutableTrailblazeTool)trailblazeTool, trailblazeExecutionContext);
                if (Intrinsics.areEqual((Object)result, (Object)TrailblazeToolResult.Success.INSTANCE)) continue;
                return TuplesKt.to((Object)toolsExecuted, (Object)result);
            }
            if (trailblazeTool2 instanceof DelegatingTrailblazeTool) {
                List<ExecutableTrailblazeTool> executableTools = ((DelegatingTrailblazeTool)trailblazeTool).toExecutableTrailblazeTools(trailblazeExecutionContext);
                this.logDelegatingTrailblazeTool((DelegatingTrailblazeTool)trailblazeTool, executableTools);
                for (ExecutableTrailblazeTool mappedTool : executableTools) {
                    toolsExecuted.add(mappedTool);
                    TrailblazeToolResult result = this.handleExecutableTool(mappedTool, trailblazeExecutionContext);
                    if (Intrinsics.areEqual((Object)result, (Object)TrailblazeToolResult.Success.INSTANCE)) continue;
                    return TuplesKt.to((Object)toolsExecuted, (Object)result);
                }
                continue;
            }
            if (trailblazeTool2 instanceof MemoryTrailblazeTool) {
                ((MemoryTrailblazeTool)trailblazeTool).execute(trailblazeExecutionContext.getTrailblazeAgent().memory, elementComparator);
                continue;
            }
            StringBuilder $this$runTrailblazeTools_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$runTrailblazeTools_u24lambda_u241.append("Unhandled Trailblaze tool " + trailblazeTool.getClass().getSimpleName() + ".").append('\n');
            $this$runTrailblazeTools_u24lambda_u241.append("Supported Trailblaze Tools must implement one of the following:").append('\n');
            $this$runTrailblazeTools_u24lambda_u241.append("- " + ExecutableTrailblazeTool.class.getSimpleName()).append('\n');
            $this$runTrailblazeTools_u24lambda_u241.append("- " + DelegatingTrailblazeTool.class.getSimpleName()).append('\n');
            String string = stringBuilder.toString();
            throw new TrailblazeException(string);
        }
        return TuplesKt.to((Object)toolsExecuted, (Object)TrailblazeToolResult.Success.INSTANCE);
    }

    private final TrailblazeToolResult handleExecutableTool(ExecutableTrailblazeTool trailblazeTool, TrailblazeToolExecutionContext trailblazeExecutionContext) {
        TrailblazeToolResult trailblazeToolResult = trailblazeTool.execute(trailblazeExecutionContext);
        this.logTrailblazeTool(trailblazeTool, trailblazeExecutionContext, trailblazeToolResult);
        return trailblazeToolResult;
    }

    private final void logTrailblazeTool(ExecutableTrailblazeTool trailblazeTool, TrailblazeToolExecutionContext trailblazeExecutionContext, TrailblazeToolResult trailblazeToolResult) {
        Instant timeBeforeToolExecution = Clock.System.INSTANCE.now();
        String string = TrailblazeToolsKt.getToolNameFromAnnotation(trailblazeTool);
        TrailblazeToolResult.Error error = trailblazeToolResult instanceof TrailblazeToolResult.Error ? (TrailblazeToolResult.Error)trailblazeToolResult : null;
        String string2 = error != null ? error.getErrorMessage() : null;
        boolean bl = Intrinsics.areEqual((Object)trailblazeToolResult, (Object)TrailblazeToolResult.Success.INSTANCE);
        long l = Clock.System.INSTANCE.now().toEpochMilliseconds() - timeBeforeToolExecution.toEpochMilliseconds();
        String string3 = trailblazeExecutionContext.getLlmResponseId();
        String string4 = TrailblazeLogger.INSTANCE.getCurrentSessionId();
        TrailblazeLogger.INSTANCE.log((TrailblazeLog)new TrailblazeLog.TrailblazeToolLog((TrailblazeTool)trailblazeTool, string, bl, string3, string2, l, string4, timeBeforeToolExecution));
    }

    private final void logDelegatingTrailblazeTool(DelegatingTrailblazeTool trailblazeTool, List<? extends ExecutableTrailblazeTool> executableTools) {
        String string = TrailblazeLogger.INSTANCE.getCurrentSessionId();
        Instant instant = Clock.System.INSTANCE.now();
        TrailblazeLogger.INSTANCE.log((TrailblazeLog)new TrailblazeLog.DelegatingTrailblazeToolLog((TrailblazeTool)trailblazeTool, string, instant, executableTools));
    }
}

