/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.agent.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import xyz.block.trailblaze.agent.model.StaticObjective;
import xyz.block.trailblaze.agent.model.TestCase;
import xyz.block.trailblaze.agent.model.TestObjective;
import xyz.block.trailblaze.agent.model.TrailblazePromptStep;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.JsonSerializationUtil;
import xyz.block.trailblaze.toolcalls.TrailblazeKoogTool;
import xyz.block.trailblaze.toolcalls.TrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeToolSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0001<B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010\u001b\u001a\u00020\u00192\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0014\u0010$\u001a\u00020\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0014\u0010%\u001a\u00020&2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0012\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\u0017H\u0002J\u001e\u0010)\u001a\u00020\u00032\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00072\b\b\u0002\u0010*\u001a\u00020\u0005H\u0002J\u0012\u0010+\u001a\u00020,2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010-\u001a\u00020.2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010/\u001a\u0002002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00101\u001a\u0002022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00103\u001a\u0002042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00105\u001a\u0002062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00107\u001a\u0002082\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006="}, d2={"Lxyz/block/trailblaze/agent/model/MixedModeTestCase;", "Lxyz/block/trailblaze/agent/model/TestCase;", "yamlContent", "", "executeRecordedSteps", "", "additionalTrailblazeTools", "", "Lkotlin/reflect/KClass;", "Lxyz/block/trailblaze/toolcalls/TrailblazeTool;", "<init>", "(Ljava/lang/String;ZLjava/util/List;)V", "allPossibleTools", "", "contextString", "getContextString", "()Ljava/lang/String;", "objectives", "Lxyz/block/trailblaze/agent/model/TestObjective;", "getObjectives", "()Ljava/util/List;", "parseObjectivesFromYaml", "yamlObj", "", "parseTrailblazePrompt", "Lxyz/block/trailblaze/agent/model/TestObjective$TrailblazeObjective;", "value", "parseTrailblazePromptSteps", "generatePromptStepsFromList", "Lxyz/block/trailblaze/agent/model/TrailblazePromptStep;", "steps", "fullPrompt", "generatePromptStepsFromString", "stepInstructions", "parseSinglePrompt", "instructions", "shouldParseCommands", "parseTrailblazeCommands", "Lxyz/block/trailblaze/agent/model/TestObjective$TrailblazeObjective$TrailblazeCommand;", "parseTrailblazeToolsForStep", "step", "parseFullPrompt", "useOnlyKeys", "parseRememberTextCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberTextCommand;", "parseRememberNumberCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberNumberCommand;", "parseRememberWithAiCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$RememberWithAiCommand;", "parseAssertEqualsCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertEqualsCommand;", "parseAssertNotEqualsCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertNotEqualsCommand;", "parseAssertWithAiCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertWithAiCommand;", "parseAssertMathCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$AssertMathCommand;", "parseMaestroCommand", "Lxyz/block/trailblaze/agent/model/TestObjective$MaestroCommand;", "key", "Companion", "trailblaze-common"})
@SourceDebugExtension(value={"SMAP\nMixedModeTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeTestCase.kt\nxyz/block/trailblaze/agent/model/MixedModeTestCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1563#2:396\n1634#2,3:397\n1740#2,3:400\n808#2,11:403\n1573#2:414\n1604#2,4:415\n1563#2:419\n1634#2,3:420\n774#2:423\n865#2,2:424\n1573#2:426\n1604#2,4:427\n1740#2,3:431\n1563#2:434\n1634#2,2:435\n1563#2:437\n1634#2,3:438\n1636#2:441\n295#2,2:442\n1617#2,9:449\n1869#2:458\n1870#2:460\n1626#2:461\n29#3,2:444\n31#3:448\n216#4,2:446\n1#5:459\n*S KotlinDebug\n*F\n+ 1 MixedModeTestCase.kt\nxyz/block/trailblaze/agent/model/MixedModeTestCase\n*L\n55#1:396\n55#1:397,3\n109#1:400,3\n111#1:403,11\n125#1:414\n125#1:415,4\n139#1:419\n139#1:420,3\n140#1:423\n140#1:424,2\n141#1:426\n141#1:427,4\n160#1:431,3\n163#1:434\n163#1:435,2\n173#1:437\n173#1:438,3\n163#1:441\n185#1:442,2\n207#1:449,9\n207#1:458\n207#1:460\n207#1:461\n188#1:444,2\n188#1:448\n189#1:446,2\n207#1:459\n*E\n"})
public final class MixedModeTestCase
extends TestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean executeRecordedSteps;
    @NotNull
    private final List<KClass<? extends TrailblazeTool>> additionalTrailblazeTools;
    @NotNull
    private final Set<KClass<? extends TrailblazeTool>> allPossibleTools;
    @Nullable
    private final String contextString;
    @NotNull
    private final List<TestObjective> objectives;
    @NotNull
    private static final Set<String> trailblazeCommands;
    @NotNull
    private static final Set<String> noParamMaestroCommands;
    @NotNull
    private static final Set<String> maestroCommands;

    public MixedModeTestCase(@NotNull String yamlContent, boolean executeRecordedSteps, @NotNull List<? extends KClass<? extends TrailblazeTool>> additionalTrailblazeTools) {
        Intrinsics.checkNotNullParameter((Object)yamlContent, (String)"yamlContent");
        Intrinsics.checkNotNullParameter(additionalTrailblazeTools, (String)"additionalTrailblazeTools");
        super(yamlContent);
        this.executeRecordedSteps = executeRecordedSteps;
        this.additionalTrailblazeTools = additionalTrailblazeTools;
        this.allPossibleTools = SetsKt.plus(TrailblazeToolSet.Companion.getAllBuiltInTrailblazeTools(), (Iterable)this.additionalTrailblazeTools);
        Yaml yaml = new Yaml();
        Object parsedYaml = yaml.load(this.getInstructions());
        if (!(parsedYaml instanceof List)) {
            throw new TrailblazeException("YAML must be a list");
        }
        Object list = parsedYaml;
        if (!((Collection)list).isEmpty() && ((List)list).get(0) instanceof Map) {
            Object e = ((List)list).get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map firstMap = (Map)e;
            if (firstMap.size() == 1 && firstMap.containsKey("context")) {
                Object v = firstMap.get("context");
                this.contextString = v != null ? v.toString() : null;
                this.objectives = this.parseObjectivesFromYaml(CollectionsKt.drop((Iterable)((Iterable)list), (int)1));
            } else {
                this.contextString = null;
                this.objectives = this.parseObjectivesFromYaml(list);
            }
        } else {
            this.contextString = null;
            this.objectives = this.parseObjectivesFromYaml(list);
        }
    }

    public /* synthetic */ MixedModeTestCase(String string, boolean bl, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, bl, list);
    }

    @Nullable
    public final String getContextString() {
        return this.contextString;
    }

    @NotNull
    public List<TestObjective> getObjectives() {
        return this.objectives;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestObjective> parseObjectivesFromYaml(Object yamlObj) {
        void $this$mapTo$iv$iv;
        if (!(yamlObj instanceof List)) {
            throw new TrailblazeException("Objectives must be a list");
        }
        Iterable $this$map$iv = (Iterable)yamlObj;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestObjective testObjective;
            void command;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            System.out.println((Object)("### Parsing command from yaml " + command));
            if (command instanceof Map) {
                Object object = CollectionsKt.firstOrNull((Iterable)((Map)command).keySet());
                String key = object != null ? object.toString() : null;
                Object value = CollectionsKt.firstOrNull((Iterable)((Map)command).values());
                String $this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240 = key;
                boolean bl2 = false;
                if (MixedModeTestCase.Companion.isTrailblazeCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseTrailblazePrompt(value);
                } else if (MixedModeTestCase.Companion.isRememberTextCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseRememberTextCommand(value);
                } else if (MixedModeTestCase.Companion.isRememberNumberCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseRememberNumberCommand(value);
                } else if (MixedModeTestCase.Companion.isRememberWithAiCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseRememberWithAiCommand(value);
                } else if (MixedModeTestCase.Companion.isAssertEqualsCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseAssertEqualsCommand(value);
                } else if (MixedModeTestCase.Companion.isAssertNotEqualsCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseAssertNotEqualsCommand(value);
                } else if (MixedModeTestCase.Companion.isAssertWithAiCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseAssertWithAiCommand(value);
                } else if (MixedModeTestCase.Companion.isAssertMathCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    testObjective = (TestObjective)this.parseAssertMathCommand(value);
                } else if (MixedModeTestCase.Companion.isMaestroCommand($this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240)) {
                    String string = $this$parseObjectivesFromYaml_u24lambda_u241_u24lambda_u240;
                    Intrinsics.checkNotNull((Object)string);
                    testObjective = (TestObjective)this.parseMaestroCommand(string, value);
                } else {
                    Object object2 = value;
                    if (object2 == null) {
                        object2 = "";
                    }
                    testObjective = (TestObjective)this.parseTrailblazePrompt(CollectionsKt.listOf((Object)(key + " " + object2)));
                }
            } else {
                String commandStr;
                String string = command;
                String string2 = string != null && (string = string.toString()) != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : (commandStr = null);
                if (MixedModeTestCase.Companion.isNoParamMaestroCommand(commandStr)) {
                    String string3 = commandStr;
                    Intrinsics.checkNotNull((Object)string3);
                    testObjective = (TestObjective)this.parseMaestroCommand(string3, null);
                } else {
                    testObjective = (TestObjective)this.parseTrailblazePrompt(CollectionsKt.listOf((Object)command));
                }
            }
            collection.add(testObjective);
        }
        return (List)destination$iv$iv;
    }

    private final TestObjective.TrailblazeObjective parseTrailblazePrompt(Object value) {
        TestObjective.TrailblazeObjective trailblazeObjective;
        Object object = value;
        if (object instanceof List) {
            trailblazeObjective = this.parseTrailblazePromptSteps((List)value);
        } else if (object instanceof String) {
            trailblazeObjective = this.parseSinglePrompt((String)value);
        } else {
            throw new TrailblazeException("No objectives found in Trailblaze objective: " + value);
        }
        return trailblazeObjective;
    }

    /*
     * WARNING - void declaration
     */
    private final TestObjective.TrailblazeObjective parseTrailblazePromptSteps(List<?> objectives) {
        TestObjective.TrailblazeObjective trailblazeObjective;
        if (this.shouldParseCommands(objectives)) {
            System.out.println((Object)"### parsing trailblaze commands");
            trailblazeObjective = (TestObjective.TrailblazeObjective)this.parseTrailblazeCommands(objectives);
        } else {
            TestObjective.TrailblazeObjective.TrailblazePrompt trailblazePrompt;
            boolean allStrings;
            Object element$iv;
            block8: {
                System.out.println((Object)"### parsing full prompt with prompt steps");
                Iterable $this$all$iv = objectives;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v1 = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        Object it = element$iv = iterator.next();
                        boolean bl = false;
                        if (it instanceof String) continue;
                        v1 = false;
                        break block8;
                    }
                    v1 = allStrings = true;
                }
            }
            if (allStrings) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = objectives;
                boolean $i$f$filterIsInstance = false;
                element$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof String)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List stringList = (List)destination$iv$iv;
                String fullInstructions = CollectionsKt.joinToString$default((Iterable)stringList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                List<TrailblazePromptStep> promptSteps = this.generatePromptStepsFromList(stringList, fullInstructions);
                trailblazePrompt = new TestObjective.TrailblazeObjective.TrailblazePrompt(fullInstructions, promptSteps);
            } else {
                String fullInstructions = this.parseFullPrompt(objectives, !this.executeRecordedSteps);
                List<TrailblazePromptStep> promptSteps = this.generatePromptStepsFromString(fullInstructions);
                trailblazePrompt = new TestObjective.TrailblazeObjective.TrailblazePrompt(fullInstructions, promptSteps);
            }
            trailblazeObjective = (TestObjective.TrailblazeObjective)trailblazePrompt;
        }
        return trailblazeObjective;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TrailblazePromptStep> generatePromptStepsFromList(List<String> steps, String fullPrompt) {
        void $this$mapIndexedTo$iv$iv;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        Iterable $this$mapIndexed$iv = steps;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void step;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TrailblazePromptStep((String)step, taskId, (int)index, fullPrompt, false, 16, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TrailblazePromptStep> generatePromptStepsFromString(String stepInstructions) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        Iterable $this$map$iv = StringsKt.lines((CharSequence)stepInstructions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$filterTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void line;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string3 = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TrailblazePromptStep((String)line, taskId, (int)index, stepInstructions, false, 16, null));
        }
        return (List)destination$iv$iv;
    }

    private final TestObjective.TrailblazeObjective parseSinglePrompt(String instructions) {
        return (TestObjective.TrailblazeObjective)new TestObjective.TrailblazeObjective.TrailblazePrompt(instructions, CollectionsKt.listOf((Object)new TrailblazePromptStep(instructions, null, 0, null, false, 30, null)));
    }

    private final boolean shouldParseCommands(List<?> objectives) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = objectives;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it instanceof Map) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl & this.executeRecordedSteps;
    }

    /*
     * WARNING - void declaration
     */
    private final TestObjective.TrailblazeObjective.TrailblazeCommand parseTrailblazeCommands(List<?> objectives) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = objectives;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            List steps;
            void obj;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = obj instanceof Map ? (Map)obj : null;
            if (map == null) {
                throw new TrailblazeException("Cannot parse objectives from invalid type " + obj);
            }
            Map objMap = map;
            Object objValue = CollectionsKt.firstOrNull((Iterable)objMap.values());
            if ((objValue instanceof List ? (List)objValue : null) == null) {
                throw new TrailblazeException("Cannot parse trailblaze commands from empty steps");
            }
            steps = steps;
            Object object = CollectionsKt.firstOrNull((Iterable)objMap.keySet());
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object desc = object;
            System.out.println((Object)("[MixedModeExecutor] Executing steps for objective: " + (String)desc));
            Iterable $this$map$iv2 = steps;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv2;
                Object t2 = item$iv$iv2 = iterator2.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(this.parseTrailblazeToolsForStep(it));
            }
            List tools = (List)destination$iv$iv2;
            collection.add(new StaticObjective(tools));
        }
        List staticObjectives = (List)destination$iv$iv;
        return new TestObjective.TrailblazeObjective.TrailblazeCommand(staticObjectives);
    }

    private final TrailblazeTool parseTrailblazeToolsForStep(Object step) {
        TrailblazeTool trailblazeTool;
        JsonObjectBuilder builder$iv;
        Object v3;
        Map params;
        Object toolName;
        block8: {
            Map map = step instanceof Map ? (Map)step : null;
            if (map == null) {
                throw new TrailblazeException("Cannot parse Trailblaze tools for invalid step type " + step);
            }
            Map stepMap = map;
            Object object = CollectionsKt.firstOrNull((Iterable)stepMap.keySet());
            if (object == null || (object = object.toString()) == null) {
                throw new TrailblazeException("Unknown tool name provided for " + step);
            }
            toolName = object;
            Object object2 = CollectionsKt.firstOrNull((Iterable)stepMap.values());
            Map map2 = object2 instanceof Map ? (Map)object2 : null;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            params = map2;
            Iterable $this$firstOrNull$iv = this.allPossibleTools;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KClass toolKClass = (KClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)TrailblazeKoogTool.Companion.toKoogToolDescriptor(toolKClass).getName(), (Object)toolName)) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        KClass kClass = v3;
        if (kClass == null) {
            throw new TrailblazeException("Could not find TrailblazeTool that matches tool name " + (String)toolName);
        }
        KClass toolClass = kClass;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$parseTrailblazeToolsForStep_u24lambda_u2412 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = v;
            JsonElement jsonElement = v2 instanceof Boolean ? $this$parseTrailblazeToolsForStep_u24lambda_u2412.put(String.valueOf(k), (JsonElement)JsonElementKt.JsonPrimitive((Boolean)((Boolean)v))) : (v2 instanceof Number ? $this$parseTrailblazeToolsForStep_u24lambda_u2412.put(String.valueOf(k), (JsonElement)JsonElementKt.JsonPrimitive((Number)((Number)v))) : (v2 instanceof String ? $this$parseTrailblazeToolsForStep_u24lambda_u2412.put(String.valueOf(k), (JsonElement)JsonElementKt.JsonPrimitive((String)((String)v))) : $this$parseTrailblazeToolsForStep_u24lambda_u2412.put(String.valueOf(k), (JsonElement)JsonElementKt.JsonPrimitive((String)String.valueOf(v)))));
        }
        JsonObject jsonParams = builder$iv.build();
        try {
            trailblazeTool = (TrailblazeTool)JsonSerializationUtil.INSTANCE.deserializeTrailblazeTool(toolClass, jsonParams);
        }
        catch (Exception e) {
            throw new TrailblazeException("Failed to deserialize tool: " + (String)toolName + " with params " + params + ": \" + e.message");
        }
        return trailblazeTool;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseFullPrompt(List<?> objectives, boolean useOnlyKeys) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = objectives;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            Object t = it;
            if (t instanceof String) {
                object = (String)it;
            } else if (t instanceof Map) {
                Object key;
                Object object2 = CollectionsKt.firstOrNull((Iterable)((Map)it).keySet());
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = key = "";
                }
                if (useOnlyKeys) {
                    object = key;
                } else {
                    Object object3 = CollectionsKt.firstOrNull((Iterable)((Map)it).values());
                    if (object3 == null || (object3 = object3.toString()) == null) {
                        object3 = "";
                    }
                    object = (String)key + ": " + (String)object3;
                }
            } else {
                object = null;
            }
            if (object == null) continue;
            String it$iv$iv = object;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String fullInstructions = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.isBlank((CharSequence)fullInstructions)) {
            throw new TrailblazeException("Cannot parse objectives from empty instructions.");
        }
        return fullInstructions;
    }

    static /* synthetic */ String parseFullPrompt$default(MixedModeTestCase mixedModeTestCase, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return mixedModeTestCase.parseFullPrompt(list, bl);
    }

    private final TestObjective.RememberTextCommand parseRememberTextCommand(Object value) {
        String variable;
        String prompt;
        if (value instanceof Map) {
            Object v = ((Map)value).get("prompt");
            prompt = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("variable");
            String string = variable = v2 != null ? v2.toString() : null;
            if (prompt == null || variable == null) {
                throw new TrailblazeException("Invalid rememberText command: missing prompt or variable name");
            }
        } else {
            throw new TrailblazeException("Invalid rememberText command format");
        }
        return new TestObjective.RememberTextCommand(prompt, variable);
    }

    private final TestObjective.RememberNumberCommand parseRememberNumberCommand(Object value) {
        String variable;
        String prompt;
        if (value instanceof Map) {
            Object v = ((Map)value).get("prompt");
            prompt = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("variable");
            String string = variable = v2 != null ? v2.toString() : null;
            if (prompt == null || variable == null) {
                throw new TrailblazeException("Invalid rememberNumber command: missing prompt or variable name");
            }
        } else {
            throw new TrailblazeException("Invalid rememberNumber command format");
        }
        return new TestObjective.RememberNumberCommand(prompt, variable);
    }

    private final TestObjective.RememberWithAiCommand parseRememberWithAiCommand(Object value) {
        String variable;
        String prompt;
        if (value instanceof Map) {
            Object v = ((Map)value).get("prompt");
            prompt = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("variable");
            String string = variable = v2 != null ? v2.toString() : null;
            if (prompt == null || variable == null) {
                throw new TrailblazeException("Invalid rememberWithAI command: missing prompt or variable name");
            }
        } else {
            throw new TrailblazeException("Invalid rememberWithAI command format");
        }
        return new TestObjective.RememberWithAiCommand(prompt, variable);
    }

    private final TestObjective.AssertEqualsCommand parseAssertEqualsCommand(Object value) {
        String expected;
        String actual;
        if (value instanceof Map) {
            Object v = ((Map)value).get("actual");
            actual = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("expected");
            String string = expected = v2 != null ? v2.toString() : null;
            if (actual == null || expected == null) {
                throw new TrailblazeException("Invalid assertEquals command: missing actual or expected name");
            }
        } else {
            throw new TrailblazeException("Invalid assertEquals command format");
        }
        return new TestObjective.AssertEqualsCommand(actual, expected);
    }

    private final TestObjective.AssertNotEqualsCommand parseAssertNotEqualsCommand(Object value) {
        String expected;
        String actual;
        if (value instanceof Map) {
            Object v = ((Map)value).get("actual");
            actual = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("expected");
            String string = expected = v2 != null ? v2.toString() : null;
            if (actual == null || expected == null) {
                throw new TrailblazeException("Invalid assertNotEquals command: missing actual or expected name");
            }
        } else {
            throw new TrailblazeException("Invalid assertNotEquals command format");
        }
        return new TestObjective.AssertNotEqualsCommand(actual, expected);
    }

    private final TestObjective.AssertWithAiCommand parseAssertWithAiCommand(Object value) {
        Object v;
        if (value instanceof Map) {
            v = ((Map)value).get("prompt");
            if (v == null || (v = v.toString()) == null) {
                throw new TrailblazeException("Invalid assertWithAi command: missing prompt");
            }
        } else {
            throw new TrailblazeException("Invalid assertWithAi command");
        }
        Object prompt = v;
        return new TestObjective.AssertWithAiCommand(prompt);
    }

    private final TestObjective.AssertMathCommand parseAssertMathCommand(Object value) {
        String expected;
        String expression;
        if (value instanceof Map) {
            Object v = ((Map)value).get("expression");
            expression = v != null ? v.toString() : null;
            Object v2 = ((Map)value).get("expected");
            String string = expected = v2 != null ? v2.toString() : null;
            if (expression == null || expected == null) {
                throw new TrailblazeException("Invalid assertMath command: missing expression or expected values");
            }
        } else {
            throw new TrailblazeException("Invalid assertMath command");
        }
        return new TestObjective.AssertMathCommand(expression, expected);
    }

    private final TestObjective.MaestroCommand parseMaestroCommand(String key, Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "- " + key;
        } else if (object instanceof Map) {
            DumperOptions dumperOptions;
            DumperOptions $this$parseMaestroCommand_u24lambda_u2414 = dumperOptions = new DumperOptions();
            boolean bl = false;
            $this$parseMaestroCommand_u24lambda_u2414.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            $this$parseMaestroCommand_u24lambda_u2414.setIndent(2);
            DumperOptions options = dumperOptions;
            Yaml yaml = new Yaml(options);
            String string2 = yaml.dump(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dump(...)");
            String inline = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            string = "- " + key + ": " + inline;
        } else {
            string = "- " + key + ": " + value;
        }
        String maestroCommand = string;
        return new TestObjective.MaestroCommand(maestroCommand);
    }

    static {
        Object[] objectArray = new String[]{"tb", "trailblaze", "\ud83e\udded", "run"};
        trailblazeCommands = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"scroll", "back", "hideKeyboard", "waitForAnimationToEnd"};
        noParamMaestroCommands = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"addMedia", "assertVisible", "assertNotVisible", "assertTrue", "assertNoDefectsWithAi", "back", "clearKeychain", "clearState", "copyTextFrom", "evalScript", "eraseText", "extendedWaitUntil", "hideKeyboard", "inputText", "killApp", "launchApp", "openLink", "pressKey", "pasteText", "repeat", "retry", "runFlow", "runScript", "scroll", "scrollUntilVisible", "setAirplaneMode", "setLocation", "startRecording", "stopApp", "stopRecording", "swipe", "takeScreenshot", "toggleAirplaneMode", "tapOn", "doubleTapOn", "longPressOn", "travel", "waitForAnimationToEnd"};
        maestroCommands = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\f\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\r\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0010\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\n*\u0004\u0018\u00010\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/block/trailblaze/agent/model/MixedModeTestCase$Companion;", "", "<init>", "()V", "trailblazeCommands", "", "", "noParamMaestroCommands", "maestroCommands", "isTrailblazeCommand", "", "isRememberTextCommand", "isRememberNumberCommand", "isRememberWithAiCommand", "isAssertEqualsCommand", "isAssertNotEqualsCommand", "isAssertWithAiCommand", "isAssertMathCommand", "isMaestroCommand", "isNoParamMaestroCommand", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTrailblazeCommand(String $this$isTrailblazeCommand) {
            return $this$isTrailblazeCommand != null && trailblazeCommands.contains($this$isTrailblazeCommand);
        }

        private final boolean isRememberTextCommand(String $this$isRememberTextCommand) {
            return Intrinsics.areEqual((Object)"rememberText", (Object)$this$isRememberTextCommand);
        }

        private final boolean isRememberNumberCommand(String $this$isRememberNumberCommand) {
            return Intrinsics.areEqual((Object)"rememberNumber", (Object)$this$isRememberNumberCommand);
        }

        private final boolean isRememberWithAiCommand(String $this$isRememberWithAiCommand) {
            return Intrinsics.areEqual((Object)"rememberWithAI", (Object)$this$isRememberWithAiCommand);
        }

        private final boolean isAssertEqualsCommand(String $this$isAssertEqualsCommand) {
            return Intrinsics.areEqual((Object)"assertEquals", (Object)$this$isAssertEqualsCommand);
        }

        private final boolean isAssertNotEqualsCommand(String $this$isAssertNotEqualsCommand) {
            return Intrinsics.areEqual((Object)"assertNotEquals", (Object)$this$isAssertNotEqualsCommand);
        }

        private final boolean isAssertWithAiCommand(String $this$isAssertWithAiCommand) {
            return Intrinsics.areEqual((Object)"assertWithAI", (Object)$this$isAssertWithAiCommand);
        }

        private final boolean isAssertMathCommand(String $this$isAssertMathCommand) {
            return Intrinsics.areEqual((Object)"assertMath", (Object)$this$isAssertMathCommand);
        }

        private final boolean isMaestroCommand(String $this$isMaestroCommand) {
            return $this$isMaestroCommand != null && maestroCommands.contains($this$isMaestroCommand);
        }

        private final boolean isNoParamMaestroCommand(String $this$isNoParamMaestroCommand) {
            return $this$isNoParamMaestroCommand != null && noParamMaestroCommands.contains($this$isNoParamMaestroCommand);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

