/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.logs.client;

import ai.koog.prompt.message.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import xyz.block.trailblaze.agent.model.AgentTaskStatus;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;
import xyz.block.trailblaze.logs.client.TrailblazeJsonInstanceKt;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.model.LlmMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\u00072\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tJR\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020\nJ\u0010\u0010)\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010\u0003R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lxyz/block/trailblaze/logs/client/TrailblazeLogger;", "", "<init>", "()V", "logListener", "Lkotlin/Function1;", "Lxyz/block/trailblaze/logs/client/TrailblazeLog;", "", "logScreenshotListener", "", "", "setLogListener", "log", "trailblazeLog", "setLogScreenshotListener", "logScreenshot", "screenshotBytes", "logLlmRequest", "llmModelId", "llmRequestId", "agentTaskStatus", "Lxyz/block/trailblaze/agent/model/AgentTaskStatus;", "screenState", "Lxyz/block/trailblaze/api/ScreenState;", "instructions", "llmMessages", "", "Lxyz/block/trailblaze/logs/model/LlmMessage;", "response", "Lai/koog/prompt/message/Message$Response;", "startTime", "Lkotlinx/datetime/Instant;", "DATE_TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "getDATE_TIME_FORMAT$annotations", "generateSessionId", "seed", "sessionId", "startSession", "sessionName", "getCurrentSessionId", "truncateSessionId", "overrideSessionId", "sessionIdOverride", "trailblaze-common"})
@SourceDebugExtension(value={"SMAP\nTrailblazeLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailblazeLogger.kt\nxyz/block/trailblaze/logs/client/TrailblazeLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n808#2,11:104\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 TrailblazeLogger.kt\nxyz/block/trailblaze/logs/client/TrailblazeLogger\n*L\n44#1:104,11\n58#1:115\n58#1:116,3\n*E\n"})
public final class TrailblazeLogger {
    @NotNull
    public static final TrailblazeLogger INSTANCE = new TrailblazeLogger();
    @NotNull
    private static Function1<? super TrailblazeLog, Unit> logListener = TrailblazeLogger::logListener$lambda$0;
    @NotNull
    private static Function1<? super byte[], String> logScreenshotListener = TrailblazeLogger::logScreenshotListener$lambda$1;
    @NotNull
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.US);
    @NotNull
    private static String sessionId = INSTANCE.generateSessionId("Trailblaze");

    private TrailblazeLogger() {
    }

    public final void setLogListener(@NotNull Function1<? super TrailblazeLog, Unit> logListener) {
        Intrinsics.checkNotNullParameter(logListener, (String)"logListener");
        TrailblazeLogger.logListener = logListener;
    }

    public final void log(@NotNull TrailblazeLog trailblazeLog) {
        Intrinsics.checkNotNullParameter((Object)trailblazeLog, (String)"trailblazeLog");
        logListener.invoke((Object)trailblazeLog);
    }

    public final void setLogScreenshotListener(@NotNull Function1<? super byte[], String> logScreenshotListener) {
        Intrinsics.checkNotNullParameter(logScreenshotListener, (String)"logScreenshotListener");
        TrailblazeLogger.logScreenshotListener = logScreenshotListener;
    }

    @NotNull
    public final String logScreenshot(@NotNull byte[] screenshotBytes) {
        Intrinsics.checkNotNullParameter((Object)screenshotBytes, (String)"screenshotBytes");
        return (String)logScreenshotListener.invoke((Object)screenshotBytes);
    }

    /*
     * WARNING - void declaration
     */
    public final void logLlmRequest(@NotNull String llmModelId, @NotNull String llmRequestId, @NotNull AgentTaskStatus agentTaskStatus, @NotNull ScreenState screenState, @NotNull String instructions, @NotNull List<LlmMessage> llmMessages, @NotNull List<? extends Message.Response> response, @NotNull Instant startTime) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)llmModelId, (String)"llmModelId");
        Intrinsics.checkNotNullParameter((Object)llmRequestId, (String)"llmRequestId");
        Intrinsics.checkNotNullParameter((Object)agentTaskStatus, (String)"agentTaskStatus");
        Intrinsics.checkNotNullParameter((Object)screenState, (String)"screenState");
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(llmMessages, (String)"llmMessages");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Iterable $this$filterIsInstance$iv = response;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof Message.Tool)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List toolMessages = (List)destination$iv$iv;
        byte[] byArray = screenState.getScreenshotBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] bytes = byArray;
        String screenshotFilename = this.logScreenshot(bytes);
        iterable = screenState.getViewHierarchy();
        Iterable $i$f$filterIsInstanceTo22 = toolMessages;
        TrailblazeLogger trailblazeLogger = this;
        boolean $i$f$map = false;
        element$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message.Tool tool = (Message.Tool)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new TrailblazeLog.TrailblazeLlmRequestLog.Action(it.getTool(), (JsonObject)TrailblazeJsonInstanceKt.getTrailblazeJsonInstance().decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), it.getContent())));
        }
        List list = (List)destination$iv$iv2;
        Instant instant = Clock.System.INSTANCE.now();
        long l = Clock.System.INSTANCE.now().getEpochSeconds() - startTime.getEpochSeconds();
        int n = screenState.getDeviceWidth();
        int n2 = screenState.getDeviceHeight();
        String string = this.getCurrentSessionId();
        trailblazeLogger.log((TrailblazeLog)new TrailblazeLog.TrailblazeLlmRequestLog(agentTaskStatus, (ViewHierarchyTreeNode)iterable, instructions, llmModelId, llmMessages, response, list, screenshotFilename, l, string, instant, llmRequestId, n2, n));
    }

    private static /* synthetic */ void getDATE_TIME_FORMAT$annotations() {
    }

    private final String generateSessionId(String seed) {
        return DATE_TIME_FORMAT.format(new Date()) + "_" + seed;
    }

    @NotNull
    public final String startSession(@NotNull String sessionName) {
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        return this.overrideSessionId(this.generateSessionId(sessionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getCurrentSessionId() {
        String string = sessionId;
        synchronized (string) {
            boolean bl = false;
            String string2 = sessionId;
            return string2;
        }
    }

    private final String truncateSessionId(String sessionId) {
        String string = sessionId.substring(0, Math.min(sessionId.length(), 100));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("[^a-zA-Z0-9]");
        String string2 = "_";
        String string3 = regex.replace(charSequence, string2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Prefer startSession() unless you need to explicitly override the session id")
    @NotNull
    public final String overrideSessionId(@NotNull String sessionIdOverride) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sessionIdOverride, (String)"sessionIdOverride");
        String string2 = sessionId;
        synchronized (string2) {
            String string3;
            boolean bl = false;
            String it = string3 = INSTANCE.truncateSessionId(sessionIdOverride);
            boolean bl2 = false;
            sessionId = it;
            string = string3;
        }
        return string;
    }

    private static final Unit logListener$lambda$0(TrailblazeLog it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final String logScreenshotListener$lambda$1(byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Screenshot_Not_Logged";
    }
}

