/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.toolcalls.commands;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.api.ScreenState;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;
import xyz.block.trailblaze.exception.TrailblazeException;
import xyz.block.trailblaze.toolcalls.DelegatingTrailblazeTool;
import xyz.block.trailblaze.toolcalls.ExecutableTrailblazeTool;
import xyz.block.trailblaze.toolcalls.TrailblazeToolClass;
import xyz.block.trailblaze.toolcalls.TrailblazeToolExecutionContext;
import xyz.block.trailblaze.toolcalls.commands.AssertVisibleByNodeIdTrailblazeTool$;
import xyz.block.trailblaze.toolcalls.commands.AssertVisibleWithAccessibilityTextTrailblazeTool;
import xyz.block.trailblaze.toolcalls.commands.AssertVisibleWithResourceIdTrailblazeTool;
import xyz.block.trailblaze.toolcalls.commands.AssertVisibleWithTextTrailblazeTool;

@Serializable
@TrailblazeToolClass(name="assertVisibleWithNodeId")
@LLMDescription(description="\nAssert that the element with the given nodeId is visible on the screen. This will delegate to the appropriate assert tool (by text, resource ID, or accessibility text) based on the node's properties.\n")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B\u001b\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B-\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/AssertVisibleByNodeIdTrailblazeTool;", "Lxyz/block/trailblaze/toolcalls/DelegatingTrailblazeTool;", "reason", "", "nodeId", "", "<init>", "(Ljava/lang/String;J)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getReason", "()Ljava/lang/String;", "getNodeId", "()J", "toExecutableTrailblazeTools", "", "Lxyz/block/trailblaze/toolcalls/ExecutableTrailblazeTool;", "executionContext", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolExecutionContext;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$trailblaze_common", "$serializer", "Companion", "trailblaze-common"})
public final class AssertVisibleByNodeIdTrailblazeTool
implements DelegatingTrailblazeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String reason;
    private final long nodeId;

    public AssertVisibleByNodeIdTrailblazeTool(@LLMDescription(description="Reasoning on why this element was chosen. Do NOT restate the nodeId.") @NotNull String reason, @LLMDescription(description="The nodeId of the element in the view hierarchy to assert visibility for. Do NOT use the nodeId 0.") long nodeId) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        this.nodeId = nodeId;
    }

    public /* synthetic */ AssertVisibleByNodeIdTrailblazeTool(String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string, l);
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    @Override
    @NotNull
    public List<ExecutableTrailblazeTool> toExecutableTrailblazeTools(@NotNull TrailblazeToolExecutionContext executionContext) {
        ExecutableTrailblazeTool executableTrailblazeTool;
        ScreenState screenState;
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        ScreenState screenState2 = screenState = executionContext.getScreenState();
        if ((screenState2 != null ? screenState2.getViewHierarchy() : null) == null) {
            throw new TrailblazeException("No View Hierarchy available when processing " + this);
        }
        ViewHierarchyTreeNode matchingNode = ViewHierarchyTreeNode.Companion.dfs(screenState.getViewHierarchy(), arg_0 -> AssertVisibleByNodeIdTrailblazeTool.toExecutableTrailblazeTools$lambda$0(this, arg_0));
        if (matchingNode == null) {
            throw new TrailblazeException("AssertVisibleWithNodeId: No node found with nodeId=" + this.nodeId + ".  " + this);
        }
        CharSequence charSequence = matchingNode.getText();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = matchingNode.getText();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
            String string2 = matchingNode.getResourceId();
            boolean bl = matchingNode.getEnabled();
            boolean bl2 = matchingNode.getSelected();
            executableTrailblazeTool = new AssertVisibleWithTextTrailblazeTool((String)charSequence, 0, string2, bl, bl2);
        } else {
            charSequence = matchingNode.getAccessibilityText();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String string = matchingNode.getAccessibilityText();
                Intrinsics.checkNotNull((Object)string);
                executableTrailblazeTool = new AssertVisibleWithAccessibilityTextTrailblazeTool(string, matchingNode.getResourceId(), 0, matchingNode.getEnabled(), matchingNode.getSelected());
            } else {
                charSequence = matchingNode.getResourceId();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    String string = matchingNode.getResourceId();
                    Intrinsics.checkNotNull((Object)string);
                    executableTrailblazeTool = new AssertVisibleWithResourceIdTrailblazeTool(string, matchingNode.getAccessibilityText(), 0, matchingNode.getEnabled(), matchingNode.getSelected());
                } else {
                    throw new TrailblazeException("AssertVisibleWithNodeId: No suitable property to assert visibility for nodeId=" + this.nodeId);
                }
            }
        }
        ExecutableTrailblazeTool tool = executableTrailblazeTool;
        return CollectionsKt.listOf((Object)tool);
    }

    @NotNull
    public final String component1() {
        return this.reason;
    }

    public final long component2() {
        return this.nodeId;
    }

    @NotNull
    public final AssertVisibleByNodeIdTrailblazeTool copy(@LLMDescription(description="Reasoning on why this element was chosen. Do NOT restate the nodeId.") @NotNull String reason, @LLMDescription(description="The nodeId of the element in the view hierarchy to assert visibility for. Do NOT use the nodeId 0.") long nodeId) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new AssertVisibleByNodeIdTrailblazeTool(reason, nodeId);
    }

    public static /* synthetic */ AssertVisibleByNodeIdTrailblazeTool copy$default(AssertVisibleByNodeIdTrailblazeTool assertVisibleByNodeIdTrailblazeTool, String string, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = assertVisibleByNodeIdTrailblazeTool.reason;
        }
        if ((n & 2) != 0) {
            l = assertVisibleByNodeIdTrailblazeTool.nodeId;
        }
        return assertVisibleByNodeIdTrailblazeTool.copy(string, l);
    }

    @NotNull
    public String toString() {
        return "AssertVisibleByNodeIdTrailblazeTool(reason=" + this.reason + ", nodeId=" + this.nodeId + ")";
    }

    public int hashCode() {
        int result = this.reason.hashCode();
        result = result * 31 + Long.hashCode(this.nodeId);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AssertVisibleByNodeIdTrailblazeTool)) {
            return false;
        }
        AssertVisibleByNodeIdTrailblazeTool assertVisibleByNodeIdTrailblazeTool = (AssertVisibleByNodeIdTrailblazeTool)other;
        if (!Intrinsics.areEqual((Object)this.reason, (Object)assertVisibleByNodeIdTrailblazeTool.reason)) {
            return false;
        }
        return this.nodeId == assertVisibleByNodeIdTrailblazeTool.nodeId;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$trailblaze_common(AssertVisibleByNodeIdTrailblazeTool self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.reason, (Object)"")) {
            output.encodeStringElement(serialDesc, 0, self.reason);
        }
        output.encodeLongElement(serialDesc, 1, self.nodeId);
    }

    public /* synthetic */ AssertVisibleByNodeIdTrailblazeTool(int seen0, String reason, long nodeId, SerializationConstructorMarker serializationConstructorMarker) {
        if (2 != (2 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)2, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.reason = (seen0 & 1) == 0 ? "" : reason;
        this.nodeId = nodeId;
    }

    private static final boolean toExecutableTrailblazeTools$lambda$0(AssertVisibleByNodeIdTrailblazeTool this$0, ViewHierarchyTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNodeId() == this$0.nodeId;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/block/trailblaze/toolcalls/commands/AssertVisibleByNodeIdTrailblazeTool$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/block/trailblaze/toolcalls/commands/AssertVisibleByNodeIdTrailblazeTool;", "trailblaze-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AssertVisibleByNodeIdTrailblazeTool> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

