/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.agent.model;

import ai.koog.prompt.message.Message;
import ai.koog.prompt.message.RequestMetaInfo;
import ai.koog.prompt.message.ResponseMetaInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.agent.model.AgentTaskStatus;
import xyz.block.trailblaze.agent.model.AgentTaskStatusData;
import xyz.block.trailblaze.api.AgentMessages;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0006J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019J\u0006\u0010!\u001a\u00020\tJ,\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00032\b\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010)J \u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0018\u0010-\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020#J\u0006\u00101\u001a\u00020#J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\tH\u00c6\u0003J;\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u00108\u001a\u00020\t2\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020\u0006H\u00d6\u0001J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006<"}, d2={"Lxyz/block/trailblaze/agent/model/TrailblazePromptStep;", "", "description", "", "taskId", "taskIndex", "", "fullPrompt", "llmStatusChecks", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getTaskId", "getTaskIndex", "()I", "getFullPrompt", "getLlmStatusChecks", "()Z", "koogLlmResponseHistory", "", "Lai/koog/prompt/message/Message;", "getHistorySize", "getKoogLlmResponseHistory", "", "taskCreatedTimestamp", "Lkotlinx/datetime/Instant;", "currentStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lxyz/block/trailblaze/agent/model/AgentTaskStatus;", "getCurrentStatus", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "isFinished", "addCompletedToolCallToChatHistory", "", "commandResult", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "llmResponseContent", "toolName", "toolArgs", "Lkotlinx/serialization/json/JsonObject;", "addToolExecutionResultUserMessageToChatHistory", "addAssistantMessageToChatHistory", "llmContent", "addEmptyToolCallToChatHistory", "result", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult$Error$EmptyToolCall;", "markAsComplete", "markAsFailed", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "trailblaze-models"})
public final class TrailblazePromptStep {
    @NotNull
    private final String description;
    @NotNull
    private final String taskId;
    private final int taskIndex;
    @NotNull
    private final String fullPrompt;
    private final boolean llmStatusChecks;
    @NotNull
    private final List<Message> koogLlmResponseHistory;
    @NotNull
    private final Instant taskCreatedTimestamp;
    @NotNull
    private final MutableStateFlow<AgentTaskStatus> currentStatus;

    public TrailblazePromptStep(@NotNull String description, @NotNull String taskId, int taskIndex, @NotNull String fullPrompt, boolean llmStatusChecks) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)fullPrompt, (String)"fullPrompt");
        this.description = description;
        this.taskId = taskId;
        this.taskIndex = taskIndex;
        this.fullPrompt = fullPrompt;
        this.llmStatusChecks = llmStatusChecks;
        this.koogLlmResponseHistory = new ArrayList();
        this.taskCreatedTimestamp = Clock.System.INSTANCE.now();
        String string = this.fullPrompt;
        Instant instant = this.taskCreatedTimestamp;
        String string2 = this.taskId;
        this.currentStatus = StateFlowKt.MutableStateFlow((Object)new AgentTaskStatus.InProgress(new AgentTaskStatusData(string2, string, 0, instant, 0L)));
    }

    public /* synthetic */ TrailblazePromptStep(String string, String string2, int n, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(string, string2, n, string3, bl);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTaskId() {
        return this.taskId;
    }

    public final int getTaskIndex() {
        return this.taskIndex;
    }

    @NotNull
    public final String getFullPrompt() {
        return this.fullPrompt;
    }

    public final boolean getLlmStatusChecks() {
        return this.llmStatusChecks;
    }

    public final int getHistorySize() {
        return this.koogLlmResponseHistory.size();
    }

    @NotNull
    public final List<Message> getKoogLlmResponseHistory() {
        return this.koogLlmResponseHistory;
    }

    @NotNull
    public final MutableStateFlow<AgentTaskStatus> getCurrentStatus() {
        return this.currentStatus;
    }

    public final boolean isFinished() {
        return !(this.currentStatus.getValue() instanceof AgentTaskStatus.InProgress);
    }

    public final void addCompletedToolCallToChatHistory(@NotNull TrailblazeToolResult commandResult, @Nullable String llmResponseContent, @Nullable String toolName, @Nullable JsonObject toolArgs) {
        Intrinsics.checkNotNullParameter((Object)commandResult, (String)"commandResult");
        String string = llmResponseContent;
        if (string != null) {
            String llmContent = string;
            boolean bl = false;
            this.addAssistantMessageToChatHistory(llmContent);
        }
        if (toolName != null && toolArgs != null) {
            this.addToolExecutionResultUserMessageToChatHistory(commandResult, toolName, toolArgs);
        }
    }

    private final void addToolExecutionResultUserMessageToChatHistory(TrailblazeToolResult commandResult, String toolName, JsonObject toolArgs) {
        String contentString = AgentMessages.INSTANCE.toContentString(commandResult, toolName, toolArgs);
        this.koogLlmResponseHistory.add((Message)new Message.User(contentString, RequestMetaInfo.Companion.create((Clock)Clock.System.INSTANCE), null, 4, null));
    }

    private final void addAssistantMessageToChatHistory(String llmContent) {
        this.koogLlmResponseHistory.add((Message)new Message.Assistant(llmContent, ResponseMetaInfo.Companion.create$default((ResponseMetaInfo.Companion)ResponseMetaInfo.Companion, (Clock)((Clock)Clock.System.INSTANCE), null, null, null, null, (int)30, null), null, null, 12, null));
    }

    public final void addEmptyToolCallToChatHistory(@Nullable String llmResponseContent, @NotNull TrailblazeToolResult.Error.EmptyToolCall result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.addCompletedToolCallToChatHistory(result, llmResponseContent, null, null);
    }

    public final void markAsComplete() {
        String string = this.description;
        int n = this.getHistorySize();
        Instant instant = this.taskCreatedTimestamp;
        long l = Clock.System.INSTANCE.now().getEpochSeconds() - this.taskCreatedTimestamp.getEpochSeconds();
        String string2 = this.taskId;
        this.currentStatus.setValue((Object)new AgentTaskStatus.Success.ObjectiveComplete(new AgentTaskStatusData(string2, string, n, instant, l), "All objectives completed successfully"));
    }

    public final void markAsFailed() {
        String string = this.description;
        int n = this.getHistorySize();
        Instant instant = this.taskCreatedTimestamp;
        long l = Clock.System.INSTANCE.now().toEpochMilliseconds() - this.taskCreatedTimestamp.toEpochMilliseconds();
        String string2 = this.taskId;
        this.currentStatus.setValue((Object)new AgentTaskStatus.Failure.ObjectiveFailed(new AgentTaskStatusData(string2, string, n, instant, l), "The objective failed to complete"));
    }

    @NotNull
    public final String component1() {
        return this.description;
    }

    @NotNull
    public final String component2() {
        return this.taskId;
    }

    public final int component3() {
        return this.taskIndex;
    }

    @NotNull
    public final String component4() {
        return this.fullPrompt;
    }

    public final boolean component5() {
        return this.llmStatusChecks;
    }

    @NotNull
    public final TrailblazePromptStep copy(@NotNull String description, @NotNull String taskId, int taskIndex, @NotNull String fullPrompt, boolean llmStatusChecks) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)fullPrompt, (String)"fullPrompt");
        return new TrailblazePromptStep(description, taskId, taskIndex, fullPrompt, llmStatusChecks);
    }

    public static /* synthetic */ TrailblazePromptStep copy$default(TrailblazePromptStep trailblazePromptStep, String string, String string2, int n, String string3, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = trailblazePromptStep.description;
        }
        if ((n2 & 2) != 0) {
            string2 = trailblazePromptStep.taskId;
        }
        if ((n2 & 4) != 0) {
            n = trailblazePromptStep.taskIndex;
        }
        if ((n2 & 8) != 0) {
            string3 = trailblazePromptStep.fullPrompt;
        }
        if ((n2 & 0x10) != 0) {
            bl = trailblazePromptStep.llmStatusChecks;
        }
        return trailblazePromptStep.copy(string, string2, n, string3, bl);
    }

    @NotNull
    public String toString() {
        return "TrailblazePromptStep(description=" + this.description + ", taskId=" + this.taskId + ", taskIndex=" + this.taskIndex + ", fullPrompt=" + this.fullPrompt + ", llmStatusChecks=" + this.llmStatusChecks + ")";
    }

    public int hashCode() {
        int result = this.description.hashCode();
        result = result * 31 + this.taskId.hashCode();
        result = result * 31 + Integer.hashCode(this.taskIndex);
        result = result * 31 + this.fullPrompt.hashCode();
        result = result * 31 + Boolean.hashCode(this.llmStatusChecks);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrailblazePromptStep)) {
            return false;
        }
        TrailblazePromptStep trailblazePromptStep = (TrailblazePromptStep)other;
        if (!Intrinsics.areEqual((Object)this.description, (Object)trailblazePromptStep.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taskId, (Object)trailblazePromptStep.taskId)) {
            return false;
        }
        if (this.taskIndex != trailblazePromptStep.taskIndex) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fullPrompt, (Object)trailblazePromptStep.fullPrompt)) {
            return false;
        }
        return this.llmStatusChecks == trailblazePromptStep.llmStatusChecks;
    }
}

