/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import xyz.block.trailblaze.toolcalls.TrailblazeToolResult;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lxyz/block/trailblaze/api/AgentMessages;", "", "<init>", "()V", "toContentString", "", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult;", "toolName", "toolArgs", "Lkotlinx/serialization/json/JsonObject;", "errorExceptionContentString", "errorException", "Lxyz/block/trailblaze/toolcalls/TrailblazeToolResult$Error$ExceptionThrown;", "successContentString", "validationErrorContentString", "errorMessage", "unknownCommandErrorContentString", "emptyToolCallErrorContentString", "unknownToolErrorContentString", "functionName", "functionArgs", "missingRequiredArgsContentString", "requiredArguments", "", "trailblaze-models"})
public final class AgentMessages {
    @NotNull
    public static final AgentMessages INSTANCE = new AgentMessages();

    private AgentMessages() {
    }

    @NotNull
    public final String toContentString(@NotNull TrailblazeToolResult $this$toContentString, @NotNull String toolName, @NotNull JsonObject toolArgs) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toContentString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)toolArgs, (String)"toolArgs");
        TrailblazeToolResult trailblazeToolResult = $this$toContentString;
        if (trailblazeToolResult instanceof TrailblazeToolResult.Success) {
            string = this.successContentString(toolName, toolArgs);
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.MaestroValidationError) {
            string = this.validationErrorContentString(toolName, toolArgs, ((TrailblazeToolResult.Error.MaestroValidationError)$this$toContentString).getErrorMessage());
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.UnknownTrailblazeTool) {
            string = this.unknownCommandErrorContentString(toolName, toolArgs, ((TrailblazeToolResult.Error.UnknownTrailblazeTool)$this$toContentString).getErrorMessage());
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.EmptyToolCall) {
            string = this.emptyToolCallErrorContentString();
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.ExceptionThrown) {
            string = this.errorExceptionContentString((TrailblazeToolResult.Error.ExceptionThrown)$this$toContentString);
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.UnknownTool) {
            string = this.unknownToolErrorContentString(((TrailblazeToolResult.Error.UnknownTool)$this$toContentString).getFunctionName(), ((TrailblazeToolResult.Error.UnknownTool)$this$toContentString).getFunctionArgs(), ((TrailblazeToolResult.Error.UnknownTool)$this$toContentString).getErrorMessage());
        } else if (trailblazeToolResult instanceof TrailblazeToolResult.Error.MissingRequiredArgs) {
            string = this.missingRequiredArgsContentString(((TrailblazeToolResult.Error.MissingRequiredArgs)$this$toContentString).getFunctionName(), ((TrailblazeToolResult.Error.MissingRequiredArgs)$this$toContentString).getFunctionArgs(), ((TrailblazeToolResult.Error.MissingRequiredArgs)$this$toContentString).getRequiredArgs());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String errorExceptionContentString(TrailblazeToolResult.Error.ExceptionThrown errorException) {
        StringBuilder stringBuilder;
        StringBuilder $this$errorExceptionContentString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$errorExceptionContentString_u24lambda_u240.append("# Error executing tool: " + errorException).append('\n');
        $this$errorExceptionContentString_u24lambda_u240.append("Exception Message: " + errorException.getErrorMessage()).append('\n');
        $this$errorExceptionContentString_u24lambda_u240.append("Command: " + errorException.getCommand()).append('\n');
        return stringBuilder.toString();
    }

    private final String successContentString(String toolName, JsonObject toolArgs) {
        StringBuilder stringBuilder;
        StringBuilder $this$successContentString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$successContentString_u24lambda_u241.append("# Successfully performed the following action on the device:").append('\n');
        $this$successContentString_u24lambda_u241.append("Tool: " + toolName).append('\n');
        $this$successContentString_u24lambda_u241.append("Parameters " + toolArgs).append('\n');
        return stringBuilder.toString();
    }

    private final String validationErrorContentString(String toolName, JsonObject toolArgs, String errorMessage) {
        StringBuilder stringBuilder;
        StringBuilder $this$validationErrorContentString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$validationErrorContentString_u24lambda_u242.append("# Failed to perform the following action on the device because of a verification error.").append('\n');
        $this$validationErrorContentString_u24lambda_u242.append("Tool: " + toolName).append('\n');
        $this$validationErrorContentString_u24lambda_u242.append("Parameters " + toolArgs).append('\n');
        $this$validationErrorContentString_u24lambda_u242.append("Error message: " + errorMessage).append('\n');
        return stringBuilder.toString();
    }

    private final String unknownCommandErrorContentString(String toolName, JsonObject toolArgs, String errorMessage) {
        StringBuilder stringBuilder;
        StringBuilder $this$unknownCommandErrorContentString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$unknownCommandErrorContentString_u24lambda_u243.append("# Unknown command provided, please try a different tool.").append('\n');
        $this$unknownCommandErrorContentString_u24lambda_u243.append("Tool: " + toolName).append('\n');
        $this$unknownCommandErrorContentString_u24lambda_u243.append("Parameters " + toolArgs).append('\n');
        $this$unknownCommandErrorContentString_u24lambda_u243.append("Error message: " + errorMessage).append('\n');
        return stringBuilder.toString();
    }

    private final String emptyToolCallErrorContentString() {
        StringBuilder stringBuilder;
        StringBuilder $this$emptyToolCallErrorContentString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$emptyToolCallErrorContentString_u24lambda_u244.append("# FAILURE: No tool call provided").append('\n');
        $this$emptyToolCallErrorContentString_u24lambda_u244.append("Error message: " + TrailblazeToolResult.Error.EmptyToolCall.INSTANCE.getErrorMessage()).append('\n');
        return stringBuilder.toString();
    }

    private final String unknownToolErrorContentString(String functionName, JsonObject functionArgs, String errorMessage) {
        StringBuilder stringBuilder;
        StringBuilder $this$unknownToolErrorContentString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$unknownToolErrorContentString_u24lambda_u245.append("# Unregistered command provided, please try a different tool.").append('\n');
        $this$unknownToolErrorContentString_u24lambda_u245.append("Tool: " + functionName).append('\n');
        $this$unknownToolErrorContentString_u24lambda_u245.append("Parameters " + functionArgs).append('\n');
        $this$unknownToolErrorContentString_u24lambda_u245.append("Error message: " + errorMessage).append('\n');
        return stringBuilder.toString();
    }

    private final String missingRequiredArgsContentString(String functionName, JsonObject functionArgs, List<String> requiredArguments) {
        StringBuilder stringBuilder;
        StringBuilder $this$missingRequiredArgsContentString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$missingRequiredArgsContentString_u24lambda_u246.append("# Tool attempted is missing required arguments.").append('\n');
        $this$missingRequiredArgsContentString_u24lambda_u246.append("Tool: " + functionName).append('\n');
        $this$missingRequiredArgsContentString_u24lambda_u246.append("Parameters provided " + functionArgs).append('\n');
        $this$missingRequiredArgsContentString_u24lambda_u246.append("Parameters required " + requiredArguments).append('\n');
        return stringBuilder.toString();
    }
}

