/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.viewhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.api.ViewHierarchyTreeNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0002\n\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter;", "", "screenWidth", "", "screenHeight", "<init>", "(II)V", "filterInteractableViewHierarchyTreeNodes", "Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "viewHierarchy", "Bounds", "Companion", "trailblaze-models"})
public final class ViewHierarchyFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int screenWidth;
    private final int screenHeight;

    public ViewHierarchyFilter(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @NotNull
    public final ViewHierarchyTreeNode filterInteractableViewHierarchyTreeNodes(@NotNull ViewHierarchyTreeNode viewHierarchy) {
        Intrinsics.checkNotNullParameter((Object)viewHierarchy, (String)"viewHierarchy");
        Bounds bounds = viewHierarchy.getBounds();
        if (bounds == null) {
            bounds = new Bounds(0, 0, this.screenWidth, this.screenHeight);
        }
        Bounds rootBounds = bounds;
        List visibleViewHierarchyTreeNodes = ViewHierarchyFilter.Companion.findVisibleViewHierarchyTreeNodes(viewHierarchy.aggregate(), rootBounds);
        List interactableViewHierarchyTreeNodes = ViewHierarchyFilter.Companion.findInteractableViewHierarchyTreeNodes(visibleViewHierarchyTreeNodes);
        String string = this.screenWidth / 2 + "," + this.screenHeight / 2;
        String string2 = this.screenWidth + "x" + this.screenHeight;
        return new ViewHierarchyTreeNode(0L, null, string, false, interactableViewHierarchyTreeNodes, null, false, string2, false, false, false, false, false, null, false, false, null, 0, null, 524139, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\""}, d2={"Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Bounds;", "", "x1", "", "y1", "x2", "y2", "<init>", "(IIII)V", "getX1", "()I", "getY1", "getX2", "getY2", "width", "getWidth", "height", "getHeight", "centerX", "getCenterX", "centerY", "getCenterY", "contains", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "toString", "", "trailblaze-models"})
    public static final class Bounds {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;
        private final int width;
        private final int height;
        private final int centerX;
        private final int centerY;

        public Bounds(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.width = this.x2 - this.x1;
            this.height = this.y2 - this.y1;
            this.centerX = this.x1 + this.width / 2;
            this.centerY = this.y1 + this.height / 2;
        }

        public final int getX1() {
            return this.x1;
        }

        public final int getY1() {
            return this.y1;
        }

        public final int getX2() {
            return this.x2;
        }

        public final int getY2() {
            return this.y2;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getCenterX() {
            return this.centerX;
        }

        public final int getCenterY() {
            return this.centerY;
        }

        public final boolean contains(@NotNull Bounds other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.x1 <= other.x1 && this.y1 <= other.y1 && this.x2 >= other.x2 && this.y2 >= other.y2;
        }

        public final int component1() {
            return this.x1;
        }

        public final int component2() {
            return this.y1;
        }

        public final int component3() {
            return this.x2;
        }

        public final int component4() {
            return this.y2;
        }

        @NotNull
        public final Bounds copy(int x1, int y1, int x2, int y2) {
            return new Bounds(x1, y1, x2, y2);
        }

        public static /* synthetic */ Bounds copy$default(Bounds bounds, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = bounds.x1;
            }
            if ((n5 & 2) != 0) {
                n2 = bounds.y1;
            }
            if ((n5 & 4) != 0) {
                n3 = bounds.x2;
            }
            if ((n5 & 8) != 0) {
                n4 = bounds.y2;
            }
            return bounds.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Bounds(x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x1);
            result = result * 31 + Integer.hashCode(this.y1);
            result = result * 31 + Integer.hashCode(this.x2);
            result = result * 31 + Integer.hashCode(this.y2);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bounds)) {
                return false;
            }
            Bounds bounds = (Bounds)other;
            if (this.x1 != bounds.x1) {
                return false;
            }
            if (this.y1 != bounds.y1) {
                return false;
            }
            if (this.x2 != bounds.x2) {
                return false;
            }
            return this.y2 == bounds.y2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\n\u0010\b\u001a\u00020\t*\u00020\u0006JH\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fJ\f\u0010\u001b\u001a\u00020\t*\u00020\u0006H\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fJ\f\u0010\u001f\u001a\u00020\t*\u00020\u0006H\u0002J\f\u0010 \u001a\u00020\t*\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u001e\u0010#\u001a\u00020$*\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0006J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010)\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0006H\u0002\u00a8\u0006+"}, d2={"Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Companion;", "", "<init>", "()V", "findInteractableViewHierarchyTreeNodes", "", "Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "elements", "isInteractable", "", "boundsOverlap", "left1", "", "top1", "right1", "bottom1", "left2", "top2", "right2", "bottom2", "findVisibleViewHierarchyTreeNodes", "screenBounds", "Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Bounds;", "getVisiblePercentage", "", "screenWidth", "screenHeight", "isOverlay", "filterOutOfBounds", "width", "height", "hasMeaningfulAttributes", "shouldBeIncluded", "isMeaningfulViewDfs", "node", "optimizeTree", "Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Companion$OptimizationResult;", "isRoot", "viewHierarchy", "collectAllClickableAndEnabledElements", "collectAllOptimizedNodes", "result", "OptimizationResult", "trailblaze-models"})
    @SourceDebugExtension(value={"SMAP\nViewHierarchyFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewHierarchyFilter.kt\nxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n774#2:433\n865#2,2:434\n774#2:436\n865#2,2:437\n1056#2:439\n774#2:440\n865#2,2:441\n1740#2,3:443\n1761#2,3:446\n1617#2,9:449\n1869#2:458\n1870#2:460\n1626#2:461\n1761#2,3:462\n1761#2,3:465\n774#2:468\n865#2,2:469\n1563#2:471\n1634#2,3:472\n1374#2:475\n1460#2,2:476\n1462#2,3:479\n1374#2:482\n1460#2,5:483\n1#3:459\n1#3:478\n*S KotlinDebug\n*F\n+ 1 ViewHierarchyFilter.kt\nxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Companion\n*L\n77#1:433\n77#1:434,2\n155#1:436\n155#1:437,2\n158#1:439\n162#1:440\n162#1:441,2\n202#1:443,3\n279#1:446,3\n299#1:449,9\n299#1:458\n299#1:460\n299#1:461\n321#1:462,3\n352#1:465,3\n367#1:468\n367#1:469,2\n368#1:471\n368#1:472,3\n369#1:475\n369#1:476,2\n369#1:479,3\n427#1:482\n427#1:483,5\n299#1:459\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<ViewHierarchyTreeNode> findInteractableViewHierarchyTreeNodes(List<ViewHierarchyTreeNode> elements) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = elements;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ViewHierarchyTreeNode elem = (ViewHierarchyTreeNode)element$iv$iv;
                boolean bl = false;
                if (!Companion.isInteractable(elem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List interactable = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Function1[] function1Array = new Function1[]{Companion::findInteractableViewHierarchyTreeNodes$lambda$1, Companion::findInteractableViewHierarchyTreeNodes$lambda$2, Companion::findInteractableViewHierarchyTreeNodes$lambda$3, Companion::findInteractableViewHierarchyTreeNodes$lambda$4};
            CollectionsKt.sortWith((List)interactable, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
            return interactable;
        }

        public final boolean isInteractable(@NotNull ViewHierarchyTreeNode $this$isInteractable) {
            Intrinsics.checkNotNullParameter((Object)$this$isInteractable, (String)"<this>");
            ViewHierarchyTreeNode elem = $this$isInteractable;
            if (elem.getEnabled()) {
                if (elem.getClickable() || elem.getSelected() || elem.getFocusable() || elem.getScrollable()) {
                    return true;
                }
                String string = elem.getText();
                boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
                if (bl) {
                    return true;
                }
                String string2 = elem.getAccessibilityText();
                boolean bl2 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                if (bl2) {
                    return true;
                }
            }
            return false;
        }

        private final boolean boundsOverlap(int left1, int top1, int right1, int bottom1, int left2, int top2, int right2, int bottom2) {
            if (right1 <= left2 || right2 <= left1) {
                return false;
            }
            return bottom1 > top2 && bottom2 > top1;
        }

        /*
         * Unable to fully structure code
         */
        private final List<ViewHierarchyTreeNode> findVisibleViewHierarchyTreeNodes(List<ViewHierarchyTreeNode> elements, Bounds screenBounds) {
            var4_3 = elements;
            $i$f$filter = false;
            var6_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                elem = (ViewHierarchyTreeNode)element$iv$iv;
                $i$a$-filter-ViewHierarchyFilter$Companion$findVisibleViewHierarchyTreeNodes$overlays$1 = false;
                bool = ViewHierarchyFilter.Companion.isOverlay(elem);
                if (!bool) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$sortedBy = false;
            overlays = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ViewHierarchyTreeNode it = (ViewHierarchyTreeNode)a;
                    boolean bl = false;
                    Bounds bounds = it.getBounds();
                    it = (ViewHierarchyTreeNode)b;
                    Comparable comparable = bounds != null ? Integer.valueOf(bounds.getY1()) : null;
                    bl = false;
                    Bounds bounds2 = it.getBounds();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(bounds2 != null ? Integer.valueOf(bounds2.getY1()) : null));
                }
            });
            $i$f$sortedBy = elements;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                elem = (ViewHierarchyTreeNode)element$iv$iv;
                $i$a$-filter-ViewHierarchyFilter$Companion$findVisibleViewHierarchyTreeNodes$candidates$1 = false;
                if (!(elem.getBounds() != null && screenBounds.contains(elem.getBounds()) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            var6_8 = ((Collection)overlays).size();
            for (i = 0; i < var6_8; ++i) {
                overlay = (ViewHierarchyTreeNode)overlays.get(i);
                remaining = new ArrayList<E>();
                for (ViewHierarchyTreeNode elem : candidates) {
                    v0 = elem.getResourceId();
                    if (v0 == null) ** GOTO lbl-1000
                    v1 = v0.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                    v0 = v1;
                    if (v1 != null) {
                        v2 = StringsKt.contains$default((CharSequence)v0, (CharSequence)"systemui", (boolean)false, (int)2, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (v2) {
                        remaining.add(elem);
                        continue;
                    }
                    isOverlayViewHierarchyTreeNode = false;
                    for (ViewHierarchyTreeNode aboveOverlay : overlays.subList(i, overlays.size())) {
                        if (!Intrinsics.areEqual((Object)elem.getResourceId(), (Object)aboveOverlay.getResourceId()) && !Intrinsics.areEqual((Object)elem.getContainerId(), (Object)aboveOverlay.getResourceId())) {
                            if (elem.getContainerId() == null || aboveOverlay.getResourceId() == null || !(((CharSequence)aboveOverlay.getResourceId()).length() > 0)) continue;
                            v3 = elem.getContainerId();
                            Intrinsics.checkNotNull((Object)v3);
                            if (!StringsKt.contains$default((CharSequence)v3, (CharSequence)aboveOverlay.getResourceId(), (boolean)false, (int)2, null)) continue;
                        }
                        isOverlayViewHierarchyTreeNode = true;
                        break;
                    }
                    if (isOverlayViewHierarchyTreeNode) {
                        remaining.add(elem);
                        continue;
                    }
                    if (elem.getBounds() != null) {
                        block20: {
                            $this$all$iv = overlays.subList(i, overlays.size());
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v4 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    o = (ViewHierarchyTreeNode)element$iv;
                                    $i$a$-all-ViewHierarchyFilter$Companion$findVisibleViewHierarchyTreeNodes$1 = false;
                                    v5 = o.getBounds();
                                    if (elem.getBounds().getY2() == (v5 != null ? v5.getY1() : 0)) continue;
                                    v4 = false;
                                    break block20;
                                }
                                v4 = true;
                            }
                        }
                        if (v4) {
                            remaining.add(elem);
                            continue;
                        }
                    }
                    if ((v6 = overlay.getResourceId()) == null) ** GOTO lbl-1000
                    v7 = v6.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toLowerCase(...)");
                    v6 = v7;
                    if (v7 != null) {
                        v8 = StringsKt.contains$default((CharSequence)v6, (CharSequence)"sheet_container", (boolean)false, (int)2, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    if (v8) {
                        v9 = overlay.getResourceId().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toLowerCase(...)");
                        if (!StringsKt.contains$default((CharSequence)v9, (CharSequence)"root", (boolean)false, (int)2, null)) {
                            if (Intrinsics.areEqual((Object)elem.getContainerId(), (Object)overlay.getResourceId()) || Intrinsics.areEqual((Object)elem.getResourceId(), (Object)overlay.getResourceId())) {
                                remaining.add(elem);
                                continue;
                            }
                            if (elem.getBounds() != null && overlay.getBounds() != null && this.boundsOverlap(elem.getBounds().getX1(), elem.getBounds().getY1(), elem.getBounds().getX2(), elem.getBounds().getY2(), overlay.getBounds().getX1(), overlay.getBounds().getY1(), overlay.getBounds().getX2(), overlay.getBounds().getY2())) continue;
                        }
                    }
                    remaining.add(elem);
                }
                candidates = remaining;
            }
            return candidates;
        }

        public final double getVisiblePercentage(@NotNull Bounds $this$getVisiblePercentage, int screenWidth, int screenHeight) {
            boolean overflow;
            Intrinsics.checkNotNullParameter((Object)$this$getVisiblePercentage, (String)"<this>");
            Bounds bounds = $this$getVisiblePercentage;
            if (bounds.getWidth() == 0 && bounds.getHeight() == 0) {
                return 0.0;
            }
            boolean bl = overflow = bounds.getX1() <= 0 && bounds.getY1() <= 0 && bounds.getX1() + bounds.getWidth() >= screenWidth && bounds.getY1() + bounds.getHeight() >= screenHeight;
            if (overflow) {
                return 1.0;
            }
            int visibleX = Math.max(0, Math.min(bounds.getX1() + bounds.getWidth(), screenWidth) - Math.max(bounds.getX1(), 0));
            int visibleY = Math.max(0, Math.min(bounds.getY1() + bounds.getHeight(), screenHeight) - Math.max(bounds.getY1(), 0));
            int visibleArea = visibleX * visibleY;
            int totalArea = bounds.getWidth() * bounds.getHeight();
            return (double)visibleArea / (double)totalArea;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isOverlay(ViewHierarchyTreeNode $this$isOverlay) {
            block4: {
                block5: {
                    element = $this$isOverlay;
                    var4_3 = new String[]{"root", "system", "content"};
                    $this$any$iv = CollectionsKt.listOf((Object[])var4_3);
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block5;
                    v0 = false;
                    break block4;
                }
                for (T element$iv : $this$any$iv) {
                    keyword = (String)element$iv;
                    $i$a$-any-ViewHierarchyFilter$Companion$isOverlay$isRootOrSystemOrContent$1 = false;
                    v1 = element.getResourceId();
                    if (v1 == null) ** GOTO lbl-1000
                    v2 = v1.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                    v1 = v2;
                    if (v2 != null) {
                        v3 = StringsKt.contains$default((CharSequence)v1, (CharSequence)keyword, (boolean)false, (int)2, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v0 = true;
                    break block4;
                }
                v0 = isRootOrSystemOrContent = false;
            }
            if (isRootOrSystemOrContent) {
                return false;
            }
            v4 = element.getClassName();
            return v4 != null ? StringsKt.contains$default((CharSequence)v4, (CharSequence)"FrameLayout", (boolean)false, (int)2, null) : false;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ViewHierarchyTreeNode filterOutOfBounds(@NotNull ViewHierarchyTreeNode $this$filterOutOfBounds, int width, int height) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$filterOutOfBounds, (String)"<this>");
            if ($this$filterOutOfBounds.getIgnoreBoundsFiltering()) {
                return $this$filterOutOfBounds;
            }
            Iterable $this$mapNotNull$iv = $this$filterOutOfBounds.getChildren();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ViewHierarchyTreeNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ViewHierarchyTreeNode it = (ViewHierarchyTreeNode)element$iv$iv;
                boolean bl2 = false;
                if (Companion.filterOutOfBounds(it, width, height) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List filtered = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            Bounds bounds = $this$filterOutOfBounds.getBounds();
            double visiblePercentage = bounds != null ? this.getVisiblePercentage(bounds, width, height) : 0.0;
            return visiblePercentage < 0.1 && filtered.isEmpty() ? null : $this$filterOutOfBounds;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasMeaningfulAttributes(ViewHierarchyTreeNode $this$hasMeaningfulAttributes) {
            boolean bl;
            block3: {
                void $this$any$iv;
                ViewHierarchyTreeNode $this$hasMeaningfulAttributes_u24lambda_u2412 = $this$hasMeaningfulAttributes;
                boolean bl2 = false;
                Object object = new String[]{$this$hasMeaningfulAttributes_u24lambda_u2412.getText(), $this$hasMeaningfulAttributes_u24lambda_u2412.getAccessibilityText()};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string = it;
                        boolean bl4 = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
                        if (!bl4) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean shouldBeIncluded(ViewHierarchyTreeNode $this$shouldBeIncluded) {
            boolean bl;
            boolean bl2;
            ViewHierarchyTreeNode $this$shouldBeIncluded_u24lambda_u2413 = $this$shouldBeIncluded;
            boolean bl3 = false;
            String string = $this$shouldBeIncluded_u24lambda_u2413.getResourceId();
            if (string == null) {
                bl2 = true;
            } else {
                boolean hasNotNeededId;
                String resourceId = string;
                boolean bl4 = hasNotNeededId = StringsKt.contains$default((CharSequence)resourceId, (CharSequence)"status_bar_container", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)resourceId, (CharSequence)"status_bar_launch_animation_container", (boolean)false, (int)2, null);
                bl2 = !hasNotNeededId;
            }
            boolean isOkResourceId = bl2;
            Bounds bounds = $this$shouldBeIncluded.getBounds();
            if (bounds != null) {
                Bounds it = bounds;
                boolean bl5 = false;
                bl = it.getWidth() == 0 && it.getHeight() == 0;
            } else {
                bl = false;
            }
            boolean isVisibleRectView = bl;
            return isOkResourceId && isVisibleRectView;
        }

        private final boolean isMeaningfulViewDfs(ViewHierarchyTreeNode node) {
            boolean bl;
            block4: {
                if (this.hasMeaningfulAttributes(node) || node.getClickable()) {
                    return true;
                }
                Iterable $this$any$iv = node.getChildren();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ViewHierarchyTreeNode it = (ViewHierarchyTreeNode)element$iv;
                        boolean bl2 = false;
                        if (!Companion.isMeaningfulViewDfs(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final OptimizationResult optimizeTree(ViewHierarchyTreeNode $this$optimizeTree, boolean isRoot, ViewHierarchyTreeNode viewHierarchy) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ViewHierarchyTreeNode it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = $this$optimizeTree.getChildren();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ViewHierarchyTreeNode)element$iv$iv;
                boolean bl = false;
                if (!(Companion.shouldBeIncluded(it) && Companion.isMeaningfulViewDfs(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ViewHierarchyTreeNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.optimizeTree(it, false, viewHierarchy));
            }
            List childResults = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = childResults;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Object object;
                block10: {
                    OptimizationResult it2;
                    block9: {
                        it2 = (OptimizationResult)element$iv$iv;
                        boolean bl = false;
                        object = it2.getNode();
                        if (object == null) break block9;
                        ViewHierarchyTreeNode node = object;
                        boolean bl2 = false;
                        List list = CollectionsKt.listOf((Object)node);
                        object = list;
                        if (list != null) break block10;
                    }
                    object = it2.getPromotedChildren();
                }
                Iterable list$iv$iv = (Iterable)object;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List optimizedChildren = (List)destination$iv$iv2;
            if (isRoot) {
                return new OptimizationResult(ViewHierarchyTreeNode.copy$default($this$optimizeTree, 0L, null, null, false, optimizedChildren, null, false, null, false, false, false, false, false, null, false, false, null, 0, null, 524271, null), CollectionsKt.emptyList());
            }
            boolean hasContentInThisNode = this.hasMeaningfulAttributes($this$optimizeTree);
            if (hasContentInThisNode) {
                return new OptimizationResult(ViewHierarchyTreeNode.copy$default($this$optimizeTree, 0L, null, null, false, optimizedChildren, null, false, null, false, false, false, false, false, null, false, false, null, 0, null, 524271, null), CollectionsKt.emptyList());
            }
            if (optimizedChildren.isEmpty()) {
                return new OptimizationResult(null, CollectionsKt.emptyList());
            }
            boolean isSingleChild = optimizedChildren.size() == 1;
            return isSingleChild ? new OptimizationResult((ViewHierarchyTreeNode)CollectionsKt.single((List)optimizedChildren), CollectionsKt.emptyList()) : new OptimizationResult(null, optimizedChildren);
        }

        static /* synthetic */ OptimizationResult optimizeTree$default(Companion companion, ViewHierarchyTreeNode viewHierarchyTreeNode, boolean bl, ViewHierarchyTreeNode viewHierarchyTreeNode2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.optimizeTree(viewHierarchyTreeNode, bl, viewHierarchyTreeNode2);
        }

        @NotNull
        public final List<ViewHierarchyTreeNode> collectAllClickableAndEnabledElements(@NotNull ViewHierarchyTreeNode $this$collectAllClickableAndEnabledElements) {
            Intrinsics.checkNotNullParameter((Object)$this$collectAllClickableAndEnabledElements, (String)"<this>");
            List result = new ArrayList();
            if ($this$collectAllClickableAndEnabledElements.getClickable() && $this$collectAllClickableAndEnabledElements.getEnabled()) {
                result.add($this$collectAllClickableAndEnabledElements);
            }
            for (ViewHierarchyTreeNode child : $this$collectAllClickableAndEnabledElements.getChildren()) {
                result.addAll((Collection)this.collectAllClickableAndEnabledElements(child));
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ViewHierarchyTreeNode> collectAllOptimizedNodes(OptimizationResult result, ViewHierarchyTreeNode viewHierarchy) {
            Object object;
            block4: {
                void $this$flatMapTo$iv$iv;
                block3: {
                    object = result.getNode();
                    if (object == null) break block3;
                    ViewHierarchyTreeNode it = object;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)it);
                    object = list;
                    if (list != null) break block4;
                }
                Iterable $this$flatMap$iv = result.getPromotedChildren();
                boolean $i$f$flatMap = false;
                Iterable bl = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ViewHierarchyTreeNode child = (ViewHierarchyTreeNode)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = Companion.collectAllOptimizedNodes(Companion.optimizeTree(child, false, viewHierarchy), viewHierarchy);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = (List)destination$iv$iv;
            }
            return object;
        }

        private static final Comparable findInteractableViewHierarchyTreeNodes$lambda$1(ViewHierarchyTreeNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getText();
            return Boolean.valueOf(!(string != null ? ((CharSequence)string).length() > 0 : false));
        }

        private static final Comparable findInteractableViewHierarchyTreeNodes$lambda$2(ViewHierarchyTreeNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getResourceId();
            return Boolean.valueOf(!(string != null ? ((CharSequence)string).length() > 0 : false));
        }

        private static final Comparable findInteractableViewHierarchyTreeNodes$lambda$3(ViewHierarchyTreeNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getAccessibilityText();
            return Boolean.valueOf(!(string != null ? ((CharSequence)string).length() > 0 : false));
        }

        private static final Comparable findInteractableViewHierarchyTreeNodes$lambda$4(ViewHierarchyTreeNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Boolean.valueOf(true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lxyz/block/trailblaze/viewhierarchy/ViewHierarchyFilter$Companion$OptimizationResult;", "", "node", "Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "promotedChildren", "", "<init>", "(Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;Ljava/util/List;)V", "getNode", "()Lxyz/block/trailblaze/api/ViewHierarchyTreeNode;", "getPromotedChildren", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "trailblaze-models"})
        public static final class OptimizationResult {
            @Nullable
            private final ViewHierarchyTreeNode node;
            @NotNull
            private final List<ViewHierarchyTreeNode> promotedChildren;

            public OptimizationResult(@Nullable ViewHierarchyTreeNode node, @NotNull List<ViewHierarchyTreeNode> promotedChildren) {
                Intrinsics.checkNotNullParameter(promotedChildren, (String)"promotedChildren");
                this.node = node;
                this.promotedChildren = promotedChildren;
            }

            @Nullable
            public final ViewHierarchyTreeNode getNode() {
                return this.node;
            }

            @NotNull
            public final List<ViewHierarchyTreeNode> getPromotedChildren() {
                return this.promotedChildren;
            }

            @Nullable
            public final ViewHierarchyTreeNode component1() {
                return this.node;
            }

            @NotNull
            public final List<ViewHierarchyTreeNode> component2() {
                return this.promotedChildren;
            }

            @NotNull
            public final OptimizationResult copy(@Nullable ViewHierarchyTreeNode node, @NotNull List<ViewHierarchyTreeNode> promotedChildren) {
                Intrinsics.checkNotNullParameter(promotedChildren, (String)"promotedChildren");
                return new OptimizationResult(node, promotedChildren);
            }

            public static /* synthetic */ OptimizationResult copy$default(OptimizationResult optimizationResult, ViewHierarchyTreeNode viewHierarchyTreeNode, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    viewHierarchyTreeNode = optimizationResult.node;
                }
                if ((n & 2) != 0) {
                    list = optimizationResult.promotedChildren;
                }
                return optimizationResult.copy(viewHierarchyTreeNode, list);
            }

            @NotNull
            public String toString() {
                return "OptimizationResult(node=" + this.node + ", promotedChildren=" + this.promotedChildren + ")";
            }

            public int hashCode() {
                int result = this.node == null ? 0 : this.node.hashCode();
                result = result * 31 + ((Object)this.promotedChildren).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OptimizationResult)) {
                    return false;
                }
                OptimizationResult optimizationResult = (OptimizationResult)other;
                if (!Intrinsics.areEqual((Object)this.node, (Object)optimizationResult.node)) {
                    return false;
                }
                return Intrinsics.areEqual(this.promotedChildren, optimizationResult.promotedChildren);
            }
        }
    }
}

