/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.agent.model.AgentTaskStatus;
import xyz.block.trailblaze.llm.LlmUsageAndCostExt;
import xyz.block.trailblaze.logs.client.TrailblazeJsonInstanceKt;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.model.HasAgentTaskStatus;
import xyz.block.trailblaze.logs.model.HasScreenshot;
import xyz.block.trailblaze.report.ReportRenderer;
import xyz.block.trailblaze.report.models.LogsSummary;
import xyz.block.trailblaze.report.utils.LogsRepo;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "moveJsonFilesToSessionDirs", "logsDir", "Ljava/io/File;", "processSession", "logsRepo", "Lxyz/block/trailblaze/report/utils/LogsRepo;", "sessionId", "renderSummary", "Lxyz/block/trailblaze/report/models/LogsSummary;", "isStandaloneFileReport", "", "getStatusMessage", "agentTaskStatus", "Lxyz/block/trailblaze/agent/model/AgentTaskStatus;", "trailblaze-report"})
@SourceDebugExtension(value={"SMAP\nReportMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportMain.kt\nxyz/block/trailblaze/report/ReportMainKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1869#2,2:143\n1869#2:148\n1870#2:151\n808#2,11:152\n1563#2:163\n1634#2,3:164\n1285#2,2:169\n1299#2,4:171\n3829#3:145\n4344#3,2:146\n222#4:149\n205#4:150\n205#4:167\n1#5:168\n*S KotlinDebug\n*F\n+ 1 ReportMain.kt\nxyz/block/trailblaze/report/ReportMainKt\n*L\n38#1:143,2\n45#1:148\n45#1:151\n90#1:152,11\n90#1:163\n90#1:164,3\n114#1:169,2\n114#1:171,4\n44#1:145\n44#1:146,2\n47#1:149\n79#1:150\n98#1:167\n*E\n"})
public final class ReportMainKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        File logsDir = new File(args[0]);
        System.out.println((Object)("logsDir: " + logsDir.getCanonicalPath()));
        LogsRepo logsRepo = new LogsRepo(logsDir);
        ReportMainKt.moveJsonFilesToSessionDirs(logsDir);
        boolean standaloneFileReport = true;
        LogsSummary logsSummaryEvents = ReportMainKt.renderSummary(logsRepo, standaloneFileReport);
        String logsSummaryJson = TrailblazeJsonInstanceKt.getTrailblazeJsonInstance().encodeToString((SerializationStrategy)LogsSummary.Companion.serializer(), (Object)logsSummaryEvents);
        File summaryJsonFile = new File(logsDir, "summary.json");
        FilesKt.writeText$default((File)summaryJsonFile, (String)logsSummaryJson, null, (int)2, null);
        File trailblazeReportHtmlFile = new File(logsDir, "trailblaze_report.html");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"summaryJson", (Object)logsSummaryJson)};
        String html = ReportRenderer.INSTANCE.renderTemplateFromResources("trailblaze_report.ftl", MapsKt.mutableMapOf((Pair[])pairArray));
        System.out.println((Object)("file://" + trailblazeReportHtmlFile.getAbsolutePath()));
        FilesKt.writeText$default((File)trailblazeReportHtmlFile, (String)html, null, (int)2, null);
        Iterable $this$forEach$iv = logsRepo.getSessionIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String sessionId = (String)element$iv;
            boolean bl = false;
            ReportMainKt.processSession(logsRepo, sessionId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void moveJsonFilesToSessionDirs(@NotNull File logsDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        File[] fileArray = logsDir.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List jsonFilesInLogsDir = list;
        Iterable $this$forEach$iv = jsonFilesInLogsDir;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File downloadedJsonFile = (File)element$iv;
            boolean bl = false;
            try {
                void string$iv;
                void this_$iv;
                Json $i$f$filterTo = TrailblazeJsonInstanceKt.getTrailblazeJsonInstance();
                Intrinsics.checkNotNull((Object)downloadedJsonFile);
                String string = FilesKt.readText$default((File)downloadedJsonFile, null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                TrailblazeLog log = (TrailblazeLog)this_$iv.decodeFromString((DeserializationStrategy)TrailblazeLog.Companion.serializer(), (String)string$iv);
                downloadedJsonFile.delete();
                String sessionId = log.getSession();
                File sessionDir = new File(logsDir, sessionId);
                sessionDir.mkdirs();
                if (log instanceof HasScreenshot) {
                    if (((HasScreenshot)log).getScreenshotFile() != null) {
                        String screenshotFile;
                        boolean bl2 = false;
                        byte[] currentScreenshotFileBytes = FilesKt.readBytes((File)new File(logsDir, screenshotFile));
                        sessionDir.delete();
                        File destScreenshotFile = new File(sessionDir, screenshotFile);
                        FilesKt.writeBytes((File)destScreenshotFile, (byte[])currentScreenshotFileBytes);
                    }
                    String screenshotFileInSessionDirPath = sessionId + "/" + ((HasScreenshot)log).getScreenshotFile();
                    TrailblazeLog trailblazeLog = log;
                    if (trailblazeLog instanceof TrailblazeLog.MaestroDriverLog) {
                        TrailblazeLog.MaestroDriverLog.copy$default((TrailblazeLog.MaestroDriverLog)((TrailblazeLog.MaestroDriverLog)log), null, (String)screenshotFileInSessionDirPath, null, (long)0L, null, null, (int)0, (int)0, (int)253, null);
                    } else if (trailblazeLog instanceof TrailblazeLog.TrailblazeLlmRequestLog) {
                        TrailblazeLog.TrailblazeLlmRequestLog.copy$default((TrailblazeLog.TrailblazeLlmRequestLog)((TrailblazeLog.TrailblazeLlmRequestLog)log), null, null, null, null, null, null, null, (String)screenshotFileInSessionDirPath, (long)0L, null, null, null, (int)0, (int)0, (int)16255, null);
                    }
                }
                File outputFile = new File(sessionDir, FilesKt.getNameWithoutExtension((File)downloadedJsonFile) + log.getClass().getSimpleName() + ".json");
                Json this_$iv2 = TrailblazeJsonInstanceKt.getTrailblazeJsonInstance();
                boolean $i$f$encodeToString = false;
                this_$iv2.getSerializersModule();
                FilesKt.writeText$default((File)outputFile, (String)this_$iv2.encodeToString((SerializationStrategy)TrailblazeLog.Companion.serializer(), (Object)log), null, (int)2, null);
                System.out.println((Object)("Deleting " + downloadedJsonFile.getCanonicalPath()));
            }
            catch (Exception e) {
                System.out.println((Object)("Error processing " + downloadedJsonFile.getAbsolutePath() + ": " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void processSession(@NotNull LogsRepo logsRepo, @NotNull String sessionId) {
        File file;
        Object object;
        void $this$processSession_u24lambda_u247;
        Object object2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)logsRepo, (String)"logsRepo");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        List<TrailblazeLog> allLogs = logsRepo.getLogsForSession(sessionId);
        Iterable $this$filterIsInstance$iv = allLogs;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HasAgentTaskStatus)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HasAgentTaskStatus hasAgentTaskStatus = (HasAgentTaskStatus)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(it.getAgentTaskStatus());
        }
        AgentTaskStatus agentTaskStatus = (AgentTaskStatus)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
        System.out.println((Object)("Processing " + sessionId));
        Object $i$f$map22 = new Pair[5];
        $i$f$map22[0] = TuplesKt.to((Object)"statusMessage", (Object)ReportMainKt.getStatusMessage(agentTaskStatus));
        $i$f$map22[1] = TuplesKt.to((Object)"inProgress", (Object)(agentTaskStatus instanceof AgentTaskStatus.InProgress));
        Object this_$iv = TrailblazeJsonInstanceKt.getTrailblazeJsonInstance();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        $i$f$map22[2] = TuplesKt.to((Object)"statusJson", (Object)this_$iv.encodeToString((SerializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)AgentTaskStatus.Companion.serializer()), (Object)agentTaskStatus));
        $i$f$map22[3] = TuplesKt.to((Object)"logs", allLogs);
        $i$f$map22[4] = TuplesKt.to((Object)"session", (Object)sessionId);
        this_$iv = $i$f$map22 = MapsKt.mutableMapOf((Pair[])$i$f$map22);
        String string = "standalone.ftl";
        object2 = ReportRenderer.INSTANCE;
        boolean bl = false;
        AgentTaskStatus agentTaskStatus2 = agentTaskStatus;
        if (agentTaskStatus2 != null && (agentTaskStatus2 = agentTaskStatus2.getStatusData()) != null) {
            AgentTaskStatus it = agentTaskStatus2;
            boolean bl2 = false;
            $this$processSession_u24lambda_u247.put("status", it);
        }
        if ((object = LlmUsageAndCostExt.INSTANCE.computeUsageSummary(allLogs)) != null && (object = object.debugString()) != null) {
            Object it = object;
            boolean bl3 = false;
            $this$processSession_u24lambda_u247.put("llmUsageSummary", it);
        }
        Unit unit = Unit.INSTANCE;
        String html = ((ReportRenderer)object2).renderTemplateFromResources(string, (Map<String, ? extends Object>)$i$f$map22);
        File sessionDir = logsRepo.getSessionDir(sessionId);
        File it = file = new File(sessionDir, "trailblaze_" + sessionId + ".html");
        boolean bl4 = false;
        System.out.println((Object)("file://" + it.getAbsolutePath()));
        FilesKt.writeText$default((File)it, (String)html, null, (int)2, null);
        File outputFile = file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LogsSummary renderSummary(@NotNull LogsRepo logsRepo, boolean isStandaloneFileReport) {
        Intrinsics.checkNotNullParameter((Object)logsRepo, (String)"logsRepo");
        Iterable $this$associateWith$iv = logsRepo.getSessionIds();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List<TrailblazeLog> list = logsRepo.getLogsForSession((String)it);
            map.put(t, list);
        }
        Map map = result$iv;
        LogsSummary logsSummary = LogsSummary.Companion.fromLogs(map, isStandaloneFileReport);
        return logsSummary;
    }

    @NotNull
    public static final String getStatusMessage(@Nullable AgentTaskStatus agentTaskStatus) {
        Object object;
        AgentTaskStatus agentTaskStatus2 = agentTaskStatus;
        if (agentTaskStatus2 instanceof AgentTaskStatus.Failure.MaxCallsLimitReached) {
            StringBuilder stringBuilder;
            StringBuilder $this$getStatusMessage_u24lambda_u2410 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getStatusMessage_u24lambda_u2410.append("Failed, Maximum Calls Limit Reached " + ((AgentTaskStatus.Failure.MaxCallsLimitReached)agentTaskStatus).getStatusData().getCallCount());
            $this$getStatusMessage_u24lambda_u2410.append(" in " + ((AgentTaskStatus.Failure.MaxCallsLimitReached)agentTaskStatus).getStatusData().getTotalDurationMs() / (long)1000 + " seconds");
            object = stringBuilder.toString();
        } else if (agentTaskStatus2 instanceof AgentTaskStatus.Failure.ObjectiveFailed) {
            StringBuilder stringBuilder;
            StringBuilder $this$getStatusMessage_u24lambda_u2411 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getStatusMessage_u24lambda_u2411.append("Objective Failed after " + ((AgentTaskStatus.Failure.ObjectiveFailed)agentTaskStatus).getStatusData().getCallCount() + " Calls");
            $this$getStatusMessage_u24lambda_u2411.append(" in " + ((AgentTaskStatus.Failure.ObjectiveFailed)agentTaskStatus).getStatusData().getTotalDurationMs() / (long)1000 + " seconds");
            $this$getStatusMessage_u24lambda_u2411.append(" with agent reason: \"" + ((AgentTaskStatus.Failure.ObjectiveFailed)agentTaskStatus).getLlmExplanation() + "\"");
            object = stringBuilder.toString();
        } else if (agentTaskStatus2 instanceof AgentTaskStatus.InProgress) {
            object = "Running, " + ((AgentTaskStatus.InProgress)agentTaskStatus).getStatusData().getCallCount() + " LLM Requests so far. ";
        } else if (agentTaskStatus2 instanceof AgentTaskStatus.Success.ObjectiveComplete) {
            StringBuilder stringBuilder;
            StringBuilder $this$getStatusMessage_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getStatusMessage_u24lambda_u2412.append("Successfully Completed after " + ((AgentTaskStatus.Success.ObjectiveComplete)agentTaskStatus).getStatusData().getCallCount() + " Calls");
            $this$getStatusMessage_u24lambda_u2412.append(" in " + ((AgentTaskStatus.Success.ObjectiveComplete)agentTaskStatus).getStatusData().getTotalDurationMs() / (long)1000 + " seconds");
            $this$getStatusMessage_u24lambda_u2412.append(" with agent reason: \"" + ((AgentTaskStatus.Success.ObjectiveComplete)agentTaskStatus).getLlmExplanation() + "\"");
            object = stringBuilder.toString();
        } else if (agentTaskStatus2 == null) {
            object = "Session Not Found";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }
}

