/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.report.utils;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0016B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lxyz/block/trailblaze/report/utils/FileWatchService;", "", "dirToWatch", "Ljava/io/File;", "onFileChange", "Lkotlin/Function2;", "Lxyz/block/trailblaze/report/utils/FileWatchService$ChangeType;", "", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "eventTypes", "", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "watchService", "Ljava/nio/file/WatchService;", "getWatchService", "()Ljava/nio/file/WatchService;", "stopWatching", "startWatching", "ChangeType", "trailblaze-report"})
@SourceDebugExtension(value={"SMAP\nFileWatchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatchService.kt\nxyz/block/trailblaze/report/utils/FileWatchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n37#3:83\n36#3,3:84\n*S KotlinDebug\n*F\n+ 1 FileWatchService.kt\nxyz/block/trailblaze/report/utils/FileWatchService\n*L\n49#1:79\n49#1:80,3\n49#1:83\n49#1:84,3\n*E\n"})
public final class FileWatchService {
    @NotNull
    private final File dirToWatch;
    @NotNull
    private final Function2<ChangeType, File, Unit> onFileChange;
    @NotNull
    private final List<ChangeType> eventTypes;
    @NotNull
    private final Path path;
    @NotNull
    private final WatchService watchService;

    public FileWatchService(@NotNull File dirToWatch, @NotNull Function2<? super ChangeType, ? super File, Unit> onFileChange) {
        Intrinsics.checkNotNullParameter((Object)dirToWatch, (String)"dirToWatch");
        Intrinsics.checkNotNullParameter(onFileChange, (String)"onFileChange");
        this.dirToWatch = dirToWatch;
        this.onFileChange = onFileChange;
        ChangeType[] changeTypeArray = new ChangeType[]{ChangeType.CREATE, ChangeType.DELETE, ChangeType.MODIFY};
        this.eventTypes = CollectionsKt.listOf((Object[])changeTypeArray);
        Path path = Paths.get(this.dirToWatch.getCanonicalPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.path = path;
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"newWatchService(...)");
        this.watchService = watchService;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final WatchService getWatchService() {
        return this.watchService;
    }

    public final void stopWatching() {
        this.watchService.close();
        System.out.println((Object)("Stopped watching directory: " + this.path));
    }

    /*
     * WARNING - void declaration
     */
    public final void startWatching() {
        WatchKey key;
        boolean valid;
        Collection<WatchEvent.Kind<Path>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.eventTypes;
        WatchService watchService = this.watchService;
        Path path = this.path;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChangeType changeType = (ChangeType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getWatchEventKind());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        path.register(watchService, thisCollection$iv.toArray(new WatchEvent.Kind[0]), new WatchEvent.Modifier[0]);
        System.out.println((Object)("Watching directory: " + this.path));
        do {
            key = this.watchService.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                Object obj = event.context();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                Path filename = (Path)obj;
                File realChangedFile = new File(this.path.toFile(), PathsKt.getName((Path)filename));
                System.out.println((Object)("File Changed in " + this.dirToWatch + "! " + kind + " " + realChangedFile.getCanonicalPath()));
                Intrinsics.checkNotNull(kind);
                this.onFileChange.invoke((Object)ChangeType.Companion.fromWatchEventKind(kind), (Object)realChangedFile);
            }
        } while (valid = key.reset());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lxyz/block/trailblaze/report/utils/FileWatchService$ChangeType;", "", "watchEventKind", "Ljava/nio/file/WatchEvent$Kind;", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;ILjava/nio/file/WatchEvent$Kind;)V", "getWatchEventKind", "()Ljava/nio/file/WatchEvent$Kind;", "CREATE", "DELETE", "MODIFY", "Companion", "trailblaze-report"})
    public static final class ChangeType
    extends Enum<ChangeType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final WatchEvent.Kind<Path> watchEventKind;
        public static final /* enum */ ChangeType CREATE;
        public static final /* enum */ ChangeType DELETE;
        public static final /* enum */ ChangeType MODIFY;
        private static final /* synthetic */ ChangeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ChangeType(WatchEvent.Kind<Path> watchEventKind) {
            this.watchEventKind = watchEventKind;
        }

        @NotNull
        public final WatchEvent.Kind<Path> getWatchEventKind() {
            return this.watchEventKind;
        }

        public static ChangeType[] values() {
            return (ChangeType[])$VALUES.clone();
        }

        public static ChangeType valueOf(String value) {
            return Enum.valueOf(ChangeType.class, value);
        }

        @NotNull
        public static EnumEntries<ChangeType> getEntries() {
            return $ENTRIES;
        }

        static {
            WatchEvent.Kind<Path> kind = StandardWatchEventKinds.ENTRY_CREATE;
            Intrinsics.checkNotNullExpressionValue(kind, (String)"ENTRY_CREATE");
            CREATE = new ChangeType(kind);
            WatchEvent.Kind<Path> kind2 = StandardWatchEventKinds.ENTRY_DELETE;
            Intrinsics.checkNotNullExpressionValue(kind2, (String)"ENTRY_DELETE");
            DELETE = new ChangeType(kind2);
            WatchEvent.Kind<Path> kind3 = StandardWatchEventKinds.ENTRY_MODIFY;
            Intrinsics.checkNotNullExpressionValue(kind3, (String)"ENTRY_MODIFY");
            MODIFY = new ChangeType(kind3);
            $VALUES = changeTypeArray = new ChangeType[]{ChangeType.CREATE, ChangeType.DELETE, ChangeType.MODIFY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\u00a8\u0006\b"}, d2={"Lxyz/block/trailblaze/report/utils/FileWatchService$ChangeType$Companion;", "", "<init>", "()V", "fromWatchEventKind", "Lxyz/block/trailblaze/report/utils/FileWatchService$ChangeType;", "watchEventKind", "Ljava/nio/file/WatchEvent$Kind;", "trailblaze-report"})
        @SourceDebugExtension(value={"SMAP\nFileWatchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatchService.kt\nxyz/block/trailblaze/report/utils/FileWatchService$ChangeType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n230#2,2:79\n*S KotlinDebug\n*F\n+ 1 FileWatchService.kt\nxyz/block/trailblaze/report/utils/FileWatchService$ChangeType$Companion\n*L\n29#1:79,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ChangeType fromWatchEventKind(@NotNull WatchEvent.Kind<? extends Object> watchEventKind) {
                Object element$iv2;
                block1: {
                    Intrinsics.checkNotNullParameter(watchEventKind, (String)"watchEventKind");
                    Iterable $this$first$iv = (Iterable)ChangeType.getEntries();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ChangeType it = (ChangeType)((Object)element$iv2);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getWatchEventKind(), watchEventKind)) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                return (ChangeType)((Object)element$iv2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

