/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.report.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.logs.client.TrailblazeJsonInstanceKt;
import xyz.block.trailblaze.logs.client.TrailblazeLog;
import xyz.block.trailblaze.logs.model.SessionStatus;
import xyz.block.trailblaze.report.utils.FileWatchService;
import xyz.block.trailblaze.report.utils.TrailblazeSessionListener;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\nj\u0002`\u000bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\f\u0012\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/block/trailblaze/report/utils/LogsRepo;", "", "logsDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getLogsDir", "()Ljava/io/File;", "fileWatcherByTrailblazeSession", "", "", "Lxyz/block/trailblaze/report/utils/TrailblazeSessionId;", "Lxyz/block/trailblaze/report/utils/FileWatchService;", "getSessionDirs", "", "getSessionIds", "stopWatching", "", "trailblazeSessionId", "startWatchingTrailblazeSession", "trailblazeSessionListener", "Lxyz/block/trailblaze/report/utils/TrailblazeSessionListener;", "getLogsForSession", "Lxyz/block/trailblaze/logs/client/TrailblazeLog;", "sessionId", "clearLogs", "getSessionDir", "session", "trailblaze-report"})
@SourceDebugExtension(value={"SMAP\nLogsRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogsRepo.kt\nxyz/block/trailblaze/report/utils/LogsRepo\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n3829#2:127\n4344#2,2:128\n3829#2:135\n4344#2,2:136\n3829#2:153\n4344#2,2:154\n1068#3:130\n1563#3:131\n1634#3,3:132\n1617#3,9:138\n1869#3:147\n1870#3:150\n1626#3:151\n1056#3:152\n1869#3,2:156\n1056#3:158\n222#4:148\n1#5:149\n*S KotlinDebug\n*F\n+ 1 LogsRepo.kt\nxyz/block/trailblaze/report/utils/LogsRepo\n*L\n22#1:127\n22#1:128,2\n83#1:135\n83#1:136,2\n106#1:153\n106#1:154,2\n22#1:130\n24#1:131\n24#1:132,3\n84#1:138,9\n84#1:147\n84#1:150\n84#1:151\n93#1:152\n106#1:156,2\n47#1:158\n86#1:148\n84#1:149\n*E\n"})
public final class LogsRepo {
    @NotNull
    private final File logsDir;
    @NotNull
    private final Map<String, FileWatchService> fileWatcherByTrailblazeSession;

    public LogsRepo(@NotNull File logsDir) {
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        this.logsDir = logsDir;
        this.logsDir.mkdirs();
        this.fileWatcherByTrailblazeSession = new LinkedHashMap();
    }

    @NotNull
    public final File getLogsDir() {
        return this.logsDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getSessionDirs() {
        void $this$filterTo$iv$iv;
        File[] fileArray = this.logsDir.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSessionIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSessionDirs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    public final void stopWatching(@NotNull String trailblazeSessionId) {
        Intrinsics.checkNotNullParameter((Object)trailblazeSessionId, (String)"trailblazeSessionId");
        FileWatchService fileWatchService = this.fileWatcherByTrailblazeSession.get(trailblazeSessionId);
        if (fileWatchService != null) {
            fileWatchService.stopWatching();
        }
        this.fileWatcherByTrailblazeSession.remove(trailblazeSessionId);
    }

    public final void startWatchingTrailblazeSession(@NotNull TrailblazeSessionListener trailblazeSessionListener) {
        Intrinsics.checkNotNullParameter((Object)trailblazeSessionListener, (String)"trailblazeSessionListener");
        String trailblazeSessionId = trailblazeSessionListener.getTrailblazeSessionId();
        if (this.fileWatcherByTrailblazeSession.get(trailblazeSessionId) != null) {
            throw new IllegalStateException(("Already watching trailblaze session: " + trailblazeSessionId + ". This method would need to be supported to allow multiple listeners for the same session.").toString());
        }
        File sessionDir = this.getSessionDir(trailblazeSessionId);
        System.out.println((Object)("LOGLISTENER - Starting to watch trailblaze session: " + trailblazeSessionId + " " + sessionDir.getCanonicalPath()));
        FileWatchService fileWatchService = new FileWatchService(sessionDir, (Function2<? super FileWatchService.ChangeType, ? super File, Unit>)((Function2)(arg_0, arg_1) -> LogsRepo.startWatchingTrailblazeSession$lambda$4(this, trailblazeSessionId, trailblazeSessionListener, arg_0, arg_1)));
        this.fileWatcherByTrailblazeSession.put(trailblazeSessionId, fileWatchService);
        fileWatchService.startWatching();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TrailblazeLog> getLogsForSession(@Nullable String sessionId) {
        File sessionDir;
        if (sessionId != null && (sessionDir = new File(this.logsDir, sessionId)).exists()) {
            void $this$sortedBy$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            File[] fileArray = sessionDir.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            Object[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List jsonFiles = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = jsonFiles;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Json it$iv$iv;
                Json json;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                try {
                    void string$iv;
                    void this_$iv;
                    json = TrailblazeJsonInstanceKt.getTrailblazeJsonInstance();
                    Intrinsics.checkNotNull((Object)it);
                    String string = FilesKt.readText$default((File)it, null, (int)1, null);
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    json = (TrailblazeLog)this_$iv.decodeFromString((DeserializationStrategy)TrailblazeLog.Companion.serializer(), (String)string$iv);
                }
                catch (Exception e) {
                    System.out.println((Object)("Error Reading " + it.getAbsolutePath()));
                    json = null;
                }
                if (json == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedBy = false;
            List logs = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TrailblazeLog it = (TrailblazeLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getTimestamp();
                    it = (TrailblazeLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTimestamp()));
                }
            });
            return logs;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearLogs() {
        if (this.logsDir.exists()) {
            void $this$filterTo$iv$iv;
            File[] fileArray = this.logsDir.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            Object[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                FilesKt.deleteRecursively((File)it);
            }
        }
    }

    @NotNull
    public final File getSessionDir(@NotNull String session) {
        File sessionDir;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!this.logsDir.exists()) {
            this.logsDir.mkdirs();
        }
        if (!(sessionDir = new File(this.logsDir, session)).exists()) {
            sessionDir.mkdirs();
        }
        return sessionDir;
    }

    private static final Unit startWatchingTrailblazeSession$lambda$4(LogsRepo this$0, String $trailblazeSessionId, TrailblazeSessionListener $trailblazeSessionListener, FileWatchService.ChangeType changeType, File fileChanged) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        Intrinsics.checkNotNullParameter((Object)fileChanged, (String)"fileChanged");
        System.out.println((Object)("LOGLISTENER - " + changeType + " " + fileChanged));
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)fileChanged), (Object)"json")) {
            Iterable $this$sortedBy$iv = this$0.getLogsForSession($trailblazeSessionId);
            boolean $i$f$sortedBy = false;
            List logsForSession = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TrailblazeLog it = (TrailblazeLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getTimestamp();
                    it = (TrailblazeLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTimestamp()));
                }
            });
            if (logsForSession.size() == 1) {
                $trailblazeSessionListener.onSessionStarted();
                return Unit.INSTANCE;
            }
            TrailblazeLog mostRecentLog = (TrailblazeLog)CollectionsKt.lastOrNull((List)logsForSession);
            if (mostRecentLog instanceof TrailblazeLog.TrailblazeSessionStatusChangeLog && ((TrailblazeLog.TrailblazeSessionStatusChangeLog)mostRecentLog).getSessionStatus() instanceof SessionStatus.Ended) {
                $trailblazeSessionListener.onSessionEnded();
                this$0.stopWatching($trailblazeSessionId);
                return Unit.INSTANCE;
            }
            if (mostRecentLog != null) {
                $trailblazeSessionListener.onUpdate("Session Updated: " + mostRecentLog.getClass().getSimpleName() + " " + mostRecentLog.getTimestamp());
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }
}

