/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.mcp.newtools;

import ai.koog.agents.core.tools.ToolRegistry;
import ai.koog.agents.core.tools.annotations.LLMDescription;
import ai.koog.agents.core.tools.annotations.Tool;
import ai.koog.agents.core.tools.reflect.ToolSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.mcp.TrailblazeMcpSseSessionContext;
import xyz.block.trailblaze.mcp.android.ondevice.rpc.OnDeviceRpc;
import xyz.block.trailblaze.mcp.android.ondevice.rpc.models.McpPromptRequestData;
import xyz.block.trailblaze.mcp.android.ondevice.rpc.models.SelectToolSet;
import xyz.block.trailblaze.mcp.models.AdbDevice;
import xyz.block.trailblaze.mcp.models.DeviceConnectionStatus;
import xyz.block.trailblaze.mcp.utils.DeviceConnectUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0007J\u0006\u0010\u000e\u001a\u00020\u000bJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0007J\u0018\u0010\u0018\u001a\u00020\r2\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0007J\u0012\u0010\u001b\u001a\u00020\r2\b\b\u0001\u0010\u001b\u001a\u00020\rH\u0007J.\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lxyz/block/trailblaze/mcp/newtools/AndroidOnDeviceToolSet;", "Lai/koog/agents/core/tools/reflect/ToolSet;", "sessionContext", "Lxyz/block/trailblaze/mcp/TrailblazeMcpSseSessionContext;", "toolRegistryUpdated", "Lkotlin/Function1;", "Lai/koog/agents/core/tools/ToolRegistry;", "", "<init>", "(Lxyz/block/trailblaze/mcp/TrailblazeMcpSseSessionContext;Lkotlin/jvm/functions/Function1;)V", "activeAdbOnDeviceConnections", "Lxyz/block/trailblaze/mcp/models/DeviceConnectionStatus;", "connectDevice", "", "connectDeviceInternal", "ioScope", "Lkotlinx/coroutines/CoroutineScope;", "getIoScope", "()Lkotlinx/coroutines/CoroutineScope;", "getActiveConnection", "Lxyz/block/trailblaze/mcp/models/DeviceConnectionStatus$TrailblazeInstrumentationRunning;", "isThereAnActiveConnection", "", "listToolSets", "setToolSets", "toolSetNames", "", "prompt", "sendPromptToAndroidOnDevice", "originalPrompt", "steps", "deviceId", "Companion", "trailblaze-server"})
public final class AndroidOnDeviceToolSet
implements ToolSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TrailblazeMcpSseSessionContext sessionContext;
    @NotNull
    private final Function1<ToolRegistry, Unit> toolRegistryUpdated;
    @NotNull
    private DeviceConnectionStatus activeAdbOnDeviceConnections;
    @NotNull
    private final CoroutineScope ioScope;
    public static final int ON_DEVICE_ANDROID_MCP_SERVER_PORT = 52526;

    public AndroidOnDeviceToolSet(@Nullable TrailblazeMcpSseSessionContext sessionContext, @NotNull Function1<? super ToolRegistry, Unit> toolRegistryUpdated) {
        Intrinsics.checkNotNullParameter(toolRegistryUpdated, (String)"toolRegistryUpdated");
        this.sessionContext = sessionContext;
        this.toolRegistryUpdated = toolRegistryUpdated;
        this.activeAdbOnDeviceConnections = new DeviceConnectionStatus.NoConnection(null, 1, null);
        this.ioScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    @LLMDescription(description="Connect to the attached device using Trailblaze.")
    @Tool
    @NotNull
    public final String connectDevice() {
        String string;
        DeviceConnectionStatus connectionStatus = this.connectDeviceInternal();
        DeviceConnectionStatus deviceConnectionStatus2 = connectionStatus;
        if (deviceConnectionStatus2 instanceof DeviceConnectionStatus.ConnectionFailure) {
            string = "Connection failed: " + ((DeviceConnectionStatus.ConnectionFailure)connectionStatus).getErrorMessage();
        } else if (deviceConnectionStatus2 instanceof DeviceConnectionStatus.TrailblazeInstrumentationRunning) {
            this.activeAdbOnDeviceConnections = connectionStatus;
            string = "Successfully connected to device " + ((DeviceConnectionStatus.TrailblazeInstrumentationRunning)connectionStatus).getDeviceId() + ". Trailblaze instrumentation is running.";
        } else {
            string = "Unexpected connection status: " + connectionStatus.getStatusText();
        }
        return string;
    }

    @NotNull
    public final DeviceConnectionStatus connectDeviceInternal() {
        if (this.isThereAnActiveConnection()) {
            DeviceConnectionStatus.TrailblazeInstrumentationRunning trailblazeInstrumentationRunning = this.getActiveConnection();
            if (trailblazeInstrumentationRunning == null) {
                throw new IllegalStateException("No active connection".toString());
            }
            return trailblazeInstrumentationRunning;
        }
        List<AdbDevice> adbDevices = DeviceConnectUtils.INSTANCE.getAdbDevices();
        if (adbDevices.isEmpty()) {
            return new DeviceConnectionStatus.ConnectionFailure("No devices found. Please ensure your device is connected and ADB is running.", null, 2, null);
        }
        if (adbDevices.size() > 1) {
            return new DeviceConnectionStatus.ConnectionFailure("Multiple devices found. Please specify a device ID to connect to.  Available Devices: " + CollectionsKt.joinToString$default((Iterable)adbDevices, null, null, null, (int)0, null, AndroidOnDeviceToolSet::connectDeviceInternal$lambda$0, (int)31, null) + ".", null, 2, null);
        }
        if (this.sessionContext == null) {
            return new DeviceConnectionStatus.ConnectionFailure("Error: Session context is null. Cannot send progress messages.", null, 2, null);
        }
        AdbDevice device = (AdbDevice)CollectionsKt.first(adbDevices);
        String deviceId = device.getId();
        try {
            this.sessionContext.sendIndeterminateProgressMessage("Starting connection process for device: " + device.getName() + " (" + deviceId + ")");
            DeviceConnectionStatus deviceConnectionStatus2 = (DeviceConnectionStatus)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DeviceConnectionStatus>, Object>(deviceId, this, null){
                int label;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ AndroidOnDeviceToolSet this$0;
                {
                    this.$deviceId = $deviceId;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DeviceConnectUtils.INSTANCE.startConnectionProcess(this.$deviceId, AndroidOnDeviceToolSet.access$getSessionContext$p(this.this$0), (Continuation<? super DeviceConnectionStatus>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super DeviceConnectionStatus> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            return deviceConnectionStatus2;
        }
        catch (Exception e) {
            String errorMessage = "Failed to start connection process for device: " + device.getName() + " (" + device.getId() + "). Error: " + e.getMessage();
            this.sessionContext.sendIndeterminateProgressMessage(errorMessage);
            return new DeviceConnectionStatus.ConnectionFailure(errorMessage, null, 2, null);
        }
    }

    @NotNull
    public final CoroutineScope getIoScope() {
        return this.ioScope;
    }

    private final DeviceConnectionStatus.TrailblazeInstrumentationRunning getActiveConnection() {
        AndroidOnDeviceToolSet $this$getActiveConnection_u24lambda_u241 = this;
        boolean bl = false;
        DeviceConnectionStatus deviceConnectionStatus2 = $this$getActiveConnection_u24lambda_u241.activeAdbOnDeviceConnections;
        return deviceConnectionStatus2 instanceof DeviceConnectionStatus.TrailblazeInstrumentationRunning ? (DeviceConnectionStatus.TrailblazeInstrumentationRunning)deviceConnectionStatus2 : null;
    }

    private final boolean isThereAnActiveConnection() {
        return this.getActiveConnection() != null;
    }

    @LLMDescription(description="Call this to list the available Trailblaze Tool Sets on the connected device.")
    @Tool
    @NotNull
    public final String listToolSets() {
        if (this.sessionContext == null) {
            return "Session context is null. Cannot send progress messages or connect to device.";
        }
        DeviceConnectionStatus.TrailblazeInstrumentationRunning activeConnection = this.getActiveConnection();
        if (activeConnection == null) {
            return "A device must be connected first.";
        }
        if (activeConnection.getDeviceId() == null) {
            return "Device status reported connected, but deviceId was unavailable.";
        }
        try {
            String psuedoRpcResult = new OnDeviceRpc(52526, (Function1<? super String, Unit>)((Function1)arg_0 -> AndroidOnDeviceToolSet.listToolSets$lambda$2(this, arg_0))).listAvailableToolSets();
            return psuedoRpcResult;
        }
        catch (Exception e) {
            String errorMessage = "Exception sending HTTP request to device " + activeConnection.getDeviceId() + ". Error: " + e.getMessage();
            this.sessionContext.sendIndeterminateProgressMessage(errorMessage);
            return errorMessage;
        }
    }

    @LLMDescription(description="This changes the enabled Trailblaze ToolSets.  This will change what tools are available to the Trailblaze device control agent.")
    @Tool
    @NotNull
    public final String setToolSets(@LLMDescription(description="The list of Trailblaze ToolSet Names to enable.  Find available ToolSet IDs with the listToolSets tool.  There is an exact match on the name, so be sure to use the correct name(s).") @NotNull List<String> toolSetNames) {
        Intrinsics.checkNotNullParameter(toolSetNames, (String)"toolSetNames");
        if (this.sessionContext == null) {
            return "Session context is null. Cannot send progress messages or connect to device.";
        }
        DeviceConnectionStatus.TrailblazeInstrumentationRunning activeConnection = this.getActiveConnection();
        if (activeConnection == null) {
            return "A device must be connected first.";
        }
        if (activeConnection.getDeviceId() == null) {
            return "Device status reported connected, but deviceId was unavailable.";
        }
        try {
            String psuedoRpcResult = new OnDeviceRpc(52526, (Function1<? super String, Unit>)((Function1)arg_0 -> AndroidOnDeviceToolSet.setToolSets$lambda$3(this, arg_0))).setToolSets(new SelectToolSet(toolSetNames));
            return psuedoRpcResult;
        }
        catch (Exception e) {
            String errorMessage = "Exception sending HTTP request to device " + activeConnection.getDeviceId() + ". Error: " + e.getMessage();
            this.sessionContext.sendIndeterminateProgressMessage(errorMessage);
            return errorMessage;
        }
    }

    @LLMDescription(description="\nSend a natural language instruction to control the currently connected device.\nUse this when someone requests any user action.\nThe prompt/action/request will be sent to the mobile device to be run.\n")
    @Tool
    @NotNull
    public final String prompt(@LLMDescription(description="The original prompt.") @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (this.sessionContext == null) {
            return "Session context is null. Cannot send progress messages or connect to device.";
        }
        DeviceConnectionStatus.TrailblazeInstrumentationRunning activeConnection = this.getActiveConnection();
        if (activeConnection == null) {
            return "A device must be connected first.";
        }
        if (activeConnection.getDeviceId() == null) {
            return "Device status reported connected, but deviceId was unavailable.";
        }
        List list = CollectionsKt.listOf((Object)prompt);
        String string = activeConnection.getDeviceId();
        Intrinsics.checkNotNull((Object)string);
        return this.sendPromptToAndroidOnDevice(prompt, list, string, this.sessionContext);
    }

    private final String sendPromptToAndroidOnDevice(String originalPrompt, List<String> steps, String deviceId, TrailblazeMcpSseSessionContext sessionContext) {
        System.out.println((Object)("Sending prompt " + steps + " to device " + deviceId + "."));
        sessionContext.sendIndeterminateProgressMessage("Setting up port forwarding for device " + deviceId + " on port 52526.");
        try {
            DeviceConnectUtils.portForward$default(DeviceConnectUtils.INSTANCE, deviceId, 52526, 0, 4, null);
        }
        catch (Exception e) {
            return "Failed to set up port forwarding for device " + deviceId + " on port 52526. Error: " + e.getMessage();
        }
        McpPromptRequestData promptRequestData = new McpPromptRequestData(originalPrompt, steps);
        try {
            sessionContext.sendIndeterminateProgressMessage("Running prompt on device " + deviceId + " with steps: " + CollectionsKt.joinToString$default((Iterable)steps, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ".");
            String psuedoRpcResult = new OnDeviceRpc(52526, (Function1<? super String, Unit>)((Function1)arg_0 -> AndroidOnDeviceToolSet.sendPromptToAndroidOnDevice$lambda$4(sessionContext, arg_0))).prompt(promptRequestData);
            return psuedoRpcResult;
        }
        catch (Exception e) {
            String errorMessage = "Exception sending HTTP request to device " + deviceId + ". Error: " + e.getMessage();
            sessionContext.sendIndeterminateProgressMessage(errorMessage);
            return errorMessage;
        }
    }

    private static final CharSequence connectDeviceInternal$lambda$0(AdbDevice it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final Unit listToolSets$lambda$2(AndroidOnDeviceToolSet this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sessionContext.sendIndeterminateProgressMessage(it);
        return Unit.INSTANCE;
    }

    private static final Unit setToolSets$lambda$3(AndroidOnDeviceToolSet this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sessionContext.sendIndeterminateProgressMessage(it);
        return Unit.INSTANCE;
    }

    private static final Unit sendPromptToAndroidOnDevice$lambda$4(TrailblazeMcpSseSessionContext $sessionContext, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sessionContext.sendIndeterminateProgressMessage(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TrailblazeMcpSseSessionContext access$getSessionContext$p(AndroidOnDeviceToolSet $this) {
        return $this.sessionContext;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lxyz/block/trailblaze/mcp/newtools/AndroidOnDeviceToolSet$Companion;", "", "<init>", "()V", "ON_DEVICE_ANDROID_MCP_SERVER_PORT", "", "trailblaze-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

