/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.mcp.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.trailblaze.mcp.TrailblazeMcpSseSessionContext;
import xyz.block.trailblaze.mcp.models.AdbDevice;
import xyz.block.trailblaze.mcp.models.DeviceConnectionStatus;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lxyz/block/trailblaze/mcp/utils/DeviceConnectUtils;", "", "<init>", "()V", "ioScope", "Lkotlinx/coroutines/CoroutineScope;", "getIoScope", "()Lkotlinx/coroutines/CoroutineScope;", "getGitRoot", "Ljava/io/File;", "startConnectionProcess", "Lxyz/block/trailblaze/mcp/models/DeviceConnectionStatus;", "deviceId", "", "sessionContext", "Lxyz/block/trailblaze/mcp/TrailblazeMcpSseSessionContext;", "(Ljava/lang/String;Lxyz/block/trailblaze/mcp/TrailblazeMcpSseSessionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "portForward", "Ljava/lang/Process;", "localPort", "", "remotePort", "getDeviceName", "getAdbDevices", "", "Lxyz/block/trailblaze/mcp/models/AdbDevice;", "trailblaze-server"})
@SourceDebugExtension(value={"SMAP\nDeviceConnectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConnectUtils.kt\nxyz/block/trailblaze/mcp/utils/DeviceConnectUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1869#2,2:192\n774#2:194\n865#2,2:195\n1563#2:197\n1634#2,3:198\n1#3:201\n*S KotlinDebug\n*F\n+ 1 DeviceConnectUtils.kt\nxyz/block/trailblaze/mcp/utils/DeviceConnectUtils\n*L\n105#1:192,2\n182#1:194\n182#1:195,2\n183#1:197\n183#1:198,3\n*E\n"})
public final class DeviceConnectUtils {
    @NotNull
    public static final DeviceConnectUtils INSTANCE = new DeviceConnectUtils();
    @NotNull
    private static final CoroutineScope ioScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));

    private DeviceConnectUtils() {
    }

    @NotNull
    public final CoroutineScope getIoScope() {
        return ioScope;
    }

    private final File getGitRoot() {
        File file;
        try {
            String[] stringArray = new String[]{"git", "rev-parse", "--show-toplevel"};
            Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String output = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
            int exit = process.waitFor();
            file = exit == 0 && !StringsKt.isBlank((CharSequence)output) ? new File(output) : null;
        }
        catch (Exception e) {
            file = null;
        }
        return file;
    }

    @Nullable
    public final Object startConnectionProcess(@NotNull String deviceId, @NotNull TrailblazeMcpSseSessionContext sessionContext, @NotNull Continuation<? super DeviceConnectionStatus> $completion) {
        CompletableDeferred completableDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        File file = this.getGitRoot();
        if (file == null) {
            file = new File(".");
        }
        File gitRoot = file;
        int port = 52526;
        DeviceConnectUtils.portForward$default(this, deviceId, port, 0, 4, null);
        sessionContext.sendIndeterminateProgressMessage("Building and Installing On-Device Trailblaze");
        String[] stringArray = new String[]{"./gradlew", ":trailblaze-android-ondevice-mcp:installDebugAndroidTest"};
        Process gradleProcess = new ProcessBuilder(stringArray).directory(gitRoot).redirectErrorStream(true).start();
        Thread gradleSystemOutListenerThread = new Thread(() -> DeviceConnectUtils.startConnectionProcess$lambda$1(gradleProcess));
        gradleSystemOutListenerThread.start();
        int gradleExit = gradleProcess.waitFor();
        gradleSystemOutListenerThread.interrupt();
        if (gradleExit != 0) {
            return new DeviceConnectionStatus.ConnectionFailure("Gradle install failed with exit code " + gradleExit, null, 2, null);
        }
        sessionContext.sendIndeterminateProgressMessage("On-Device Trailblaze Installed. Connecting to Trailblaze...");
        String testAppId = "xyz.block.trailblaze.android.mcp.ondevice.test";
        Object[] objectArray = new String[]{"adb", "-s", deviceId, "shell", "am", "force-stop", "xyz.block.trailblaze.android.mcp.ondevice.test"};
        List forceStopArgs = CollectionsKt.listOf((Object[])objectArray);
        sessionContext.sendIndeterminateProgressMessage("Ensuring old sessions are stopped...");
        new ProcessBuilder(forceStopArgs).directory(gitRoot).redirectErrorStream(true).start().waitFor();
        Object[] objectArray2 = new String[]{"adb", "-s", deviceId, "shell", "am", "instrument", "-w", "-r", "-e", "class", "xyz.block.trailblaze.AndroidOnDeviceMcpServerTest", "-e", "trailblaze.ai.enabled", "true", "-e", "OPENAI_API_KEY", System.getenv("OPENAI_API_KEY"), testAppId + "/androidx.test.runner.AndroidJUnitRunner"};
        List startInstrumentationArgs = CollectionsKt.listOf((Object[])objectArray2);
        sessionContext.sendIndeterminateProgressMessage("Connecting to Trailblaze On-Device using Android Test Instrumentation.");
        ProcessBuilder processBuilder = new ProcessBuilder(startInstrumentationArgs).directory(gitRoot).redirectErrorStream(true);
        Iterable $this$forEach$iv = System.getenv().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String envVar = (String)element$iv;
            boolean bl = false;
            String value = System.getenv(envVar);
            if (value != null) {
                Map<String, String> map = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
                map.put(envVar, value);
                continue;
            }
            System.out.println((Object)("Warning: " + envVar + " is not set in the environment"));
        }
        Process instrProcess = processBuilder.start();
        Ref.BooleanRef hasCallbackBeenCalled = new Ref.BooleanRef();
        BuildersKt.launch$default((CoroutineScope)ioScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(instrProcess, hasCallbackBeenCalled, sessionContext, (CompletableDeferred<DeviceConnectionStatus>)completableDeferred, deviceId, null){
            int label;
            final /* synthetic */ Process $instrProcess;
            final /* synthetic */ Ref.BooleanRef $hasCallbackBeenCalled;
            final /* synthetic */ TrailblazeMcpSseSessionContext $sessionContext;
            final /* synthetic */ CompletableDeferred<DeviceConnectionStatus> $completableDeferred;
            final /* synthetic */ String $deviceId;
            {
                this.$instrProcess = $instrProcess;
                this.$hasCallbackBeenCalled = $hasCallbackBeenCalled;
                this.$sessionContext = $sessionContext;
                this.$completableDeferred = $completableDeferred;
                this.$deviceId = $deviceId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            InputStream inputStream = this.$instrProcess.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                            InputStream inputStream2 = inputStream;
                            Object object2 = Charsets.UTF_8;
                            Reader reader = new InputStreamReader(inputStream2, (Charset)object2);
                            int n = 8192;
                            BufferedReader reader2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                            Ref.ObjectRef line = new Ref.ObjectRef();
                            while (true) {
                                Object it = object2 = reader2.readLine();
                                boolean bl = false;
                                line.element = it;
                                if (object2 != null) {
                                    System.out.println((Object)("Instrumentation output: " + line.element));
                                    if (this.$hasCallbackBeenCalled.element) continue;
                                    String string = (String)line.element;
                                    boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"INSTRUMENTATION_STATUS_CODE:", (boolean)false, (int)2, null) : false;
                                    if (!bl2) continue;
                                    this.$sessionContext.sendIndeterminateProgressMessage("Trailblaze On-Device Connected Successfully!");
                                    System.out.println((Object)("INSTRUMENTATION_STATUS_CODE found in output: " + line.element));
                                    this.$completableDeferred.complete((Object)new DeviceConnectionStatus.TrailblazeInstrumentationRunning(this.$deviceId));
                                    this.$hasCallbackBeenCalled.element = true;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            String errorMessage = "Error connecting Trailblaze On-Device. " + e.getMessage();
                            this.$sessionContext.sendIndeterminateProgressMessage(errorMessage);
                            this.$completableDeferred.complete((Object)new DeviceConnectionStatus.ConnectionFailure(errorMessage, null, 2, null));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return completableDeferred.await($completion);
    }

    @NotNull
    public final Process portForward(@Nullable String deviceId, int localPort, int remotePort) {
        Process process;
        try {
            List list;
            List $this$portForward_u24lambda_u243 = list = (List)new ArrayList();
            boolean bl = false;
            $this$portForward_u24lambda_u243.add("adb");
            Object[] objectArray = (Object[])deviceId;
            if (!(objectArray == null || StringsKt.isBlank((CharSequence)objectArray))) {
                $this$portForward_u24lambda_u243.add("-s");
                $this$portForward_u24lambda_u243.add(deviceId);
            }
            objectArray = new String[]{"forward", "tcp:" + localPort, "tcp:" + remotePort};
            $this$portForward_u24lambda_u243.addAll(CollectionsKt.listOf((Object[])objectArray));
            List args = list;
            process = new ProcessBuilder(args).redirectErrorStream(true).start();
            Intrinsics.checkNotNull((Object)process);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start port forwarding for device " + deviceId + ": " + e.getMessage());
        }
        return process;
    }

    public static /* synthetic */ Process portForward$default(DeviceConnectUtils deviceConnectUtils, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return deviceConnectUtils.portForward(string, n, n2);
    }

    @NotNull
    public final String getDeviceName(@NotNull String deviceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        try {
            String[] stringArray = new String[]{"adb", "-s", deviceId, "shell", "getprop", "ro.product.model"};
            Process process = new ProcessBuilder(stringArray).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = reader.readLine();
            String name = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            CharSequence charSequence = name;
            string = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? name : deviceId;
        }
        catch (Exception e) {
            string = deviceId;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AdbDevice> getAdbDevices() {
        List list;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String[] stringArray = new String[]{"adb", "devices"};
            Process process = new ProcessBuilder(stringArray).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            List lines = TextStreamsKt.readLines((Reader)reader);
            Iterable iterable = CollectionsKt.drop((Iterable)lines, (int)1);
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it) && StringsKt.contains$default((CharSequence)it, (CharSequence)"\tdevice", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String id = StringsKt.substringBefore$default((String)line, (String)"\t", null, (int)2, null);
                collection.add(new AdbDevice(id, INSTANCE.getDeviceName(id)));
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final void startConnectionProcess$lambda$1(Process $gradleProcess) {
        try {
            InputStream inputStream = $gradleProcess.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Object object = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, (Charset)object);
            int n = 8192;
            BufferedReader reader2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            Object line = null;
            while (true) {
                Object it = object = reader2.readLine();
                boolean bl = false;
                line = it;
                if (object != null) {
                    System.out.println((Object)("Gradle output: " + line));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error reading Gradle output: " + e.getMessage()));
        }
    }
}

