/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.mcp.utils;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/block/trailblaze/mcp/utils/HttpRequestUtils;", "", "baseUrl", "", "<init>", "(Ljava/lang/String;)V", "client", "Lokhttp3/OkHttpClient;", "postRequest", "jsonPostBody", "urlPath", "trailblaze-server"})
public final class HttpRequestUtils {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;

    public HttpRequestUtils(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
        this.client = new OkHttpClient.Builder().readTimeout(300L, TimeUnit.SECONDS).connectTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).build();
    }

    @NotNull
    public final String postRequest(@NotNull String jsonPostBody, @NotNull String urlPath) {
        Intrinsics.checkNotNullParameter((Object)jsonPostBody, (String)"jsonPostBody");
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        MediaType mediaType = MediaType.Companion.parse("application/json");
        RequestBody body = RequestBody.Companion.create(jsonPostBody, mediaType);
        Request request = new Request.Builder().url(this.baseUrl + urlPath).addHeader("Content-Type", "application/json").post(body).build();
        try {
            Response response = this.client.newCall(request).execute();
            ResponseBody responseBody = response.body();
            String responseBody2 = responseBody != null ? responseBody.string() : null;
            System.out.println((Object)("Response Body: " + responseBody2));
            System.out.println((Object)("Response Code: " + response.code()));
            System.out.println((Object)("Response Message: " + response.message()));
            return !response.isSuccessful() ? "\"Unexpected code " + response + "\"" : String.valueOf(responseBody2);
        }
        catch (Exception e) {
            String errorMessage = "Exception sending HTTP request to device. Error: " + e.getMessage();
            return errorMessage;
        }
    }
}

