/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.trailblaze.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Desktop;
import java.awt.Taskbar;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lxyz/block/trailblaze/ui/TrailblazeDesktopUtil;", "", "<init>", "()V", "setAppConfigForTrailblaze", "", "openInDefaultBrowser", "url", "", "openInFileBrowser", "file", "Ljava/io/File;", "openGoose", "trailblaze-ui"})
@StabilityInferred(parameters=1)
public final class TrailblazeDesktopUtil {
    @NotNull
    public static final TrailblazeDesktopUtil INSTANCE = new TrailblazeDesktopUtil();
    public static final int $stable;

    private TrailblazeDesktopUtil() {
    }

    public final void setAppConfigForTrailblaze() {
        if (Taskbar.isTaskbarSupported()) {
            Taskbar taskbar;
            Taskbar $this$setAppConfigForTrailblaze_u24lambda_u240 = taskbar = Taskbar.getTaskbar();
            boolean bl = false;
            $this$setAppConfigForTrailblaze_u24lambda_u240.setIconImage(ImageIO.read(TrailblazeDesktopUtil.class.getClassLoader().getResource("icons/icon.png")));
        }
    }

    public final void openInDefaultBrowser(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                System.out.println((Object)"Desktop is not supported on this platform.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void openInFileBrowser(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            Desktop.getDesktop().open(file);
        } else {
            System.out.println((Object)("File does not exist: " + file.getAbsolutePath()));
        }
    }

    public final void openGoose() {
        URL uRL = this.getClass().getClassLoader().getResource("trailblaze_goose_recipe.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        URL uRL2 = uRL;
        Object object = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String gooseRecipeJson = new String(byArray, (Charset)object);
        Base64 base64 = (Base64)Base64.Default;
        object = gooseRecipeJson;
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        String gooseRecipeEncoded = Base64.encode$default((Base64)base64, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        String gooseUrl = "goose://recipe?config=" + gooseRecipeEncoded;
        this.openInDefaultBrowser(gooseUrl);
    }
}

