/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.common;

import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lweb5/sdk/common/ZBase32;", "", "()V", "ALPHABET", "", "BITS_PER_BASE32_CHAR", "", "BITS_PER_BYTE", "DECODER_SIZE", "MASK_BASE32", "MASK_BYTE", "decoder", "", "decode", "", "data", "encode", "common"})
@SourceDebugExtension(value={"SMAP\nZBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZBase32.kt\nweb5/sdk/common/ZBase32\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class ZBase32 {
    @NotNull
    public static final ZBase32 INSTANCE;
    @NotNull
    private static final String ALPHABET = "ybndrfg8ejkmcpqxot1uwisza345h769";
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_PER_BASE32_CHAR = 5;
    private static final int MASK_BASE32 = 31;
    private static final int MASK_BYTE = 255;
    private static final int DECODER_SIZE = 128;
    @NotNull
    private static final int[] decoder;

    private ZBase32() {
    }

    @NotNull
    public final String encode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 0) {
            return "";
        }
        int buffer = 0;
        int bufferLength = 0;
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            buffer = (buffer << 8) + (b & 0xFF);
            bufferLength += 8;
            while (bufferLength >= 5) {
                int charIndex = buffer >> bufferLength - 5 & 0x1F;
                result.append(ALPHABET.charAt(charIndex));
                bufferLength -= 5;
            }
        }
        if (bufferLength > 0) {
            int charIndex = buffer << 5 - bufferLength & 0x1F;
            result.append(ALPHABET.charAt(charIndex));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final byte[] decode(@NotNull String data) {
        int paddingBits;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((CharSequence)data).length() == 0) {
            return new byte[0];
        }
        int buffer = 0;
        int bufferLength = 0;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int n = data.length();
        for (int i = 0; i < n; ++i) {
            char c = data.charAt(i);
            int index = decoder[c];
            if (!(index != -1)) {
                boolean bl = false;
                String string = "Invalid zbase32 character: " + c;
                throw new IllegalArgumentException(string.toString());
            }
            buffer = (buffer << 5) + index;
            bufferLength += 5;
            while (bufferLength >= 8) {
                byte b = (byte)(buffer >> bufferLength - 8 & 0xFF);
                result.write(b);
                bufferLength -= 8;
            }
        }
        if (bufferLength > 0 && (paddingBits = data.length() * 5 % 8) > 0) {
            int paddingBytes = (8 - paddingBits) / 8;
            buffer <<= paddingBits;
            for (int i = 0; i < paddingBytes; ++i) {
                byte b = (byte)(buffer >> bufferLength - 8 & 0xFF);
                result.write(b);
                bufferLength -= 8;
            }
        }
        byte[] byArray = result.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    static {
        int i;
        INSTANCE = new ZBase32();
        decoder = new int[128];
        int n = decoder.length;
        for (i = 0; i < n; ++i) {
            ZBase32.decoder[i] = -1;
        }
        n = ALPHABET.length();
        for (i = 0; i < n; ++i) {
            ZBase32.decoder[ALPHABET.charAt((int)i)] = i;
        }
    }
}

