/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lweb5/sdk/common/Json;", "", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectWriter", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "stringify", "", "obj", "common"})
public final class Json {
    @NotNull
    public static final Json INSTANCE = new Json();
    @NotNull
    private static final ObjectMapper jsonMapper;
    @NotNull
    private static final ObjectWriter objectWriter;

    private Json() {
    }

    @NotNull
    public final ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    @NotNull
    public final String stringify(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = objectWriter.writeValueAsString(obj);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    static {
        ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"disable(...)");
        jsonMapper = objectMapper;
        ObjectWriter objectWriter = jsonMapper.writer();
        Intrinsics.checkNotNullExpressionValue((Object)objectWriter, (String)"writer(...)");
        Json.objectWriter = objectWriter;
    }
}

