/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.common;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lweb5/sdk/common/Base58Btc;", "", "()V", "ALPHABET", "", "ENCODED_ZERO", "", "INDEXES", "", "decode", "", "input", "", "divmod", "", "number", "firstDigit", "", "base", "divisor", "encode", "web5-common"})
@SourceDebugExtension(value={"SMAP\nBase58Btc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base58Btc.kt\nweb5/sdk/common/Base58Btc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class Base58Btc {
    @NotNull
    public static final Base58Btc INSTANCE = new Base58Btc();
    @NotNull
    private static final char[] ALPHABET;
    private static final char ENCODED_ZERO;
    @NotNull
    private static final int[] INDEXES;

    private Base58Btc() {
    }

    @NotNull
    public final String encode(@NotNull byte[] input) {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] input2 = input;
        if (input2.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input2.length && input2[zeros] == 0; ++zeros) {
        }
        byte[] byArray = Arrays.copyOf(input2, input2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        input2 = byArray;
        char[] encoded = new char[input2.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input2.length) {
            encoded[--outputStart] = ALPHABET[this.divmod(input2, inputStart, 256, 58)];
            if (input2[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    @NotNull
    public final byte[] decode(@NotNull String input) {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((CharSequence)input).length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            int digit = c < '\u0080' ? INDEXES[c] : -1;
            if (!(digit >= 0)) {
                boolean bl = false;
                String string = "Invalid character in Base58: 0x%04x";
                Object[] objectArray = new Object[]{(int)c};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String string3 = string2;
                throw new IllegalArgumentException(string3.toString());
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = this.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        byte[] byArray = Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOfRange(...)");
        return byArray;
    }

    private final byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        int n = number.length;
        for (int i = firstDigit; i < n; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        char[] cArray = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        ALPHABET = cArray;
        ENCODED_ZERO = ALPHABET[0];
        INDEXES = new int[128];
        Arrays.fill(INDEXES, -1);
        int n = ALPHABET.length;
        for (int i = 0; i < n; ++i) {
            Base58Btc.INDEXES[Base58Btc.ALPHABET[i]] = i;
        }
    }
}

