/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.credentials;

import com.danubetech.verifiablecredentials.VerifiablePresentation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import foundation.identity.jsonld.JsonLDObject;
import java.net.URI;
import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.credentials.VerifiableCredential;
import web5.sdk.credentials.util.JwtUtil;
import web5.sdk.dids.Did;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lweb5/sdk/credentials/VerifiablePresentation;", "", "vpDataModel", "Lcom/danubetech/verifiablecredentials/VerifiablePresentation;", "Lweb5/sdk/credentials/VpDataModel;", "(Lcom/danubetech/verifiablecredentials/VerifiablePresentation;)V", "holder", "", "getHolder", "()Ljava/lang/String;", "verifiableCredential", "", "getVerifiableCredential", "()Ljava/util/List;", "getVpDataModel", "()Lcom/danubetech/verifiablecredentials/VerifiablePresentation;", "sign", "did", "Lweb5/sdk/dids/Did;", "assertionMethodId", "toString", "Companion", "credentials"})
public final class VerifiablePresentation {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final com.danubetech.verifiablecredentials.VerifiablePresentation vpDataModel;
    @NotNull
    private static final ObjectMapper objectMapper;

    public VerifiablePresentation(@NotNull com.danubetech.verifiablecredentials.VerifiablePresentation vpDataModel) {
        Intrinsics.checkNotNullParameter((Object)vpDataModel, (String)"vpDataModel");
        this.vpDataModel = vpDataModel;
    }

    @NotNull
    public final com.danubetech.verifiablecredentials.VerifiablePresentation getVpDataModel() {
        return this.vpDataModel;
    }

    @NotNull
    public final List<String> getVerifiableCredential() {
        Object v = this.vpDataModel.toMap().get("verifiableCredential");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        return (List)v;
    }

    @NotNull
    public final String getHolder() {
        String string = this.vpDataModel.getHolder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String sign(@NotNull Did did, @Nullable String assertionMethodId) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        JWTClaimsSet payload = new JWTClaimsSet.Builder().issuer(did.getUri()).issueTime(new Date()).claim("vp", (Object)this.vpDataModel.toMap()).build();
        Intrinsics.checkNotNull((Object)payload);
        return JwtUtil.INSTANCE.sign(did, assertionMethodId, payload);
    }

    public static /* synthetic */ String sign$default(VerifiablePresentation verifiablePresentation, Did did, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return verifiablePresentation.sign(did, string);
    }

    @NotNull
    public String toString() {
        String string = this.vpDataModel.toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String sign(@NotNull Did did) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        return VerifiablePresentation.sign$default(this, did, null, 2, null);
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        ObjectMapper $this$objectMapper_u24lambda_u240 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$objectMapper_u24lambda_u240.registerModule((Module)new KotlinModule.Builder().build());
        $this$objectMapper_u24lambda_u240.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        VerifiablePresentation.objectMapper = objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lweb5/sdk/credentials/VerifiablePresentation$Companion;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "create", "Lweb5/sdk/credentials/VerifiablePresentation;", "type", "", "holder", "vcJwts", "", "additionalData", "", "parseJwt", "vpJwt", "verify", "", "credentials"})
    @SourceDebugExtension(value={"SMAP\nVerifiablePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifiablePresentation.kt\nweb5/sdk/credentials/VerifiablePresentation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1#2:196\n1855#3,2:197\n*S KotlinDebug\n*F\n+ 1 VerifiablePresentation.kt\nweb5/sdk/credentials/VerifiablePresentation$Companion\n*L\n158#1:197,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final VerifiablePresentation create(@Nullable String type, @NotNull String holder, @NotNull Iterable<String> vcJwts, @Nullable Map<String, ? extends Object> additionalData) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
            Map map = additionalData;
            if (map == null || (map = MapsKt.plus(map, (Pair)TuplesKt.to((Object)"verifiableCredential", vcJwts))) == null) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"verifiableCredential", vcJwts));
            }
            Map vpProperties = map;
            JsonLDObject.Builder builder = ((VerifiablePresentation.Builder)com.danubetech.verifiablecredentials.VerifiablePresentation.builder().id(URI.create("urn:uuid:" + UUID.randomUUID()))).holder(URI.create(holder)).properties(vpProperties);
            VerifiablePresentation.Builder $this$create_u24lambda_u241 = (VerifiablePresentation.Builder)builder;
            boolean bl = false;
            String string = type;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$create_u24lambda_u241.type(it);
            }
            com.danubetech.verifiablecredentials.VerifiablePresentation vpDataModel = ((VerifiablePresentation.Builder)builder).build();
            Intrinsics.checkNotNull((Object)vpDataModel);
            return new VerifiablePresentation(vpDataModel);
        }

        public static /* synthetic */ VerifiablePresentation create$default(Companion companion, String string, String string2, Iterable iterable, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                map = null;
            }
            return companion.create(string, string2, iterable, map);
        }

        public final void verify(@NotNull String vpJwt) {
            Intrinsics.checkNotNullParameter((Object)vpJwt, (String)"vpJwt");
            JwtUtil.INSTANCE.verify(vpJwt);
            VerifiablePresentation vp = this.parseJwt(vpJwt);
            Iterable $this$forEach$iv = vp.getVerifiableCredential();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                try {
                    VerifiableCredential.Companion.verify(it);
                }
                catch (Exception e) {
                    throw new SignatureException("Failed to verify a credential inside of the vp: " + e.getMessage(), e);
                }
            }
        }

        @NotNull
        public final VerifiablePresentation parseJwt(@NotNull String vpJwt) {
            Intrinsics.checkNotNullParameter((Object)vpJwt, (String)"vpJwt");
            JWT jWT = JWTParser.parse((String)vpJwt);
            Intrinsics.checkNotNull((Object)jWT, (String)"null cannot be cast to non-null type com.nimbusds.jwt.SignedJWT");
            SignedJWT jwt = (SignedJWT)jWT;
            Map jwtPayload = jwt.getPayload().toJSONObject();
            Intrinsics.checkNotNull((Object)jwtPayload);
            Map map = jwtPayload;
            Object v = map.get("vp");
            if (v == null) {
                boolean bl = false;
                throw new IllegalArgumentException("jwt payload missing vp property");
            }
            Object vpDataModelValue = v;
            Map map2 = vpDataModelValue instanceof Map ? (Map)vpDataModelValue : null;
            if (map2 == null) {
                throw new IllegalArgumentException("expected vp property in JWT payload to be an object");
            }
            Map vpDataModelMap = map2;
            com.danubetech.verifiablecredentials.VerifiablePresentation vpDataModel = com.danubetech.verifiablecredentials.VerifiablePresentation.fromMap((Map)vpDataModelMap);
            Intrinsics.checkNotNull((Object)vpDataModel);
            return new VerifiablePresentation(vpDataModel);
        }

        @JvmOverloads
        @NotNull
        public final VerifiablePresentation create(@Nullable String type, @NotNull String holder, @NotNull Iterable<String> vcJwts) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
            return web5.sdk.credentials.VerifiablePresentation$Companion.create$default(this, type, holder, vcJwts, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final VerifiablePresentation create(@NotNull String holder, @NotNull Iterable<String> vcJwts) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
            return web5.sdk.credentials.VerifiablePresentation$Companion.create$default(this, null, holder, vcJwts, null, 9, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

