/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.credentials;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.nfeld.jsonpathkt.JsonPath;
import com.nfeld.jsonpathkt.Token;
import com.nfeld.jsonpathkt.util.JacksonUtil;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import web5.sdk.credentials.JsonPathParseException;
import web5.sdk.credentials.PexValidationException;
import web5.sdk.credentials.model.FieldV2;
import web5.sdk.credentials.model.InputDescriptorMapping;
import web5.sdk.credentials.model.InputDescriptorV2;
import web5.sdk.credentials.model.PresentationDefinitionV2;
import web5.sdk.credentials.model.PresentationDefinitionV2Validator;
import web5.sdk.credentials.model.PresentationSubmission;
import web5.sdk.credentials.model.PresentationSubmissionValidator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\f\u0010 \u001a\u00020\u000b*\u00020\u0010H\u0002\u00a8\u0006!"}, d2={"Lweb5/sdk/credentials/PresentationExchange;", "", "()V", "createPresentationFromCredentials", "Lweb5/sdk/credentials/model/PresentationSubmission;", "vcJwts", "", "", "presentationDefinition", "Lweb5/sdk/credentials/model/PresentationDefinitionV2;", "evaluateMatchedFields", "", "matchedFields", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "schema", "Lcom/networknt/schema/JsonSchema;", "mapInputDescriptorsToVCs", "", "Lweb5/sdk/credentials/model/InputDescriptorV2;", "vcJwtList", "satisfiesPresentationDefinition", "", "selectCredentials", "validateDefinition", "validateSubmission", "presentationSubmission", "valueSatisfiesFieldFilterSchema", "fieldValue", "vcSatisfiesInputDescriptor", "vcPayloadJson", "inputDescriptor", "isExpectingArray", "credentials"})
@SourceDebugExtension(value={"SMAP\nPresentationExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresentationExchange.kt\nweb5/sdk/credentials/PresentationExchange\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 JsonNode.kt\ncom/nfeld/jsonpathkt/extension/JsonNodeKt\n+ 7 JsonPath.kt\ncom/nfeld/jsonpathkt/JsonPath\n+ 8 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,272:1\n76#2:273\n96#2,5:274\n1179#3,2:279\n1253#3,4:281\n1549#3:286\n1620#3,3:287\n1271#3,2:290\n1285#3,2:292\n766#3:294\n857#3,2:295\n1549#3:297\n1620#3,3:298\n1288#3:301\n766#3:309\n857#3,2:310\n1603#3,9:312\n1855#3:321\n1783#3,2:328\n1785#3:332\n1856#3:342\n1612#3:343\n1747#3,3:344\n1#4:285\n1#4:331\n494#5,7:302\n11#6:322\n45#7,5:323\n50#7:330\n53#7,5:333\n58#7,2:340\n56#8:338\n43#8:339\n*S KotlinDebug\n*F\n+ 1 PresentationExchange.kt\nweb5/sdk/credentials/PresentationExchange\n*L\n36#1:273\n36#1:274,5\n93#1:279,2\n93#1:281,4\n164#1:286\n164#1:287,3\n170#1:290,2\n170#1:292,2\n171#1:294\n171#1:295,2\n173#1:297\n173#1:298,3\n170#1:301\n198#1:309\n198#1:310,2\n201#1:312,9\n201#1:321\n201#1:328,2\n201#1:332\n201#1:342\n201#1:343\n232#1:344,3\n201#1:331\n174#1:302,7\n201#1:322\n201#1:323,5\n201#1:330\n201#1:333,5\n201#1:340,2\n201#1:338\n201#1:339\n*E\n"})
public final class PresentationExchange {
    @NotNull
    public static final PresentationExchange INSTANCE = new PresentationExchange();

    private PresentationExchange() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> selectCredentials(@NotNull Iterable<String> vcJwts, @NotNull PresentationDefinitionV2 presentationDefinition) throws UnsupportedOperationException {
        void $this$flatMapTo$iv$iv;
        Map<InputDescriptorV2, List<String>> inputDescriptorToVcMap;
        Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        Map<InputDescriptorV2, List<String>> $this$flatMap$iv = inputDescriptorToVcMap = this.mapInputDescriptorsToVCs(vcJwts, presentationDefinition);
        boolean $i$f$flatMap = false;
        Map<InputDescriptorV2, List<String>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    public final void satisfiesPresentationDefinition(@NotNull Iterable<String> vcJwts, @NotNull PresentationDefinitionV2 presentationDefinition) throws UnsupportedOperationException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        Collection collection = presentationDefinition.getSubmissionRequirements();
        if (!(collection == null || collection.isEmpty())) {
            throw new UnsupportedOperationException("Presentation Definition's Submission Requirements feature is not implemented");
        }
        Map<InputDescriptorV2, List<String>> inputDescriptorToVcMap = this.mapInputDescriptorsToVCs(vcJwts, presentationDefinition);
        if (!(inputDescriptorToVcMap.size() == presentationDefinition.getInputDescriptors().size())) {
            boolean bl = false;
            String string = "Missing input descriptors: The presentation definition requires " + presentationDefinition.getInputDescriptors().size() + " descriptors, but only " + inputDescriptorToVcMap.size() + " were found. Check and provide the missing descriptors.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PresentationSubmission createPresentationFromCredentials(@NotNull Iterable<String> vcJwts, @NotNull PresentationDefinitionV2 presentationDefinition) {
        Object object;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(vcJwts, (String)"vcJwts");
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        this.satisfiesPresentationDefinition(vcJwts, presentationDefinition);
        Map<InputDescriptorV2, List<String>> inputDescriptorToVcMap = this.mapInputDescriptorsToVCs(vcJwts, presentationDefinition);
        Iterable $this$associate$iv = CollectionsKt.withIndex(vcJwts);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            String vcJwt = (String)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)vcJwt, (Object)index);
            object.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        Map vcJwtToIndexMap = destination$iv$iv;
        List descriptorMapList = new ArrayList();
        for (Map.Entry<InputDescriptorV2, List<String>> entry : inputDescriptorToVcMap.entrySet()) {
            InputDescriptorV2 inputDescriptor = entry.getKey();
            List<String> vcList = entry.getValue();
            String vcJwt = (String)CollectionsKt.firstOrNull(vcList);
            if (vcJwt == null) {
                boolean $i$a$-checkNotNull-PresentationExchange$createPresentationFromCredentials$32 = false;
                String $i$a$-checkNotNull-PresentationExchange$createPresentationFromCredentials$32 = "Illegal state: no vc corresponds to input descriptor";
                throw new IllegalStateException($i$a$-checkNotNull-PresentationExchange$createPresentationFromCredentials$32.toString());
            }
            Integer vcIndex = (Integer)vcJwtToIndexMap.get(vcJwt);
            if (vcIndex == null) {
                boolean bl = false;
                String string = "Illegal state: vcJwt index not found";
                throw new IllegalStateException(string.toString());
            }
            String string = inputDescriptor.getId();
            object = "$.verifiableCredential[" + vcIndex + "]";
            descriptorMapList.add(new InputDescriptorMapping(string, "jwt_vc", (String)object, null, 8, null));
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new PresentationSubmission(string, presentationDefinition.getId(), descriptorMapList);
    }

    public final void validateDefinition(@NotNull PresentationDefinitionV2 presentationDefinition) throws PexValidationException {
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        PresentationDefinitionV2Validator.INSTANCE.validate(presentationDefinition);
    }

    public final void validateSubmission(@NotNull PresentationSubmission presentationSubmission) throws PexValidationException {
        Intrinsics.checkNotNullParameter((Object)presentationSubmission, (String)"presentationSubmission");
        PresentationSubmissionValidator.INSTANCE.validate(presentationSubmission);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<InputDescriptorV2, List<String>> mapInputDescriptorsToVCs(Iterable<String> vcJwtList, PresentationDefinitionV2 presentationDefinition) {
        void $this$filterValues$iv;
        InputDescriptorV2 vcJwt;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<String> iterable = vcJwtList;
        Object object = vcJwtList;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JWT jWT = JWTParser.parse((String)((Object)vcJwt));
            Intrinsics.checkNotNull((Object)jWT, (String)"null cannot be cast to non-null type com.nimbusds.jwt.SignedJWT");
            SignedJWT vc = (SignedJWT)jWT;
            JsonNode jsonNode = JsonPath.Companion.parse(vc.getPayload().toString());
            if (jsonNode == null) {
                throw new JsonPathParseException();
            }
            collection.add(jsonNode);
        }
        List vcJwtListWithNodes = CollectionsKt.zip(object, (Iterable)((List)destination$iv$iv));
        Object $this$associateWith$iv = presentationDefinition.getInputDescriptors();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Pair pair;
            void $this$filterTo$iv$iv;
            vcJwt = (InputDescriptorV2)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = vcJwtListWithNodes;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void inputDescriptor;
                pair = (Pair)element$iv$iv2;
                boolean bl2 = false;
                JsonNode node = (JsonNode)pair.component2();
                if (!INSTANCE.vcSatisfiesInputDescriptor(node, (InputDescriptorV2)inputDescriptor)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                String vcJwt2 = (String)pair.component1();
                collection2.add(vcJwt2);
            }
            List list = (List)destination$iv$iv2;
            object.put(collection, list);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean vcSatisfiesInputDescriptor(JsonNode vcPayloadJson, InputDescriptorV2 inputDescriptor) throws JsonPathParseException {
        block13: {
            void $this$filterTo$iv$iv;
            List<FieldV2> list = inputDescriptor.getConstraints().getFields();
            if (list == null) break block13;
            List<FieldV2> fields = list;
            boolean bl = false;
            Iterable $this$filter$iv = fields;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FieldV2 field = (FieldV2)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)field.getOptional(), (Object)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List requiredFields = (List)destination$iv$iv;
            for (FieldV2 field : requiredFields) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = field.getPath();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JsonNode it$iv$iv;
                    Object object;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String path = (String)element$iv$iv;
                    boolean bl4 = false;
                    JsonNode $this$read$iv = vcPayloadJson;
                    boolean $i$f$read = false;
                    JsonPath this_$iv$iv = new JsonPath(path);
                    boolean $i$f$readFromJson = false;
                    if ($this$read$iv.isMissingNode() || $this$read$iv.isNull()) {
                        object = null;
                    } else {
                        Iterable $this$fold$iv$iv$iv = this_$iv$iv.getTokens();
                        boolean $i$f$fold = false;
                        JsonNode accumulator$iv$iv$iv = $this$read$iv;
                        for (Object element$iv$iv$iv2 : $this$fold$iv$iv$iv) {
                            JsonNode jsonNode;
                            Token token = (Token)element$iv$iv$iv2;
                            JsonNode valueAtPath$iv$iv = accumulator$iv$iv$iv;
                            boolean bl5 = false;
                            if (valueAtPath$iv$iv != null) {
                                void nextToken$iv$iv;
                                JsonNode jsonNode2;
                                JsonNode it$iv$iv2 = jsonNode2;
                                boolean bl6 = false;
                                jsonNode = nextToken$iv$iv.read(it$iv$iv2);
                            } else {
                                jsonNode = null;
                            }
                            accumulator$iv$iv$iv = jsonNode;
                        }
                        JsonNode lastValue$iv$iv = accumulator$iv$iv$iv;
                        if (lastValue$iv$iv == null || lastValue$iv$iv.isNull() || lastValue$iv$iv.isMissingNode()) {
                            object = null;
                        } else {
                            Object object2;
                            try {
                                ObjectMapper $this$convertValue$iv$iv$iv = JacksonUtil.INSTANCE.getMapper();
                                boolean $i$f$convertValue = false;
                                boolean $i$f$jacksonTypeRef = false;
                                object2 = $this$convertValue$iv$iv$iv.convertValue((Object)lastValue$iv$iv, (TypeReference)new TypeReference<JsonNode>(){});
                            }
                            catch (Exception e$iv$iv) {
                                object2 = null;
                            }
                            object = object2;
                        }
                    }
                    if ((JsonNode)object == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List matchedFields = (List)destination$iv$iv2;
                if (matchedFields.isEmpty()) {
                    return false;
                }
                if (field.getFilterSchema() == null) continue;
                JsonSchema jsonSchema = field.getFilterSchema();
                Intrinsics.checkNotNull((Object)jsonSchema);
                boolean satisfiesSchema = INSTANCE.evaluateMatchedFields(matchedFields, jsonSchema);
                if (satisfiesSchema) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean evaluateMatchedFields(List<? extends JsonNode> matchedFields, JsonSchema schema) {
        for (JsonNode jsonNode : matchedFields) {
            if (jsonNode.isArray()) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = (Iterable)jsonNode;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            JsonNode it = (JsonNode)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!INSTANCE.valueSatisfiesFieldFilterSchema(it, schema)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
            if (jsonNode.isArray() && this.isExpectingArray(schema) && this.valueSatisfiesFieldFilterSchema(jsonNode, schema)) {
                return true;
            }
            if (jsonNode.isArray() || !this.valueSatisfiesFieldFilterSchema(jsonNode, schema)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExpectingArray(JsonSchema $this$isExpectingArray) {
        JsonNode typeNode;
        JsonNode jsonNode = $this$isExpectingArray.getSchemaNode();
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"getSchemaNode(...)");
        JsonNode schemaNode = jsonNode;
        return schemaNode instanceof ObjectNode ? (typeNode = schemaNode.get("type")) != null && Intrinsics.areEqual((Object)typeNode.asText(), (Object)"array") : false;
    }

    private final boolean valueSatisfiesFieldFilterSchema(JsonNode fieldValue, JsonSchema schema) {
        Set validationMessages = schema.validate(fieldValue);
        return validationMessages.isEmpty();
    }
}

