/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.credentials;

import com.danubetech.verifiablecredentials.CredentialSubject;
import com.danubetech.verifiablecredentials.VerifiableCredential;
import com.danubetech.verifiablecredentials.credentialstatus.StatusList2021Entry;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.plugins.ClientRequestException;
import io.ktor.client.plugins.ResponseException;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.credentials.BitstringExpansionException;
import web5.sdk.credentials.StatusListCredential;
import web5.sdk.credentials.StatusListCredentialCreateException;
import web5.sdk.credentials.StatusListCredentialFetchException;
import web5.sdk.credentials.StatusListCredentialParseException;
import web5.sdk.credentials.StatusPurpose;
import web5.sdk.credentials.VerifiableCredential;
import web5.sdk.dids.DidResolvers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0016\u0010\u0007\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ\u001a\u0010\u001a\u001a\u00020\n*\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u0014"}, d2={"Lweb5/sdk/credentials/StatusListCredential;", "", "()V", "bitstringExpansion", "", "", "compressedBitstring", "bitstringGeneration", "statusListIndexes", "create", "Lweb5/sdk/credentials/VerifiableCredential;", "statusListCredentialId", "issuer", "statusPurpose", "Lweb5/sdk/credentials/StatusPurpose;", "issuedCredentials", "", "defaultHttpClient", "Lio/ktor/client/HttpClient;", "prepareCredentialsForStatusList", "credentials", "validateCredentialInStatusList", "", "credentialToValidate", "httpClient", "statusListCredential", "fetchStatusListCredential", "url", "(Lio/ktor/client/HttpClient;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;"})
@SourceDebugExtension(value={"SMAP\nStatusListCredential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusListCredential.kt\nweb5/sdk/credentials/StatusListCredential\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt\n+ 4 builders.kt\nio/ktor/client/request/BuildersKt$get$4\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1747#2,3:358\n329#3,4:361\n225#3:365\n99#3,2:367\n22#3:369\n331#4:366\n1#5:370\n*S KotlinDebug\n*F\n+ 1 StatusListCredential.kt\nweb5/sdk/credentials/StatusListCredential\n*L\n172#1:358,3\n229#1:361,4\n229#1:365\n229#1:367,2\n229#1:369\n229#1:366\n*E\n"})
public final class StatusListCredential {
    @NotNull
    public static final StatusListCredential INSTANCE = new StatusListCredential();

    private StatusListCredential() {
    }

    @NotNull
    public final VerifiableCredential create(@NotNull String statusListCredentialId, @NotNull String issuer, @NotNull StatusPurpose statusPurpose, @NotNull Iterable<VerifiableCredential> issuedCredentials) throws StatusListCredentialCreateException {
        Intrinsics.checkNotNullParameter((Object)statusListCredentialId, (String)"statusListCredentialId");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)((Object)statusPurpose), (String)"statusPurpose");
        Intrinsics.checkNotNullParameter(issuedCredentials, (String)"issuedCredentials");
        List<String> statusListIndexes = null;
        String bitString = null;
        try {
            statusListIndexes = this.prepareCredentialsForStatusList(statusPurpose, issuedCredentials);
            bitString = this.bitstringGeneration(statusListIndexes);
        }
        catch (Exception e) {
            throw new StatusListCredentialCreateException(e, "Failed to create status list credential: " + e.getMessage());
        }
        try {
            URI.create(statusListCredentialId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("status list credential id is not a valid URI", e);
        }
        try {
            URI.create(issuer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("issuer is not a valid URI", e);
        }
        try {
            DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)issuer, null, (int)2, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("issuer: " + issuer + " not resolvable", e);
        }
        Pair[] pairArray = new Pair[2];
        String string = statusPurpose.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[0] = TuplesKt.to((Object)"statusPurpose", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"encodedList", (Object)bitString);
        Map claims = MapsKt.mapOf((Pair[])pairArray);
        CredentialSubject credSubject = ((CredentialSubject.Builder)((CredentialSubject.Builder)CredentialSubject.builder().id(URI.create(statusListCredentialId))).type("StatusList2021")).claims(claims).build();
        com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel = ((VerifiableCredential.Builder)((VerifiableCredential.Builder)((VerifiableCredential.Builder)com.danubetech.verifiablecredentials.VerifiableCredential.builder().id(URI.create(statusListCredentialId))).issuer(URI.create(issuer)).issuanceDate(new Date()).context(URI.create("https://w3id.org/vc/status-list/2021/v1"))).type("StatusList2021Credential")).credentialSubject(credSubject).build();
        Intrinsics.checkNotNull((Object)vcDataModel);
        return new VerifiableCredential(vcDataModel);
    }

    public final boolean validateCredentialInStatusList(@NotNull VerifiableCredential credentialToValidate, @NotNull VerifiableCredential statusListCredential) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)credentialToValidate, (String)"credentialToValidate");
            Intrinsics.checkNotNullParameter((Object)statusListCredential, (String)"statusListCredential");
            StatusList2021Entry statusList2021Entry = StatusList2021Entry.fromJsonObject((Map)credentialToValidate.getVcDataModel().getCredentialStatus().getJsonObject());
            Intrinsics.checkNotNullExpressionValue((Object)statusList2021Entry, (String)"fromJsonObject(...)");
            StatusList2021Entry statusListEntryValue = statusList2021Entry;
            Object v = statusListCredential.getVcDataModel().getCredentialSubject().getJsonObject().get("statusPurpose");
            String statusListCredStatusPurpose = v instanceof String ? (String)v : null;
            if (!(statusListEntryValue.getStatusPurpose() != null)) {
                boolean $i$a$-require-StatusListCredential$validateCredentialInStatusList$52 = false;
                String $i$a$-require-StatusListCredential$validateCredentialInStatusList$52 = "Status purpose in the credential to validate is null";
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$validateCredentialInStatusList$52.toString());
            }
            if (!(statusListCredStatusPurpose != null)) {
                boolean $i$a$-require-StatusListCredential$validateCredentialInStatusList$62 = false;
                String $i$a$-require-StatusListCredential$validateCredentialInStatusList$62 = "Status purpose in the status list credential is null";
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$validateCredentialInStatusList$62.toString());
            }
            if (!Intrinsics.areEqual((Object)statusListEntryValue.getStatusPurpose(), (Object)statusListCredStatusPurpose)) {
                boolean $i$a$-require-StatusListCredential$validateCredentialInStatusList$72 = false;
                String $i$a$-require-StatusListCredential$validateCredentialInStatusList$72 = "Status purposes do not match between the credentials";
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$validateCredentialInStatusList$72.toString());
            }
            Object $i$a$-require-StatusListCredential$validateCredentialInStatusList$72 = statusListCredential.getVcDataModel().getCredentialSubject().getJsonObject().get("encodedList");
            String compressedBitstring = $i$a$-require-StatusListCredential$validateCredentialInStatusList$72 instanceof String ? (String)$i$a$-require-StatusListCredential$validateCredentialInStatusList$72 : null;
            $i$a$-require-StatusListCredential$validateCredentialInStatusList$72 = compressedBitstring;
            if (!(!($i$a$-require-StatusListCredential$validateCredentialInStatusList$72 == null || $i$a$-require-StatusListCredential$validateCredentialInStatusList$72.length() == 0))) {
                boolean $i$a$-require-StatusListCredential$validateCredentialInStatusList$82 = false;
                String $i$a$-require-StatusListCredential$validateCredentialInStatusList$82 = "Compressed bitstring is null or empty";
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$validateCredentialInStatusList$82.toString());
            }
            String credentialIndex = statusListEntryValue.getStatusListIndex();
            List<String> expandedValues = this.bitstringExpansion(compressedBitstring);
            Iterable $this$any$iv = expandedValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)credentialIndex)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean validateCredentialInStatusList(@NotNull VerifiableCredential credentialToValidate, @Nullable HttpClient httpClient) throws StatusListCredentialFetchException, StatusListCredentialParseException {
        Intrinsics.checkNotNullParameter((Object)credentialToValidate, (String)"credentialToValidate");
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(httpClient, credentialToValidate, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ HttpClient $httpClient;
            final /* synthetic */ VerifiableCredential $credentialToValidate;
            {
                this.$httpClient = $httpClient;
                this.$credentialToValidate = $credentialToValidate;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        isDefaultClient = new Ref.BooleanRef();
                        v0 = this.$httpClient;
                        if (v0 == null) {
                            var5_4 = StatusListCredential.access$defaultHttpClient(StatusListCredential.INSTANCE);
                            $i$a$-also-StatusListCredential$validateCredentialInStatusList$6$client$1 = false;
                            isDefaultClient.element = true;
                            v0 = var5_4;
                        }
                        client = v0;
                        v1 = StatusList2021Entry.fromJsonObject((Map)this.$credentialToValidate.getVcDataModel().getCredentialStatus().getJsonObject());
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"fromJsonObject(...)");
                        statusListEntryValue = v1;
                        var6_9 = statusListEntryValue.getStatusListCredential().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"toString(...)");
                        this.L$0 = isDefaultClient;
                        this.L$1 = client;
                        this.label = 1;
                        v2 = StatusListCredential.access$fetchStatusListCredential(StatusListCredential.INSTANCE, client, (String)var6_9, (Continuation)this);
                        ** if (v2 != var8_2) goto lbl26
lbl25:
                        // 1 sources

                        return var8_2;
lbl26:
                        // 1 sources

                        ** GOTO lbl34
                    }
                    case 1: {
                        client = (HttpClient)this.L$1;
                        isDefaultClient = (Ref.BooleanRef)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl34:
                            // 2 sources

                            statusListCredential = (VerifiableCredential)v2;
                            var6_9 = Boxing.boxBoolean((boolean)StatusListCredential.INSTANCE.validateCredentialInStatusList(this.$credentialToValidate, statusListCredential));
                            return var6_9;
                        }
                        catch (Throwable var5_5) {
                            throw var5_5;
                        }
                        finally {
                            if (isDefaultClient.element) {
                                client.close();
                            }
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ boolean validateCredentialInStatusList$default(StatusListCredential statusListCredential, VerifiableCredential verifiableCredential, HttpClient httpClient, int n, Object object) throws StatusListCredentialFetchException, StatusListCredentialParseException {
        if ((n & 2) != 0) {
            httpClient = null;
        }
        return statusListCredential.validateCredentialInStatusList(verifiableCredential, httpClient);
    }

    private final HttpClient defaultHttpClient() {
        return HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)OkHttp.INSTANCE), (Function1)defaultHttpClient.1.INSTANCE);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object fetchStatusListCredential(HttpClient var1_1, String var2_2, Continuation<? super VerifiableCredential> var3_3) {
        if (!(var3_3 instanceof fetchStatusListCredential.1)) ** GOTO lbl-1000
        var19_4 = var3_3;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StatusListCredential this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StatusListCredential.access$fetchStatusListCredential(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$get_u24default$iv = $this$fetchStatusListCredential;
                $i$f$get = false;
                $this$get$iv$iv = $this$get_u24default$iv;
                $i$f$get = false;
                var9_13 = $this$get$iv$iv;
                $this$get_u24lambda_u244$iv = var10_14 = new HttpRequestBuilder();
                $i$a$-get-BuildersKt$get$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)url);
                var13_17 = $this$get_u24lambda_u244$iv;
                $i$a$-get-BuildersKt$get$4 = false;
                builder$iv$iv$iv = var10_14;
                $i$f$get = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = url;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                ** if (v0 != var20_6) goto lbl35
lbl34:
                // 1 sources

                return var20_6;
lbl35:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$f$get = false;
                $i$f$get = false;
                $i$f$get = false;
                $i$f$request = false;
                url = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl48:
                // 2 sources

                response = (HttpResponse)v0;
                if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)response.getStatus())) throw new ClientRequestException(response, "Failed to retrieve VerifiableCredentialType from " + url);
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = HttpResponseKt.bodyAsText$default((HttpResponse)response, null, (Continuation)$continuation, (int)1, null);
                ** if (v1 != var20_6) goto lbl55
lbl54:
                // 1 sources

                return var20_6;
lbl55:
                // 1 sources

                ** GOTO lbl61
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl61:
                // 2 sources

                body = (String)v1;
                return VerifiableCredential.Companion.parseJwt(body);
            }
        }
        catch (ResponseException e) {
            throw new StatusListCredentialFetchException(e, "Failed to fetch status list credential: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new StatusListCredentialParseException(e, "Failed to parse status list credential: " + e.getMessage());
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> prepareCredentialsForStatusList(StatusPurpose statusPurpose, Iterable<VerifiableCredential> credentials) {
        Set duplicateSet = new LinkedHashSet();
        for (VerifiableCredential vc : credentials) {
            StatusList2021Entry statusListEntry;
            if (vc.getVcDataModel().getCredentialStatus() == null) {
                boolean bl = false;
                String string = "no credential status found in credential";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)StatusList2021Entry.fromJsonObject((Map)vc.getVcDataModel().getCredentialStatus().getJsonObject()), (String)"fromJsonObject(...)");
            String string = statusListEntry.getStatusPurpose();
            String string2 = statusPurpose.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)string2)) {
                boolean bl = false;
                String string3 = "status purpose mismatch";
                throw new IllegalArgumentException(string3.toString());
            }
            String string4 = statusListEntry.getStatusListIndex();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStatusListIndex(...)");
            if (duplicateSet.add(string4)) continue;
            throw new IllegalArgumentException("duplicate entry found with index: " + statusListEntry.getStatusListIndex());
        }
        return CollectionsKt.toList((Iterable)duplicateSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String bitstringGeneration(List<String> statusListIndexes) {
        Set duplicateCheck = new LinkedHashSet();
        int bitSetSize = 131072;
        BitSet bitSet = new BitSet(bitSetSize);
        for (String index : statusListIndexes) {
            Integer indexInt = StringsKt.toIntOrNull((String)index);
            if (!(indexInt != null && indexInt >= 0)) {
                boolean $i$a$-require-StatusListCredential$bitstringGeneration$42 = false;
                String $i$a$-require-StatusListCredential$bitstringGeneration$42 = "invalid status list index: " + index;
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$bitstringGeneration$42.toString());
            }
            if (!(indexInt < bitSetSize)) {
                boolean bl = false;
                throw new IndexOutOfBoundsException("invalid status list index: " + index + ", index is larger than the bitset size");
            }
            if (!duplicateCheck.add(indexInt)) {
                boolean $i$a$-require-StatusListCredential$bitstringGeneration$52 = false;
                String $i$a$-require-StatusListCredential$bitstringGeneration$52 = "duplicate status list index value found: " + indexInt;
                throw new IllegalArgumentException($i$a$-require-StatusListCredential$bitstringGeneration$52.toString());
            }
            bitSet.set(indexInt);
        }
        byte[] bitstringBinary = bitSet.toByteArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Closeable closeable = new GZIPOutputStream(baos);
        Throwable throwable = null;
        try {
            GZIPOutputStream it = (GZIPOutputStream)closeable;
            boolean bl = false;
            it.write(bitstringBinary);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = Base64.getEncoder().encodeToString(baos.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> bitstringExpansion(String compressedBitstring) throws BitstringExpansionException {
        byte[] decoded = null;
        try {
            byte[] byArray = Base64.getDecoder().decode(compressedBitstring);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            decoded = byArray;
        }
        catch (Exception e) {
            throw new BitstringExpansionException(e, "Failed to decode compressed bitstring: " + e.getMessage());
        }
        ByteArrayInputStream bitstringInputStream = new ByteArrayInputStream(decoded);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Closeable closeable = new GZIPInputStream(bitstringInputStream);
            Throwable throwable = null;
            try {
                GZIPInputStream it22 = (GZIPInputStream)closeable;
                boolean bl = false;
                long it22 = ByteStreamsKt.copyTo$default((InputStream)it22, (OutputStream)byteArrayOutputStream, (int)0, (int)2, null);
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new BitstringExpansionException(e, "Failed to unzip status list bitstring using GZIP: " + e.getMessage());
        }
        byte[] unzipped = byteArrayOutputStream.toByteArray();
        BitSet b = BitSet.valueOf(unzipped);
        List expanded = new ArrayList();
        int n = b.length();
        for (int i = 0; i < n; ++i) {
            if (!b.get(i)) continue;
            expanded.add(String.valueOf(i));
        }
        return expanded;
    }

    @JvmOverloads
    public final boolean validateCredentialInStatusList(@NotNull VerifiableCredential credentialToValidate) throws StatusListCredentialFetchException, StatusListCredentialParseException {
        Intrinsics.checkNotNullParameter((Object)credentialToValidate, (String)"credentialToValidate");
        return StatusListCredential.validateCredentialInStatusList$default(this, credentialToValidate, null, 2, null);
    }

    public static final /* synthetic */ HttpClient access$defaultHttpClient(StatusListCredential $this) {
        return $this.defaultHttpClient();
    }

    public static final /* synthetic */ Object access$fetchStatusListCredential(StatusListCredential $this, HttpClient $receiver, String url, Continuation $completion) {
        return $this.fetchStatusListCredential($receiver, url, (Continuation<? super VerifiableCredential>)$completion);
    }
}

