/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.credentials.util;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.security.SignatureException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Convert;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.DidResolvers;
import web5.sdk.dids.didcore.DIDDocument;
import web5.sdk.dids.didcore.DidUri;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.DidResolutionException;
import web5.sdk.dids.exceptions.PublicKeyJwkMissingException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lweb5/sdk/credentials/util/JwtUtil;", "", "()V", "sign", "", "did", "Lweb5/sdk/dids/Did;", "assertionMethodId", "jwtPayload", "Lcom/nimbusds/jwt/JWTClaimsSet;", "verify", "", "jwtString", "credentials"})
@SourceDebugExtension(value={"SMAP\nJwtUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtUtil.kt\nweb5/sdk/credentials/util/JwtUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n288#2,2:175\n1#3:177\n*S KotlinDebug\n*F\n+ 1 JwtUtil.kt\nweb5/sdk/credentials/util/JwtUtil\n*L\n130#1:175,2\n*E\n"})
public final class JwtUtil {
    @NotNull
    public static final JwtUtil INSTANCE = new JwtUtil();

    private JwtUtil() {
    }

    @NotNull
    public final String sign(@NotNull Did did, @Nullable String assertionMethodId, @NotNull JWTClaimsSet jwtPayload) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)jwtPayload, (String)"jwtPayload");
        DidResolutionResult didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)did.getUri(), null, (int)2, null);
        DIDDocument didDocument = didResolutionResult.getDidDocument();
        if (didResolutionResult.getDidResolutionMetadata().getError() != null || didDocument == null) {
            throw new DidResolutionException("Signature verification failed: Failed to resolve DID " + did.getUri() + ". Error: " + didResolutionResult.getDidResolutionMetadata().getError());
        }
        VerificationMethod assertionMethod = didDocument.findAssertionMethodById(assertionMethodId);
        JWK jWK = assertionMethod.getPublicKeyJwk();
        if (jWK == null) {
            throw new PublicKeyJwkMissingException("publicKeyJwk is null.");
        }
        JWK publicKeyJwk = jWK;
        String keyAlias = did.getKeyManager().getDeterministicAlias(publicKeyJwk);
        Algorithm algorithm = publicKeyJwk.getAlgorithm();
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)algorithm.toString());
        boolean bl = URI.create(assertionMethod.getId()).isAbsolute();
        if (bl) {
            object = assertionMethod.getId();
        } else if (!bl) {
            object = did.getUri() + assertionMethod.getId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String kid = object;
        JWSHeader jwtHeader = new JWSHeader.Builder(jwsAlgorithm).type(JOSEObjectType.JWT).keyID(kid).build();
        SignedJWT jwtObject = new SignedJWT(jwtHeader, jwtPayload);
        byte[] toSign = jwtObject.getSigningInput();
        KeyManager keyManager = did.getKeyManager();
        Intrinsics.checkNotNull((Object)toSign);
        byte[] signatureBytes = keyManager.sign(keyAlias, toSign);
        Base64URL base64UrlEncodedHeader = jwtHeader.toBase64URL();
        Base64URL base64UrlEncodedPayload = jwtPayload.toPayload().toBase64URL();
        Base64URL base64UrlEncodedSignature = new Base64URL(new Convert((Object)signatureBytes, null, 2, null).toBase64Url(false));
        return base64UrlEncodedHeader + "." + base64UrlEncodedPayload + "." + base64UrlEncodedSignature;
    }

    public final void verify(@NotNull String jwtString) {
        VerificationMethod assertionVerificationMethod;
        VerificationMethod verificationMethod;
        List list;
        String it;
        Set verificationMethodIds;
        DidResolutionResult didResolutionResult;
        SignedJWT jwt;
        block16: {
            block15: {
                Object v2;
                Object object;
                block13: {
                    Intrinsics.checkNotNullParameter((Object)jwtString, (String)"jwtString");
                    JWT jWT = JWTParser.parse((String)jwtString);
                    Intrinsics.checkNotNull((Object)jWT, (String)"null cannot be cast to non-null type com.nimbusds.jwt.SignedJWT");
                    jwt = (SignedJWT)jWT;
                    if (!(jwt.getHeader().getAlgorithm() != null && jwt.getHeader().getKeyID() != null)) {
                        boolean $i$a$-require-JwtUtil$verify$22 = false;
                        String $i$a$-require-JwtUtil$verify$22 = "Signature verification failed: Expected JWS header to contain alg and kid";
                        throw new IllegalArgumentException($i$a$-require-JwtUtil$verify$22.toString());
                    }
                    String verificationMethodId = jwt.getHeader().getKeyID();
                    Intrinsics.checkNotNull((Object)verificationMethodId);
                    DidUri didUri = DidUri.Parser.parse(verificationMethodId);
                    didResolutionResult = DidResolvers.resolve$default((DidResolvers)DidResolvers.INSTANCE, (String)didUri.getUrl(), null, (int)2, null);
                    if (didResolutionResult.getDidResolutionMetadata().getError() != null) {
                        throw new SignatureException("Signature verification failed: Failed to resolve DID " + didUri.getUrl() + ". Error: " + didResolutionResult.getDidResolutionMetadata().getError());
                    }
                    Object[] objectArray = new String[]{didUri.getUrl(), "#" + didUri.getFragment()};
                    verificationMethodIds = SetsKt.setOf((Object[])objectArray);
                    object = didResolutionResult.getDidDocument();
                    if (object == null || (object = object.getAssertionMethod()) == null) break block15;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (String)element$iv;
                        boolean bl = false;
                        if (!verificationMethodIds.contains(it)) continue;
                        v2 = element$iv;
                        break block13;
                    }
                    v2 = null;
                }
                if ((object = (String)v2) != null) break block16;
            }
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method with an Assertion verification relationship");
        }
        DIDDocument dIDDocument = didResolutionResult.getDidDocument();
        if (dIDDocument != null && (list = dIDDocument.getVerificationMethod()) != null) {
            Object v3;
            block14: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    it = (VerificationMethod)t;
                    boolean bl = false;
                    if (!verificationMethodIds.contains(it.getId())) continue;
                    v3 = t;
                    break block14;
                }
                v3 = null;
            }
            verificationMethod = v3;
        } else {
            verificationMethod = assertionVerificationMethod = null;
        }
        if (assertionVerificationMethod == null) {
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method with an Assertion verification relationship");
        }
        if (!((assertionVerificationMethod.isType("JsonWebKey2020") || assertionVerificationMethod.isType("JsonWebKey")) && assertionVerificationMethod.getPublicKeyJwk() != null)) {
            boolean bl = false;
            throw new SignatureException("Signature verification failed: Expected kid in JWS header to dereference a DID Document Verification Method of type JsonWebKey2020 or JsonWebKey with a publicKeyJwk");
        }
        JWK jWK = assertionVerificationMethod.getPublicKeyJwk();
        if (jWK == null) {
            throw new PublicKeyJwkMissingException("publicKeyJwk is null");
        }
        JWK publicKeyJwk = jWK;
        byte[] toVerifyBytes = jwt.getSigningInput();
        byte[] signatureBytes = jwt.getSignature().decode();
        Intrinsics.checkNotNull((Object)toVerifyBytes);
        Intrinsics.checkNotNull((Object)signatureBytes);
        Crypto.INSTANCE.verify(publicKeyJwk, toVerifyBytes, signatureBytes);
    }
}

