/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.credentials;

import com.danubetech.verifiablecredentials.CredentialSubject;
import com.danubetech.verifiablecredentials.VerifiableCredential;
import com.danubetech.verifiablecredentials.credentialstatus.CredentialStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.nfeld.jsonpathkt.JsonPath;
import com.nfeld.jsonpathkt.Token;
import com.nfeld.jsonpathkt.util.JacksonUtil;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Json;
import web5.sdk.credentials.CredentialSchema;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.jose.jwt.DecodedJwt;
import web5.sdk.jose.jwt.Jwt;
import web5.sdk.jose.jwt.JwtClaimsSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u000fJ\u001c\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lweb5/sdk/credentials/VerifiableCredential;", "", "vcDataModel", "Lcom/danubetech/verifiablecredentials/VerifiableCredential;", "Lweb5/sdk/credentials/VcDataModel;", "(Lcom/danubetech/verifiablecredentials/VerifiableCredential;)V", "credentialSchema", "Lweb5/sdk/credentials/CredentialSchema;", "getCredentialSchema", "()Lweb5/sdk/credentials/CredentialSchema;", "evidence", "", "getEvidence", "()Ljava/util/List;", "issuer", "", "getIssuer", "()Ljava/lang/String;", "subject", "getSubject", "type", "getType", "getVcDataModel", "()Lcom/danubetech/verifiablecredentials/VerifiableCredential;", "getFieldByJsonPath", "path", "sign", "did", "Lweb5/sdk/dids/did/BearerDid;", "assertionMethodId", "toString", "Companion", "web5-credentials"})
@SourceDebugExtension(value={"SMAP\nVerifiableCredential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/credentials/VerifiableCredential\n+ 2 JsonNode.kt\ncom/nfeld/jsonpathkt/extension/JsonNodeKt\n+ 3 JsonPath.kt\ncom/nfeld/jsonpathkt/JsonPath\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,412:1\n11#2:413\n45#3,5:414\n50#3:421\n53#3,5:424\n58#3,2:431\n1783#4,2:419\n1785#4:423\n1#5:422\n56#6:429\n43#6:430\n*S KotlinDebug\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/credentials/VerifiableCredential\n*L\n97#1:413\n97#1:414,5\n97#1:421\n97#1:424,5\n97#1:431,2\n97#1:419,2\n97#1:423\n97#1:422\n97#1:429\n97#1:430\n*E\n"})
public final class VerifiableCredential {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel;
    @NotNull
    private static final ObjectMapper objectMapper;

    public VerifiableCredential(@NotNull com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel) {
        Intrinsics.checkNotNullParameter((Object)vcDataModel, (String)"vcDataModel");
        this.vcDataModel = vcDataModel;
    }

    @NotNull
    public final com.danubetech.verifiablecredentials.VerifiableCredential getVcDataModel() {
        return this.vcDataModel;
    }

    @NotNull
    public final String getType() {
        List list = this.vcDataModel.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
        Object object = CollectionsKt.last((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        return (String)object;
    }

    @NotNull
    public final String getIssuer() {
        String string = this.vcDataModel.getIssuer().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getSubject() {
        String string = this.vcDataModel.getCredentialSubject().getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final List<Object> getEvidence() {
        return (List)this.vcDataModel.toMap().get("evidence");
    }

    @Nullable
    public final CredentialSchema getCredentialSchema() {
        return (CredentialSchema)this.vcDataModel.toMap().get("credentialSchema");
    }

    @JvmOverloads
    @NotNull
    public final String sign(@NotNull BearerDid did, @Nullable String assertionMethodId) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        JwtClaimsSet.Builder builder = new JwtClaimsSet.Builder().issuer(did.getUri()).issueTime(this.vcDataModel.getIssuanceDate().getTime());
        String string = this.vcDataModel.getCredentialSubject().getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        JwtClaimsSet.Builder builder2 = builder.subject(string);
        Map map = this.vcDataModel.toMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toMap(...)");
        JwtClaimsSet payload = builder2.misc("vc", (Object)map).build();
        return Jwt.INSTANCE.sign(did, payload);
    }

    public static /* synthetic */ String sign$default(VerifiableCredential verifiableCredential, BearerDid bearerDid, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return verifiableCredential.sign(bearerDid, string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getFieldByJsonPath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string2 = this.vcDataModel.toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        String vcJsonString = string2;
        JsonNode jsonNode = JsonPath.Companion.parse(vcJsonString);
        if (jsonNode != null) {
            Object object;
            JsonNode $this$read$iv = jsonNode;
            boolean $i$f$read = false;
            JsonPath this_$iv$iv = new JsonPath(path);
            boolean $i$f$readFromJson = false;
            if ($this$read$iv.isMissingNode() || $this$read$iv.isNull()) {
                object = null;
            } else {
                Iterable $this$fold$iv$iv$iv = this_$iv$iv.getTokens();
                boolean $i$f$fold = false;
                JsonNode accumulator$iv$iv$iv = $this$read$iv;
                for (Object element$iv$iv$iv : $this$fold$iv$iv$iv) {
                    JsonNode jsonNode2;
                    Token token = (Token)element$iv$iv$iv;
                    JsonNode valueAtPath$iv$iv = accumulator$iv$iv$iv;
                    boolean bl = false;
                    if (valueAtPath$iv$iv != null) {
                        void nextToken$iv$iv;
                        JsonNode jsonNode3;
                        JsonNode it$iv$iv = jsonNode3;
                        boolean bl2 = false;
                        jsonNode2 = nextToken$iv$iv.read(it$iv$iv);
                    } else {
                        jsonNode2 = null;
                    }
                    accumulator$iv$iv$iv = jsonNode2;
                }
                JsonNode lastValue$iv$iv = accumulator$iv$iv$iv;
                if (lastValue$iv$iv == null || lastValue$iv$iv.isNull() || lastValue$iv$iv.isMissingNode()) {
                    object = null;
                } else {
                    Object object2;
                    try {
                        ObjectMapper $this$convertValue$iv$iv$iv = JacksonUtil.INSTANCE.getMapper();
                        boolean $i$f$convertValue = false;
                        boolean $i$f$jacksonTypeRef = false;
                        object2 = $this$convertValue$iv$iv$iv.convertValue((Object)lastValue$iv$iv, (TypeReference)new TypeReference<String>(){});
                    }
                    catch (Exception e$iv$iv) {
                        object2 = null;
                    }
                    object = object2;
                }
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.vcDataModel.toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String sign(@NotNull BearerDid did) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        return VerifiableCredential.sign$default(this, did, null, 2, null);
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        ObjectMapper $this$objectMapper_u24lambda_u240 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$objectMapper_u24lambda_u240.registerModule((Module)new KotlinModule.Builder().build());
        $this$objectMapper_u24lambda_u240.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        VerifiableCredential.objectMapper = objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jw\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u0002H\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\tJ\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lweb5/sdk/credentials/VerifiableCredential$Companion;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "create", "Lweb5/sdk/credentials/VerifiableCredential;", "T", "type", "", "issuer", "subject", "data", "issuanceDate", "Ljava/util/Date;", "expirationDate", "credentialStatus", "Lcom/danubetech/verifiablecredentials/credentialstatus/CredentialStatus;", "credentialSchema", "Lweb5/sdk/credentials/CredentialSchema;", "evidence", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/util/Date;Ljava/util/Date;Lcom/danubetech/verifiablecredentials/credentialstatus/CredentialStatus;Lweb5/sdk/credentials/CredentialSchema;Ljava/util/List;)Lweb5/sdk/credentials/VerifiableCredential;", "fromJson", "vcJson", "parseJwt", "vcJwt", "validateDataModel", "", "model", "", "verify", "web5-credentials"})
    @SourceDebugExtension(value={"SMAP\nVerifiableCredential.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/credentials/VerifiableCredential$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nweb5/sdk/common/Json\n*L\n1#1,412:1\n62#2:413\n49#2:414\n1#3:415\n62#4:416\n*S KotlinDebug\n*F\n+ 1 VerifiableCredential.kt\nweb5/sdk/credentials/VerifiableCredential$Companion\n*L\n147#1:413\n147#1:414\n282#1:416\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data, @NotNull Date issuanceDate, @Nullable Date expirationDate, @Nullable CredentialStatus credentialStatus, @Nullable CredentialSchema credentialSchema, @Nullable List<? extends Object> evidence) {
            VerifiableCredential.Builder builder;
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)issuanceDate, (String)"issuanceDate");
            JsonNode jsonNode = objectMapper.valueToTree(data);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"valueToTree(...)");
            JsonNode jsonData = jsonNode;
            boolean bl = jsonData.isObject();
            if (!bl) {
                if (!bl) {
                    throw new IllegalArgumentException("expected data to be parseable into a JSON object");
                }
                throw new NoWhenBranchMatchedException();
            }
            ObjectMapper $this$convertValue$iv = objectMapper;
            boolean $i$f$convertValue = false;
            boolean $i$f$jacksonTypeRef = false;
            Map mapData = (Map)$this$convertValue$iv.convertValue((Object)jsonData, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            CredentialSubject credentialSubject = ((CredentialSubject.Builder)CredentialSubject.builder().id(URI.create(subject))).claims(mapData).build();
            VerifiableCredential.Builder builder2 = builder = ((VerifiableCredential.Builder)((VerifiableCredential.Builder)com.danubetech.verifiablecredentials.VerifiableCredential.builder().type(type)).id(URI.create("urn:uuid:" + UUID.randomUUID()))).issuer(URI.create(issuer)).issuanceDate(issuanceDate).credentialSubject(credentialSubject);
            boolean bl2 = false;
            Date date = expirationDate;
            if (date != null) {
                Date it = date;
                boolean bl3 = false;
                builder2.expirationDate(it);
            }
            CredentialStatus credentialStatus2 = credentialStatus;
            if (credentialStatus2 != null) {
                CredentialStatus status = credentialStatus2;
                boolean bl4 = false;
                builder2.credentialStatus(status);
                VerifiableCredential.Builder cfr_ignored_0 = (VerifiableCredential.Builder)builder2.context(URI.create("https://w3id.org/vc/status-list/2021/v1"));
            }
            CredentialSchema credentialSchema2 = credentialSchema;
            if (credentialSchema2 != null) {
                CredentialSchema schema = credentialSchema2;
                boolean bl5 = false;
                VerifiableCredential.Builder cfr_ignored_1 = (VerifiableCredential.Builder)builder2.properties(MapsKt.mapOf((Pair)TuplesKt.to((Object)"credentialSchema", (Object)schema)));
            }
            List<? extends Object> list = evidence;
            if (list != null) {
                List<? extends Object> ev = list;
                boolean bl6 = false;
                builder2.properties(MapsKt.mapOf((Pair)TuplesKt.to((Object)"evidence", ev)));
            }
            com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel = builder.build();
            Map map = vcDataModel.toMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toMap(...)");
            this.validateDataModel(map);
            Intrinsics.checkNotNull((Object)vcDataModel);
            return new VerifiableCredential(vcDataModel);
        }

        public static /* synthetic */ VerifiableCredential create$default(Companion companion, String string, String string2, String string3, Object object, Date date, Date date2, CredentialStatus credentialStatus, CredentialSchema credentialSchema, List list, int n, Object object2) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                date = new Date();
            }
            if ((n & 0x20) != 0) {
                date2 = null;
            }
            if ((n & 0x40) != 0) {
                credentialStatus = null;
            }
            if ((n & 0x80) != 0) {
                credentialSchema = null;
            }
            if ((n & 0x100) != 0) {
                list = null;
            }
            return companion.create(string, string2, string3, object, date, date2, credentialStatus, credentialSchema, list);
        }

        public final void verify(@NotNull String vcJwt) {
            long l;
            Intrinsics.checkNotNullParameter((Object)vcJwt, (String)"vcJwt");
            DecodedJwt decodedJwt = Jwt.INSTANCE.decode(vcJwt);
            Long exp = decodedJwt.getClaims().getExp();
            String iss = decodedJwt.getClaims().getIss();
            Long nbf = decodedJwt.getClaims().getNbf();
            String jti = decodedJwt.getClaims().getJti();
            String sub = decodedJwt.getClaims().getSub();
            VerifiableCredential vc = this.parseJwt(vcJwt);
            com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel = vc.getVcDataModel();
            if (exp != null && vcDataModel.getExpirationDate() != null) {
                l = vcDataModel.getExpirationDate().getTime() / (long)1000;
                if (exp != l) {
                    throw new IllegalArgumentException("Verification failed: exp claim does not match expirationDate");
                }
            }
            if (!(iss != null)) {
                boolean $i$a$-require-VerifiableCredential$Companion$verify$32 = false;
                String $i$a$-require-VerifiableCredential$Companion$verify$32 = "Verification failed: iss claim is required";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$verify$32.toString());
            }
            if (!Intrinsics.areEqual((Object)iss, (Object)vcDataModel.getIssuer().toString())) {
                boolean bl = false;
                String string = "Verification failed: iss claim does not match expected issuer";
                throw new IllegalArgumentException(string.toString());
            }
            if (nbf != null && nbf >= new Date().getTime() / (long)1000) {
                throw new IllegalArgumentException("Verification failed: nbf claim is in the future");
            }
            if (nbf != null && vcDataModel.getIssuanceDate() != null) {
                l = vcDataModel.getIssuanceDate().getTime() / (long)1000;
                if (nbf != l) {
                    throw new IllegalArgumentException("Verification failed: nbf claim does not match issuanceDate");
                }
            }
            if (sub != null && !Intrinsics.areEqual((Object)sub, (Object)vcDataModel.getCredentialSubject().getId().toString())) {
                throw new IllegalArgumentException("Verification failed: sub claim does not match credentialSubject.id");
            }
            if (jti != null && !Intrinsics.areEqual((Object)jti, (Object)vcDataModel.getId().toString())) {
                throw new IllegalArgumentException("Verification failed: jti claim does not match id");
            }
            Map map = vcDataModel.toMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toMap(...)");
            this.validateDataModel(map);
            decodedJwt.verify();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VerifiableCredential parseJwt(@NotNull String vcJwt) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)vcJwt, (String)"vcJwt");
            DecodedJwt jwt = Jwt.INSTANCE.decode(vcJwt);
            JwtClaimsSet jwtPayload = jwt.getClaims();
            Object v = jwtPayload.getMisc().get("vc");
            if (v == null) {
                throw new IllegalArgumentException("jwt payload missing vc property");
            }
            Object vcDataModelValue = v;
            Json json = Json.INSTANCE;
            String payload$iv = Json.INSTANCE.stringify(vcDataModelValue);
            boolean $i$f$parse = false;
            Map vcDataModelMap = (Map)this_$iv.getObjectReader().readValue(payload$iv, Map.class);
            com.danubetech.verifiablecredentials.VerifiableCredential vcDataModel = com.danubetech.verifiablecredentials.VerifiableCredential.fromMap((Map)vcDataModelMap);
            Intrinsics.checkNotNull((Object)vcDataModel);
            return new VerifiableCredential(vcDataModel);
        }

        @NotNull
        public final VerifiableCredential fromJson(@NotNull String vcJson) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)vcJson, (String)"vcJson");
            TypeReference<HashMap<String, Object>> typeRef2 = new TypeReference<HashMap<String, Object>>(){};
            HashMap vcMap = (HashMap)objectMapper.readValue(vcJson, (TypeReference)typeRef2);
            Intrinsics.checkNotNull((Object)vcMap);
            this.validateDataModel(vcMap);
            com.danubetech.verifiablecredentials.VerifiableCredential verifiableCredential = com.danubetech.verifiablecredentials.VerifiableCredential.fromMap((Map)vcMap);
            Intrinsics.checkNotNullExpressionValue((Object)verifiableCredential, (String)"fromMap(...)");
            return new VerifiableCredential(verifiableCredential);
        }

        private final void validateDataModel(Map<String, ? extends Object> model) {
            Object expirationDate;
            Object type;
            if (!(model.get("credentialSubject") != null)) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$182 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$182 = "credentialSubject property is required";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$182.toString());
            }
            Object context = model.get("@context");
            if (!(context instanceof List && !((Collection)context).isEmpty())) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$192 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$192 = "context must have at least one entry but got " + context;
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$192.toString());
            }
            if (!Intrinsics.areEqual((Object)String.valueOf(CollectionsKt.first((List)((List)context))), (Object)"https://www.w3.org/2018/credentials/v1")) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$202 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$202 = "first item of context must be https://www.w3.org/2018/credentials/v1";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$202.toString());
            }
            Regex uriRegex = new Regex("\\w+:(/?/?)\\S+");
            Object id = model.get("id");
            if (id != null) {
                if (!(id instanceof String)) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$212 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$212 = "id must be a string but found " + id;
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$212.toString());
                }
                if (!uriRegex.matches((CharSequence)id)) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$222 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$222 = "id must be a URI but found " + id;
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$222.toString());
                }
            }
            if (!((type = model.get("type")) instanceof List && !((Collection)type).isEmpty())) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$232 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$232 = "type property must have one or more URIs";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$232.toString());
            }
            if (!Intrinsics.areEqual((Object)"VerifiableCredential", (Object)CollectionsKt.first((List)((List)type)))) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$242 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$242 = "first item of type must be \"VerifiableCredential\"";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$242.toString());
            }
            Object issuanceDate = model.get("issuanceDate");
            Regex dateTimeLexicalRegex = new Regex("-?([1-9][0-9]{3,}|0[0-9]{3})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?|(24:00:00(\\.0+)?))(Z|([+\\-])((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?");
            if (!(issuanceDate != null)) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$252 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$252 = "issuanceDate property is required";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$252.toString());
            }
            if (!(issuanceDate instanceof String && dateTimeLexicalRegex.matches((CharSequence)issuanceDate))) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$262 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$262 = "issuanceDate must be in XMLSCHEMA11-2 combined date-time format. For example: 2010-01-01T19:23:24Z";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$262.toString());
            }
            Object issuer = model.get("issuer");
            if (!(issuer != null)) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$272 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$272 = "issuer property is required";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$272.toString());
            }
            if (!(!(issuer instanceof List))) {
                boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$282 = false;
                String $i$a$-require-VerifiableCredential$Companion$validateDataModel$282 = "issuer cannot be a list";
                throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$282.toString());
            }
            Object $i$a$-require-VerifiableCredential$Companion$validateDataModel$262 = issuer;
            if ($i$a$-require-VerifiableCredential$Companion$validateDataModel$262 instanceof String) {
                if (!uriRegex.matches((CharSequence)issuer)) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$292 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$292 = "when issuer is a string, it must be a URI but was " + issuer;
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$292.toString());
                }
            } else if ($i$a$-require-VerifiableCredential$Companion$validateDataModel$262 instanceof Map) {
                if (!((Map)issuer).containsValue("id")) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$302 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$302 = "when issuer is an object, it must contain an id property";
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$302.toString());
                }
            } else {
                throw new IllegalArgumentException("issuer must be a URI or an object containing an id property, but found " + issuer);
            }
            if ((expirationDate = model.get("expirationDate")) != null && !(expirationDate instanceof String && dateTimeLexicalRegex.matches((CharSequence)expirationDate))) {
                boolean bl = false;
                String string = "expirationDate must be in XMLSCHEMA11-2 combined date-time format. For example: 2010-01-01T19:23:24Z";
                throw new IllegalArgumentException(string.toString());
            }
            Object credentialStatus = model.get("credentialStatus");
            if (credentialStatus != null) {
                if (!(credentialStatus instanceof Map)) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$312 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$312 = "credentialStatus must be an object but found " + credentialStatus;
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$312.toString());
                }
                if (!((Map)credentialStatus).containsKey("type")) {
                    boolean $i$a$-require-VerifiableCredential$Companion$validateDataModel$322 = false;
                    String $i$a$-require-VerifiableCredential$Companion$validateDataModel$322 = "credentialStatus must contain a type property";
                    throw new IllegalArgumentException($i$a$-require-VerifiableCredential$Companion$validateDataModel$322.toString());
                }
                if (!((Map)credentialStatus).containsKey("id")) {
                    boolean bl = false;
                    String string = "credentialStatus must contain an id property";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data, @NotNull Date issuanceDate, @Nullable Date expirationDate, @Nullable CredentialStatus credentialStatus, @Nullable CredentialSchema credentialSchema) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)issuanceDate, (String)"issuanceDate");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, type, issuer, subject, data, issuanceDate, expirationDate, credentialStatus, credentialSchema, null, 256, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data, @NotNull Date issuanceDate, @Nullable Date expirationDate, @Nullable CredentialStatus credentialStatus) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)issuanceDate, (String)"issuanceDate");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, type, issuer, subject, data, issuanceDate, expirationDate, credentialStatus, null, null, 384, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data, @NotNull Date issuanceDate, @Nullable Date expirationDate) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)issuanceDate, (String)"issuanceDate");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, type, issuer, subject, data, issuanceDate, expirationDate, null, null, null, 448, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data, @NotNull Date issuanceDate) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)issuanceDate, (String)"issuanceDate");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, type, issuer, subject, data, issuanceDate, null, null, null, null, 480, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@Nullable String type, @NotNull String issuer, @NotNull String subject, T data) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, type, issuer, subject, data, null, null, null, null, null, 496, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> VerifiableCredential create(@NotNull String issuer, @NotNull String subject, T data) {
            Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            return web5.sdk.credentials.VerifiableCredential$Companion.create$default(this, null, issuer, subject, data, null, null, null, null, null, 497, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

