/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.ion;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.jackson.JacksonConverterKt;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Convert;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.PublicKeyPurpose;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.methods.ion.CommonOptions;
import web5.sdk.dids.methods.ion.CreateDidIonOptions;
import web5.sdk.dids.methods.ion.DeactivateDidIonOptions;
import web5.sdk.dids.methods.ion.DidIon;
import web5.sdk.dids.methods.ion.DidIonApi;
import web5.sdk.dids.methods.ion.DidIonConfiguration;
import web5.sdk.dids.methods.ion.DidIonKt;
import web5.sdk.dids.methods.ion.InvalidStatusException;
import web5.sdk.dids.methods.ion.IonCreationMetadata;
import web5.sdk.dids.methods.ion.IonDeactivateResult;
import web5.sdk.dids.methods.ion.IonRecoverResult;
import web5.sdk.dids.methods.ion.IonUpdateResult;
import web5.sdk.dids.methods.ion.KeyAliases;
import web5.sdk.dids.methods.ion.RecoverDidIonOptions;
import web5.sdk.dids.methods.ion.ResolutionException;
import web5.sdk.dids.methods.ion.UpdateDidIonOptions;
import web5.sdk.dids.methods.ion.VerificationMethodCreationParams;
import web5.sdk.dids.methods.ion.models.Commitment;
import web5.sdk.dids.methods.ion.models.DeactivateUpdateSignedData;
import web5.sdk.dids.methods.ion.models.Delta;
import web5.sdk.dids.methods.ion.models.InitialState;
import web5.sdk.dids.methods.ion.models.OperationSuffixDataObject;
import web5.sdk.dids.methods.ion.models.PatchAction;
import web5.sdk.dids.methods.ion.models.PublicKey;
import web5.sdk.dids.methods.ion.models.RecoveryUpdateSignedData;
import web5.sdk.dids.methods.ion.models.Reveal;
import web5.sdk.dids.methods.ion.models.Service;
import web5.sdk.dids.methods.ion.models.SidetreeCreateOperation;
import web5.sdk.dids.methods.ion.models.SidetreeDeactivateOperation;
import web5.sdk.dids.methods.ion.models.SidetreeRecoverOperation;
import web5.sdk.dids.methods.ion.models.SidetreeUpdateOperation;
import web5.sdk.dids.methods.ion.models.UpdateOperationSignedData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J+\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J1\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J,\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u000200H\u0002J\u001e\u00101\u001a\u0002022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001eJ\u0010\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020'H\u0002J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\fH\u0002J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J.\u0010=\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020?0 0>2\b\u0010\u001a\u001a\u0004\u0018\u00010@2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010A\u001a\u00020B2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020,J\u001a\u0010C\u001a\u00020D2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010EH\u0016J \u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\fH\u0002J\u001e\u0010J\u001a\u00020K2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u000200J\u0016\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020?0OH\u0002J\u0010\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020\fH\u0002J\u0016\u0010R\u001a\u00020M2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0OH\u0002J\u0010\u0010U\u001a\u00020M2\u0006\u0010V\u001a\u00020WH\u0002J\u0016\u0010X\u001a\u00020M2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020W0OH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002Z[\u00a8\u0006\\"}, d2={"Lweb5/sdk/dids/methods/ion/DidIonApi;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/ion/DidIon;", "Lweb5/sdk/dids/methods/ion/CreateDidIonOptions;", "configuration", "Lweb5/sdk/dids/methods/ion/DidIonConfiguration;", "(Lweb5/sdk/dids/methods/ion/DidIonConfiguration;)V", "client", "Lio/ktor/client/HttpClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "identifiersEndpoint", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "methodName", "getMethodName", "()Ljava/lang/String;", "operationsEndpoint", "canonicalized", "", "data", "", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "createDeactivateOperation", "Lweb5/sdk/dids/methods/ion/models/SidetreeDeactivateOperation;", "did", "Lweb5/sdk/dids/methods/ion/DeactivateDidIonOptions;", "createOperation", "Lkotlin/Pair;", "Lweb5/sdk/dids/methods/ion/models/SidetreeCreateOperation;", "Lweb5/sdk/dids/methods/ion/KeyAliases;", "createOperation$dids", "createOperationSuffixDataObject", "Lweb5/sdk/dids/methods/ion/models/OperationSuffixDataObject;", "createOperationDeltaObject", "Lweb5/sdk/dids/methods/ion/models/Delta;", "recoveryCommitment", "Lweb5/sdk/dids/methods/ion/models/Commitment;", "createRecoverOperation", "Lweb5/sdk/dids/methods/ion/models/SidetreeRecoverOperation;", "Lweb5/sdk/dids/methods/ion/RecoverDidIonOptions;", "createRecoverOperation$dids", "createUpdateOperation", "Lweb5/sdk/dids/methods/ion/models/SidetreeUpdateOperation;", "Lweb5/sdk/dids/methods/ion/UpdateDidIonOptions;", "deactivate", "Lweb5/sdk/dids/methods/ion/IonDeactivateResult;", "deltaHash", "updateOpDeltaObject", "didUriSegment", "initialState", "Lweb5/sdk/dids/methods/ion/models/InitialState;", "isBase64UrlString", "", "input", "load", "uri", "publicKeysWithAliasesToAdd", "", "Lweb5/sdk/dids/methods/ion/models/PublicKey;", "Lweb5/sdk/dids/methods/ion/CommonOptions;", "recover", "Lweb5/sdk/dids/methods/ion/IonRecoverResult;", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Lweb5/sdk/dids/ResolveDidOptions;", "sign", "Lcom/nimbusds/jose/JWSObject;", "serializableObject", "signKeyAlias", "update", "Lweb5/sdk/dids/methods/ion/IonUpdateResult;", "validateDidDocumentKeys", "", "publicKeys", "", "validateId", "id", "validatePublicKeyPurposes", "purposes", "Lweb5/sdk/dids/PublicKeyPurpose;", "validateService", "service", "Lweb5/sdk/dids/methods/ion/models/Service;", "validateServices", "services", "Lweb5/sdk/dids/methods/ion/DidIon$Default;", "Lweb5/sdk/dids/methods/ion/DidIonApiImpl;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidIon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidIon.kt\nweb5/sdk/dids/methods/ion/DidIonApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,905:1\n1#2:906\n1#2:921\n1#2:938\n1#2:957\n1549#3:907\n1620#3,3:908\n1603#3,9:911\n1855#3:920\n1856#3:922\n1612#3:923\n1549#3:924\n1620#3,3:925\n1603#3,9:928\n1855#3:937\n1856#3:939\n1612#3:940\n1855#3,2:941\n1549#3:943\n1620#3,3:944\n1603#3,9:947\n1855#3:956\n1856#3:958\n1612#3:959\n*S KotlinDebug\n*F\n+ 1 DidIon.kt\nweb5/sdk/dids/methods/ion/DidIonApi\n*L\n395#1:921\n478#1:938\n587#1:957\n369#1:907\n369#1:908,3\n395#1:911,9\n395#1:920\n395#1:922\n395#1:923\n453#1:924\n453#1:925,3\n478#1:928,9\n478#1:937\n478#1:939\n478#1:940\n496#1:941,2\n558#1:943\n558#1:944,3\n587#1:947,9\n587#1:956\n587#1:958\n587#1:959\n*E\n"})
public abstract class DidIonApi
implements DidMethod<DidIon, CreateDidIonOptions> {
    @NotNull
    private final DidIonConfiguration configuration;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final String operationsEndpoint;
    @NotNull
    private final String identifiersEndpoint;
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final HttpClient client;
    @NotNull
    private final String methodName;

    private DidIonApi(DidIonConfiguration configuration) {
        this.configuration = configuration;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
        this.operationsEndpoint = this.configuration.getIonHost() + "/operations";
        this.identifiersEndpoint = this.configuration.getIonHost() + "/identifiers";
        HttpClientEngine httpClientEngine = this.configuration.getEngine();
        if (httpClientEngine == null) {
            httpClientEngine = OkHttp.INSTANCE.create((Function1)engine.1.INSTANCE);
        }
        this.engine = httpClientEngine;
        this.client = HttpClientKt.HttpClient((HttpClientEngine)this.engine, (Function1)new Function1<HttpClientConfig<?>, Unit>(this){
            final /* synthetic */ DidIonApi this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$HttpClient) {
                Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)new Function1<ContentNegotiation.Config, Unit>(this.this$0){
                    final /* synthetic */ DidIonApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ContentNegotiation.Config $this$install) {
                        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                        JacksonConverterKt.jackson$default((Configuration)((Configuration)$this$install), null, (boolean)false, (Function1)((Function1)new Function1<ObjectMapper, Unit>(this.this$0){
                            final /* synthetic */ DidIonApi this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ObjectMapper $this$jackson) {
                                Intrinsics.checkNotNullParameter((Object)$this$jackson, (String)"$this$jackson");
                                DidIonApi.access$getMapper$p(this.this$0);
                            }
                        }), (int)3, null);
                    }
                });
            }
        });
        this.methodName = "ion";
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public DidIon create(@NotNull KeyManager keyManager, @Nullable CreateDidIonOptions options) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Pair<SidetreeCreateOperation, KeyAliases> pair = this.createOperation$dids(keyManager, options);
        SidetreeCreateOperation createOp = (SidetreeCreateOperation)pair.component1();
        KeyAliases keys = (KeyAliases)pair.component2();
        byte[] canonicalizedSuffixData = this.canonicalized(createOp.getSuffixData());
        byte[] suffixDataMultihash = DidIonKt.multihash(canonicalizedSuffixData);
        String shortFormDidSegment = new Convert((Object)suffixDataMultihash, null, 2, null).toBase64Url(false);
        InitialState initialState = new InitialState(createOp.getSuffixData(), createOp.getDelta());
        String longFormDidSegment = this.didUriSegment(initialState);
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, createOp, null){
            int label;
            final /* synthetic */ DidIonApi this$0;
            final /* synthetic */ SidetreeCreateOperation $createOp;
            {
                this.this$0 = $receiver;
                this.$createOp = $createOp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$post$iv$iv$iv;
                        void urlString$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$post$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidIonApi.access$getClient$p(this.this$0);
                        String string = DidIonApi.access$getOperationsEndpoint$p(this.this$0);
                        SidetreeCreateOperation sidetreeCreateOperation = this.$createOp;
                        boolean $i$f$post = false;
                        void $this$post$iv$iv = $this$post$iv;
                        boolean $i$f$post2 = false;
                        void var8_11 = $this$post$iv$iv;
                        HttpRequestBuilder $this$post_u24lambda_u245$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$post_u24lambda_u245$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                        HttpRequestBuilder $this$setBody$iv = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$setBody = false;
                        SidetreeCreateOperation sidetreeCreateOperation2 = sidetreeCreateOperation;
                        if (sidetreeCreateOperation2 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeCreateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeCreateOperation.class), (KType)kType$iv$iv));
                        } else if (sidetreeCreateOperation2 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)sidetreeCreateOperation);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)sidetreeCreateOperation);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeCreateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeCreateOperation.class), (KType)kType$iv$iv));
                        }
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$post3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                        void $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$post = false;
                        boolean $i$f$post4 = false;
                        boolean $i$f$post5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String opBody2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
            int label;
            final /* synthetic */ HttpResponse $response;
            {
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (HttpStatusCodeKt.isSuccess((HttpStatusCode)response2.getStatus())) {
            String shortFormDid = "did:ion:" + shortFormDidSegment;
            String longFormDid = shortFormDid + ":" + longFormDidSegment;
            DidResolutionResult resolutionResult = DidMethod.DefaultImpls.resolve$default(this, longFormDid, null, 2, null);
            CharSequence charSequence = resolutionResult.getDidResolutionMetadata().getError();
            if (!(charSequence == null || charSequence.length() == 0)) {
                throw new ResolutionException("error when resolving after creation: " + resolutionResult.getDidResolutionMetadata().getError());
            }
            DIDDocument dIDDocument = resolutionResult.getDidDocument();
            Intrinsics.checkNotNull((Object)dIDDocument);
            String string = dIDDocument.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new DidIon(string, keyManager, new IonCreationMetadata(createOp, shortFormDid, longFormDid, opBody2, keys), this);
        }
        throw new InvalidStatusException(response2.getStatus().getValue(), "received error response: '" + opBody2 + "'");
    }

    @Override
    @NotNull
    public DidIon load(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
        return new DidIon(uri, keyManager, null, this);
    }

    private final byte[] canonicalized(Object data) {
        String jsonString = this.mapper.writeValueAsString(data);
        byte[] byArray = new JsonCanonicalizer(jsonString).getEncodedUTF8();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncodedUTF8(...)");
        return byArray;
    }

    private final String didUriSegment(InitialState initialState) {
        byte[] canonicalized = this.canonicalized(initialState);
        return new Convert((Object)canonicalized, null, 2, null).toBase64Url(false);
    }

    @Override
    @NotNull
    public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        DID didObj = DID.fromString((String)did);
        if (!Intrinsics.areEqual((Object)didObj.getMethodName(), (Object)this.getMethodName())) {
            boolean bl = false;
            throw new IllegalArgumentException("expected did:ion");
        }
        HttpResponse resp2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, didObj, null){
            int label;
            final /* synthetic */ DidIonApi this$0;
            final /* synthetic */ DID $didObj;
            {
                this.this$0 = $receiver;
                this.$didObj = $didObj;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$get$iv$iv$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$get_u24default$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidIonApi.access$getClient$p(this.this$0);
                        String urlString$iv = DidIonApi.access$getIdentifiersEndpoint$p(this.this$0) + "/" + this.$didObj;
                        boolean $i$f$get = false;
                        void $this$get$iv$iv = $this$get_u24default$iv;
                        boolean $i$f$get2 = false;
                        void var7_10 = $this$get$iv$iv;
                        HttpRequestBuilder $this$get_u24lambda_u244$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)urlString$iv);
                        HttpRequestBuilder httpRequestBuilder2 = $this$get_u24lambda_u244$iv;
                        boolean bl2 = false;
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$get3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                        void $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$get = false;
                        boolean $i$f$get4 = false;
                        boolean $i$f$get5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String body2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(resp2, null){
            int label;
            final /* synthetic */ HttpResponse $resp;
            {
                this.$resp = $resp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$resp, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)resp2.getStatus())) {
            throw new InvalidStatusException(resp2.getStatus().getValue(), "resolution error response: '" + body2 + "'");
        }
        Object object = this.mapper.readValue(body2, DidResolutionResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (DidResolutionResult)object;
    }

    @NotNull
    public final IonUpdateResult update(@NotNull KeyManager keyManager, @NotNull String did, @NotNull UpdateDidIonOptions options) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<SidetreeUpdateOperation, KeyAliases> pair = this.createUpdateOperation(keyManager, did, options);
        SidetreeUpdateOperation updateOp = (SidetreeUpdateOperation)pair.component1();
        KeyAliases keyAliases = (KeyAliases)pair.component2();
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, updateOp, null){
            int label;
            final /* synthetic */ DidIonApi this$0;
            final /* synthetic */ SidetreeUpdateOperation $updateOp;
            {
                this.this$0 = $receiver;
                this.$updateOp = $updateOp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$post$iv$iv$iv;
                        void urlString$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$post$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidIonApi.access$getClient$p(this.this$0);
                        String string = DidIonApi.access$getOperationsEndpoint$p(this.this$0);
                        SidetreeUpdateOperation sidetreeUpdateOperation = this.$updateOp;
                        boolean $i$f$post = false;
                        void $this$post$iv$iv = $this$post$iv;
                        boolean $i$f$post2 = false;
                        void var8_11 = $this$post$iv$iv;
                        HttpRequestBuilder $this$post_u24lambda_u245$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$post_u24lambda_u245$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                        HttpRequestBuilder $this$setBody$iv = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$setBody = false;
                        SidetreeUpdateOperation sidetreeUpdateOperation2 = sidetreeUpdateOperation;
                        if (sidetreeUpdateOperation2 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeUpdateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeUpdateOperation.class), (KType)kType$iv$iv));
                        } else if (sidetreeUpdateOperation2 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)sidetreeUpdateOperation);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)sidetreeUpdateOperation);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeUpdateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeUpdateOperation.class), (KType)kType$iv$iv));
                        }
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$post3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                        void $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$post = false;
                        boolean $i$f$post4 = false;
                        boolean $i$f$post5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String opBody2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
            int label;
            final /* synthetic */ HttpResponse $response;
            {
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (HttpStatusCodeKt.isSuccess((HttpStatusCode)response2.getStatus())) {
            return new IonUpdateResult(opBody2, keyAliases);
        }
        throw new InvalidStatusException(response2.getStatus().getValue(), "received error response: '" + opBody2 + "'");
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<SidetreeUpdateOperation, KeyAliases> createUpdateOperation(KeyManager keyManager, String did, UpdateDidIonOptions options) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        DID parsedDid = DID.fromString((String)did);
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        if (!(!StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-DidIonApi$createUpdateOperation$22 = false;
            String $i$a$-require-DidIonApi$createUpdateOperation$22 = "updating a DID is only allowed for short form dids, but got " + did;
            throw new IllegalArgumentException($i$a$-require-DidIonApi$createUpdateOperation$22.toString());
        }
        JWK updatePublicKey = keyManager.getPublicKey(options.getUpdateKeyAlias());
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"ES256K");
        String newUpdateKeyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm), null, null, (int)6, null);
        JWK newUpdatePublicKey = keyManager.getPublicKey(newUpdateKeyAlias);
        Reveal reveal = DidIonKt.access$reveal(updatePublicKey);
        Commitment commitment = DidIonKt.access$commitment(newUpdatePublicKey);
        this.validateServices(options.getServicesToAdd());
        List publicKeysWithAliases = DidIonKt.access$toPublicKeys(options.getVerificationMethodsToAdd(), keyManager);
        Iterable $this$map$iv = publicKeysWithAliases;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PublicKey)it.getSecond());
        }
        List publicKeys = (List)destination$iv$iv;
        this.validateDidDocumentKeys(publicKeys);
        Delta updateOpDeltaObject = new Delta((Iterable<? extends PatchAction>)options.toPatches$dids(publicKeys), commitment);
        String deltaHash = this.deltaHash(updateOpDeltaObject);
        UpdateOperationSignedData updateOpSignedData = new UpdateOperationSignedData(updatePublicKey, deltaHash);
        JWSObject signedJwsObject = this.sign(updateOpSignedData, keyManager, options.getUpdateKeyAlias());
        String string2 = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodSpecificId(...)");
        String string3 = signedJwsObject.serialize(false);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"serialize(...)");
        Iterable $i$f$mapTo22 = publicKeysWithAliases;
        String string4 = newUpdateKeyAlias;
        SidetreeUpdateOperation sidetreeUpdateOperation = new SidetreeUpdateOperation("update", string2, reveal, updateOpDeltaObject, string3);
        boolean $i$f$mapNotNull = false;
        item$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((String)it.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        String string5 = null;
        List list2 = list;
        String string6 = string4;
        KeyAliases keyAliases = new KeyAliases(string6, list2, string5);
        SidetreeUpdateOperation sidetreeUpdateOperation2 = sidetreeUpdateOperation;
        return new Pair((Object)sidetreeUpdateOperation2, (Object)keyAliases);
    }

    private final JWSObject sign(Object serializableObject, KeyManager keyManager, String signKeyAlias) {
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.ES256K).build();
        Payload payload = new Payload(this.mapper.writeValueAsString(serializableObject));
        JWSObject jwsObject = new JWSObject(header, payload);
        byte[] byArray = jwsObject.getSigningInput();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSigningInput(...)");
        byte[] signatureBytes = keyManager.sign(signKeyAlias, byArray);
        Base64URL base64UrlEncodedSignature = new Base64URL(new Convert((Object)signatureBytes, null, 2, null).toBase64Url(false));
        return new JWSObject(jwsObject.getHeader().toBase64URL(), jwsObject.getPayload().toBase64URL(), base64UrlEncodedSignature);
    }

    private final String deltaHash(Delta updateOpDeltaObject) {
        byte[] canonicalizedOp = this.canonicalized(updateOpDeltaObject);
        byte[] opMultihash = DidIonKt.multihash(canonicalizedOp);
        return new Convert((Object)opMultihash, null, 2, null).toBase64Url(false);
    }

    private final void validateDidDocumentKeys(Iterable<PublicKey> publicKeys) {
        HashSet<String> publicKeyIdSet = new HashSet<String>();
        for (PublicKey publicKey : publicKeys) {
            this.validateId(publicKey.getId());
            if (publicKeyIdSet.contains(publicKey.getId())) {
                throw new IllegalArgumentException("DID Document key with ID \"" + publicKey.getId() + "\" already exists.");
            }
            publicKeyIdSet.add(publicKey.getId());
            this.validatePublicKeyPurposes(publicKey.getPurposes());
        }
    }

    private final void validatePublicKeyPurposes(Iterable<? extends PublicKeyPurpose> purposes) {
        HashSet<PublicKeyPurpose> processedPurposes = new HashSet<PublicKeyPurpose>();
        for (PublicKeyPurpose publicKeyPurpose : purposes) {
            if (processedPurposes.contains((Object)publicKeyPurpose)) {
                throw new IllegalArgumentException("Public key purpose \"" + publicKeyPurpose.getCode() + "\" already specified.");
            }
            processedPurposes.add(publicKeyPurpose);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<SidetreeCreateOperation, KeyAliases> createOperation$dids(@NotNull KeyManager keyManager, @Nullable CreateDidIonOptions options) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"ES256K");
        String updateKeyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm), null, null, (int)6, null);
        JWK updatePublicJwk = keyManager.getPublicKey(updateKeyAlias);
        Commitment publicKeyCommitment = DidIonKt.access$commitment(updatePublicJwk);
        List<Pair<String, PublicKey>> publicKeysWithAlias = this.publicKeysWithAliasesToAdd(options, keyManager);
        Iterable $this$map$iv = publicKeysWithAlias;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PublicKey)it.getSecond());
        }
        List publicKeysToAdd = (List)destination$iv$iv;
        this.validateDidDocumentKeys(publicKeysToAdd);
        Object object = options;
        if (object == null || (object = ((CreateDidIonOptions)object).getServicesToAdd()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.validateServices((Iterable<Service>)object);
        Delta createOperationDelta = new Delta(DidIonKt.access$toPatches(options, publicKeysToAdd), publicKeyCommitment);
        JWSAlgorithm jWSAlgorithm2 = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm2, (String)"ES256K");
        String recoveryKeyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm2), null, null, (int)6, null);
        JWK recoveryPublicJwk = keyManager.getPublicKey(recoveryKeyAlias);
        Commitment recoveryCommitment = DidIonKt.access$commitment(recoveryPublicJwk);
        OperationSuffixDataObject operation = this.createOperationSuffixDataObject(createOperationDelta, recoveryCommitment);
        Iterable iterable2 = publicKeysWithAlias;
        String string = updateKeyAlias;
        SidetreeCreateOperation sidetreeCreateOperation = new SidetreeCreateOperation("create", createOperationDelta, operation);
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((String)it2.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        String string2 = recoveryKeyAlias;
        List list2 = list;
        String string3 = string;
        KeyAliases keyAliases = new KeyAliases(string3, list2, string2);
        SidetreeCreateOperation sidetreeCreateOperation2 = sidetreeCreateOperation;
        return new Pair((Object)sidetreeCreateOperation2, (Object)keyAliases);
    }

    private final List<Pair<String, PublicKey>> publicKeysWithAliasesToAdd(CommonOptions options, KeyManager keyManager) {
        List list;
        if (options == null || CollectionsKt.count(options.getVerificationMethodsToAdd()) == 0) {
            JWSAlgorithm jWSAlgorithm = JWSAlgorithm.ES256K;
            Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"ES256K");
            PublicKeyPurpose[] publicKeyPurposeArray = new PublicKeyPurpose[]{PublicKeyPurpose.AUTHENTICATION, PublicKeyPurpose.ASSERTION_METHOD};
            list = DidIonKt.access$toPublicKeys(CollectionsKt.listOf((Object)new VerificationMethodCreationParams((Algorithm)jWSAlgorithm, null, null, CollectionsKt.listOf((Object[])publicKeyPurposeArray), 6, null)), keyManager);
        } else {
            list = DidIonKt.access$toPublicKeys(options.getVerificationMethodsToAdd(), keyManager);
        }
        return list;
    }

    private final void validateServices(Iterable<Service> services) {
        Iterable<Service> $this$forEach$iv = services;
        boolean $i$f$forEach = false;
        Iterator<Service> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Service element$iv;
            Service it = element$iv = iterator.next();
            boolean bl = false;
            this.validateService(it);
        }
    }

    private final void validateService(Service service) {
        this.validateId(service.getId());
        if (!(service.getType().length() < 30)) {
            boolean bl = false;
            String string = "service type \"" + service.getType() + "\" exceeds max allowed length of 30";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            URI.create(service.getServiceEndpoint());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("service endpoint is not a valid URI", e);
        }
    }

    private final void validateId(String id) {
        if (!this.isBase64UrlString(id)) {
            boolean $i$a$-require-DidIonApi$validateId$32 = false;
            String $i$a$-require-DidIonApi$validateId$32 = "id \"" + id + "\" is not base 64 url charset";
            throw new IllegalArgumentException($i$a$-require-DidIonApi$validateId$32.toString());
        }
        if (!(id.length() <= 50)) {
            boolean bl = false;
            String string = "id \"" + id + "\" exceeds max allowed length of 50";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean isBase64UrlString(String input) {
        return DidIonKt.access$getBase64UrlCharsetRegex$p().matches((CharSequence)input);
    }

    private final OperationSuffixDataObject createOperationSuffixDataObject(Delta createOperationDeltaObject, Commitment recoveryCommitment) {
        String jsonString = this.mapper.writeValueAsString((Object)createOperationDeltaObject);
        byte[] canonicalized = new JsonCanonicalizer(jsonString).getEncodedUTF8();
        Intrinsics.checkNotNull((Object)canonicalized);
        byte[] deltaMultihash = DidIonKt.multihash(canonicalized);
        return new OperationSuffixDataObject(new Convert((Object)deltaMultihash, null, 2, null).toBase64Url(false), recoveryCommitment);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<SidetreeRecoverOperation, KeyAliases> createRecoverOperation$dids(@NotNull KeyManager keyManager, @NotNull String did, @NotNull RecoverDidIonOptions options) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        DID parsedDid = DID.fromString((String)did);
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        if (!(!StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-DidIonApi$createRecoverOperation$22 = false;
            String $i$a$-require-DidIonApi$createRecoverOperation$22 = "recovering a DID is only allowed for short form dids, but got " + did;
            throw new IllegalArgumentException($i$a$-require-DidIonApi$createRecoverOperation$22.toString());
        }
        JWK recoveryPublicKey = keyManager.getPublicKey(options.getRecoveryKeyAlias());
        Reveal reveal = DidIonKt.access$reveal(recoveryPublicKey);
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"ES256K");
        String nextRecoveryKeyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm), null, null, (int)6, null);
        JWK nextRecoveryPublicKey = keyManager.getPublicKey(nextRecoveryKeyAlias);
        Commitment nextRecoveryCommitment = DidIonKt.access$commitment(nextRecoveryPublicKey);
        JWSAlgorithm jWSAlgorithm2 = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm2, (String)"ES256K");
        String nextUpdateKeyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm2), null, null, (int)6, null);
        JWK nextUpdatePublicKey = keyManager.getPublicKey(nextUpdateKeyAlias);
        Commitment nextUpdateCommitment = DidIonKt.access$commitment(nextUpdatePublicKey);
        List<Pair<String, PublicKey>> publicKeyWithAliases = this.publicKeysWithAliasesToAdd(options, keyManager);
        Iterable $this$map$iv = publicKeyWithAliases;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PublicKey)it.getSecond());
        }
        List publicKeysToAdd = (List)destination$iv$iv;
        this.validateDidDocumentKeys(publicKeysToAdd);
        this.validateServices(options.getServicesToAdd());
        Delta delta = new Delta(DidIonKt.access$toPatches(options, publicKeysToAdd), nextUpdateCommitment);
        String deltaHash = this.deltaHash(delta);
        RecoveryUpdateSignedData dataToBeSigned = new RecoveryUpdateSignedData(nextRecoveryCommitment, recoveryPublicKey, deltaHash, null, 8, null);
        JWSObject jwsObject = this.sign(dataToBeSigned, keyManager, options.getRecoveryKeyAlias());
        String string2 = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodSpecificId(...)");
        String string3 = jwsObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"serialize(...)");
        Iterable $i$f$mapTo22 = publicKeyWithAliases;
        String string4 = nextUpdateKeyAlias;
        SidetreeRecoverOperation sidetreeRecoverOperation = new SidetreeRecoverOperation("recover", string2, reveal, delta, string3);
        boolean $i$f$mapNotNull = false;
        item$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((String)it.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        String string5 = nextRecoveryKeyAlias;
        List list2 = list;
        String string6 = string4;
        KeyAliases keyAliases = new KeyAliases(string6, list2, string5);
        SidetreeRecoverOperation sidetreeRecoverOperation2 = sidetreeRecoverOperation;
        return new Pair((Object)sidetreeRecoverOperation2, (Object)keyAliases);
    }

    private final SidetreeDeactivateOperation createDeactivateOperation(KeyManager keyManager, String did, DeactivateDidIonOptions options) {
        DID parsedDid = DID.fromString((String)did);
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        if (!(!StringsKt.contains$default((CharSequence)string, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-DidIonApi$createDeactivateOperation$22 = false;
            String $i$a$-require-DidIonApi$createDeactivateOperation$22 = "deactivating a DID is only allowed for short form dids, but got " + did;
            throw new IllegalArgumentException($i$a$-require-DidIonApi$createDeactivateOperation$22.toString());
        }
        JWK recoveryPublicKey = keyManager.getPublicKey(options.getRecoveryKeyAlias());
        Reveal reveal = DidIonKt.access$reveal(recoveryPublicKey);
        String string2 = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodSpecificId(...)");
        DeactivateUpdateSignedData dataToBeSigned = new DeactivateUpdateSignedData(string2, recoveryPublicKey);
        JWSObject jwsObject = this.sign(dataToBeSigned, keyManager, options.getRecoveryKeyAlias());
        String string3 = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethodSpecificId(...)");
        String string4 = jwsObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"serialize(...)");
        return new SidetreeDeactivateOperation("deactivate", string3, reveal, string4);
    }

    @NotNull
    public final IonRecoverResult recover(@NotNull KeyManager keyManager, @NotNull String did, @NotNull RecoverDidIonOptions options) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<SidetreeRecoverOperation, KeyAliases> pair = this.createRecoverOperation$dids(keyManager, did, options);
        SidetreeRecoverOperation recoverOp = (SidetreeRecoverOperation)pair.component1();
        KeyAliases keyAliases = (KeyAliases)pair.component2();
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, recoverOp, null){
            int label;
            final /* synthetic */ DidIonApi this$0;
            final /* synthetic */ SidetreeRecoverOperation $recoverOp;
            {
                this.this$0 = $receiver;
                this.$recoverOp = $recoverOp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$post$iv$iv$iv;
                        void urlString$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$post$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidIonApi.access$getClient$p(this.this$0);
                        String string = DidIonApi.access$getOperationsEndpoint$p(this.this$0);
                        SidetreeRecoverOperation sidetreeRecoverOperation = this.$recoverOp;
                        boolean $i$f$post = false;
                        void $this$post$iv$iv = $this$post$iv;
                        boolean $i$f$post2 = false;
                        void var8_11 = $this$post$iv$iv;
                        HttpRequestBuilder $this$post_u24lambda_u245$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$post_u24lambda_u245$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                        HttpRequestBuilder $this$setBody$iv = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$setBody = false;
                        SidetreeRecoverOperation sidetreeRecoverOperation2 = sidetreeRecoverOperation;
                        if (sidetreeRecoverOperation2 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeRecoverOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeRecoverOperation.class), (KType)kType$iv$iv));
                        } else if (sidetreeRecoverOperation2 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)sidetreeRecoverOperation);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)sidetreeRecoverOperation);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeRecoverOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeRecoverOperation.class), (KType)kType$iv$iv));
                        }
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$post3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                        void $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$post = false;
                        boolean $i$f$post4 = false;
                        boolean $i$f$post5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String opBody2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
            int label;
            final /* synthetic */ HttpResponse $response;
            {
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new IonRecoverResult(keyAliases, recoverOp, opBody2);
    }

    @NotNull
    public final IonDeactivateResult deactivate(@NotNull KeyManager keyManager, @NotNull String did, @NotNull DeactivateDidIonOptions options) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        SidetreeDeactivateOperation deactivateOp = this.createDeactivateOperation(keyManager, did, options);
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, deactivateOp, null){
            int label;
            final /* synthetic */ DidIonApi this$0;
            final /* synthetic */ SidetreeDeactivateOperation $deactivateOp;
            {
                this.this$0 = $receiver;
                this.$deactivateOp = $deactivateOp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$post$iv$iv$iv;
                        void urlString$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$post$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidIonApi.access$getClient$p(this.this$0);
                        String string = DidIonApi.access$getOperationsEndpoint$p(this.this$0);
                        SidetreeDeactivateOperation sidetreeDeactivateOperation = this.$deactivateOp;
                        boolean $i$f$post = false;
                        void $this$post$iv$iv = $this$post$iv;
                        boolean $i$f$post2 = false;
                        void var8_11 = $this$post$iv$iv;
                        HttpRequestBuilder $this$post_u24lambda_u245$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u245$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$post_u24lambda_u245$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                        HttpRequestBuilder $this$setBody$iv = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$setBody = false;
                        SidetreeDeactivateOperation sidetreeDeactivateOperation2 = sidetreeDeactivateOperation;
                        if (sidetreeDeactivateOperation2 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeDeactivateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeDeactivateOperation.class), (KType)kType$iv$iv));
                        } else if (sidetreeDeactivateOperation2 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)sidetreeDeactivateOperation);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)sidetreeDeactivateOperation);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(SidetreeDeactivateOperation.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(SidetreeDeactivateOperation.class), (KType)kType$iv$iv));
                        }
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$post3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                        void $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$post = false;
                        boolean $i$f$post4 = false;
                        boolean $i$f$post5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String opBody2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
            int label;
            final /* synthetic */ HttpResponse $response;
            {
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new IonDeactivateResult(deactivateOp, opBody2);
    }

    public /* synthetic */ DidIonApi(DidIonConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }

    public static final /* synthetic */ HttpClient access$getClient$p(DidIonApi $this) {
        return $this.client;
    }

    public static final /* synthetic */ String access$getOperationsEndpoint$p(DidIonApi $this) {
        return $this.operationsEndpoint;
    }

    public static final /* synthetic */ String access$getIdentifiersEndpoint$p(DidIonApi $this) {
        return $this.identifiersEndpoint;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(DidIonApi $this) {
        return $this.mapper;
    }
}

