/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.ion;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.crypto.KeyGenOptions;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.PublicKeyPurpose;
import web5.sdk.dids.methods.ion.VerificationMethodKeyManagerGenerator;
import web5.sdk.dids.methods.ion.VerificationMethodSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lweb5/sdk/dids/methods/ion/VerificationMethodCreationParams;", "Lweb5/sdk/dids/methods/ion/VerificationMethodSpec;", "algorithm", "Lcom/nimbusds/jose/Algorithm;", "curve", "Lcom/nimbusds/jose/jwk/Curve;", "options", "Lweb5/sdk/crypto/KeyGenOptions;", "relationships", "", "Lweb5/sdk/dids/PublicKeyPurpose;", "(Lcom/nimbusds/jose/Algorithm;Lcom/nimbusds/jose/jwk/Curve;Lweb5/sdk/crypto/KeyGenOptions;Ljava/lang/Iterable;)V", "getAlgorithm", "()Lcom/nimbusds/jose/Algorithm;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getOptions", "()Lweb5/sdk/crypto/KeyGenOptions;", "getRelationships", "()Ljava/lang/Iterable;", "toGenerator", "Lweb5/sdk/dids/methods/ion/VerificationMethodKeyManagerGenerator;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "toGenerator$dids", "dids"})
public final class VerificationMethodCreationParams
implements VerificationMethodSpec {
    @NotNull
    private final Algorithm algorithm;
    @Nullable
    private final Curve curve;
    @Nullable
    private final KeyGenOptions options;
    @NotNull
    private final Iterable<PublicKeyPurpose> relationships;

    public VerificationMethodCreationParams(@NotNull Algorithm algorithm, @Nullable Curve curve, @Nullable KeyGenOptions options, @NotNull Iterable<? extends PublicKeyPurpose> relationships) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(relationships, (String)"relationships");
        this.algorithm = algorithm;
        this.curve = curve;
        this.options = options;
        this.relationships = relationships;
    }

    public /* synthetic */ VerificationMethodCreationParams(Algorithm algorithm, Curve curve, KeyGenOptions keyGenOptions, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            curve = null;
        }
        if ((n & 4) != 0) {
            keyGenOptions = null;
        }
        this(algorithm, curve, keyGenOptions, iterable);
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public final Curve getCurve() {
        return this.curve;
    }

    @Nullable
    public final KeyGenOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final Iterable<PublicKeyPurpose> getRelationships() {
        return this.relationships;
    }

    @NotNull
    public final VerificationMethodKeyManagerGenerator toGenerator$dids(@NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        return new VerificationMethodKeyManagerGenerator(keyManager, this);
    }
}

