/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.VerificationMethod;
import foundation.identity.did.parser.ParserException;
import java.net.URI;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.methods.jwk.CreateDidJwkOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lweb5/sdk/dids/methods/jwk/DidJwk;", "Lweb5/sdk/dids/Did;", "uri", "", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "(Ljava/lang/String;Lweb5/sdk/crypto/KeyManager;)V", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Companion", "dids"})
public final class DidJwk
extends Did {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String methodName = "jwk";

    public DidJwk(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        super(uri, keyManager);
    }

    @NotNull
    public final DidResolutionResult resolve() {
        return DidMethod.DefaultImpls.resolve$default(Companion, this.getUri(), null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lweb5/sdk/dids/methods/jwk/DidJwk$Companion;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/jwk/DidJwk;", "Lweb5/sdk/dids/methods/jwk/CreateDidJwkOptions;", "()V", "methodName", "", "getMethodName", "()Ljava/lang/String;", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "load", "uri", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "did", "Lweb5/sdk/dids/ResolveDidOptions;", "dids"})
    public static final class Companion
    implements DidMethod<DidJwk, CreateDidJwkOptions> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getMethodName() {
            return methodName;
        }

        @Override
        @NotNull
        public DidJwk create(@NotNull KeyManager keyManager, @Nullable CreateDidJwkOptions options) {
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            CreateDidJwkOptions createDidJwkOptions = options;
            if (createDidJwkOptions == null) {
                createDidJwkOptions = new CreateDidJwkOptions(null, null, 3, null);
            }
            CreateDidJwkOptions opts = createDidJwkOptions;
            String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)opts.getAlgorithm(), (Curve)opts.getCurve(), null, (int)4, null);
            JWK publicKey = keyManager.getPublicKey(keyAlias);
            String base64Encoded = new Convert((Object)publicKey.toJSONString(), null, 2, null).toBase64Url(false);
            String did = "did:jwk:" + base64Encoded;
            return new DidJwk(did, keyManager);
        }

        @Override
        @NotNull
        public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
            JWK jWK;
            DID dID;
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            try {
                dID = DID.fromString((String)did);
            }
            catch (ParserException parserException) {
                return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.INVALID_DID.getValue(), null, 5, null), 6, null);
            }
            DID parsedDid = dID;
            if (!Intrinsics.areEqual((Object)parsedDid.getMethodName(), (Object)this.getMethodName())) {
                return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.METHOD_NOT_SUPPORTED.getValue(), null, 5, null), 6, null);
            }
            String id = parsedDid.getMethodSpecificId();
            String decodedKey = new Convert((Object)id, EncodingFormat.Base64Url).toStr();
            try {
                jWK = JWK.parse((String)decodedKey);
            }
            catch (ParseException parseException) {
                return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.INVALID_DID.getValue(), null, 5, null), 6, null);
            }
            JWK publicKeyJwk = jWK;
            if (!(!publicKeyJwk.isPrivate())) {
                boolean bl = false;
                throw new IllegalArgumentException("decoded jwk value cannot be a private key");
            }
            URI verificationMethodId = URI.create(did + "#0");
            VerificationMethod verificationMethod = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethodId)).publicKeyJwk(publicKeyJwk.toJSONObject()).controller(new URI(did)).type("JsonWebKey2020")).build();
            VerificationMethod verificationMethodRef = ((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethodId)).build();
            Object[] objectArray = new URI[]{URI.create("https://w3id.org/security/suites/jws-2020/v1")};
            DIDDocument.Builder didDocumentBuilder = ((DIDDocument.Builder)((DIDDocument.Builder)DIDDocument.builder().contexts(CollectionsKt.mutableListOf((Object[])objectArray))).id(new URI(did))).verificationMethod(verificationMethod);
            if (!Intrinsics.areEqual((Object)publicKeyJwk.getKeyUse(), (Object)KeyUse.ENCRYPTION)) {
                didDocumentBuilder.assertionMethodVerificationMethod(verificationMethodRef).authenticationVerificationMethod(verificationMethodRef).capabilityDelegationVerificationMethods(CollectionsKt.listOf((Object)verificationMethodRef)).capabilityInvocationVerificationMethod(verificationMethodRef);
            }
            if (!Intrinsics.areEqual((Object)publicKeyJwk.getKeyUse(), (Object)KeyUse.SIGNATURE)) {
                didDocumentBuilder.keyAgreementVerificationMethod(verificationMethodRef);
            }
            DIDDocument didDocument = didDocumentBuilder.build();
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", didDocument, null, null, 12, null);
        }

        @Override
        @NotNull
        public DidJwk load(@NotNull String uri, @NotNull KeyManager keyManager) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
            return new DidJwk(uri, keyManager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

