/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids;

import com.nimbusds.jose.jwk.JWK;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.VerificationMethod;
import java.security.SignatureException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.CreateDidOptions;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidResolutionResult;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u001a<\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b\"\b\b\u0001\u0010\t*\u00020\n*\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"findAssertionMethodById", "Lfoundation/identity/did/VerificationMethod;", "Lfoundation/identity/did/DIDDocument;", "assertionMethodId", "", "validateKeyMaterialInsideKeyManager", "", "T", "Lweb5/sdk/dids/Did;", "O", "Lweb5/sdk/dids/CreateDidOptions;", "Lweb5/sdk/dids/DidMethod;", "did", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidMethod.kt\nweb5/sdk/dids/DidMethodKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1855#2,2:207\n*S KotlinDebug\n*F\n+ 1 DidMethod.kt\nweb5/sdk/dids/DidMethodKt\n*L\n201#1:207,2\n*E\n"})
public final class DidMethodKt {
    @JvmOverloads
    @NotNull
    public static final VerificationMethod findAssertionMethodById(@NotNull DIDDocument $this$findAssertionMethodById, @Nullable String assertionMethodId) {
        VerificationMethod verificationMethod;
        Intrinsics.checkNotNullParameter((Object)$this$findAssertionMethodById, (String)"<this>");
        Collection collection = $this$findAssertionMethodById.getAssertionMethodVerificationMethodsDereferenced();
        if (!(!(collection == null || collection.isEmpty()))) {
            boolean bl = false;
            throw new SignatureException("No assertion methods found in DID document");
        }
        if (assertionMethodId != null) {
            Object v1;
            block5: {
                List list = $this$findAssertionMethodById.getAssertionMethodVerificationMethodsDereferenced();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssertionMethodVerifi\u2026nMethodsDereferenced(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    VerificationMethod it = (VerificationMethod)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId().toString(), (Object)assertionMethodId)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            verificationMethod = v1;
        } else {
            List list = $this$findAssertionMethodById.getAssertionMethodVerificationMethodsDereferenced();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssertionMethodVerifi\u2026nMethodsDereferenced(...)");
            verificationMethod = (VerificationMethod)CollectionsKt.firstOrNull((List)list);
        }
        if (verificationMethod == null) {
            throw new SignatureException("assertion method \"" + assertionMethodId + "\" not found");
        }
        VerificationMethod assertionMethod = verificationMethod;
        return assertionMethod;
    }

    public static /* synthetic */ VerificationMethod findAssertionMethodById$default(DIDDocument dIDDocument, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return DidMethodKt.findAssertionMethodById(dIDDocument, string);
    }

    public static final <T extends Did, O extends CreateDidOptions> void validateKeyMaterialInsideKeyManager(@NotNull DidMethod<T, O> $this$validateKeyMaterialInsideKeyManager, @NotNull String did, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter($this$validateKeyMaterialInsideKeyManager, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        if (!Intrinsics.areEqual((Object)DID.fromString((String)did).getMethodName(), (Object)$this$validateKeyMaterialInsideKeyManager.getMethodName())) {
            boolean $i$a$-require-DidMethodKt$validateKeyMaterialInsideKeyManager$22 = false;
            String $i$a$-require-DidMethodKt$validateKeyMaterialInsideKeyManager$22 = "did must start with the prefix \"did:" + $this$validateKeyMaterialInsideKeyManager.getMethodName() + "\", but got " + did;
            throw new IllegalArgumentException($i$a$-require-DidMethodKt$validateKeyMaterialInsideKeyManager$22.toString());
        }
        DidResolutionResult didResolutionResult = DidMethod.DefaultImpls.resolve$default($this$validateKeyMaterialInsideKeyManager, did, null, 2, null);
        List list = didResolutionResult.getDidDocument().getAllVerificationMethods();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllVerificationMethods(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VerificationMethod it = (VerificationMethod)element$iv;
            boolean bl = false;
            JWK publicKeyJwk = JWK.parse((Map)it.getPublicKeyJwk());
            Intrinsics.checkNotNull((Object)publicKeyJwk);
            String keyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
            keyManager.getPublicKey(keyAlias);
        }
    }

    @JvmOverloads
    @NotNull
    public static final VerificationMethod findAssertionMethodById(@NotNull DIDDocument $this$findAssertionMethodById) {
        Intrinsics.checkNotNullParameter((Object)$this$findAssertionMethodById, (String)"<this>");
        return DidMethodKt.findAssertionMethodById$default($this$findAssertionMethodById, null, 1, null);
    }
}

