/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.dht;

import com.nimbusds.jose.jwk.JWK;
import com.turn.ttorrent.bcodec.BEncoder;
import io.ktor.client.HttpClient;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.client.statement.ReadersKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.Message;
import web5.sdk.common.ZBase32;
import web5.sdk.crypto.Ed25519;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Signer;
import web5.sdk.dids.exceptions.PkarrRecordResponseException;
import web5.sdk.dids.methods.dht.Bep44Message;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lweb5/sdk/dids/methods/dht/DhtClient;", "", "gateway", "", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "(Ljava/lang/String;Lio/ktor/client/engine/HttpClientEngine;)V", "client", "Lio/ktor/client/HttpClient;", "pkarrGet", "Lweb5/sdk/dids/methods/dht/Bep44Message;", "id", "pkarrPut", "", "message", "Companion", "dids"})
public final class DhtClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String gateway;
    @NotNull
    private final HttpClient client;

    public DhtClient(@NotNull String gateway, @NotNull HttpClientEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        this.gateway = gateway;
        this.client = new HttpClient(engine2, null, 2, null);
    }

    public /* synthetic */ DhtClient(String string, HttpClientEngine httpClientEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "https://diddht.tbddev.org";
        }
        if ((n & 2) != 0) {
            httpClientEngine = HttpClientEngineFactory.DefaultImpls.create$default((HttpClientEngineFactory)((HttpClientEngineFactory)OkHttp.INSTANCE), null, (int)1, null);
        }
        this(string, httpClientEngine);
    }

    public final void pkarrPut(@NotNull String id, @NotNull Bep44Message message) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(ZBase32.INSTANCE.decode(id).length == 32)) {
            boolean $i$a$-require-DhtClient$pkarrPut$22 = false;
            String $i$a$-require-DhtClient$pkarrPut$22 = "Identifier must be a z-base-32 encoded Ed25519 public key";
            throw new IllegalArgumentException($i$a$-require-DhtClient$pkarrPut$22.toString());
        }
        ByteBuffer seqBuffer = ByteBuffer.allocate(8);
        seqBuffer.order(ByteOrder.BIG_ENDIAN);
        seqBuffer.putLong(message.getSeq());
        byte[] seqBytes = seqBuffer.array();
        byte[] byArray = message.getSig();
        Intrinsics.checkNotNull((Object)seqBytes);
        byte[] body2 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])byArray, (byte[])seqBytes), (byte[])message.getV());
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, id, body2, null){
            int label;
            final /* synthetic */ DhtClient this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ byte[] $body;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$body = $body;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$put$iv$iv$iv;
                        void urlString$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$put$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DhtClient.access$getClient$p(this.this$0);
                        String string = DhtClient.access$getGateway$p(this.this$0) + "/" + this.$id;
                        byte[] byArray = this.$body;
                        boolean $i$f$put = false;
                        void $this$put$iv$iv = $this$put$iv;
                        boolean $i$f$put2 = false;
                        void var8_11 = $this$put$iv$iv;
                        HttpRequestBuilder $this$put_u24lambda_u246$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$put_u24lambda_u246$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$put_u24lambda_u246$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getOctetStream());
                        HttpRequestBuilder $this$setBody$iv = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$setBody = false;
                        byte[] byArray2 = byArray;
                        if (byArray2 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(byte[].class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        } else if (byArray2 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)byArray);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)byArray);
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(byte[].class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        }
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$put3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPut());
                        void $this$request$iv$iv$iv$iv = $this$put$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$put = false;
                        boolean $i$f$put4 = false;
                        boolean $i$f$put5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)response2.getStatus())) {
            String err2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
                int label;
                final /* synthetic */ HttpResponse $response;
                {
                    this.$response = $response;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            throw new PkarrRecordResponseException("Error writing Pkarr Record Set for id " + id + ". Error: " + err2);
        }
    }

    @NotNull
    public final Bep44Message pkarrGet(@NotNull String id) throws PkarrRecordResponseException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        byte[] publicKey = ZBase32.INSTANCE.decode(id);
        if (!(publicKey.length == 32)) {
            boolean $i$a$-require-DhtClient$pkarrGet$32 = false;
            String $i$a$-require-DhtClient$pkarrGet$32 = "Identifier must be a z-base-32 encoded Ed25519 public key";
            throw new IllegalArgumentException($i$a$-require-DhtClient$pkarrGet$32.toString());
        }
        HttpResponse response2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, id, null){
            int label;
            final /* synthetic */ DhtClient this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$get$iv$iv$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$get_u24default$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DhtClient.access$getClient$p(this.this$0);
                        String urlString$iv = DhtClient.access$getGateway$p(this.this$0) + "/" + this.$id;
                        boolean $i$f$get = false;
                        void $this$get$iv$iv = $this$get_u24default$iv;
                        boolean $i$f$get2 = false;
                        void var7_10 = $this$get$iv$iv;
                        HttpRequestBuilder $this$get_u24lambda_u244$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)urlString$iv);
                        HttpRequestBuilder httpRequestBuilder2 = $this$get_u24lambda_u244$iv;
                        boolean bl2 = false;
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$get3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                        void $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$get = false;
                        boolean $i$f$get4 = false;
                        boolean $i$f$get5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)response2.getStatus())) {
            String err2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(response2, null){
                int label;
                final /* synthetic */ HttpResponse $response;
                {
                    this.$response = $response;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$response, null, (Continuation)((Continuation)this), (int)1, null);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            throw new PkarrRecordResponseException("Error reading Pkarr Record Set of id " + id + ". Error: " + err2);
        }
        byte[] responseBytes2 = (byte[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(response2, null){
            int label;
            final /* synthetic */ HttpResponse $response;
            {
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ReadersKt.readBytes((HttpResponse)this.$response, (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!(responseBytes2.length >= 72)) {
            boolean $i$a$-require-DhtClient$pkarrGet$42 = false;
            String $i$a$-require-DhtClient$pkarrGet$42 = "Malformed response from DHT";
            throw new IllegalArgumentException($i$a$-require-DhtClient$pkarrGet$42.toString());
        }
        byte[] sig = ArraysKt.sliceArray((byte[])responseBytes2, (IntRange)new IntRange(0, 63));
        long seq = ByteBuffer.wrap(ArraysKt.sliceArray((byte[])responseBytes2, (IntRange)new IntRange(64, 71))).order(ByteOrder.BIG_ENDIAN).getLong();
        byte[] v = ArraysKt.sliceArray((byte[])responseBytes2, (IntRange)RangesKt.until((int)72, (int)responseBytes2.length));
        return new Bep44Message(v, publicKey, sig, seq);
    }

    public DhtClient() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ HttpClient access$getClient$p(DhtClient $this) {
        return $this.client;
    }

    public static final /* synthetic */ String access$getGateway$p(DhtClient $this) {
        return $this.gateway;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lweb5/sdk/dids/methods/dht/DhtClient$Companion;", "", "()V", "createBep44PutRequest", "Lweb5/sdk/dids/methods/dht/Bep44Message;", "manager", "Lweb5/sdk/crypto/KeyManager;", "keyAlias", "", "message", "Lorg/xbill/DNS/Message;", "parseBep44GetResponse", "signBep44Message", "seq", "", "v", "", "verifyBep44Message", "", "dids"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Bep44Message createBep44PutRequest(@NotNull KeyManager manager, @NotNull String keyAlias, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            JWK pubKey = manager.getPublicKey(keyAlias);
            if (!(Intrinsics.areEqual((Object)pubKey.getKeyType(), (Object)Ed25519.INSTANCE.getKeyType()) && Intrinsics.areEqual((Object)pubKey.getAlgorithm(), (Object)Ed25519.INSTANCE.getAlgorithm()))) {
                boolean bl = false;
                String string = "Must supply an Ed25519 key";
                throw new IllegalArgumentException(string.toString());
            }
            long seq = System.currentTimeMillis() / (long)1000;
            byte[] v = message.toWire();
            Intrinsics.checkNotNull((Object)v);
            if (!(!(v.length == 0))) {
                boolean bl = false;
                String string = "Message must be not be empty";
                throw new IllegalArgumentException(string.toString());
            }
            return this.signBep44Message(manager, keyAlias, seq, v);
        }

        @NotNull
        public final Message parseBep44GetResponse(@NotNull Bep44Message message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.verifyBep44Message(message);
            DNSInput dnsInput = new DNSInput(message.getV());
            boolean bl = false;
            return new Message(dnsInput.readByteArray());
        }

        @NotNull
        public final Bep44Message signBep44Message(@NotNull KeyManager manager, @NotNull String keyAlias, long seq, @NotNull byte[] v) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            JWK pubKey = manager.getPublicKey(keyAlias);
            if (!(Intrinsics.areEqual((Object)pubKey.getKeyType(), (Object)Ed25519.INSTANCE.getKeyType()) && Intrinsics.areEqual((Object)pubKey.getAlgorithm(), (Object)Ed25519.INSTANCE.getAlgorithm()))) {
                boolean $i$a$-require-DhtClient$Companion$signBep44Message$32 = false;
                String $i$a$-require-DhtClient$Companion$signBep44Message$32 = "Must supply an Ed25519 key";
                throw new IllegalArgumentException($i$a$-require-DhtClient$Companion$signBep44Message$32.toString());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BEncoder.bencode((byte[])v, (OutputStream)out);
            byte[] vEncoded = out.toByteArray();
            if (!(vEncoded.length <= 1000)) {
                boolean bl = false;
                String string = "Value must be <= 1000 bytes compressed, current bytes {" + vEncoded.length + "}";
                throw new IllegalArgumentException(string.toString());
            }
            String string = "3:seqi" + seq + "e1:v";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Intrinsics.checkNotNull((Object)vEncoded);
            byte[] bytesToSign = ArraysKt.plus((byte[])byArray, (byte[])vEncoded);
            byte[] signature = manager.sign(keyAlias, bytesToSign);
            boolean bl = false;
            return new Bep44Message(v, Ed25519.INSTANCE.publicKeyToBytes(pubKey), signature, seq);
        }

        public final void verifyBep44Message(@NotNull Bep44Message message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BEncoder.bencode((byte[])message.getV(), (OutputStream)out);
            byte[] vEncoded = out.toByteArray();
            String string = "3:seqi" + message.getSeq() + "e1:v";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Intrinsics.checkNotNull((Object)vEncoded);
            byte[] bytesToVerify = ArraysKt.plus((byte[])byArray, (byte[])vEncoded);
            JWK ed25519PublicKey = Ed25519.INSTANCE.bytesToPublicKey(message.getK());
            Signer.DefaultImpls.verify$default((Signer)((Signer)Ed25519.INSTANCE), (JWK)ed25519PublicKey, (byte[])bytesToVerify, (byte[])message.getSig(), null, (int)8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

