/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.dht;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.Service;
import foundation.identity.did.VerificationMethod;
import io.ktor.client.engine.HttpClientEngine;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.ZBase32;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.Ed25519;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.dids.DidDocumentMetadata;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.PublicKeyPurpose;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.methods.dht.Bep44Message;
import web5.sdk.dids.methods.dht.CreateDidDhtOptions;
import web5.sdk.dids.methods.dht.DhtClient;
import web5.sdk.dids.methods.dht.DidDht;
import web5.sdk.dids.methods.dht.DidDhtConfiguration;
import web5.sdk.dids.methods.dht.DidDhtTypeIndexing;
import web5.sdk.dids.methods.ion.models.MetadataMethod;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J/\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00162\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0017H\u0002J0\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0002JB\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\u001a\u001a\u00020\f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0)2\u0006\u00100\u001a\u00020\fH\u0002J\u0018\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u00103\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f042\u0006\u00105\u001a\u00020\fH\u0002J*\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00172\u0010\b\u0002\u00108\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0007J\u001a\u00109\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010;H\u0016J\u000e\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fJ'\u0010>\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00172\u0010\b\u0002\u00108\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0001\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bAJ\u001d\u0010B\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bCR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002DE\u00a8\u0006F"}, d2={"Lweb5/sdk/dids/methods/dht/DidDhtApi;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/dht/DidDht;", "Lweb5/sdk/dids/methods/dht/CreateDidDhtOptions;", "configuration", "Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;", "(Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;)V", "dht", "Lweb5/sdk/dids/methods/dht/DhtClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "ttl", "", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "fromDnsPacket", "Lkotlin/Pair;", "Lfoundation/identity/did/DIDDocument;", "", "Lweb5/sdk/dids/methods/dht/DidDhtTypeIndexing;", "did", "msg", "Lorg/xbill/DNS/Message;", "fromDnsPacket$dids", "getDidIdentifier", "identityKey", "Lcom/nimbusds/jose/jwk/JWK;", "getDidIdentifier$dids", "getIdentityKid", "didDocument", "handleRootRecord", "", "rr", "Lorg/xbill/DNS/TXTRecord;", "keyLookup", "", "doc", "Lfoundation/identity/did/DIDDocument$Builder;", "handleVerificationMethods", "verificationMethods", "", "Lfoundation/identity/did/VerificationMethod;", "name", "load", "uri", "parseTxtData", "", "data", "publish", "manager", "types", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Lweb5/sdk/dids/ResolveDidOptions;", "suffix", "id", "toDnsPacket", "toDnsPacket$dids", "validate", "validate$dids", "validateIdentityKey", "validateIdentityKey$dids", "Lweb5/sdk/dids/methods/dht/DidDht$Default;", "Lweb5/sdk/dids/methods/dht/DidDhtApiImpl;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidDht.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,624:1\n1855#2:625\n1856#2:633\n1549#2:634\n1620#2,2:635\n1622#2:646\n1855#2:647\n1856#2:649\n1549#2:650\n1620#2,3:651\n1549#2:654\n1620#2,3:655\n1864#2,3:658\n1864#2,3:661\n1549#2:664\n1620#2,3:665\n1549#2:668\n1620#2,3:669\n1549#2:672\n1620#2,3:673\n1549#2:676\n1620#2,3:677\n1549#2:680\n1620#2,3:681\n1549#2:684\n1620#2,3:685\n1855#2:688\n1549#2:689\n1620#2,3:690\n1856#2:693\n1855#2:694\n1855#2,2:695\n1856#2:697\n1179#2,2:698\n1253#2,4:700\n372#3,7:626\n372#3,7:638\n13309#4:637\n13310#4:645\n1#5:648\n*S KotlinDebug\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n*L\n143#1:625\n143#1:633\n149#1:634\n149#1:635,2\n149#1:646\n163#1:647\n163#1:649\n169#1:650\n169#1:651,3\n219#1:654\n219#1:655,3\n330#1:658,3\n357#1:661,3\n375#1:664\n375#1:665,3\n379#1:668\n379#1:669,3\n383#1:672\n383#1:673,3\n387#1:676\n387#1:677,3\n391#1:680\n391#1:681,3\n405#1:684\n405#1:685,3\n433#1:688\n454#1:689\n454#1:690,3\n433#1:693\n520#1:694\n524#1:695,2\n520#1:697\n542#1:698,2\n542#1:700,4\n144#1:626,7\n157#1:638,7\n156#1:637\n156#1:645\n*E\n"})
public abstract class DidDhtApi
implements DidMethod<DidDht, CreateDidDhtOptions> {
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final DhtClient dht;
    private final long ttl;
    @NotNull
    private final String methodName;

    private DidDhtApi(DidDhtConfiguration configuration) {
        this.engine = configuration.getEngine();
        this.dht = new DhtClient(configuration.getGateway(), this.engine);
        this.ttl = 7200L;
        this.methodName = "dht";
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DidDht create(@NotNull KeyManager keyManager, @Nullable CreateDidDhtOptions options) {
        List list;
        List list2;
        Collection collection;
        Collection destination$iv$iv;
        Map $this$getOrPut$iv;
        void $this$forEach$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        CreateDidDhtOptions createDidDhtOptions = options;
        if (createDidDhtOptions == null) {
            createDidDhtOptions = new CreateDidDhtOptions(null, null, false, 7, null);
        }
        CreateDidDhtOptions opts = createDidDhtOptions;
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.EdDSA;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"EdDSA");
        String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm), (Curve)Curve.Ed25519, null, (int)4, null);
        JWK publicKey = keyManager.getPublicKey(keyAlias);
        String id = DidDht.Default.getDidIdentifier$dids(publicKey);
        VerificationMethod identityVerificationMethod = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(id + "#0"))).type("JsonWebKey2020")).controller(URI.create(id)).publicKeyJwk(publicKey.toPublicJWK().toJSONObject()).build();
        Map $this$create_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        VerificationMethod identityVerificationMethodRef = ((VerificationMethod.Builder)VerificationMethod.builder().id(identityVerificationMethod.getId())).build();
        Object object = new PublicKeyPurpose[]{PublicKeyPurpose.AUTHENTICATION, PublicKeyPurpose.ASSERTION_METHOD, PublicKeyPurpose.CAPABILITY_DELEGATION, PublicKeyPurpose.CAPABILITY_INVOCATION};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            PublicKeyPurpose purpose = (PublicKeyPurpose)((Object)element$iv);
            boolean bl2 = false;
            $this$getOrPut$iv = $this$create_u24lambda_u242;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)purpose);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(purpose, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            List list3 = (List)object2;
            Intrinsics.checkNotNull((Object)identityVerificationMethodRef);
            list3.add(identityVerificationMethodRef);
        }
        Map relationshipsMap = map;
        Iterable<Pair<JWK, PublicKeyPurpose[]>> iterable = opts.getVerificationMethods();
        if (iterable != null) {
            void $this$mapTo$iv$iv;
            Iterable<Pair<JWK, PublicKeyPurpose[]>> $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable<Pair<JWK, PublicKeyPurpose[]>> $i$f$forEach2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VerificationMethod verificationMethod;
                $this$getOrPut$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                JWK key = (JWK)$this$getOrPut$iv.component1();
                PublicKeyPurpose[] purposes = (PublicKeyPurpose[])$this$getOrPut$iv.component2();
                VerificationMethod verificationMethod2 = verificationMethod = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(id + "#" + key.getKeyID()))).type("JsonWebKey2020")).controller(URI.create(id)).publicKeyJwk(key.toPublicJWK().toJSONObject()).build();
                boolean bl5 = false;
                PublicKeyPurpose[] $this$forEach$iv2 = purposes;
                boolean $i$f$forEach3 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    Object object3;
                    PublicKeyPurpose element$iv;
                    PublicKeyPurpose relationship = element$iv = $this$forEach$iv2[i];
                    boolean bl6 = false;
                    Map $this$getOrPut$iv2 = relationshipsMap;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get((Object)relationship);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(relationship, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    List list4 = (List)object3;
                    VerificationMethod verificationMethod3 = ((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethod2.getId())).build();
                    Intrinsics.checkNotNullExpressionValue((Object)verificationMethod3, (String)"build(...)");
                    list4.add(verificationMethod3);
                }
                collection.add(verificationMethod);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List verificationMethods = CollectionsKt.plus((Collection)list2, (Object)identityVerificationMethod);
        Iterable<Service> iterable2 = opts.getServices();
        if (iterable2 != null) {
            Iterable<Service> $this$forEach$iv3 = iterable2;
            boolean $i$f$forEach4 = false;
            Iterator<Service> $i$f$map = $this$forEach$iv3.iterator();
            while ($i$f$map.hasNext()) {
                Service element$iv;
                Service service = element$iv = $i$f$map.next();
                boolean bl8 = false;
                if (service.getId() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$1$42 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$1$42 = "Service id cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$1$42.toString());
                }
                if (service.getType() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$1$52 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$1$52 = "Service type cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$1$52.toString());
                }
                if (service.getServiceEndpoint() != null) continue;
                boolean bl9 = false;
                String string = "Service serviceEndpoint cannot be null";
                throw new IllegalArgumentException(string.toString());
            }
        }
        Iterable<Service> iterable3 = opts.getServices();
        if (iterable3 != null) {
            void $this$mapTo$iv$iv;
            Iterable<Service> $this$map$iv = iterable3;
            boolean $i$f$map = false;
            Iterable<Service> element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void service;
                $this$getOrPut$iv = (Service)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add(((Service.Builder)((Service.Builder)Service.builder().id(URI.create(id + "#" + service.getId()))).type(service.getType())).serviceEndpoint(service.getServiceEndpoint()).build());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List services = list;
        DIDDocument didDocument = ((DIDDocument.Builder)DIDDocument.builder().id(new URI(id))).verificationMethods(verificationMethods).services(services).assertionMethodVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.ASSERTION_METHOD)).authenticationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.AUTHENTICATION)).keyAgreementVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.KEY_AGREEMENT)).capabilityDelegationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.CAPABILITY_DELEGATION)).capabilityInvocationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.CAPABILITY_INVOCATION)).build();
        if (opts.getPublish()) {
            Intrinsics.checkNotNull((Object)didDocument);
            DidDhtApi.publish$default(this, keyManager, didDocument, null, 4, null);
        }
        return new DidDht(id, keyManager, didDocument, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        this.validate$dids(did);
        String getId = DidDht.Default.suffix(did);
        Bep44Message bep44Message = this.dht.pkarrGet(getId);
        Message dnsPacket = DhtClient.Companion.parseBep44GetResponse(bep44Message);
        Pair<DIDDocument, List<DidDhtTypeIndexing>> pair = this.fromDnsPacket$dids(did, dnsPacket);
        boolean bl = false;
        DIDDocument didDocument = (DIDDocument)pair.component1();
        List types = (List)pair.component2();
        Iterable iterable = types;
        MetadataMethod metadataMethod = null;
        String string = null;
        List list = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Boolean bl2 = null;
        String string5 = null;
        String string6 = null;
        DidResolutionMetadata didResolutionMetadata = null;
        DIDDocument dIDDocument = didDocument;
        String string7 = null;
        boolean $i$f$map = false;
        void var24_24 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DidDhtTypeIndexing didDhtTypeIndexing = (DidDhtTypeIndexing)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getIndex());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 511;
        Collection<Integer> collection2 = collection;
        MetadataMethod metadataMethod2 = metadataMethod;
        String string8 = string;
        List list2 = list;
        String string9 = string2;
        String string10 = string3;
        String string11 = string4;
        Boolean bl4 = bl2;
        String string12 = string5;
        String string13 = string6;
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n2 = 5;
        DidDocumentMetadata didDocumentMetadata = new DidDocumentMetadata(string13, string12, bl4, string11, string10, string9, list2, string8, metadataMethod2, (List)collection2, n, defaultConstructorMarker);
        DidResolutionMetadata didResolutionMetadata2 = didResolutionMetadata;
        DIDDocument dIDDocument2 = dIDDocument;
        String string14 = string7;
        return new DidResolutionResult(string14, dIDDocument2, didResolutionMetadata2, didDocumentMetadata, n2, defaultConstructorMarker2);
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        String string = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.validate$dids(string);
        String string2 = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String publishId = DidDht.Default.suffix(string2);
        Message dnsPacket = this.toDnsPacket$dids(didDocument, types);
        Bep44Message bep44Message = DhtClient.Companion.createBep44PutRequest(manager, this.getIdentityKid(didDocument), dnsPacket);
        this.dht.pkarrPut(publishId, bep44Message);
    }

    public static /* synthetic */ void publish$default(DidDhtApi didDhtApi, KeyManager keyManager, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publish");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        didDhtApi.publish(keyManager, dIDDocument, list);
    }

    @NotNull
    public final String suffix(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String[] stringArray = new String[]{":"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final String getIdentityKid(DIDDocument didDocument) {
        String string = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.validate$dids(string);
        List list = didDocument.getVerificationMethods();
        JWK publicKeyJwk = JWK.parse(list != null && (list = (VerificationMethod)CollectionsKt.first((List)list)) != null ? list.getPublicKeyJwk() : null);
        String string2 = publicKeyJwk.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKeyID(...)");
        return string2;
    }

    @Override
    @NotNull
    public DidDht load(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
        this.validateIdentityKey$dids(uri, keyManager);
        return new DidDht(uri, keyManager, null, this);
    }

    public final void validateIdentityKey$dids(@NotNull String did, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DID parsedDid = DID.fromString((String)did);
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        byte[] decodedId = ZBase32.INSTANCE.decode(string);
        if (!(decodedId.length == 32)) {
            boolean $i$a$-require-DidDhtApi$validateIdentityKey$22 = false;
            String $i$a$-require-DidDhtApi$validateIdentityKey$22 = "expected size of decoded identifier \"" + parsedDid.getMethodSpecificId() + "\" to be 32";
            throw new IllegalArgumentException($i$a$-require-DidDhtApi$validateIdentityKey$22.toString());
        }
        JWK publicKeyJwk = Ed25519.INSTANCE.bytesToPublicKey(decodedId);
        String identityKeyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
        keyManager.getPublicKey(identityKeyAlias);
    }

    @NotNull
    public final String getDidIdentifier$dids(@NotNull JWK identityKey) {
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        JWK publicKeyJwk = identityKey.toPublicJWK();
        Intrinsics.checkNotNull((Object)publicKeyJwk);
        byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
        String zBase32Encoded = ZBase32.INSTANCE.encode(publicKeyBytes);
        return "did:dht:" + zBase32Encoded;
    }

    public final void validate$dids(@NotNull String did) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        DID parsedDid = DID.fromString((String)did);
        if (!Intrinsics.areEqual((Object)parsedDid.getMethodName(), (Object)DidDht.Default.getMethodName())) {
            boolean bl = false;
            String string = "expected method to be dht";
            throw new IllegalArgumentException(string.toString());
        }
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        byte[] decodedId = ZBase32.INSTANCE.decode(string);
        if (!(decodedId.length == 32)) {
            boolean bl = false;
            String string2 = "expected size of decoded identifier to be 32";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object it;
        VerificationMethod it2;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object object5;
        Iterable service;
        String base64UrlEncodedKey;
        Service verificationMethod;
        int i;
        int n;
        int index$iv;
        boolean $i$f$forEachIndexed;
        Iterable $this$forEachIndexed$iv;
        Message message;
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        Message $this$toDnsPacket_u24lambda_u2417 = message = new Message(0);
        boolean bl = false;
        $this$toDnsPacket_u24lambda_u2417.getHeader().setFlag(5);
        Message message2 = message;
        Map verificationMethodsById = new LinkedHashMap();
        List verificationMethodIds = new ArrayList();
        List serviceIds = new ArrayList();
        List list = didDocument.getVerificationMethods();
        if (list != null) {
            $this$forEachIndexed$iv = list;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n2;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VerificationMethod verificationMethod2 = (VerificationMethod)item$iv;
                i = n;
                boolean bl2 = false;
                JWK publicKeyJwk = JWK.parse((Map)verificationMethod.getPublicKeyJwk());
                Intrinsics.checkNotNull((Object)publicKeyJwk);
                byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
                base64UrlEncodedKey = new Convert((Object)publicKeyBytes, null, 2, null).toBase64Url(false);
                String verificationMethodId = "k" + i;
                Map map = verificationMethodsById;
                String string = verificationMethod.getId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                map.put(string, verificationMethodId);
                Algorithm algorithm = publicKeyJwk.getAlgorithm();
                if (Intrinsics.areEqual((Object)algorithm, (Object)JWSAlgorithm.EdDSA)) {
                    n2 = 0;
                } else if (Intrinsics.areEqual((Object)algorithm, (Object)JWSAlgorithm.ES256K)) {
                    n2 = 1;
                } else {
                    throw new IllegalArgumentException("unsupported algorithm: " + publicKeyJwk.getAlgorithm());
                }
                int keyType = n2;
                message2.addRecord((Record)new TXTRecord(new Name("_" + verificationMethodId + "._did."), 1, this.ttl, "id=" + verificationMethod.getId().getRawFragment() + ",t=" + keyType + ",k=" + base64UrlEncodedKey), 1);
                ((Collection)verificationMethodIds).add(verificationMethodId);
            }
        }
        List list2 = didDocument.getServices();
        if (list2 != null) {
            $this$forEachIndexed$iv = list2;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                verificationMethod = (Service)item$iv;
                i = n;
                boolean bl3 = false;
                Iterator sId = "s" + i;
                message2.addRecord((Record)new TXTRecord(new Name("_" + (String)((Object)sId) + "._did."), 1, this.ttl, "id=" + service.getId().getRawFragment() + ",t=" + service.getType() + ",uri=" + service.getServiceEndpoint()), 1);
                ((Collection)serviceIds).add(sId);
            }
        }
        Iterable $this$toDnsPacket_u24lambda_u2430 = $this$forEachIndexed$iv = (List)new ArrayList();
        boolean bl4 = false;
        if (!((Collection)verificationMethodIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2430.add("vm=" + CollectionsKt.joinToString$default((Iterable)verificationMethodIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)serviceIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2430.add("svc=" + CollectionsKt.joinToString$default((Iterable)serviceIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object5 = didDocument.getAuthenticationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object5;
            $i$f$map = false;
            service = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                base64UrlEncodedKey = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object5 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object5 != null) {
                it = object5;
                boolean bl6 = false;
                $this$toDnsPacket_u24lambda_u2430.add("auth=" + (String)it);
            }
        }
        if ((object4 = didDocument.getAssertionMethodVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object4;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object4 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object4 != null) {
                it = object4;
                boolean bl8 = false;
                $this$toDnsPacket_u24lambda_u2430.add("asm=" + (String)it);
            }
        }
        if ((object3 = didDocument.getKeyAgreementVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object3;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object3 != null) {
                it = object3;
                boolean bl10 = false;
                $this$toDnsPacket_u24lambda_u2430.add("agm=" + (String)it);
            }
        }
        if ((object2 = didDocument.getCapabilityInvocationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl11 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object2 != null) {
                it = object2;
                boolean bl12 = false;
                $this$toDnsPacket_u24lambda_u2430.add("inv=" + (String)it);
            }
        }
        if ((object = didDocument.getCapabilityDelegationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl13 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object != null) {
                it = object;
                boolean bl14 = false;
                $this$toDnsPacket_u24lambda_u2430.add("del=" + (String)it);
            }
        }
        Iterable rootRecordText = $this$forEachIndexed$iv;
        message2.addRecord((Record)new TXTRecord(new Name("_did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)rootRecordText, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
        if (types != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = types;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                DidDhtTypeIndexing $i$f$mapTo3 = (DidDhtTypeIndexing)((Object)item$iv$iv);
                Collection collection2 = destination$iv$iv;
                boolean bl15 = false;
                collection2.add(it3.getIndex());
            }
            List typeIndexes = (List)destination$iv$iv;
            message2.addRecord((Record)new TXTRecord(new Name("_typ._did."), 1, this.ttl, "id=" + CollectionsKt.joinToString$default((Iterable)typeIndexes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), 1);
        }
        return message2;
    }

    public static /* synthetic */ Message toDnsPacket$dids$default(DidDhtApi didDhtApi, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDnsPacket");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return didDhtApi.toDnsPacket$dids(dIDDocument, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<DIDDocument, List<DidDhtTypeIndexing>> fromDnsPacket$dids(@NotNull String did, @NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        DIDDocument.Builder doc = (DIDDocument.Builder)DIDDocument.builder().id(URI.create(did));
        List verificationMethods = new ArrayList();
        List services = new ArrayList();
        List types = new ArrayList();
        Map keyLookup = new LinkedHashMap();
        List list = msg.getSection(1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSection(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            Record rr = (Record)element$iv;
            boolean bl = false;
            if (!(rr instanceof TXTRecord)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TXTRecord)rr).getName().toString(), (String)"toString(...)");
            if (StringsKt.startsWith$default((String)name, (String)"_k", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleVerificationMethods((TXTRecord)rr, verificationMethods, did, keyLookup, name);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_s", (boolean)false, (int)2, null)) {
                List list2 = ((TXTRecord)rr).getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                Collection collection = services;
                Service.Builder builder = Service.builder();
                String string = data.get("id");
                Intrinsics.checkNotNull((Object)string);
                Service.Builder builder2 = (Service.Builder)builder.id(URI.create(did + "#" + string));
                String string2 = data.get("t");
                Intrinsics.checkNotNull((Object)string2);
                Service.Builder builder3 = (Service.Builder)builder2.type(string2);
                String string3 = data.get("uri");
                Intrinsics.checkNotNull((Object)string3);
                collection.add(builder3.serviceEndpoint((Object)string3).build());
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"_typ._did.")) {
                Object e = ((TXTRecord)rr).getStrings().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                if (((CharSequence)e).length() > 0 && ((TXTRecord)rr).getStrings().size() == 1) {
                    void $this$mapTo$iv$iv;
                    Collection collection = types;
                    Object e2 = ((TXTRecord)rr).getStrings().get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    Object object = new String[]{","};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)((String)e2), (CharSequence)"id="), (String[])object, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        DidDhtTypeIndexing didDhtTypeIndexing = DidDhtTypeIndexing.Companion.fromInt(Integer.parseInt((String)it));
                        if (didDhtTypeIndexing == null) {
                            throw new IllegalArgumentException("invalid type index");
                        }
                        collection2.add(didDhtTypeIndexing);
                    }
                    object = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)object);
                    continue;
                }
                throw new IllegalArgumentException("invalid types record");
            }
            if (!Intrinsics.areEqual((Object)name, (Object)"_did.")) continue;
            Intrinsics.checkNotNull((Object)rr);
            TXTRecord tXTRecord = (TXTRecord)rr;
            Intrinsics.checkNotNull((Object)doc);
            this.handleRootRecord(tXTRecord, keyLookup, doc);
        }
        doc.verificationMethods(verificationMethods);
        doc.services(services);
        return TuplesKt.to((Object)doc.build(), (Object)types);
    }

    private final void handleVerificationMethods(TXTRecord rr, List<VerificationMethod> verificationMethods, String did, Map<String, String> keyLookup, String name) {
        JWK jWK;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        String string = data.get("id");
        Intrinsics.checkNotNull((Object)string);
        String verificationMethodId = string;
        String string2 = data.get("k");
        Intrinsics.checkNotNull((Object)string2);
        byte[] keyBytes = new Convert((Object)string2, EncodingFormat.Base64Url).toByteArray();
        String string3 = data.get("t");
        Intrinsics.checkNotNull((Object)string3);
        Object object = string3;
        if (Intrinsics.areEqual((Object)object, (Object)"0")) {
            jWK = Ed25519.INSTANCE.bytesToPublicKey(keyBytes);
        } else if (Intrinsics.areEqual((Object)object, (Object)"1")) {
            jWK = Secp256k1.INSTANCE.bytesToPublicKey(keyBytes);
        } else {
            throw new IllegalArgumentException("Unknown key type: " + data.get("t"));
        }
        JWK publicKeyJwk = jWK;
        ((Collection)verificationMethods).add(((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(did + "#" + verificationMethodId))).type("JsonWebKey2020")).controller(URI.create(did)).publicKeyJwk(publicKeyJwk.toJSONObject()).build());
        object = keyLookup;
        Object object2 = new String[]{"."};
        object2 = StringsKt.drop((String)((String)StringsKt.split$default((CharSequence)name, (String[])object2, (boolean)false, (int)0, (int)6, null).get(0)), (int)1);
        String string4 = did + "#" + verificationMethodId;
        object.put(object2, string4);
    }

    private final void handleRootRecord(TXTRecord rr, Map<String, String> keyLookup, DIDDocument.Builder<?> doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String[] stringArray = new String[]{";"};
        List rootData = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"auth", (Object)new ArrayList()), TuplesKt.to((Object)"asm", (Object)new ArrayList()), TuplesKt.to((Object)"agm", (Object)new ArrayList()), TuplesKt.to((Object)"inv", (Object)new ArrayList()), TuplesKt.to((Object)"del", (Object)new ArrayList())};
        Map lists = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = rootData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list2 = StringsKt.split$default((CharSequence)item, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list2.get(0);
            String values = (String)list2.get(1);
            String[] stringArray3 = new String[]{","};
            List valueItems = StringsKt.split$default((CharSequence)values, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv2 = valueItems;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                List list3 = (List)lists.get(key);
                if (list3 == null) continue;
                VerificationMethod.Builder builder = VerificationMethod.builder();
                String string = keyLookup.get(it);
                Intrinsics.checkNotNull((Object)string);
                VerificationMethod verificationMethod = ((VerificationMethod.Builder)builder.id(new URI(string))).build();
                Intrinsics.checkNotNullExpressionValue((Object)verificationMethod, (String)"build(...)");
                list3.add(verificationMethod);
            }
        }
        doc.authenticationVerificationMethods((List)lists.get("auth"));
        doc.assertionMethodVerificationMethods((List)lists.get("asm"));
        doc.keyAgreementVerificationMethods((List)lists.get("agm"));
        doc.capabilityInvocationVerificationMethods((List)lists.get("inv"));
        doc.capabilityDelegationVerificationMethods((List)lists.get("del"));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseTxtData(String data) {
        void $this$associateTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        DidDhtApi.publish$default(this, manager, didDocument, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        return DidDhtApi.toDnsPacket$dids$default(this, didDocument, null, 2, null);
    }

    public /* synthetic */ DidDhtApi(DidDhtConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }
}

