/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.jackson.JacksonConverterKt;
import java.net.URL;
import java.net.URLDecoder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.CreateDidOptions;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.methods.ion.InvalidStatusException;
import web5.sdk.dids.methods.web.DidWeb;
import web5.sdk.dids.methods.web.DidWebApi;
import web5.sdk.dids.methods.web.DidWebApiConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lweb5/sdk/dids/methods/web/DidWebApi;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/web/DidWeb;", "Lweb5/sdk/dids/CreateDidOptions;", "configuration", "Lweb5/sdk/dids/methods/web/DidWebApiConfiguration;", "(Lweb5/sdk/dids/methods/web/DidWebApiConfiguration;)V", "client", "Lio/ktor/client/HttpClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "getDocURL", "didWebStr", "load", "uri", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "did", "Lweb5/sdk/dids/ResolveDidOptions;", "Lweb5/sdk/dids/methods/web/DidWeb$Default;", "Lweb5/sdk/dids/methods/web/DidWebApiImpl;", "dids"})
public abstract class DidWebApi
implements DidMethod<DidWeb, CreateDidOptions> {
    @NotNull
    private final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final HttpClient client;
    @NotNull
    private final String methodName;

    private DidWebApi(DidWebApiConfiguration configuration) {
        HttpClientEngine httpClientEngine = configuration.getEngine();
        if (httpClientEngine == null) {
            httpClientEngine = OkHttp.INSTANCE.create((Function1)engine.1.INSTANCE);
        }
        this.engine = httpClientEngine;
        this.client = HttpClientKt.HttpClient((HttpClientEngine)this.engine, (Function1)new Function1<HttpClientConfig<?>, Unit>(this){
            final /* synthetic */ DidWebApi this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$HttpClient) {
                Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)new Function1<ContentNegotiation.Config, Unit>(this.this$0){
                    final /* synthetic */ DidWebApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ContentNegotiation.Config $this$install) {
                        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                        JacksonConverterKt.jackson$default((Configuration)((Configuration)$this$install), null, (boolean)false, (Function1)((Function1)new Function1<ObjectMapper, Unit>(this.this$0){
                            final /* synthetic */ DidWebApi this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ObjectMapper $this$jackson) {
                                Intrinsics.checkNotNullParameter((Object)$this$jackson, (String)"$this$jackson");
                                DidWebApi.access$getMapper$p(this.this$0);
                            }
                        }), (int)3, null);
                    }
                });
            }
        });
        this.methodName = "web";
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        String docURL = this.getDocURL(did);
        HttpResponse resp2 = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, docURL, null){
            int label;
            final /* synthetic */ DidWebApi this$0;
            final /* synthetic */ String $docURL;
            {
                this.this$0 = $receiver;
                this.$docURL = $docURL;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$get$iv$iv$iv;
                        HttpRequestBuilder httpRequestBuilder;
                        void $this$get$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpClient httpClient = DidWebApi.access$getClient$p(this.this$0);
                        String urlString$iv = this.$docURL;
                        boolean $i$f$get = false;
                        void $this$get$iv$iv = $this$get$iv;
                        boolean $i$f$get2 = false;
                        void var7_10 = $this$get$iv$iv;
                        HttpRequestBuilder $this$get_u24lambda_u244$iv = httpRequestBuilder = new HttpRequestBuilder();
                        boolean bl = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)urlString$iv);
                        HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$get_u24lambda_u244$iv;
                        boolean bl2 = false;
                        HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                        HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                        boolean $i$f$get3 = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                        void $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                        boolean $i$f$request = false;
                        this.label = 1;
                        Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$get = false;
                        boolean $i$f$get4 = false;
                        boolean $i$f$get5 = false;
                        boolean $i$f$request = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String body2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(resp2, null){
            int label;
            final /* synthetic */ HttpResponse $resp;
            {
                this.$resp = $resp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$resp, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)resp2.getStatus())) {
            throw new InvalidStatusException(resp2.getStatus().getValue(), "resolution error response: '" + body2 + "'");
        }
        Object object = this.mapper.readValue(body2, DIDDocument.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return new DidResolutionResult(null, (DIDDocument)object, null, null, 13, null);
    }

    @Override
    @NotNull
    public DidWeb load(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
        return new DidWeb(uri, keyManager, this);
    }

    private final String getDocURL(String didWebStr) {
        DID parsedDid = DID.fromString((String)didWebStr);
        if (!Intrinsics.areEqual((Object)parsedDid.getMethodName(), (Object)this.getMethodName())) {
            boolean $i$a$-require-DidWebApi$getDocURL$22 = false;
            String $i$a$-require-DidWebApi$getDocURL$22 = didWebStr + " is missing prefix \"did:" + this.getMethodName() + "\"";
            throw new IllegalArgumentException($i$a$-require-DidWebApi$getDocURL$22.toString());
        }
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        String domainNameWithPath = StringsKt.replace$default((String)string, (String)":", (String)"/", (boolean)false, (int)4, null);
        String decodedDomain = URLDecoder.decode(domainNameWithPath, Charsets.UTF_8);
        StringBuilder targetUrl = new StringBuilder("https://" + decodedDomain);
        URL url = new URL(targetUrl.toString());
        String string2 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        if (((CharSequence)string2).length() == 0) {
            targetUrl.append("/.well-known");
        }
        targetUrl.append("/did.json");
        String string3 = targetUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @Override
    @NotNull
    public DidWeb create(@NotNull KeyManager keyManager, @Nullable CreateDidOptions options) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        throw new UnsupportedOperationException("Create operation is not supported for did:web");
    }

    public /* synthetic */ DidWebApi(DidWebApiConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }

    public static final /* synthetic */ HttpClient access$getClient$p(DidWebApi $this) {
        return $this.client;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(DidWebApi $this) {
        return $this.mapper;
    }
}

