/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.dht;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.Service;
import foundation.identity.did.VerificationMethod;
import io.ktor.client.engine.HttpClientEngine;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.ZBase32;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.Ed25519;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.dids.DidDocumentMetadata;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.PublicKeyPurpose;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.exceptions.InvalidIdentifierException;
import web5.sdk.dids.exceptions.InvalidIdentifierSizeException;
import web5.sdk.dids.exceptions.InvalidMethodNameException;
import web5.sdk.dids.exceptions.PkarrRecordNotFoundException;
import web5.sdk.dids.methods.dht.Bep44Message;
import web5.sdk.dids.methods.dht.CreateDidDhtOptions;
import web5.sdk.dids.methods.dht.DhtClient;
import web5.sdk.dids.methods.dht.DidDht;
import web5.sdk.dids.methods.dht.DidDhtConfiguration;
import web5.sdk.dids.methods.dht.DidDhtKt;
import web5.sdk.dids.methods.dht.DidDhtTypeIndexing;
import web5.sdk.dids.methods.ion.models.MetadataMethod;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u0018\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0016J/\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001a0\u00192\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J\u001c\u0010/\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J0\u00100\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002JB\u00102\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010\"\u001a\u00020\f2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f062\u0006\u00107\u001a\u00020\fH\u0002J\u0018\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010;\u001a\u00020\fH\u0002J*\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010>\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001aH\u0007J\u001a\u0010?\u001a\u00020@2\u0006\u0010\"\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010AH\u0016J\u0010\u0010B\u001a\u00020@2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020EH\u0002J\u000e\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fJ'\u0010H\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010>\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001aH\u0001\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bKJ\u001d\u0010L\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bMR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002NO\u00a8\u0006P"}, d2={"Lweb5/sdk/dids/methods/dht/DidDhtApi;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/dht/DidDht;", "Lweb5/sdk/dids/methods/dht/CreateDidDhtOptions;", "configuration", "Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;", "(Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;)V", "dht", "Lweb5/sdk/dids/methods/dht/DhtClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "ttl", "", "addAlsoKnownAsRecord", "", "didDocument", "Lfoundation/identity/did/DIDDocument;", "message", "Lorg/xbill/DNS/Message;", "addControllerRecord", "addVerificationMethodRecords", "Lkotlin/Pair;", "", "", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "fromDnsPacket", "Lweb5/sdk/dids/methods/dht/DidDhtTypeIndexing;", "did", "msg", "fromDnsPacket$dids", "getDidIdentifier", "identityKey", "Lcom/nimbusds/jose/jwk/JWK;", "getDidIdentifier$dids", "getIdentityKid", "handleAlsoKnownAsRecord", "rr", "Lorg/xbill/DNS/TXTRecord;", "doc", "Lfoundation/identity/did/DIDDocument$Builder;", "handleControllerRecord", "handleRootRecord", "keyLookup", "handleVerificationMethods", "verificationMethods", "", "Lfoundation/identity/did/VerificationMethod;", "", "name", "load", "uri", "parseTxtData", "data", "publish", "manager", "types", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Lweb5/sdk/dids/ResolveDidOptions;", "resolveInternal", "serviceRecordValue", "service", "Lfoundation/identity/did/Service;", "suffix", "id", "toDnsPacket", "toDnsPacket$dids", "validate", "validate$dids", "validateIdentityKey", "validateIdentityKey$dids", "Lweb5/sdk/dids/methods/dht/DidDht$Default;", "Lweb5/sdk/dids/methods/dht/DidDhtApiImpl;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidDht.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,765:1\n1855#2:766\n1856#2:774\n1549#2:775\n1620#2,2:776\n1622#2:787\n1855#2:788\n1856#2:790\n1549#2:791\n1620#2,3:792\n1549#2:795\n1620#2,3:796\n1549#2:799\n1620#2,3:800\n1549#2:803\n1620#2,3:804\n1864#2,3:807\n1549#2:810\n1620#2,3:811\n1549#2:814\n1620#2,3:815\n1549#2:818\n1620#2,3:819\n1549#2:822\n1620#2,3:823\n1549#2:826\n1620#2,3:827\n1549#2:830\n1620#2,3:831\n1864#2,3:834\n1855#2:837\n1549#2:838\n1620#2,3:839\n1856#2:842\n1549#2:843\n1620#2,3:844\n1549#2:847\n1620#2,3:848\n1855#2:851\n1855#2,2:852\n1856#2:854\n1179#2,2:855\n1253#2,4:857\n372#3,7:767\n372#3,7:779\n13309#4:778\n13310#4:786\n1#5:789\n*S KotlinDebug\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n*L\n159#1:766\n159#1:774\n166#1:775\n166#1:776,2\n166#1:787\n180#1:788\n180#1:790\n186#1:791\n186#1:792,3\n207#1:795\n207#1:796,3\n208#1:799\n208#1:800,3\n261#1:803\n261#1:804,3\n380#1:807,3\n405#1:810\n405#1:811,3\n409#1:814\n409#1:815,3\n413#1:818\n413#1:819,3\n417#1:822\n417#1:823,3\n421#1:826\n421#1:827,3\n435#1:830\n435#1:831,3\n450#1:834,3\n543#1:837\n564#1:838\n564#1:839,3\n543#1:842\n597#1:843\n597#1:844,3\n602#1:847\n602#1:848,3\n661#1:851\n665#1:852,2\n661#1:854\n683#1:855,2\n683#1:857,4\n160#1:767,7\n174#1:779,7\n173#1:778\n173#1:786\n*E\n"})
public abstract class DidDhtApi
implements DidMethod<DidDht, CreateDidDhtOptions> {
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final DhtClient dht;
    private final long ttl;
    @NotNull
    private final String methodName;

    private DidDhtApi(DidDhtConfiguration configuration) {
        this.engine = configuration.getEngine();
        this.dht = new DhtClient(configuration.getGateway(), this.engine);
        this.ttl = 7200L;
        this.methodName = "dht";
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DidDht create(@NotNull KeyManager keyManager, @Nullable CreateDidDhtOptions options) {
        String p0;
        Collection collection;
        Iterable<String> $this$mapTo$iv$iv;
        DIDDocument.Builder builder;
        List list;
        void service;
        Iterable iterable;
        Object object;
        Collection destination$iv$iv;
        Collection collection2;
        Map $this$getOrPut$iv;
        void $this$forEach$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        CreateDidDhtOptions createDidDhtOptions = options;
        if (createDidDhtOptions == null) {
            createDidDhtOptions = new CreateDidDhtOptions(null, null, false, null, null, 31, null);
        }
        CreateDidDhtOptions opts = createDidDhtOptions;
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.EdDSA;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"EdDSA");
        String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (Algorithm)((Algorithm)jWSAlgorithm), (Curve)Curve.Ed25519, null, (int)4, null);
        JWK publicKey = keyManager.getPublicKey(keyAlias);
        String id = DidDht.Default.getDidIdentifier$dids(publicKey);
        VerificationMethod identityVerificationMethod = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(id + "#0"))).type("JsonWebKey")).controller(URI.create(id)).publicKeyJwk(publicKey.toPublicJWK().toJSONObject()).build();
        Map $this$create_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Object identityVerificationMethodRef = ((VerificationMethod.Builder)VerificationMethod.builder().id(identityVerificationMethod.getId())).build();
        Object object2 = new PublicKeyPurpose[]{PublicKeyPurpose.AUTHENTICATION, PublicKeyPurpose.ASSERTION_METHOD, PublicKeyPurpose.CAPABILITY_DELEGATION, PublicKeyPurpose.CAPABILITY_INVOCATION};
        object2 = CollectionsKt.listOf((Object[])object2);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object3;
            PublicKeyPurpose purpose = (PublicKeyPurpose)((Object)element$iv);
            boolean bl2 = false;
            $this$getOrPut$iv = $this$create_u24lambda_u242;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)purpose);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(purpose, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            List list2 = (List)object3;
            Intrinsics.checkNotNull((Object)identityVerificationMethodRef);
            list2.add(identityVerificationMethodRef);
        }
        Map relationshipsMap = map;
        Collection collection3 = CollectionsKt.listOf((Object)identityVerificationMethod);
        Iterable<Triple<JWK, PublicKeyPurpose[], String>> iterable2 = opts.getVerificationMethods();
        if (iterable2 != null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            identityVerificationMethodRef = iterable2;
            collection2 = collection3;
            boolean $i$f$map = false;
            void $i$f$forEach2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                $this$getOrPut$iv = (Triple)item$iv$iv;
                Collection collection4 = destination$iv$iv;
                boolean bl4 = false;
                JWK key = (JWK)$this$getOrPut$iv.component1();
                PublicKeyPurpose[] purposes = (PublicKeyPurpose[])$this$getOrPut$iv.component2();
                String controller = (String)$this$getOrPut$iv.component3();
                VerificationMethod.Builder builder2 = (VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(id + "#" + key.getKeyID()))).type("JsonWebKey");
                String string = controller;
                if (string == null) {
                    string = id;
                }
                VerificationMethod verificationMethod = object = builder2.controller(URI.create(string)).publicKeyJwk(key.toPublicJWK().toJSONObject()).build();
                boolean bl5 = false;
                PublicKeyPurpose[] $this$forEach$iv2 = purposes;
                boolean $i$f$forEach3 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    Object object4;
                    PublicKeyPurpose element$iv;
                    PublicKeyPurpose relationship = element$iv = $this$forEach$iv2[i];
                    boolean bl6 = false;
                    Map $this$getOrPut$iv2 = relationshipsMap;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get((Object)relationship);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(relationship, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv;
                    }
                    List list3 = (List)object4;
                    VerificationMethod verificationMethod2 = ((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethod.getId())).build();
                    Intrinsics.checkNotNullExpressionValue((Object)verificationMethod2, (String)"build(...)");
                    list3.add(verificationMethod2);
                }
                collection4.add(object);
            }
            collection3 = collection2;
            iterable = (List)destination$iv$iv;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        List verificationMethods = CollectionsKt.plus((Collection)collection3, (Iterable)iterable);
        Iterable<Service> iterable3 = opts.getServices();
        if (iterable3 != null) {
            Iterable<Service> $this$forEach$iv3 = iterable3;
            boolean $i$f$forEach4 = false;
            Iterator<Service> $i$f$map = $this$forEach$iv3.iterator();
            while ($i$f$map.hasNext()) {
                Service element$iv;
                Service service2 = element$iv = $i$f$map.next();
                boolean bl8 = false;
                if (service2.getId() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$1$42 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$1$42 = "Service id cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$1$42.toString());
                }
                if (service2.getType() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$1$52 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$1$52 = "Service type cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$1$52.toString());
                }
                if (service2.getServiceEndpoint() != null) continue;
                boolean bl9 = false;
                String string = "Service serviceEndpoint cannot be null";
                throw new IllegalArgumentException(string.toString());
            }
        }
        Iterable<Service> iterable4 = opts.getServices();
        if (iterable4 != null) {
            void $this$mapTo$iv$iv3;
            Iterable<Service> $this$map$iv = iterable4;
            boolean $i$f$map = false;
            Iterable<Service> element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                $this$getOrPut$iv = (Service)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl10 = false;
                collection2.add(((Service.Builder)((Service.Builder)Service.builder().id(URI.create(id + "#" + service.getId()))).type(service.getType())).serviceEndpoint(service.getServiceEndpoint()).build());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List services = list;
        DIDDocument.Builder didDocumentBuilder = ((DIDDocument.Builder)((DIDDocument.Builder)DIDDocument.builder().defaultContexts(false)).id(new URI(id))).verificationMethods(verificationMethods).services(services).assertionMethodVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.ASSERTION_METHOD)).authenticationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.AUTHENTICATION)).keyAgreementVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.KEY_AGREEMENT)).capabilityDelegationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.CAPABILITY_DELEGATION)).capabilityInvocationVerificationMethods((List)relationshipsMap.get((Object)PublicKeyPurpose.CAPABILITY_INVOCATION));
        Iterable<String> iterable5 = opts.getControllers();
        if (iterable5 != null) {
            void $this$map$iv;
            Iterable<String> it = iterable5;
            boolean bl11 = false;
            Iterable<String> $i$f$mapTo = it;
            builder = didDocumentBuilder;
            boolean $i$f$map = false;
            service = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (String item$iv$iv : $this$mapTo$iv$iv) {
                object = item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl12 = false;
                collection.add(URI.create(p0));
            }
            builder.controllers((List)destination$iv$iv2);
        }
        Iterable<String> iterable6 = opts.getAlsoKnownAses();
        if (iterable6 != null) {
            Iterable<String> it = iterable6;
            boolean bl13 = false;
            Iterable<String> $this$map$iv = it;
            builder = didDocumentBuilder;
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<String> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv$iv;
                p0 = item$iv$iv = iterator.next();
                collection = destination$iv$iv3;
                boolean bl14 = false;
                collection.add(URI.create(p0));
            }
            builder.alsoKnownAses((List)destination$iv$iv3);
        }
        DIDDocument didDocument = didDocumentBuilder.build();
        if (opts.getPublish()) {
            Intrinsics.checkNotNull((Object)didDocument);
            DidDhtApi.publish$default(this, keyManager, didDocument, null, 4, null);
        }
        return new DidDht(id, keyManager, didDocument, this);
    }

    @Override
    @NotNull
    public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
        DidResolutionResult didResolutionResult;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        try {
            didResolutionResult = this.resolveInternal(did);
        }
        catch (Exception e) {
            DidDhtKt.access$getLogger$p().warn((Throwable)e, (Function0)new Function0<Object>(did){
                final /* synthetic */ String $did;
                {
                    this.$did = $did;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "resolving DID " + this.$did + " failed";
                }
            });
            didResolutionResult = DidResolutionResult.Companion.fromResolutionError(ResolutionError.INTERNAL_ERROR);
        }
        return didResolutionResult;
    }

    /*
     * WARNING - void declaration
     */
    private final DidResolutionResult resolveInternal(String did) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Bep44Message bep44Message;
        try {
            this.validate$dids(did);
        }
        catch (InvalidMethodNameException invalidMethodNameException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.METHOD_NOT_SUPPORTED);
        }
        catch (InvalidIdentifierSizeException invalidIdentifierSizeException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        String getId = DidDht.Default.suffix(did);
        try {
            bep44Message = this.dht.pkarrGet(getId);
        }
        catch (PkarrRecordNotFoundException pkarrRecordNotFoundException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.NOT_FOUND);
        }
        Bep44Message bep44Message2 = bep44Message;
        Message dnsPacket = DhtClient.Companion.parseBep44GetResponse(bep44Message2);
        Pair<DIDDocument, List<DidDhtTypeIndexing>> pair = this.fromDnsPacket$dids(did, dnsPacket);
        boolean bl = false;
        DIDDocument didDocument = (DIDDocument)pair.component1();
        List types = (List)pair.component2();
        Iterable iterable = types;
        MetadataMethod metadataMethod = null;
        String string = null;
        List list = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Boolean bl2 = null;
        String string5 = null;
        String string6 = null;
        DIDDocument dIDDocument = didDocument;
        String string7 = null;
        boolean $i$f$map = false;
        void var23_26 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DidDhtTypeIndexing didDhtTypeIndexing = (DidDhtTypeIndexing)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getIndex());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 511;
        Collection<Integer> collection2 = collection;
        MetadataMethod metadataMethod2 = metadataMethod;
        String string8 = string;
        List list2 = list;
        String string9 = string2;
        String string10 = string3;
        String string11 = string4;
        Boolean bl4 = bl2;
        String string12 = string5;
        String string13 = string6;
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n2 = 9;
        DidResolutionMetadata didResolutionMetadata = null;
        DidDocumentMetadata didDocumentMetadata = new DidDocumentMetadata(string13, string12, bl4, string11, string10, string9, list2, string8, metadataMethod2, (List)collection2, n, defaultConstructorMarker);
        DIDDocument dIDDocument2 = dIDDocument;
        String string14 = string7;
        return new DidResolutionResult(string14, dIDDocument2, didDocumentMetadata, didResolutionMetadata, n2, defaultConstructorMarker2);
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        String string = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.validate$dids(string);
        String string2 = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String publishId = DidDht.Default.suffix(string2);
        Message dnsPacket = this.toDnsPacket$dids(didDocument, types);
        Bep44Message bep44Message = DhtClient.Companion.createBep44PutRequest(manager, this.getIdentityKid(didDocument), dnsPacket);
        this.dht.pkarrPut(publishId, bep44Message);
    }

    public static /* synthetic */ void publish$default(DidDhtApi didDhtApi, KeyManager keyManager, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publish");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        didDhtApi.publish(keyManager, dIDDocument, list);
    }

    @NotNull
    public final String suffix(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String[] stringArray = new String[]{":"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final String getIdentityKid(DIDDocument didDocument) {
        String string = didDocument.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.validate$dids(string);
        List list = didDocument.getVerificationMethods();
        JWK publicKeyJwk = JWK.parse(list != null && (list = (VerificationMethod)CollectionsKt.first((List)list)) != null ? list.getPublicKeyJwk() : null);
        String string2 = publicKeyJwk.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKeyID(...)");
        return string2;
    }

    @Override
    @NotNull
    public DidDht load(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
        this.validateIdentityKey$dids(uri, keyManager);
        return new DidDht(uri, keyManager, null, this);
    }

    public final void validateIdentityKey$dids(@NotNull String did, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DID parsedDid = DID.fromString((String)did);
        String string = parsedDid.getMethodSpecificId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
        byte[] decodedId = ZBase32.INSTANCE.decode(string);
        if (!(decodedId.length == 32)) {
            boolean $i$a$-require-DidDhtApi$validateIdentityKey$22 = false;
            String $i$a$-require-DidDhtApi$validateIdentityKey$22 = "expected size of decoded identifier \"" + parsedDid.getMethodSpecificId() + "\" to be 32";
            throw new IllegalArgumentException($i$a$-require-DidDhtApi$validateIdentityKey$22.toString());
        }
        JWK publicKeyJwk = Ed25519.INSTANCE.bytesToPublicKey(decodedId);
        String identityKeyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
        keyManager.getPublicKey(identityKeyAlias);
    }

    @NotNull
    public final String getDidIdentifier$dids(@NotNull JWK identityKey) {
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        JWK publicKeyJwk = identityKey.toPublicJWK();
        Intrinsics.checkNotNull((Object)publicKeyJwk);
        byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
        String zBase32Encoded = ZBase32.INSTANCE.encode(publicKeyBytes);
        return "did:dht:" + zBase32Encoded;
    }

    public final void validate$dids(@NotNull String did) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        DID parsedDid = DID.fromString((String)did);
        if (!Intrinsics.areEqual((Object)parsedDid.getMethodName(), (Object)DidDht.Default.getMethodName())) {
            boolean bl = false;
            throw new InvalidMethodNameException("expected method to be dht");
        }
        try {
            String string = parsedDid.getMethodSpecificId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodSpecificId(...)");
            byArray = ZBase32.INSTANCE.decode(string);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidIdentifierException("expected method-specific identifier to be z-base-32 encoded", e);
        }
        byte[] decodedId = byArray;
        if (!(decodedId.length == 32)) {
            boolean bl = false;
            throw new InvalidIdentifierSizeException("expected size of decoded identifier to be 32");
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object it;
        VerificationMethod it2;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object object5;
        Iterable service;
        Iterable $this$forEachIndexed$iv;
        Pair<List<String>, Map<String, String>> pair;
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        Pair<List<String>, Map<String, String>> $this$toDnsPacket_u24lambda_u2420 = pair = new Pair<List<String>, Map<String, String>>(0);
        boolean bl = false;
        $this$toDnsPacket_u24lambda_u2420.getHeader().setFlag(5);
        Pair<List<String>, Map<String, String>> message = pair;
        pair = this.addVerificationMethodRecords(didDocument, (Message)message);
        List verificationMethodIds = (List)pair.component1();
        Map verificationMethodsById = (Map)pair.component2();
        List serviceIds = new ArrayList();
        List list = didDocument.getServices();
        if (list != null) {
            $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Service service2 = (Service)item$iv;
                int i = n;
                boolean bl2 = false;
                Iterator sId = "s" + i;
                Name name = new Name("_" + (String)((Object)sId) + "._did.");
                Object[] objectArray = new String[3];
                objectArray[0] = "id=" + service.getId().getRawFragment();
                objectArray[1] = "t=" + service.getType();
                Intrinsics.checkNotNull((Object)service);
                objectArray[2] = "se=" + this.serviceRecordValue((Service)service);
                message.addRecord((Record)new TXTRecord(name, 1, this.ttl, CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
                ((Collection)serviceIds).add(sId);
            }
        }
        this.addControllerRecord(didDocument, (Message)message);
        this.addAlsoKnownAsRecord(didDocument, (Message)message);
        Iterable $this$toDnsPacket_u24lambda_u2432 = $this$forEachIndexed$iv = (List)new ArrayList();
        boolean bl3 = false;
        if (!((Collection)verificationMethodIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2432.add("vm=" + CollectionsKt.joinToString$default((Iterable)verificationMethodIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)serviceIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2432.add("svc=" + CollectionsKt.joinToString$default((Iterable)serviceIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object5 = didDocument.getAuthenticationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object5;
            $i$f$map = false;
            service = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VerificationMethod verificationMethod = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object5 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object5 != null) {
                it = object5;
                boolean bl5 = false;
                $this$toDnsPacket_u24lambda_u2432.add("auth=" + (String)it);
            }
        }
        if ((object4 = didDocument.getAssertionMethodVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object4;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object4 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object4 != null) {
                it = object4;
                boolean bl7 = false;
                $this$toDnsPacket_u24lambda_u2432.add("asm=" + (String)it);
            }
        }
        if ((object3 = didDocument.getKeyAgreementVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object3;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object3 != null) {
                it = object3;
                boolean bl9 = false;
                $this$toDnsPacket_u24lambda_u2432.add("agm=" + (String)it);
            }
        }
        if ((object2 = didDocument.getCapabilityInvocationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object2 != null) {
                it = object2;
                boolean bl11 = false;
                $this$toDnsPacket_u24lambda_u2432.add("inv=" + (String)it);
            }
        }
        if ((object = didDocument.getCapabilityDelegationVerificationMethodsDereferenced()) != null) {
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl12 = false;
                collection.add((String)verificationMethodsById.get(it2.getId().toString()));
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object != null) {
                it = object;
                boolean bl13 = false;
                $this$toDnsPacket_u24lambda_u2432.add("del=" + (String)it);
            }
        }
        Iterable rootRecordText = $this$forEachIndexed$iv;
        message.addRecord((Record)new TXTRecord(new Name("_did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)rootRecordText, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
        if (types != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = types;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                DidDhtTypeIndexing $i$f$mapTo3 = (DidDhtTypeIndexing)((Object)item$iv$iv);
                Collection collection2 = destination$iv$iv;
                boolean bl14 = false;
                collection2.add(it3.getIndex());
            }
            List typeIndexes = (List)destination$iv$iv;
            message.addRecord((Record)new TXTRecord(new Name("_typ._did."), 1, this.ttl, "id=" + CollectionsKt.joinToString$default((Iterable)typeIndexes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), 1);
        }
        return message;
    }

    public static /* synthetic */ Message toDnsPacket$dids$default(DidDhtApi didDhtApi, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDnsPacket");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return didDhtApi.toDnsPacket$dids(dIDDocument, list);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, Map<String, String>> addVerificationMethodRecords(DIDDocument didDocument, Message message) {
        List list;
        List list2;
        Map verificationMethodsById = new LinkedHashMap();
        List $this$addVerificationMethodRecords_u24lambda_u2436 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        List list3 = list = didDocument.getVerificationMethods();
        if (list3 != null) {
            Intrinsics.checkNotNull((Object)list3);
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$addVerificationMethodRecords_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
                int n;
                void verificationMethod;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VerificationMethod verificationMethod2 = (VerificationMethod)item$iv;
                int i = n2;
                boolean bl2 = false;
                JWK publicKeyJwk = JWK.parse((Map)verificationMethod.getPublicKeyJwk());
                Intrinsics.checkNotNull((Object)publicKeyJwk);
                byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
                String base64UrlEncodedKey = new Convert((Object)publicKeyBytes, null, 2, null).toBase64Url(false);
                String verificationMethodId = "k" + i;
                Map map = verificationMethodsById;
                String string = verificationMethod.getId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                map.put(string, verificationMethodId);
                Object object = publicKeyJwk.getAlgorithm();
                if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.EdDSA)) {
                    n = 0;
                } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256K)) {
                    n = 1;
                } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256)) {
                    n = 2;
                } else {
                    throw new IllegalArgumentException("unsupported algorithm: " + publicKeyJwk.getAlgorithm());
                }
                int keyType = n;
                Object object2 = object = CollectionsKt.createListBuilder();
                long l = this.ttl;
                int n3 = 1;
                Name name = new Name("_" + verificationMethodId + "._did.");
                Message message2 = message;
                boolean bl3 = false;
                $this$addVerificationMethodRecords_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.add("id=" + verificationMethod.getId().getRawFragment());
                $this$addVerificationMethodRecords_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.add("t=" + keyType);
                $this$addVerificationMethodRecords_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.add("k=" + base64UrlEncodedKey);
                if (verificationMethod.getJsonObject().containsKey("controller")) {
                    $this$addVerificationMethodRecords_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.add("c=" + verificationMethod.getJsonObject().get("controller"));
                }
                Unit unit = Unit.INSTANCE;
                String string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)object), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
                long l2 = l;
                int n4 = n3;
                Name name2 = name;
                message2.addRecord((Record)new TXTRecord(name2, n4, l2, string2), 1);
                $this$addVerificationMethodRecords_u24lambda_u2436.add(verificationMethodId);
            }
        }
        List verificationMethods = CollectionsKt.build((List)list2);
        return new Pair((Object)verificationMethods, (Object)verificationMethodsById);
    }

    private final void addAlsoKnownAsRecord(DIDDocument didDocument, Message message) {
        Collection collection = didDocument.getAlsoKnownAses();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Name name = new Name("_aka._did.");
        List list = didDocument.getAlsoKnownAses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAlsoKnownAses(...)");
        message.addRecord((Record)new TXTRecord(name, 1, this.ttl, CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
    }

    private final void addControllerRecord(DIDDocument didDocument, Message message) {
        Collection collection = didDocument.getControllers();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Name name = new Name("_cnt._did.");
        List list = didDocument.getControllers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getControllers(...)");
        message.addRecord((Record)new TXTRecord(name, 1, this.ttl, CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
    }

    private final String serviceRecordValue(Service service) {
        Object endpoint = service.getServiceEndpoint();
        String seValue = endpoint instanceof List ? CollectionsKt.joinToString$default((Iterable)((Iterable)endpoint), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : endpoint.toString();
        return seValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<DIDDocument, List<DidDhtTypeIndexing>> fromDnsPacket$dids(@NotNull String did, @NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        DIDDocument.Builder doc = (DIDDocument.Builder)((DIDDocument.Builder)DIDDocument.builder().id(URI.create(did))).defaultContexts(false);
        List verificationMethods = new ArrayList();
        List services = new ArrayList();
        List types = new ArrayList();
        Map keyLookup = new LinkedHashMap();
        List list = msg.getSection(1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSection(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String name;
            Record rr = (Record)element$iv;
            boolean bl = false;
            if (!(rr instanceof TXTRecord)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TXTRecord)rr).getName().toString(), (String)"toString(...)");
            if (StringsKt.startsWith$default((String)name, (String)"_k", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleVerificationMethods((TXTRecord)rr, verificationMethods, did, keyLookup, name);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_s", (boolean)false, (int)2, null)) {
                List list2 = ((TXTRecord)rr).getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                object = (String[])services;
                Service.Builder builder = Service.builder();
                String string = data.get("id");
                Intrinsics.checkNotNull((Object)string);
                Service.Builder builder2 = (Service.Builder)builder.id(URI.create(did + "#" + string));
                String string2 = data.get("t");
                Intrinsics.checkNotNull((Object)string2);
                Service.Builder builder3 = (Service.Builder)builder2.type(string2);
                String string3 = data.get("se");
                Intrinsics.checkNotNull((Object)string3);
                String[] stringArray = new String[]{","};
                stringArray = builder3.serviceEndpoint((Object)StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).build();
                object.add(stringArray);
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"_typ._did.")) {
                Object e = ((TXTRecord)rr).getStrings().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                if (((CharSequence)e).length() > 0 && ((TXTRecord)rr).getStrings().size() == 1) {
                    void $this$mapTo$iv$iv;
                    Collection collection = types;
                    Object e2 = ((TXTRecord)rr).getStrings().get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    object = new String[]{","};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)((String)e2), (CharSequence)"id="), (String[])object, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        DidDhtTypeIndexing didDhtTypeIndexing = DidDhtTypeIndexing.Companion.fromInt(Integer.parseInt((String)it));
                        if (didDhtTypeIndexing == null) {
                            throw new IllegalArgumentException("invalid type index");
                        }
                        collection2.add(didDhtTypeIndexing);
                    }
                    object = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)object);
                    continue;
                }
                throw new IllegalArgumentException("invalid types record");
            }
            if (Intrinsics.areEqual((Object)name, (Object)"_did.")) {
                Intrinsics.checkNotNull((Object)rr);
                TXTRecord tXTRecord = (TXTRecord)rr;
                Intrinsics.checkNotNull((Object)doc);
                this.handleRootRecord(tXTRecord, keyLookup, doc);
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"_cnt._did.")) {
                Intrinsics.checkNotNull((Object)rr);
                TXTRecord tXTRecord = (TXTRecord)rr;
                Intrinsics.checkNotNull((Object)doc);
                this.handleControllerRecord(tXTRecord, doc);
                continue;
            }
            if (!Intrinsics.areEqual((Object)name, (Object)"_aka._did.")) continue;
            Intrinsics.checkNotNull((Object)rr);
            TXTRecord tXTRecord = (TXTRecord)rr;
            Intrinsics.checkNotNull((Object)doc);
            this.handleAlsoKnownAsRecord(tXTRecord, doc);
        }
        doc.verificationMethods(verificationMethods);
        doc.services(services);
        return TuplesKt.to((Object)doc.build(), (Object)types);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleAlsoKnownAsRecord(TXTRecord rr, DIDDocument.Builder<?> doc) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)data, (String[])object, (boolean)false, (int)0, (int)6, null);
        DIDDocument.Builder<?> builder = doc;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(URI.create((String)it));
        }
        builder.alsoKnownAses((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleControllerRecord(TXTRecord rr, DIDDocument.Builder<?> doc) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)data, (String[])object, (boolean)false, (int)0, (int)6, null);
        DIDDocument.Builder<?> builder = doc;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(URI.create((String)it));
        }
        builder.controllers((List)destination$iv$iv);
    }

    private final void handleVerificationMethods(TXTRecord rr, List<VerificationMethod> verificationMethods, String did, Map<String, String> keyLookup, String name) {
        JWK jWK;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        String string = data.get("id");
        Intrinsics.checkNotNull((Object)string);
        String verificationMethodId = string;
        String string2 = data.get("k");
        Intrinsics.checkNotNull((Object)string2);
        byte[] keyBytes = new Convert((Object)string2, EncodingFormat.Base64Url).toByteArray();
        String string3 = data.get("t");
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string3;
        if (Intrinsics.areEqual((Object)string4, (Object)"0")) {
            jWK = Ed25519.INSTANCE.bytesToPublicKey(keyBytes);
        } else if (Intrinsics.areEqual((Object)string4, (Object)"1")) {
            jWK = Secp256k1.INSTANCE.bytesToPublicKey(keyBytes);
        } else {
            throw new IllegalArgumentException("Unknown key type: " + data.get("t"));
        }
        JWK publicKeyJwk = jWK;
        VerificationMethod.Builder builder = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(URI.create(did + "#" + verificationMethodId))).type("JsonWebKey")).publicKeyJwk(publicKeyJwk.toPublicJWK().toJSONObject());
        if (data.containsKey("c")) {
            String string5 = data.get("c");
            Intrinsics.checkNotNull((Object)string5);
            builder.controller(URI.create(string5));
        } else {
            builder.controller(URI.create(Intrinsics.areEqual((Object)verificationMethodId, (Object)"0") ? did : ""));
        }
        ((Collection)verificationMethods).add(builder.build());
        Map<String, String> map = keyLookup;
        Object object = new String[]{"."};
        object = StringsKt.drop((String)((String)StringsKt.split$default((CharSequence)name, (String[])object, (boolean)false, (int)0, (int)6, null).get(0)), (int)1);
        String string6 = did + "#" + verificationMethodId;
        map.put((String)object, string6);
    }

    private final void handleRootRecord(TXTRecord rr, Map<String, String> keyLookup, DIDDocument.Builder<?> doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String[] stringArray = new String[]{";"};
        List rootData = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"auth", (Object)new ArrayList()), TuplesKt.to((Object)"asm", (Object)new ArrayList()), TuplesKt.to((Object)"agm", (Object)new ArrayList()), TuplesKt.to((Object)"inv", (Object)new ArrayList()), TuplesKt.to((Object)"del", (Object)new ArrayList())};
        Map lists = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = rootData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list2 = StringsKt.split$default((CharSequence)item, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list2.get(0);
            String values = (String)list2.get(1);
            String[] stringArray3 = new String[]{","};
            List valueItems = StringsKt.split$default((CharSequence)values, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv2 = valueItems;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                List list3 = (List)lists.get(key);
                if (list3 == null) continue;
                VerificationMethod.Builder builder = VerificationMethod.builder();
                String string = keyLookup.get(it);
                Intrinsics.checkNotNull((Object)string);
                VerificationMethod verificationMethod = ((VerificationMethod.Builder)builder.id(new URI(string))).build();
                Intrinsics.checkNotNullExpressionValue((Object)verificationMethod, (String)"build(...)");
                list3.add(verificationMethod);
            }
        }
        doc.authenticationVerificationMethods((List)lists.get("auth"));
        doc.assertionMethodVerificationMethods((List)lists.get("asm"));
        doc.keyAgreementVerificationMethods((List)lists.get("agm"));
        doc.capabilityInvocationVerificationMethods((List)lists.get("inv"));
        doc.capabilityDelegationVerificationMethods((List)lists.get("del"));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseTxtData(String data) {
        void $this$associateTo$iv$iv;
        String[] stringArray = new String[]{";"};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        DidDhtApi.publish$default(this, manager, didDocument, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        return DidDhtApi.toDnsPacket$dids$default(this, didDocument, null, 2, null);
    }

    public /* synthetic */ DidDhtApi(DidDhtConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }
}

