/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.ion;

import com.nimbusds.jose.jwk.JWK;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;
import web5.sdk.common.Varint;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.methods.ion.CommonOptions;
import web5.sdk.dids.methods.ion.DidIonApi;
import web5.sdk.dids.methods.ion.DidIonApiImpl;
import web5.sdk.dids.methods.ion.DidIonConfiguration;
import web5.sdk.dids.methods.ion.VerificationMethodCreationParams;
import web5.sdk.dids.methods.ion.VerificationMethodGenerator;
import web5.sdk.dids.methods.ion.VerificationMethodSpec;
import web5.sdk.dids.methods.ion.models.Commitment;
import web5.sdk.dids.methods.ion.models.Document;
import web5.sdk.dids.methods.ion.models.PatchAction;
import web5.sdk.dids.methods.ion.models.PublicKey;
import web5.sdk.dids.methods.ion.models.ReplaceAction;
import web5.sdk.dids.methods.ion.models.Reveal;
import web5.sdk.dids.methods.ion.models.Service;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011\u001a\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0016H\u0002\u001a \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\"\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c*\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001cH\u0002\u001a.\u0010%\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020$0&0\u001a*\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"base64UrlCharsetRegex", "Lkotlin/text/Regex;", "base64UrlCharsetRegexStr", "", "identifiersPath", "maxIdLength", "", "maxServiceTypeLength", "operationsPath", "sha256MultiCodec", "", "DidIonApi", "Lweb5/sdk/dids/methods/ion/DidIonApi;", "configurationBlock", "Lkotlin/Function1;", "Lweb5/sdk/dids/methods/ion/DidIonConfiguration;", "", "Lkotlin/ExtensionFunctionType;", "multihash", "payload", "commitment", "Lweb5/sdk/dids/methods/ion/models/Commitment;", "Lcom/nimbusds/jose/jwk/JWK;", "reveal", "Lweb5/sdk/dids/methods/ion/models/Reveal;", "toGenerators", "", "Lweb5/sdk/dids/methods/ion/VerificationMethodGenerator;", "", "Lweb5/sdk/dids/methods/ion/VerificationMethodSpec;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "toPatches", "Lweb5/sdk/dids/methods/ion/models/PatchAction;", "Lweb5/sdk/dids/methods/ion/CommonOptions;", "publicKeysToAdd", "Lweb5/sdk/dids/methods/ion/models/PublicKey;", "toPublicKeys", "Lkotlin/Pair;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidIon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidIon.kt\nweb5/sdk/dids/methods/ion/DidIonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,902:1\n1#2:903\n1549#3:904\n1620#3,3:905\n*S KotlinDebug\n*F\n+ 1 DidIon.kt\nweb5/sdk/dids/methods/ion/DidIonKt\n*L\n886#1:904\n886#1:905,3\n*E\n"})
public final class DidIonKt {
    @NotNull
    private static final String operationsPath = "/operations";
    @NotNull
    private static final String identifiersPath = "/identifiers";
    @NotNull
    private static final byte[] sha256MultiCodec = Varint.INSTANCE.encode(18);
    private static final int maxServiceTypeLength = 30;
    private static final int maxIdLength = 50;
    @NotNull
    private static final String base64UrlCharsetRegexStr = "^[A-Za-z0-9_-]+$";
    @NotNull
    private static final Regex base64UrlCharsetRegex = new Regex("^[A-Za-z0-9_-]+$");

    @NotNull
    public static final DidIonApi DidIonApi(@NotNull Function1<? super DidIonConfiguration, Unit> configurationBlock) {
        Intrinsics.checkNotNullParameter(configurationBlock, (String)"configurationBlock");
        DidIonConfiguration didIonConfiguration = new DidIonConfiguration(null, null, 3, null);
        configurationBlock.invoke((Object)didIonConfiguration);
        DidIonConfiguration conf = didIonConfiguration;
        return new DidIonApiImpl(conf);
    }

    private static final Iterable<PatchAction> toPatches(CommonOptions $this$toPatches, Iterable<PublicKey> publicKeysToAdd) {
        Object object = $this$toPatches;
        if (object == null || (object = object.getServicesToAdd()) == null) {
            object = CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new ReplaceAction(new Document(publicKeysToAdd, (Iterable<Service>)object)));
    }

    private static final Commitment commitment(JWK $this$commitment) {
        if (!(!$this$commitment.isPrivate())) {
            boolean bl = false;
            throw new IllegalArgumentException("provided JWK must not be a private key");
        }
        String pkJson = $this$commitment.toJSONString();
        byte[] canonicalized = new JsonCanonicalizer(pkJson).getEncodedUTF8();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] pkDigest = sha256.digest(canonicalized);
        Intrinsics.checkNotNull((Object)pkDigest);
        byte[] pkDigestMultihash = DidIonKt.multihash(pkDigest);
        return new Commitment(pkDigestMultihash);
    }

    private static final Reveal reveal(JWK $this$reveal) {
        if (!(!$this$reveal.isPrivate())) {
            boolean bl = false;
            throw new IllegalArgumentException("provided JWK must not be a private key");
        }
        String pkJson = $this$reveal.toJSONString();
        byte[] canonicalized = new JsonCanonicalizer(pkJson).getEncodedUTF8();
        Intrinsics.checkNotNull((Object)canonicalized);
        byte[] mh = DidIonKt.multihash(canonicalized);
        return new Reveal(mh);
    }

    @NotNull
    public static final byte[] multihash(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(payload);
        int digestLen = sha256.getDigestLength();
        byte[] digest = sha256.digest();
        byte[] byArray = ArraysKt.plus((byte[])sha256MultiCodec, (byte[])Varint.INSTANCE.encode(digestLen));
        Intrinsics.checkNotNull((Object)digest);
        return ArraysKt.plus((byte[])byArray, (byte[])digest);
    }

    private static final List<VerificationMethodGenerator> toGenerators(Iterable<? extends VerificationMethodSpec> $this$toGenerators, KeyManager keyManager) {
        List list;
        List $this$toGenerators_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (VerificationMethodSpec verificationMethodSpec : $this$toGenerators) {
            VerificationMethodSpec verificationMethodSpec2 = verificationMethodSpec;
            if (verificationMethodSpec2 instanceof VerificationMethodCreationParams) {
                $this$toGenerators_u24lambda_u242.add(((VerificationMethodCreationParams)verificationMethodSpec).toGenerator$dids(keyManager));
                continue;
            }
            if (!(verificationMethodSpec2 instanceof VerificationMethodGenerator)) continue;
            $this$toGenerators_u24lambda_u242.add(verificationMethodSpec);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<String, PublicKey>> toPublicKeys(Iterable<? extends VerificationMethodSpec> $this$toPublicKeys, KeyManager keyManager) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = DidIonKt.toGenerators($this$toPublicKeys, keyManager);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VerificationMethodGenerator verificationMethodGenerator = (VerificationMethodGenerator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.generate());
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Reveal access$reveal(JWK $receiver) {
        return DidIonKt.reveal($receiver);
    }

    public static final /* synthetic */ Commitment access$commitment(JWK $receiver) {
        return DidIonKt.commitment($receiver);
    }

    public static final /* synthetic */ List access$toPublicKeys(Iterable $receiver, KeyManager keyManager) {
        return DidIonKt.toPublicKeys($receiver, keyManager);
    }

    public static final /* synthetic */ Iterable access$toPatches(CommonOptions $receiver, Iterable publicKeysToAdd) {
        return DidIonKt.toPatches($receiver, publicKeysToAdd);
    }

    public static final /* synthetic */ Regex access$getBase64UrlCharsetRegex$p() {
        return base64UrlCharsetRegex;
    }
}

