/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.ion;

import com.nimbusds.jose.jwk.JWK;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.methods.ion.VerificationMethodCreationParams;
import web5.sdk.dids.methods.ion.VerificationMethodGenerator;
import web5.sdk.dids.methods.ion.models.PublicKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lweb5/sdk/dids/methods/ion/VerificationMethodKeyManagerGenerator;", "Lweb5/sdk/dids/methods/ion/VerificationMethodGenerator;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "params", "Lweb5/sdk/dids/methods/ion/VerificationMethodCreationParams;", "(Lweb5/sdk/crypto/KeyManager;Lweb5/sdk/dids/methods/ion/VerificationMethodCreationParams;)V", "getKeyManager", "()Lweb5/sdk/crypto/KeyManager;", "getParams", "()Lweb5/sdk/dids/methods/ion/VerificationMethodCreationParams;", "generate", "Lkotlin/Pair;", "", "Lweb5/sdk/dids/methods/ion/models/PublicKey;", "dids"})
public final class VerificationMethodKeyManagerGenerator
implements VerificationMethodGenerator {
    @NotNull
    private final KeyManager keyManager;
    @NotNull
    private final VerificationMethodCreationParams params;

    public VerificationMethodKeyManagerGenerator(@NotNull KeyManager keyManager, @NotNull VerificationMethodCreationParams params) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.keyManager = keyManager;
        this.params = params;
    }

    @NotNull
    public final KeyManager getKeyManager() {
        return this.keyManager;
    }

    @NotNull
    public final VerificationMethodCreationParams getParams() {
        return this.params;
    }

    @Override
    @NotNull
    public Pair<String, PublicKey> generate() {
        String alias = this.keyManager.generatePrivateKey(this.params.getAlgorithmId(), this.params.getOptions());
        JWK publicKeyJwk = this.keyManager.getPublicKey(alias);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Pair((Object)alias, (Object)new PublicKey(string, "JsonWebKey2020", null, publicKeyJwk, this.params.getRelationships(), 4, null));
    }
}

