/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.key;

import com.nimbusds.jose.jwk.JWK;
import foundation.identity.did.DID;
import foundation.identity.did.DIDDocument;
import foundation.identity.did.VerificationMethod;
import io.ipfs.multibase.Multibase;
import java.net.URI;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Varint;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.KeyGenerator;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.methods.key.CreateDidKeyOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lweb5/sdk/dids/methods/key/DidKey;", "Lweb5/sdk/dids/Did;", "uri", "", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "(Ljava/lang/String;Lweb5/sdk/crypto/KeyManager;)V", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Companion", "dids"})
public final class DidKey
extends Did {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String methodName = "key";

    public DidKey(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        super(uri, keyManager);
    }

    @NotNull
    public final DidResolutionResult resolve() {
        return DidMethod.DefaultImpls.resolve$default(Companion, this.getUri(), null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lweb5/sdk/dids/methods/key/DidKey$Companion;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/key/DidKey;", "Lweb5/sdk/dids/methods/key/CreateDidKeyOptions;", "()V", "methodName", "", "getMethodName", "()Ljava/lang/String;", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "load", "uri", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "did", "Lweb5/sdk/dids/ResolveDidOptions;", "dids"})
    @SourceDebugExtension(value={"SMAP\nDidKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidKey.kt\nweb5/sdk/dids/methods/key/DidKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
    public static final class Companion
    implements DidMethod<DidKey, CreateDidKeyOptions> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getMethodName() {
            return methodName;
        }

        @Override
        @NotNull
        public DidKey create(@NotNull KeyManager keyManager, @Nullable CreateDidKeyOptions options) {
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            CreateDidKeyOptions createDidKeyOptions = options;
            if (createDidKeyOptions == null) {
                createDidKeyOptions = new CreateDidKeyOptions(null, 1, null);
            }
            CreateDidKeyOptions opts = createDidKeyOptions;
            String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (AlgorithmId)opts.getAlgorithmId(), null, (int)2, null);
            JWK publicKey = keyManager.getPublicKey(keyAlias);
            byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKey);
            if (opts.getAlgorithmId() == AlgorithmId.secp256k1) {
                publicKeyBytes = Secp256k1.INSTANCE.compressPublicKey(publicKeyBytes);
            }
            Integer n = Crypto.INSTANCE.getAlgorithmMultiCodec(opts.getAlgorithmId());
            if (n == null) {
                throw new UnsupportedOperationException(opts.getAlgorithmId().getCurveName() + " curve not supported");
            }
            int multiCodec = n;
            byte[] multiCodecBytes = Varint.INSTANCE.encode(multiCodec);
            byte[] idBytes = ArraysKt.plus((byte[])multiCodecBytes, (byte[])publicKeyBytes);
            String multibaseEncodedId = Multibase.encode((Multibase.Base)Multibase.Base.Base58BTC, (byte[])idBytes);
            String did = "did:key:" + multibaseEncodedId;
            return new DidKey(did, keyManager);
        }

        @Override
        @NotNull
        public DidKey load(@NotNull String uri, @NotNull KeyManager keyManager) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
            return new DidKey(uri, keyManager);
        }

        @Override
        @NotNull
        public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            DID parsedDid = DID.fromString((String)did);
            if (!Intrinsics.areEqual((Object)parsedDid.getMethodName(), (Object)this.getMethodName())) {
                boolean bl = false;
                throw new IllegalArgumentException("expected did:key");
            }
            String id = parsedDid.getMethodSpecificId();
            byte[] idBytes = Multibase.decode((String)id);
            Intrinsics.checkNotNull((Object)idBytes);
            Pair pair = Varint.INSTANCE.decode(idBytes);
            int multiCodec = ((Number)pair.component1()).intValue();
            int numBytes = ((Number)pair.component2()).intValue();
            byte[] publicKeyBytes = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])idBytes, (int)numBytes));
            KeyGenerator keyGenerator = Crypto.INSTANCE.getKeyGenerator(multiCodec);
            if (keyGenerator.getAlgorithm() == Secp256k1.INSTANCE.getAlgorithm()) {
                publicKeyBytes = Secp256k1.INSTANCE.inflatePublicKey(publicKeyBytes);
            }
            JWK publicKeyJwk = keyGenerator.bytesToPublicKey(publicKeyBytes);
            URI verificationMethodId = URI.create(did + "#" + id);
            VerificationMethod verificationMethod = ((VerificationMethod.Builder)((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethodId)).publicKeyJwk(publicKeyJwk.toJSONObject()).controller(new URI(did)).type("JsonWebKey2020")).build();
            VerificationMethod verificationMethodRef = ((VerificationMethod.Builder)VerificationMethod.builder().id(verificationMethodId)).build();
            DIDDocument didDocument = ((DIDDocument.Builder)DIDDocument.builder().id(new URI(did))).verificationMethod(verificationMethod).assertionMethodVerificationMethod(verificationMethodRef).authenticationVerificationMethod(verificationMethodRef).capabilityDelegationVerificationMethods(CollectionsKt.listOf((Object)verificationMethodRef)).capabilityInvocationVerificationMethod(verificationMethodRef).keyAgreementVerificationMethod(verificationMethodRef).build();
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", didDocument, null, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

