/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids;

import com.nimbusds.jose.jwk.JWK;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.CreateDidOptions;
import web5.sdk.dids.Did;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.didcore.DIDDocument;
import web5.sdk.dids.didcore.DidUri;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.PublicKeyJwkMissingException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u0005*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"validateKeyMaterialInsideKeyManager", "", "T", "Lweb5/sdk/dids/Did;", "O", "Lweb5/sdk/dids/CreateDidOptions;", "Lweb5/sdk/dids/DidMethod;", "did", "", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidMethod.kt\nweb5/sdk/dids/DidMethodKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1855#2,2:185\n*S KotlinDebug\n*F\n+ 1 DidMethod.kt\nweb5/sdk/dids/DidMethodKt\n*L\n179#1:185,2\n*E\n"})
public final class DidMethodKt {
    public static final <T extends Did, O extends CreateDidOptions> void validateKeyMaterialInsideKeyManager(@NotNull DidMethod<T, O> $this$validateKeyMaterialInsideKeyManager, @NotNull String did, @NotNull KeyManager keyManager) {
        block3: {
            Intrinsics.checkNotNullParameter($this$validateKeyMaterialInsideKeyManager, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            if (!Intrinsics.areEqual((Object)DidUri.Parser.parse(did).getMethod(), (Object)$this$validateKeyMaterialInsideKeyManager.getMethodName())) {
                boolean bl = false;
                String string = "did must start with the prefix \"did:" + $this$validateKeyMaterialInsideKeyManager.getMethodName() + "\", but got " + did;
                throw new IllegalArgumentException(string.toString());
            }
            DidResolutionResult didResolutionResult = DidMethod.DefaultImpls.resolve$default($this$validateKeyMaterialInsideKeyManager, did, null, 2, null);
            DIDDocument dIDDocument = didResolutionResult.getDidDocument();
            Intrinsics.checkNotNull((Object)dIDDocument);
            List<VerificationMethod> list = dIDDocument.getVerificationMethod();
            if (list == null) break block3;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JWK publicKeyJwk;
                VerificationMethod it = (VerificationMethod)element$iv;
                boolean bl = false;
                if (it.getPublicKeyJwk() == null) {
                    throw new PublicKeyJwkMissingException("publicKeyJwk is null");
                }
                String keyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
                keyManager.getPublicKey(keyAlias);
            }
        }
    }
}

